/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.dependency.tests.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import junit.framework.Assert;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.tests.ProjectUtility;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.GlobalConfiguration;
import org.eclipse.wst.validation.internal.ValidatorMetaData;

public class DependencyUtil {
    public static final IWorkspace ws = ResourcesPlugin.getWorkspace();

    public static String getUniqueName(String prefix) {
        return String.valueOf(prefix) + System.currentTimeMillis();
    }

    public static void waitForValidationJobs() {
        Platform.getJobManager();
        IProject[] projects = ProjectUtility.getAllProjects();
        int i = 0;
        while (i < projects.length) {
            IProject p = projects[i];
            DependencyUtil.waitForValidationJobs(p);
            ++i;
        }
    }

    public static void waitForValidationJobs(IProject project) {
        Platform.getJobManager();
        String family = String.valueOf(project.getName()) + "validators";
        DependencyUtil.waitForJobs(family);
    }

    public static void waitForProjectRefactoringJobs() {
        DependencyUtil.waitForJobs("org.eclipse.jst.j2ee.refactor.project");
    }

    public static void waitForComponentRefactoringJobs() {
        DependencyUtil.waitForJobs("org.eclipse.jst.j2ee.refactor.component");
    }

    public static void waitForJobs(String family) {
        DependencyUtil.waitForJobs((Object)family);
    }

    public static void waitForJobs(Object family) {
        IJobManager jobMgr = Platform.getJobManager();
        int i = 0;
        while (i < 1000) {
            block6: {
                Job[] jobs = jobMgr.find(family);
                if (jobs.length > 0) {
                    try {
                        jobMgr.join(family, null);
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                        i = 999;
                        break block6;
                    }
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            ++i;
        }
    }

    public static void disableValidation() throws InvocationTargetException {
        DependencyUtil.disableValidation(true);
    }

    public static void enableValidation() throws InvocationTargetException {
        DependencyUtil.disableValidation(false);
    }

    private static void disableValidation(boolean disabled) throws InvocationTargetException {
        GlobalConfiguration config = new GlobalConfiguration(ConfigurationManager.getManager().getGlobalConfiguration());
        config.setDisableAllValidation(disabled);
        config.passivate();
        config.store();
    }

    public static void disableValidation(String validatorToLeaveEnabled) throws InvocationTargetException {
        GlobalConfiguration config = new GlobalConfiguration(ConfigurationManager.getManager().getGlobalConfiguration());
        ArrayList<ValidatorMetaData> listVmd = new ArrayList<ValidatorMetaData>();
        ValidatorMetaData[] enabledValidators = config.getEnabledValidators();
        boolean disabledSomeValidators = false;
        int i = 0;
        while (i < enabledValidators.length) {
            String uniqueName = enabledValidators[i].getValidatorUniqueName();
            if (uniqueName.equals(validatorToLeaveEnabled)) {
                listVmd.add(enabledValidators[i]);
            } else {
                disabledSomeValidators = true;
            }
            ++i;
        }
        if (disabledSomeValidators) {
            config.setEnabledValidators(listVmd.toArray(new ValidatorMetaData[0]));
            config.passivate();
            config.store();
        }
    }

    public static boolean addJavaSrcPath(IProject project, IPath path) throws CoreException {
        IFolder folder = project.getFolder(path);
        if (!folder.exists()) {
            folder.create(true, true, null);
        }
        IJavaProject jProject = JavaCore.create((IProject)project);
        IPath absolutePath = project.getFullPath().append(path);
        IClasspathEntry entry = JavaCore.newSourceEntry((IPath)absolutePath);
        IClasspathEntry[] cp = jProject.getRawClasspath();
        ArrayList<IClasspathEntry> cpList = new ArrayList<IClasspathEntry>();
        boolean hasEntry = false;
        int i = 0;
        while (i < cp.length) {
            IClasspathEntry cpe = cp[i];
            if (cpe.getEntryKind() == 3 && cpe.getPath().equals((Object)absolutePath)) {
                hasEntry = true;
                break;
            }
            cpList.add(cp[i]);
            ++i;
        }
        if (!hasEntry) {
            cpList.add(entry);
            cp = cpList.toArray(new IClasspathEntry[cpList.size()]);
            jProject.setRawClasspath(cp, null);
            DependencyUtil.waitForComponentRefactoringJobs();
            return true;
        }
        return false;
    }

    public static boolean removeJavaSrcPath(IProject project, IPath path) throws CoreException {
        IJavaProject jProject = JavaCore.create((IProject)project);
        IPath absolutePath = project.getFullPath().append(path);
        IClasspathEntry[] cp = jProject.getRawClasspath();
        ArrayList<IClasspathEntry> cpList = new ArrayList<IClasspathEntry>();
        boolean removedEntry = false;
        int i = 0;
        while (i < cp.length) {
            IClasspathEntry cpe = cp[i];
            if (cpe.getEntryKind() != 3 || !cpe.getPath().equals((Object)absolutePath)) {
                cpList.add(cp[i]);
            } else {
                removedEntry = true;
            }
            ++i;
        }
        if (removedEntry) {
            cp = cpList.toArray(new IClasspathEntry[cpList.size()]);
            jProject.setRawClasspath(cp, null);
            DependencyUtil.waitForComponentRefactoringJobs();
            return true;
        }
        return false;
    }

    public static void verifyComponentMapping(IProject project, IPath projectPath, boolean exists) throws CoreException {
        Path runtimePath = Path.ROOT;
        if (JavaEEProjectUtilities.isDynamicWebProject((IProject)project)) {
            runtimePath = new Path("WEB-INF/classes");
        }
        DependencyUtil.verifyComponentMapping(project, projectPath, (IPath)runtimePath, exists);
    }

    public static void verifyComponentMapping(IProject project, IPath projectPath, IPath runtimePath, boolean exists) throws CoreException {
        IVirtualComponent c = ComponentCore.createComponent((IProject)project);
        c.create(0, null);
        IVirtualFolder dest = c.getRootFolder();
        if (!runtimePath.equals((Object)Path.ROOT)) {
            dest = dest.getFolder(runtimePath);
        }
        IContainer[] mappedFolders = dest.getUnderlyingFolders();
        boolean hasMapping = false;
        int i = 0;
        while (i < mappedFolders.length) {
            if (mappedFolders[i].getProjectRelativePath().equals((Object)projectPath)) {
                hasMapping = true;
                break;
            }
            ++i;
        }
        if (exists) {
            Assert.assertTrue((String)("Component mapping from " + projectPath + " to " + dest.toString() + " missing"), (boolean)hasMapping);
        } else {
            Assert.assertFalse((String)("Component mapping from " + projectPath + " to " + dest.toString() + " should not exist"), (boolean)hasMapping);
        }
    }
}

