/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.flexible.project.fvtests;

import junit.framework.Test;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jst.common.project.facet.JavaFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.archive.emftests.GeneralEMFPopulationTest;
import org.eclipse.jst.j2ee.earcreation.IEarFacetInstallDataModelProperties;
import org.eclipse.jst.j2ee.ejb.internal.operations.NewSessionBeanClassDataModelProvider;
import org.eclipse.jst.j2ee.ejb.project.operations.IEjbFacetInstallDataModelProperties;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.deployables.J2EEFlexProjDeployable;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.internal.impl.WTPResourceFactoryRegistry;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.tests.SimpleTestSuite;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;

public class EJBDeployTest
extends GeneralEMFPopulationTest {
    private static final String PROJECTNAME = "TestNewModels";
    public static final String PACKAGE = "test";
    public static final String SESSION_BEAN_NAME = "TestSessionBean";

    public EJBDeployTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new SimpleTestSuite(EJBDeployTest.class);
    }

    private void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("", 2000);
            projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }
        finally {
            monitor.done();
        }
    }

    public void testEJBDeployment() throws Exception {
        String projName = "TestEE5EjbProject";
        this.createEjbProject(projName);
        IProject project = this.getProject(projName);
        this.createSessionBean(projName);
        boolean found = false;
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        J2EEFlexProjDeployable deployable = new J2EEFlexProjDeployable(project, component);
        try {
            if (deployable.isSingleRootStructure()) {
                IModuleResource[] members = deployable.members();
                int i = 0;
                while (i < members.length) {
                    IModuleResource packageFolder = members[i];
                    String name = packageFolder.getName();
                    if (name.equals(PACKAGE)) {
                        IModuleResource[] javaMembers = ((IModuleFolder)packageFolder).members();
                        int j = 0;
                        while (j < javaMembers.length) {
                            IModuleResource cfr_ignored_0 = javaMembers[j];
                            if (javaMembers[j].getName().equals("TestSessionBean.class")) {
                                found = true;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            EJBDeployTest.assertTrue((String)"Can't find class files in ejb deployment", (boolean)found);
        }
        catch (CoreException e) {
            EJBDeployTest.fail((String)e.getMessage());
        }
    }

    private void createSessionBean(String projName) throws ExecutionException {
        IDataModel dm = DataModelFactory.createDataModel(NewSessionBeanClassDataModelProvider.class);
        dm.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)projName);
        dm.setProperty("NewJavaClassDataModel.JAVA_PACKAGE", (Object)PACKAGE);
        dm.setProperty("NewJavaClassDataModel.CLASS_NAME", (Object)SESSION_BEAN_NAME);
        dm.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        try {
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
        }
        catch (OperationCanceledException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private ProjectResourceSet getResourceSet(String projName) {
        IProject proj = this.getProject(projName);
        return (ProjectResourceSet)WorkbenchResourceHelperBase.getResourceSet((IProject)proj);
    }

    private IProject createEjbProject(String projName) throws ExecutionException {
        IDataModel dataModel = DataModelFactory.createDataModel(IEjbFacetInstallDataModelProperties.class);
        String versionString = J2EEVersionUtil.convertVersionIntToString((int)30);
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");
        IProjectFacetVersion facetVersion = facet.getVersion(versionString);
        this.addVersionProperties(dataModel, projName, facetVersion, "jst.ejb");
        dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        map.add(this.setupJavaInstallAction(projName, J2EEPlugin.getDefault().getJ2EEPreferences().getString("ejbContent")));
        dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        IProject webProj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        return webProj;
    }

    private IProject createEarProject(String projName) throws ExecutionException {
        IDataModel dataModel = DataModelFactory.createDataModel(IEarFacetInstallDataModelProperties.class);
        String versionString = J2EEVersionUtil.convertVersionIntToString((int)50);
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)"jst.ear");
        IProjectFacetVersion facetVersion = facet.getVersion(versionString);
        this.addVersionProperties(dataModel, projName, facetVersion, "jst.ear");
        dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        IProject webProj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        return webProj;
    }

    protected IDataModel setupJavaInstallAction(String aProjectName, String srcFolder) {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new JavaFacetInstallDataModelProvider());
        dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)aProjectName);
        String jVersion = "5.0";
        dm.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)jVersion);
        dm.setStringProperty("IJavaFacetInstallDataModelProperties.SOURCE_FOLDER_NAME", srcFolder);
        return dm;
    }

    private void addVersionProperties(IDataModel dataModel, String projName, IProjectFacetVersion fv, String facetString) {
        dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel model = (IDataModel)map.get((Object)facetString);
        model.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", true);
        model.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)fv);
    }

    public IProject getProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECTNAME);
    }

    public IProject getProject(String projName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
    }

    private void registerFactory(URI uri, ResourceSet resSet, Resource.Factory factory) {
        WTPResourceFactoryRegistry registry = (WTPResourceFactoryRegistry)resSet.getResourceFactoryRegistry();
        registry.registerLastFileSegment(uri.lastSegment(), factory);
    }

    private ResourceSet getResourceSet() {
        ResourceSetImpl set = new ResourceSetImpl();
        set.setResourceFactoryRegistry((Resource.Factory.Registry)WTPResourceFactoryRegistry.INSTANCE);
        return set;
    }
}

