/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.flexible.project.fvtests;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.etools.common.test.apitools.ProjectUnzipUtil;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.deployables.J2EEFlexProjDeployable;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wtp.j2ee.headless.tests.plugin.HeadlessTestsPlugin;

public class WebDeployTest
extends TestCase {
    private static String[] projectNames = new String[]{"TestDeploy", "TestDeployUtil", "TestDeployWeb", "TestWebLibProject", "TestExternalJar"};
    private static Path zipFilePath = new Path("/TestData/WebDeployTests/WebDeployTest.zip");

    public static Test suite() {
        return new TestSuite(WebDeployTest.class);
    }

    public void testMembersDeployment() {
        ProjectUnzipUtil util = new ProjectUnzipUtil(WebDeployTest.getLocalPath(), projectNames);
        util.createProjects();
        IProject project = ProjectUtilities.getProject((String)projectNames[2]);
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        J2EEFlexProjDeployable deployable = new J2EEFlexProjDeployable(project, component);
        try {
            IModuleResource[] members = deployable.members();
            WebDeployTest.assertTrue((members.length == 2 ? 1 : 0) != 0);
            int i = 0;
            while (i < members.length) {
                String name = members[i].getName();
                if (name.equals("META-INF")) {
                    IModuleResource manifest = ((IModuleFolder)members[i]).members()[0];
                    WebDeployTest.assertTrue((boolean)manifest.getModuleRelativePath().toString().equals("META-INF"));
                    WebDeployTest.assertTrue((boolean)manifest.getName().equals("MANIFEST.MF"));
                } else if (name.equals("WEB-INF")) {
                    IModuleResource[] webInf = ((IModuleFolder)members[i]).members();
                    WebDeployTest.assertTrue((webInf.length == 3 ? 1 : 0) != 0);
                    int j = 0;
                    while (j < webInf.length) {
                        IModuleResource webResource = webInf[j];
                        WebDeployTest.assertTrue((boolean)webResource.getModuleRelativePath().toString().equals("WEB-INF"));
                        if (webResource.getName().equals("lib")) {
                            IModuleResource[] webresMembers = ((IModuleFolder)webResource).members();
                            WebDeployTest.assertTrue((webresMembers.length == 0 ? 1 : 0) != 0);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            IModule[] childModules = deployable.getChildModules();
            WebDeployTest.assertEquals((int)3, (int)childModules.length);
            List<String> childURIs = Arrays.asList("WEB-INF/lib/SmokeEJB.jar", "WEB-INF/lib/TestWebLibProject.jar", "WEB-INF/lib/AutoWorldEJB512.jar");
            int l = 0;
            while (l < childModules.length) {
                String uri = deployable.getURI(childModules[l]);
                if (!childURIs.contains(uri)) {
                    WebDeployTest.fail((String)("URI " + uri + " is not an expected child module uri result"));
                }
                ++l;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            WebDeployTest.fail((String)e.getMessage());
        }
    }

    private static IPath getLocalPath() {
        URL url = HeadlessTestsPlugin.getDefault().find((IPath)zipFilePath);
        try {
            url = Platform.asLocalURL((URL)url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new Path(url.getPath());
    }
}

