/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.ejb.tests;

import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.dependency.tests.util.ProjectUtil;
import org.eclipse.jst.javaee.core.EjbLocalRef;
import org.eclipse.jst.javaee.core.InjectionTarget;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.jee.model.internal.EJBAnnotationReader;
import org.eclipse.jst.jee.model.internal.common.AbstractAnnotationModelProvider;
import org.eclipse.jst.jee.model.tests.AbstractAnnotationModelTest;
import org.eclipse.jst.jee.model.tests.AbstractTest;
import org.eclipse.jst.jee.model.tests.TestUtils;

public class EjbReferenceTest
extends AbstractAnnotationModelTest {
    public static TestSuite suite() throws Exception {
        TestSuite suite = new TestSuite(EjbReferenceTest.class);
        return suite;
    }

    public static void setUpProject() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(EjbReferenceTest.class.getSimpleName());
        if (!project.exists()) {
            project = ProjectUtil.createEJBProject(EjbReferenceTest.class.getSimpleName(), null, 30, true);
            EjbReferenceTest.createProjectContent(project);
        }
    }

    private static void createProjectContent(IProject project) throws Exception {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IFolder comFolder = javaProject.getProject().getFolder("ejbModule/com");
        comFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)comFolder);
        root.createPackageFragment("sap", true, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void tearDownAfterClass() throws InterruptedException {
        AbstractTest.deleteProject(EjbReferenceTest.class.getSimpleName());
    }

    protected void setUp() throws Exception {
        EjbReferenceTest.setUpProject();
        super.setUp();
        this.fixture = new EJBAnnotationReader(this.facetedProject, this.clientProject);
    }

    protected void tearDown() throws Exception {
        ((AbstractAnnotationModelProvider)this.fixture).dispose();
    }

    public void testAddDeleteInterfaceEjbOnFieldAnnotation() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/AddedBean.java");
        this.saveFileAndUpdate(beanFile, "package com.sap;@Stateless  public class AddedBean {@EJB(beanInterface = InjectionInterface.class) private InjectionInterface bean1;}");
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "AddedBean");
        EjbReferenceTest.assertNotNull((Object)result);
        EjbReferenceTest.assertEquals((Object)new Integer(1), (Object)new Integer(result.getEjbLocalRefs().size()));
        EjbLocalRef ref = (EjbLocalRef)result.getEjbLocalRefs().get(0);
        EjbReferenceTest.assertEquals((String)"InjectionInterface", (String)ref.getLocal());
        EjbReferenceTest.assertEquals((Object)new Integer(1), (Object)new Integer(ref.getInjectionTargets().size()));
        InjectionTarget injectionTarget = (InjectionTarget)ref.getInjectionTargets().get(0);
        EjbReferenceTest.assertEquals((String)"com.sap.AddedBean", (String)injectionTarget.getInjectionTargetClass());
        EjbReferenceTest.assertEquals((String)"bean1", (String)injectionTarget.getInjectionTargetName());
        IFile interfaceFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/InjectionInterface.java");
        this.saveFileAndUpdate(interfaceFile, "package com.sap;public interface InjectionInterface {}");
        result = TestUtils.getSessionBean(this.getEJBJar(), "AddedBean");
        ref = (EjbLocalRef)result.getEjbLocalRefs().get(0);
        EjbReferenceTest.assertEquals((String)"com.sap.InjectionInterface", (String)ref.getLocal());
        this.deleteFileAndUpdate(interfaceFile);
        result = TestUtils.getSessionBean(this.getEJBJar(), "AddedBean");
        ref = (EjbLocalRef)result.getEjbLocalRefs().get(0);
        EjbReferenceTest.assertEquals((String)"InjectionInterface", (String)ref.getLocal());
        this.deleteFileAndUpdate(beanFile);
        EjbReferenceTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "AddedBean"));
    }

    public void testManyEjbFields() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testManyEjbFields.java");
        this.saveFileAndUpdate(beanFile, "package com.sap;@Stateless  public class testManyEjbFields {@EJB(beanInterface = InjectionInterface.class) private InjectionInterface bean1;@EJB() private InjectionInterface bean2;@EJB(beanInterface = Collection.class) private String invalideBean;@EJB(beanInterface = Collection.class) private int simpelType;}");
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "testManyEjbFields");
        EjbReferenceTest.assertNotNull((Object)result);
        EjbReferenceTest.assertEquals((Object)new Integer(2), (Object)new Integer(result.getEjbLocalRefs().size()));
        EjbLocalRef bean1Reference = TestUtils.findLocalRefByName(result.getEjbLocalRefs(), "com.sap.testManyEjbFields/bean1");
        EjbReferenceTest.assertNotNull((Object)bean1Reference);
        EjbReferenceTest.assertEquals((String)"InjectionInterface", (String)bean1Reference.getLocal());
        EjbReferenceTest.assertEquals((String)"InjectionInterface", (String)bean1Reference.getLocalHome());
        EjbLocalRef bean2Reference = TestUtils.findLocalRefByName(result.getEjbLocalRefs(), "com.sap.testManyEjbFields/bean2");
        EjbReferenceTest.assertNotNull((Object)bean2Reference);
        EjbReferenceTest.assertEquals((String)"InjectionInterface", (String)bean2Reference.getLocalHome());
        EjbReferenceTest.assertEquals((String)"InjectionInterface", (String)bean2Reference.getLocal());
        IFile interfaceFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/InjectionInterface.java");
        this.saveFileAndUpdate(interfaceFile, "package com.sap;public interface InjectionInterface {}");
        result = TestUtils.getSessionBean(this.getEJBJar(), "testManyEjbFields");
        EjbReferenceTest.assertNotNull((Object)result);
        bean1Reference = TestUtils.findLocalRefByName(result.getEjbLocalRefs(), "com.sap.testManyEjbFields/bean1");
        bean2Reference = TestUtils.findLocalRefByName(result.getEjbLocalRefs(), "com.sap.testManyEjbFields/bean2");
        EjbReferenceTest.assertEquals((String)"com.sap.InjectionInterface", (String)bean1Reference.getLocal());
        EjbReferenceTest.assertEquals((String)"com.sap.InjectionInterface", (String)bean1Reference.getLocalHome());
        EjbReferenceTest.assertEquals((String)"com.sap.InjectionInterface", (String)bean2Reference.getLocalHome());
        this.deleteFileAndUpdate(interfaceFile);
        result = TestUtils.getSessionBean(this.getEJBJar(), "testManyEjbFields");
        bean1Reference = TestUtils.findLocalRefByName(result.getEjbLocalRefs(), "com.sap.testManyEjbFields/bean1");
        bean2Reference = TestUtils.findLocalRefByName(result.getEjbLocalRefs(), "com.sap.testManyEjbFields/bean2");
        EjbReferenceTest.assertEquals((String)"InjectionInterface", (String)bean1Reference.getLocal());
        EjbReferenceTest.assertEquals((String)"InjectionInterface", (String)bean1Reference.getLocalHome());
        EjbReferenceTest.assertEquals((String)"InjectionInterface", (String)bean2Reference.getLocalHome());
        this.deleteFileAndUpdate(beanFile);
        EjbReferenceTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testManyEjbFields"));
    }

    public void testAddDeleteInterfaceEjbOnMethodAnnotation() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testAddDeleteInterfaceEjbOnMethodAnnotation.java");
        this.saveFileAndUpdate(beanFile, "package com.sap;@Stateless  public class testAddDeleteInterfaceEjbOnMethodAnnotation {@EJB(beanInterface = InjectionInterface.class) public void setBean1(InjectionInterface inter) {}private InjectionInterface bean1;}");
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "testAddDeleteInterfaceEjbOnMethodAnnotation");
        EjbReferenceTest.assertNotNull((Object)result);
        EjbReferenceTest.assertEquals((Object)new Integer(1), (Object)new Integer(result.getEjbLocalRefs().size()));
        EjbLocalRef ref = (EjbLocalRef)result.getEjbLocalRefs().get(0);
        EjbReferenceTest.assertEquals((String)"InjectionInterface", (String)ref.getLocal());
        EjbReferenceTest.assertEquals((Object)new Integer(1), (Object)new Integer(ref.getInjectionTargets().size()));
        InjectionTarget injectionTarget = (InjectionTarget)ref.getInjectionTargets().get(0);
        EjbReferenceTest.assertEquals((String)"com.sap.testAddDeleteInterfaceEjbOnMethodAnnotation", (String)injectionTarget.getInjectionTargetClass());
        EjbReferenceTest.assertEquals((String)"bean1", (String)injectionTarget.getInjectionTargetName());
        IFile interfaceFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/InjectionInterface.java");
        this.saveFileAndUpdate(interfaceFile, "package com.sap;public interface InjectionInterface {}");
        result = TestUtils.getSessionBean(this.getEJBJar(), "testAddDeleteInterfaceEjbOnMethodAnnotation");
        ref = (EjbLocalRef)result.getEjbLocalRefs().get(0);
        EjbReferenceTest.assertEquals((String)"com.sap.InjectionInterface", (String)ref.getLocal());
        this.deleteFileAndUpdate(interfaceFile);
        result = TestUtils.getSessionBean(this.getEJBJar(), "testAddDeleteInterfaceEjbOnMethodAnnotation");
        ref = (EjbLocalRef)result.getEjbLocalRefs().get(0);
        EjbReferenceTest.assertEquals((String)"InjectionInterface", (String)ref.getLocal());
        this.deleteFileAndUpdate(beanFile);
        EjbReferenceTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testAddDeleteInterfaceEjbOnMethodAnnotation"));
    }

    public void testManyEjbMethods() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testManyEjbMethods.java");
        this.saveFileAndUpdate(beanFile, "package com.sap;@Stateless  public class testManyEjbMethods {@EJB(beanInterface = InjectionInterface.class) public void setBean1(InjectionInterface bean1){};@EJB() public void setBean2(InjectionInterface bean2){};@EJB(beanInterface = Collection.class) public void setInvalideBean(String invalideBean) {};}");
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "testManyEjbMethods");
        EjbReferenceTest.assertNotNull((Object)result);
        EjbReferenceTest.assertEquals((Object)new Integer(2), (Object)new Integer(result.getEjbLocalRefs().size()));
        EjbLocalRef bean1Reference = TestUtils.findLocalRefByName(result.getEjbLocalRefs(), "com.sap.testManyEjbMethods/bean1");
        EjbReferenceTest.assertNotNull((Object)bean1Reference);
        EjbReferenceTest.assertEquals((String)"InjectionInterface", (String)bean1Reference.getLocal());
        EjbReferenceTest.assertEquals((String)"InjectionInterface", (String)bean1Reference.getLocalHome());
        EjbLocalRef bean2Reference = TestUtils.findLocalRefByName(result.getEjbLocalRefs(), "com.sap.testManyEjbMethods/bean2");
        EjbReferenceTest.assertNotNull((Object)bean2Reference);
        EjbReferenceTest.assertEquals((String)"InjectionInterface", (String)bean2Reference.getLocalHome());
        EjbReferenceTest.assertEquals((String)"InjectionInterface", (String)bean2Reference.getLocal());
        IFile interfaceFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/InjectionInterface.java");
        this.saveFileAndUpdate(interfaceFile, "package com.sap;public interface InjectionInterface {}");
        result = TestUtils.getSessionBean(this.getEJBJar(), "testManyEjbMethods");
        EjbReferenceTest.assertNotNull((Object)result);
        bean1Reference = TestUtils.findLocalRefByName(result.getEjbLocalRefs(), "com.sap.testManyEjbMethods/bean1");
        bean2Reference = TestUtils.findLocalRefByName(result.getEjbLocalRefs(), "com.sap.testManyEjbMethods/bean2");
        EjbReferenceTest.assertEquals((String)"com.sap.InjectionInterface", (String)bean1Reference.getLocal());
        EjbReferenceTest.assertEquals((String)"com.sap.InjectionInterface", (String)bean1Reference.getLocalHome());
        EjbReferenceTest.assertEquals((String)"com.sap.InjectionInterface", (String)bean2Reference.getLocalHome());
        this.deleteFileAndUpdate(interfaceFile);
        result = TestUtils.getSessionBean(this.getEJBJar(), "testManyEjbMethods");
        bean1Reference = TestUtils.findLocalRefByName(result.getEjbLocalRefs(), "com.sap.testManyEjbMethods/bean1");
        bean2Reference = TestUtils.findLocalRefByName(result.getEjbLocalRefs(), "com.sap.testManyEjbMethods/bean2");
        EjbReferenceTest.assertEquals((String)"InjectionInterface", (String)bean1Reference.getLocal());
        EjbReferenceTest.assertEquals((String)"InjectionInterface", (String)bean1Reference.getLocalHome());
        EjbReferenceTest.assertEquals((String)"InjectionInterface", (String)bean2Reference.getLocalHome());
        this.deleteFileAndUpdate(beanFile);
        EjbReferenceTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testManyEjbMethods"));
    }

    public void testEjbOnMethodAndFieldsOfMessageBean() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testEjbOnMethodAndFieldsOfMessageBean.java");
        this.saveFileAndUpdate(beanFile, "package com.sap;@MessageDriven  public class testEjbOnMethodAndFieldsOfMessageBean {@EJB(beanInterface = InjectionInterface.class) public void setBean1(InjectionInterface bean1){};@EJB() public InjectionInterface bean2;}");
        MessageDrivenBean result = TestUtils.getMessageDrivenBean(this.getEJBJar(), "testEjbOnMethodAndFieldsOfMessageBean");
        EjbReferenceTest.assertNotNull((Object)result);
        EjbReferenceTest.assertEquals((Object)new Integer(2), (Object)new Integer(result.getEjbLocalRefs().size()));
        EjbLocalRef bean1Reference = TestUtils.findLocalRefByName(result.getEjbLocalRefs(), "com.sap.testEjbOnMethodAndFieldsOfMessageBean/bean1");
        EjbReferenceTest.assertNotNull((Object)bean1Reference);
        EjbReferenceTest.assertEquals((String)"InjectionInterface", (String)bean1Reference.getLocal());
        EjbReferenceTest.assertEquals((String)"InjectionInterface", (String)bean1Reference.getLocalHome());
        EjbLocalRef bean2Reference = TestUtils.findLocalRefByName(result.getEjbLocalRefs(), "com.sap.testEjbOnMethodAndFieldsOfMessageBean/bean2");
        EjbReferenceTest.assertNotNull((Object)bean2Reference);
        EjbReferenceTest.assertEquals((String)"InjectionInterface", (String)bean2Reference.getLocalHome());
        EjbReferenceTest.assertEquals((String)"InjectionInterface", (String)bean2Reference.getLocal());
        IFile interfaceFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/InjectionInterface.java");
        this.saveFileAndUpdate(interfaceFile, "package com.sap;public interface InjectionInterface {}");
        result = TestUtils.getMessageDrivenBean(this.getEJBJar(), "testEjbOnMethodAndFieldsOfMessageBean");
        EjbReferenceTest.assertNotNull((Object)result);
        bean1Reference = TestUtils.findLocalRefByName(result.getEjbLocalRefs(), "com.sap.testEjbOnMethodAndFieldsOfMessageBean/bean1");
        bean2Reference = TestUtils.findLocalRefByName(result.getEjbLocalRefs(), "com.sap.testEjbOnMethodAndFieldsOfMessageBean/bean2");
        EjbReferenceTest.assertEquals((String)"com.sap.InjectionInterface", (String)bean1Reference.getLocal());
        EjbReferenceTest.assertEquals((String)"com.sap.InjectionInterface", (String)bean1Reference.getLocalHome());
        EjbReferenceTest.assertEquals((String)"com.sap.InjectionInterface", (String)bean2Reference.getLocalHome());
        this.deleteFileAndUpdate(interfaceFile);
        result = TestUtils.getMessageDrivenBean(this.getEJBJar(), "testEjbOnMethodAndFieldsOfMessageBean");
        bean1Reference = TestUtils.findLocalRefByName(result.getEjbLocalRefs(), "com.sap.testEjbOnMethodAndFieldsOfMessageBean/bean1");
        bean2Reference = TestUtils.findLocalRefByName(result.getEjbLocalRefs(), "com.sap.testEjbOnMethodAndFieldsOfMessageBean/bean2");
        EjbReferenceTest.assertEquals((String)"InjectionInterface", (String)bean1Reference.getLocal());
        EjbReferenceTest.assertEquals((String)"InjectionInterface", (String)bean1Reference.getLocalHome());
        EjbReferenceTest.assertEquals((String)"InjectionInterface", (String)bean2Reference.getLocalHome());
        this.deleteFileAndUpdate(beanFile);
        EjbReferenceTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testEjbOnMethodAndFieldsOfMessageBean"));
    }

    public void testAddDeleteBeanInterfaceOnEjbAnnotation() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testAddDeleteBeanInterfaceOnEjbAnnotation.java");
        this.saveFileAndUpdate(beanFile, "package com.sap;@Stateless @EJB(name=\"refName\", beanInterface = BeanInterface.class, beanName=\"beanName\", mappedName=\"mappedName\") public class testAddDeleteBeanInterfaceOnEjbAnnotation {}");
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "testAddDeleteBeanInterfaceOnEjbAnnotation");
        EjbReferenceTest.assertNotNull((Object)result);
        EjbReferenceTest.assertEquals((Object)new Integer(1), (Object)new Integer(result.getEjbLocalRefs().size()));
        EjbLocalRef ref = (EjbLocalRef)result.getEjbLocalRefs().get(0);
        EjbReferenceTest.assertEquals((String)"BeanInterface", (String)ref.getLocal());
        IFile interfaceFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/BeanInterface.java");
        this.saveFileAndUpdate(interfaceFile, "package com.sap;public interface BeanInterface {}");
        result = TestUtils.getSessionBean(this.getEJBJar(), "testAddDeleteBeanInterfaceOnEjbAnnotation");
        ref = (EjbLocalRef)result.getEjbLocalRefs().get(0);
        EjbReferenceTest.assertEquals((String)"com.sap.BeanInterface", (String)ref.getLocal());
        this.deleteFileAndUpdate(interfaceFile);
        result = TestUtils.getSessionBean(this.getEJBJar(), "testAddDeleteBeanInterfaceOnEjbAnnotation");
        ref = (EjbLocalRef)result.getEjbLocalRefs().get(0);
        EjbReferenceTest.assertEquals((String)"BeanInterface", (String)ref.getLocal());
        this.deleteFileAndUpdate(beanFile);
        EjbReferenceTest.assertFalse((boolean)beanFile.exists());
        EjbReferenceTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testAddDeleteBeanInterfaceOnEjbAnnotation"));
    }

    public void testAddDeleteInterfaceOnEjbsAnnotation() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testAddDeleteInterfaceOnEjbsAnnotation.java");
        this.saveFileAndUpdate(beanFile, "package com.sap;@Stateless @EJBs(value = { @EJB(name=\"comparable\", beanInterface = java.lang.Comparable.class, beanName = \"beanName\"), @EJB(name=\"nonResolved\", beanInterface = BeanInterface.class) })  public class testAddDeleteInterfaceOnEjbsAnnotation {}");
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "testAddDeleteInterfaceOnEjbsAnnotation");
        EjbReferenceTest.assertNotNull((Object)result);
        EjbLocalRef comparable = TestUtils.findLocalRefByName(result.getEjbLocalRefs(), "comparable");
        EjbReferenceTest.assertNotNull((Object)comparable);
        EjbReferenceTest.assertEquals((String)"java.lang.Comparable", (String)comparable.getLocal());
        EjbLocalRef nonResolved = TestUtils.findLocalRefByName(result.getEjbLocalRefs(), "nonResolved");
        EjbReferenceTest.assertNotNull((Object)nonResolved);
        EjbReferenceTest.assertEquals((String)"BeanInterface", (String)nonResolved.getLocal());
        EjbReferenceTest.assertEquals((Object)new Integer(2), (Object)new Integer(result.getEjbLocalRefs().size()));
        IFile interfaceFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/BeanInterface.java");
        this.saveFileAndUpdate(interfaceFile, "package com.sap;public interface BeanInterface {}");
        result = TestUtils.getSessionBean(this.getEJBJar(), "testAddDeleteInterfaceOnEjbsAnnotation");
        nonResolved = TestUtils.findLocalRefByName(result.getEjbLocalRefs(), "nonResolved");
        EjbReferenceTest.assertEquals((String)"com.sap.BeanInterface", (String)nonResolved.getLocal());
        this.deleteFileAndUpdate(interfaceFile);
        result = TestUtils.getSessionBean(this.getEJBJar(), "testAddDeleteInterfaceOnEjbsAnnotation");
        nonResolved = TestUtils.findLocalRefByName(result.getEjbLocalRefs(), "nonResolved");
        EjbReferenceTest.assertEquals((String)"BeanInterface", (String)nonResolved.getLocal());
        this.deleteFileAndUpdate(beanFile);
        EjbReferenceTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testAddDeleteInterfaceOnEjbsAnnotation"));
    }
}

