/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.web.tests;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.etools.common.test.apitools.ProjectUnzipUtil;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.web.Filter;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.j2ee.headless.tests.plugin.HeadlessTestsPlugin;
import org.osgi.framework.Bundle;
import org.w3c.dom.NodeList;

public class TestWebXmlModelAfterUpdate
extends TestCase {
    private static final String PROJECT_NAME = "TestJSTL_Web25";
    private static final Path PROJECT_ZIP_LOCATION = new Path("TestData/WebEditDdExternal/TestJSTL_Web25.zip");
    private static String[] projectNames = new String[]{"TestJSTL_Web25"};
    private static final String TRINIDAD_FILTER_NAME = "trinidad";
    private static final String TRINIDAD_FILTER_CLASS = "trinidadClass";
    private static final String DUMMY_FILTER_NAME = "dummyFilter";
    private static final String DUMMY_FILTER_CLASS = "dummyFilterClass";
    private IProject _iProject;

    public static Test suite() {
        TestSuite suite = new TestSuite(TestWebXmlModelAfterUpdate.class);
        return suite;
    }

    protected void setUp() throws Exception {
        super.setUp();
        ProjectUnzipUtil util = new ProjectUnzipUtil(TestWebXmlModelAfterUpdate.getLocalPath((IPath)PROJECT_ZIP_LOCATION), projectNames);
        util.createProjects();
        this._iProject = ProjectUtilities.getProject((String)projectNames[0]);
    }

    public void testModelAfterWebXmlConfigOperation() throws CoreException, UnsupportedEncodingException, IOException, MalformedTreeException, BadLocationException {
        this.addDummyFilterUsingWebapp();
        this.addTrinidadFilterUsingNonWebapp();
        this.removeTrinidadFilterUsingWebapp();
    }

    private void removeTrinidadFilterUsingWebapp() {
        final IModelProvider modelProvider = ModelProviderManager.getModelProvider((IProject)this._iProject);
        modelProvider.modify(new Runnable(){

            public void run() {
                WebApp webapp = (WebApp)modelProvider.getModelObject();
                TestWebXmlModelAfterUpdate.assertNotNull((String)"Expected non-null webapp", (Object)webapp);
                List filters = webapp.getFilters();
                TestWebXmlModelAfterUpdate.assertNotNull((String)"Expected non-null list of filters", (Object)filters);
                Filter filterToRemove = TestWebXmlModelAfterUpdate.findFilter(webapp, TestWebXmlModelAfterUpdate.TRINIDAD_FILTER_NAME);
                TestWebXmlModelAfterUpdate.assertNotNull((String)"Expected Trinidad filter to be non-null", (Object)filterToRemove);
                TestWebXmlModelAfterUpdate.assertTrue((boolean)filters.remove(filterToRemove));
            }
        }, (IPath)new Path("WEB-INF/web.xml"));
    }

    private void addDummyFilterUsingWebapp() {
        final IModelProvider modelProvider = ModelProviderManager.getModelProvider((IProject)this._iProject);
        modelProvider.modify(new Runnable(){

            public void run() {
                Filter filter = WebFactory.eINSTANCE.createFilter();
                filter.setFilterName(TestWebXmlModelAfterUpdate.DUMMY_FILTER_NAME);
                filter.setFilterClass(TestWebXmlModelAfterUpdate.DUMMY_FILTER_CLASS);
                WebApp webapp = (WebApp)modelProvider.getModelObject();
                webapp.getFilters().add(filter);
            }
        }, (IPath)new Path("WEB-INF/web.xml"));
    }

    private void addTrinidadFilterUsingNonWebapp() throws CoreException, UnsupportedEncodingException, IOException, MalformedTreeException, BadLocationException {
        IFile webXmlIfile = this._iProject.getFile("WebContent/WEB-INF/web.xml");
        TestWebXmlModelAfterUpdate.assertTrue((boolean)webXmlIfile.exists());
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().getModelForEdit(webXmlIfile);
        TestWebXmlModelAfterUpdate.assertNotNull((String)"Expected non-null web.xml DOM model", (Object)model);
        model.aboutToChangeModel();
        IDOMDocument document = model.getDocument();
        MapNamespaceContext namespaceContextMap = new MapNamespaceContext();
        namespaceContextMap.put("ns", "http://java.sun.com/xml/ns/javaee");
        NodeList nodeList = TestWebXmlModelAfterUpdate.resolveXpath(document, "//ns:web-app", namespaceContextMap);
        IDOMNode node = (IDOMNode)nodeList.item(0);
        int offset = node.getEndStructuredDocumentRegion().getStartOffset();
        MultiTextEdit edit = new MultiTextEdit();
        InsertEdit insertEdit = new InsertEdit(offset, "<filter>\n    <filter-name>trinidad</filter-name>\n    <filter-class>trinidadClass</filter-class>\n</filter>\n");
        edit.addChild((TextEdit)insertEdit);
        FileBuffers.getTextFileBufferManager().connect(webXmlIfile.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(webXmlIfile.getFullPath(), LocationKind.IFILE);
        IDocument idocument = buffer.getDocument();
        edit.apply(idocument);
        model.save();
        model.changedModel();
    }

    private static Filter findFilter(WebApp webapp, String filterName) {
        for (Object filter : webapp.getFilters()) {
            if (!((Filter)filter).getFilterName().equals(filterName)) continue;
            return (Filter)filter;
        }
        return null;
    }

    private static NodeList resolveXpath(IDOMDocument document, String xPathExpression, NamespaceContext namespaceContext) {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        if (namespaceContext != null) {
            xPath.setNamespaceContext(namespaceContext);
        }
        NodeList nodeList = null;
        try {
            Object nodeEval = xPath.evaluate(xPathExpression, document, XPathConstants.NODESET);
            if (nodeEval instanceof NodeList) {
                nodeList = (NodeList)nodeEval;
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return nodeList;
    }

    private static IPath getLocalPath(IPath path) {
        URL url = FileLocator.find((Bundle)HeadlessTestsPlugin.getDefault().getBundle(), (IPath)path, null);
        try {
            url = FileLocator.toFileURL((URL)url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new Path(url.getPath());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapNamespaceContext
    implements NamespaceContext {
        private final Map<String, String> prefixToUri = new HashMap<String, String>();
        private final Map<String, String> uriToPrefix = new HashMap<String, String>();

        private MapNamespaceContext() {
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.prefixToUri.get(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return this.uriToPrefix.get(namespaceURI);
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceURI) {
            return this.prefixToUri.keySet().iterator();
        }

        public void put(String prefix, String uri) {
            this.prefixToUri.put(prefix, uri);
            this.uriToPrefix.put(uri, prefix);
        }
    }
}

