/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.web.tests;

import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.Listener;
import org.eclipse.jst.javaee.core.RunAs;
import org.eclipse.jst.javaee.core.SecurityRole;
import org.eclipse.jst.javaee.core.SecurityRoleRef;
import org.eclipse.jst.javaee.web.Filter;
import org.eclipse.jst.javaee.web.Servlet;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.jst.jee.model.internal.WebAnnotationReader;
import org.eclipse.jst.jee.model.tests.AbstractAnnotationModelTest;
import org.eclipse.jst.jee.model.tests.AbstractTest;
import org.eclipse.jst.jee.model.tests.TestUtils;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;

public class WebAnnotationReaderTest
extends AbstractAnnotationModelTest {
    private static String BEAN_WITH_NAME = "package com.sap;import javax.ejb.Stateless;@Stateless(name=\"%s\") public class BeanWithName implements SessionBeanLocal {}";
    private WebApp ddApp;

    public static TestSuite suite() throws Exception {
        TestSuite suite = new TestSuite(WebAnnotationReaderTest.class);
        return suite;
    }

    public static void setUpProject() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(WebAnnotationReaderTest.class.getSimpleName());
        if (!project.exists()) {
            IFacetedProject facetedProject = AbstractTest.createWebProject(WebAnnotationReaderTest.class.getSimpleName());
            WebAnnotationReaderTest.createProjectContent(facetedProject.getProject());
        }
    }

    public static void tearDownAfterClass() throws InterruptedException {
        AbstractTest.deleteProject(WebAnnotationReaderTest.class.getSimpleName());
    }

    private static void createProjectContent(IProject project) throws Exception {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IFolder comFolder = javaProject.getProject().getFolder("src/com");
        comFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)comFolder);
        IPackageFragment fragment = root.createPackageFragment("sap", true, (IProgressMonitor)new NullProgressMonitor());
        WebAnnotationReaderTest.createServlet(fragment);
        WebAnnotationReaderTest.createServletWithSecurity(fragment);
    }

    private static void createServlet(IPackageFragment fragment) throws Exception {
        IFile file = ((IContainer)fragment.getResource()).getFile((IPath)new Path("Servlet1.java"));
        AbstractTest.saveFile(file, "package com.sap;import javax.annotation.Resource;import javax.ejb.EJB;import javax.servlet.http.HttpServlet;public class Servlet1 extends HttpServlet {private static final long serialVersionUID = 1L;@EJB private Comparable comp; @EJB public void setComparable(Comparable comp){};@Resource private Comparable comp2; @Resource public void setComparable2(Comparable comp){} }");
    }

    private static void createServletWithSecurity(IPackageFragment fragment) throws Exception {
        IFile file = ((IContainer)fragment.getResource()).getFile((IPath)new Path("ServletWithSecurity.java"));
        AbstractTest.saveFile(file, "package com.sap;import javax.servlet.http.HttpServlet;@DeclareRoles(value = {\"role1\", \"role2\"})  public class ServletWithSecurity extends HttpServlet {}");
    }

    protected void setUp() throws Exception {
        WebAnnotationReaderTest.setUpProject();
        super.setUp();
        this.ddApp = WebFactory.eINSTANCE.createWebApp();
        WebAnnotationReaderTest.addServlet(this.ddApp, "ServletWithSecurity", "com.sap.ServletWithSecurity");
        WebAnnotationReaderTest.addServlet(this.ddApp, "Servlet1", "com.sap.Servlet1");
        this.fixture = new WebAnnotationReader(this.facetedProject, this.ddApp);
    }

    protected void tearDown() throws Exception {
        ((WebAnnotationReader)this.fixture).dispose();
    }

    public void testCerateReaderWithNullProject() {
        try {
            new WebAnnotationReader(null, this.ddApp);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testServletEjbRef() {
        WebApp app = (WebApp)this.fixture.getModelObject();
        WebAnnotationReaderTest.assertNotNull((Object)app);
        WebAnnotationReaderTest.assertEquals((Object)new Integer(2), (Object)new Integer(app.getEjbLocalRefs().size()));
    }

    public void testServletResourceRef() {
        WebApp app = (WebApp)this.fixture.getModelObject();
        WebAnnotationReaderTest.assertNotNull((Object)app);
        WebAnnotationReaderTest.assertEquals((Object)new Integer(2), (Object)new Integer(app.getResourceRefs().size()));
    }

    public void testSecurityRoles() {
        WebApp app = (WebApp)this.fixture.getModelObject();
        WebAnnotationReaderTest.assertNotNull((Object)app);
        WebAnnotationReaderTest.assertEquals((Object)new Integer(2), (Object)new Integer(app.getSecurityRoles().size()));
    }

    public void testAddDeleteEjbRef() throws Exception {
        WebAnnotationReaderTest.addServlet(this.ddApp, "testAddDeleteEjbRef", "com.sap.testAddDeleteEjbRef");
        IFile file = this.facetedProject.getProject().getFile("src/com/sap/testAddDeleteEjbRef.java");
        this.saveFileAndUpdate(file, "package com.sap;import javax.annotation.Resource;import javax.ejb.EJB;import javax.servlet.http.HttpServlet;public class testAddDeleteEjbRef extends HttpServlet {private static final long serialVersionUID = 1L;@EJB private Comparable comp; @EJB public void setComparable(Comparable comp){};}");
        WebApp result = (WebApp)this.fixture.getModelObject();
        WebAnnotationReaderTest.assertEquals((Object)new Integer(4), (Object)new Integer(result.getEjbLocalRefs().size()));
        this.deleteFileAndUpdate(file);
        result = (WebApp)this.fixture.getModelObject();
        WebAnnotationReaderTest.assertEquals((Object)new Integer(2), (Object)new Integer(result.getEjbLocalRefs().size()));
    }

    public void testNotAServletAddDeleteEjbRef() throws Exception {
        IFile file = this.facetedProject.getProject().getFile("src/com/sap/testNotAServletAddDeleteEjbRef.java");
        AbstractTest.saveFile(file, "package com.sap;import javax.annotation.Resource;import javax.ejb.EJB;import javax.servlet.http.HttpServlet;public class testNotAServletAddDeleteEjbRef extends HttpServlet {private static final long serialVersionUID = 1L;@EJB private Comparable comp; @EJB public void setComparable(Comparable comp){};}");
        WebApp result = (WebApp)this.fixture.getModelObject();
        WebAnnotationReaderTest.assertEquals((Object)new Integer(2), (Object)new Integer(result.getEjbLocalRefs().size()));
        AbstractTest.deleteFile(file);
        result = (WebApp)this.fixture.getModelObject();
        WebAnnotationReaderTest.assertEquals((Object)new Integer(2), (Object)new Integer(result.getEjbLocalRefs().size()));
    }

    public void testAddDeleteResourceRef() throws Exception {
        WebAnnotationReaderTest.addServlet(this.ddApp, "testAddDeleteResourceRef", "com.sap.testAddDeleteResourceRef");
        IFile file = this.facetedProject.getProject().getFile("src/com/sap/testAddDeleteResourceRef.java");
        this.saveFileAndUpdate(file, "package com.sap;import javax.annotation.Resource;import javax.ejb.EJB;import javax.servlet.http.HttpServlet;public class testAddDeleteResourceRef extends HttpServlet {private static final long serialVersionUID = 1L;@Resource private Comparable comp2; @Resource public void setComparable2(Comparable comp){} }");
        WebApp result = (WebApp)this.fixture.getModelObject();
        WebAnnotationReaderTest.assertEquals((Object)new Integer(4), (Object)new Integer(result.getResourceRefs().size()));
        this.deleteFileAndUpdate(file);
        result = (WebApp)this.fixture.getModelObject();
        WebAnnotationReaderTest.assertEquals((Object)new Integer(2), (Object)new Integer(result.getResourceRefs().size()));
    }

    public void testListener() throws Exception {
        WebAnnotationReaderTest.addListener(this.ddApp, "com.sap.testListener");
        IFile file = this.facetedProject.getProject().getFile("src/com/sap/testListener.java");
        this.saveFileAndUpdate(file, "package com.sap;import javax.annotation.Resource;import javax.ejb.EJB;public class testListener {@EJB private Comparable comp; @EJB public void setComparable(Comparable comp){};@Resource private Comparable comp2; @Resource public void setComparable2(Comparable comp){} }");
        WebApp result = (WebApp)this.fixture.getModelObject();
        WebAnnotationReaderTest.assertEquals((Object)new Integer(4), (Object)new Integer(result.getResourceRefs().size()));
        WebAnnotationReaderTest.assertEquals((Object)new Integer(4), (Object)new Integer(result.getEjbLocalRefs().size()));
        this.deleteFileAndUpdate(file);
        result = (WebApp)this.fixture.getModelObject();
        WebAnnotationReaderTest.assertEquals((Object)new Integer(2), (Object)new Integer(result.getResourceRefs().size()));
        WebAnnotationReaderTest.assertEquals((Object)new Integer(2), (Object)new Integer(result.getEjbLocalRefs().size()));
    }

    public void testFilter() throws Exception {
        WebAnnotationReaderTest.addFilter(this.ddApp, "com.sap.testFilter");
        IFile file = this.facetedProject.getProject().getFile("src/com/sap/testFilter.java");
        this.saveFileAndUpdate(file, "package com.sap;import javax.annotation.Resource;import javax.ejb.EJB;public class testFilter {@EJB private Comparable comp; @EJB public void setComparable(Comparable comp){};@Resource private Comparable comp2; @Resource public void setComparable2(Comparable comp){} }");
        WebApp result = (WebApp)this.fixture.getModelObject();
        WebAnnotationReaderTest.assertEquals((Object)new Integer(4), (Object)new Integer(result.getResourceRefs().size()));
        WebAnnotationReaderTest.assertEquals((Object)new Integer(4), (Object)new Integer(result.getEjbLocalRefs().size()));
        this.deleteFileAndUpdate(file);
        result = (WebApp)this.fixture.getModelObject();
        WebAnnotationReaderTest.assertEquals((Object)new Integer(2), (Object)new Integer(result.getResourceRefs().size()));
        WebAnnotationReaderTest.assertEquals((Object)new Integer(2), (Object)new Integer(result.getEjbLocalRefs().size()));
    }

    public void testResourcesServlet() throws Exception {
        WebAnnotationReaderTest.addServlet(this.ddApp, "testResourcesServlet", "com.sap.testResourcesServlet");
        IFile file = this.facetedProject.getProject().getFile("src/com/sap/testResourcesServlet.java");
        this.saveFileAndUpdate(file, "package com.sap;import javax.annotation.Resource;import javax.ejb.EJB;@Resources(value = {@Resource(name = \"withNotDefaults\", mappedName = \"mappedName\", \tshareable = false, type = java.lang.Comparable.class, \tauthenticationType = AuthenticationType.APPLICATION, description = \"description\"),@Resource(name = \"withDefaults\", type = java.lang.Comparable.class), @Resource(name = \"invalidNoType\") })public class testResourcesServlet {}");
        WebApp result = (WebApp)this.fixture.getModelObject();
        WebAnnotationReaderTest.assertEquals((Object)new Integer(4), (Object)new Integer(result.getResourceRefs().size()));
        this.deleteFileAndUpdate(file);
        result = (WebApp)this.fixture.getModelObject();
        WebAnnotationReaderTest.assertEquals((Object)new Integer(2), (Object)new Integer(result.getResourceRefs().size()));
    }

    public void testResourcesFilter() throws Exception {
        WebAnnotationReaderTest.addFilter(this.ddApp, "com.sap.testResourcesFilter");
        IFile file = this.facetedProject.getProject().getFile("src/com/sap/testResourcesFilter.java");
        this.saveFileAndUpdate(file, "package com.sap;import javax.annotation.Resource;import javax.ejb.EJB;@Resources(value = {@Resource(name = \"withNotDefaults\", mappedName = \"mappedName\", \tshareable = false, type = java.lang.Comparable.class, \tauthenticationType = AuthenticationType.APPLICATION, description = \"description\"),@Resource(name = \"withDefaults\", type = java.lang.Comparable.class), @Resource(name = \"invalidNoType\") })public class testResourcesFilter {}");
        WebApp result = (WebApp)this.fixture.getModelObject();
        WebAnnotationReaderTest.assertEquals((Object)new Integer(4), (Object)new Integer(result.getResourceRefs().size()));
        this.deleteFileAndUpdate(file);
        result = (WebApp)this.fixture.getModelObject();
        WebAnnotationReaderTest.assertEquals((Object)new Integer(2), (Object)new Integer(result.getResourceRefs().size()));
    }

    public void testResourcesOnListener() throws Exception {
        WebAnnotationReaderTest.addServlet(this.ddApp, "testResourcesOnListener", "com.sap.testResourcesOnListener");
        IFile file = this.facetedProject.getProject().getFile("src/com/sap/testResourcesOnListener.java");
        this.saveFileAndUpdate(file, "package com.sap;import javax.annotation.Resource;import javax.ejb.EJB;@Resources(value = {@Resource(name = \"withNotDefaults\", mappedName = \"mappedName\", \tshareable = false, type = java.lang.Comparable.class, \tauthenticationType = AuthenticationType.APPLICATION, description = \"description\"),@Resource(name = \"withDefaults\", type = java.lang.Comparable.class), @Resource(name = \"invalidNoType\") })public class testResourcesOnListener {}");
        WebApp result = (WebApp)this.fixture.getModelObject();
        WebAnnotationReaderTest.assertEquals((Object)new Integer(4), (Object)new Integer(result.getResourceRefs().size()));
        this.deleteFileAndUpdate(file);
        result = (WebApp)this.fixture.getModelObject();
        WebAnnotationReaderTest.assertEquals((Object)new Integer(2), (Object)new Integer(result.getResourceRefs().size()));
    }

    public void testDeclareRoles() throws Exception {
        WebAnnotationReaderTest.addServlet(this.ddApp, "testDeclareRoles", "com.sap.testDeclareRoles");
        IFile servletFile = this.facetedProject.getProject().getFile("src/com/sap/testDeclareRoles.java");
        this.saveFileAndUpdate(servletFile, "package com.sap;@DeclareRoles(value = {\"testDeclareRoles1\", \"testDeclareRoles1\"}) public class testDeclareRoles extends HttpServlet {}");
        WebApp app = (WebApp)this.fixture.getModelObject();
        Servlet result = TestUtils.findServletByName(app, "testDeclareRoles");
        WebAnnotationReaderTest.assertNotNull((Object)result);
        SecurityRole role1 = TestUtils.findSecurityRole(app.getSecurityRoles(), "testDeclareRoles1");
        SecurityRole role2 = TestUtils.findSecurityRole(app.getSecurityRoles(), "testDeclareRoles1");
        WebAnnotationReaderTest.assertNotNull((Object)role1);
        WebAnnotationReaderTest.assertNotNull((Object)role2);
        SecurityRoleRef role1Ref = TestUtils.findSecurityRoleRef(result.getSecurityRoleRefs(), "testDeclareRoles1");
        WebAnnotationReaderTest.assertNotNull((Object)role1Ref);
        SecurityRoleRef role2Ref = TestUtils.findSecurityRoleRef(result.getSecurityRoleRefs(), "testDeclareRoles1");
        WebAnnotationReaderTest.assertNotNull((Object)role2Ref);
        this.deleteFileAndUpdate(servletFile);
        app = (WebApp)this.fixture.getModelObject();
        WebAnnotationReaderTest.assertNull((Object)TestUtils.findServletByName(app, "testDeclareRoles"));
        WebAnnotationReaderTest.assertNull((Object)TestUtils.findSecurityRole(app.getSecurityRoles(), "testDeclareRoles1"));
        WebAnnotationReaderTest.assertNull((Object)TestUtils.findSecurityRole(app.getSecurityRoles(), "testDeclareRoles1"));
    }

    public void testDeclareRoleOnManyServlets() throws Exception {
        WebAnnotationReaderTest.addServlet(this.ddApp, "testDeclareRoleOnManyServlets1", "com.sap.testDeclareRoleOnManyServlets1");
        WebAnnotationReaderTest.addServlet(this.ddApp, "testDeclareRoleOnManyServlets2", "com.sap.testDeclareRoleOnManyServlets2");
        IFile bean1File = this.facetedProject.getProject().getFile("src/com/sap/testDeclareRoleOnManyServlets1.java");
        IFile bean2File = this.facetedProject.getProject().getFile("src/com/sap/testDeclareRoleOnManyServlets2.java");
        this.saveFileAndUpdate(bean1File, "package com.sap;@DeclareRoles(value = {\"testDeclareRoleOnManyBeansRole\"}) public class testDeclareRoleOnManyServlets1 implements SessionBeanLocal {}");
        this.saveFileAndUpdate(bean2File, "package com.sap;@DeclareRoles(value = {\"testDeclareRoleOnManyBeansRole\"}) public class testDeclareRoleOnManyServlets2 implements SessionBeanLocal {}");
        WebApp app = (WebApp)this.fixture.getModelObject();
        Servlet result = TestUtils.findServletByName(app, "testDeclareRoleOnManyServlets1");
        SecurityRole role1 = TestUtils.findSecurityRole(app.getSecurityRoles(), "testDeclareRoleOnManyBeansRole");
        WebAnnotationReaderTest.assertNotNull((Object)role1);
        SecurityRoleRef role1Ref = TestUtils.findSecurityRoleRef(result.getSecurityRoleRefs(), "testDeclareRoleOnManyBeansRole");
        WebAnnotationReaderTest.assertNotNull((Object)role1Ref);
        this.deleteFileAndUpdate(bean1File);
        WebAnnotationReaderTest.assertNotNull((Object)TestUtils.findSecurityRole(app.getSecurityRoles(), "testDeclareRoleOnManyBeansRole"));
        this.deleteFileAndUpdate(bean2File);
        WebAnnotationReaderTest.assertNull((Object)TestUtils.findSecurityRole(app.getSecurityRoles(), "testDeclareRoleOnManyBeansRole"));
    }

    public void testRunAs() throws Exception {
        WebAnnotationReaderTest.addServlet(this.ddApp, "testRunAs", "com.sap.testRunAs");
        IFile servletFile = this.facetedProject.getProject().getFile("src/com/sap/testRunAs.java");
        this.saveFileAndUpdate(servletFile, "package com.sap;@DeclareRoles(value = {\"testRunAsRole\"}) @RunAs(value = \"testRunAsRole\") public class testRunAs{}");
        WebApp app = (WebApp)this.fixture.getModelObject();
        Servlet result = TestUtils.findServletByName(app, "testRunAs");
        SecurityRole role1 = TestUtils.findSecurityRole(app.getSecurityRoles(), "testRunAsRole");
        WebAnnotationReaderTest.assertNotNull((Object)role1);
        SecurityRoleRef role1Ref = TestUtils.findSecurityRoleRef(result.getSecurityRoleRefs(), "testRunAsRole");
        WebAnnotationReaderTest.assertNotNull((Object)role1Ref);
        RunAs runAs = result.getRunAs();
        WebAnnotationReaderTest.assertNotNull((Object)runAs);
        WebAnnotationReaderTest.assertEquals((String)"testRunAsRole", (String)runAs.getRoleName());
        this.deleteFileAndUpdate(servletFile);
        WebAnnotationReaderTest.assertNull((Object)TestUtils.findSecurityRole(((WebApp)this.fixture.getModelObject()).getSecurityRoles(), "testRunAsRole"));
    }

    public void testAddEjbRefToServlet() throws Exception {
        WebAnnotationReaderTest.addServlet(this.ddApp, "testAddEjbRefToServlet", "com.sap.testAddEjbRefToServlet");
        IFile file = this.facetedProject.getProject().getFile("src/com/sap/testAddEjbRefToServlet.java");
        this.saveFileAndUpdate(file, "package com.sap;import javax.annotation.Resource;import javax.ejb.EJB;import javax.servlet.http.HttpServlet;public class testAddEjbRefToServlet extends HttpServlet {private static final long serialVersionUID = 1L;}");
        WebApp app = (WebApp)this.fixture.getModelObject();
        WebAnnotationReaderTest.assertEquals((Object)new Integer(2), (Object)new Integer(app.getEjbLocalRefs().size()));
        this.saveFileAndUpdate(file, "package com.sap;import javax.annotation.Resource;import javax.ejb.EJB;import javax.servlet.http.HttpServlet;public class testAddEjbRefToServlet extends HttpServlet {private static final long serialVersionUID = 1L;@EJB private Comparable comp; @EJB public void setComparable(Comparable comp){};}");
        app = (WebApp)this.fixture.getModelObject();
        WebAnnotationReaderTest.assertEquals((Object)new Integer(4), (Object)new Integer(app.getEjbLocalRefs().size()));
        this.deleteFileAndUpdate(file);
        app = (WebApp)this.fixture.getModelObject();
        WebAnnotationReaderTest.assertEquals((Object)new Integer(2), (Object)new Integer(app.getEjbLocalRefs().size()));
    }

    private static void addListener(WebApp app, String listenerClass) {
        Listener listener = JavaeeFactory.eINSTANCE.createListener();
        listener.setListenerClass(listenerClass);
        app.getListeners().add(listener);
    }

    private static void addServlet(WebApp app, String servletName, String servletClass) {
        Servlet servlet = WebFactory.eINSTANCE.createServlet();
        servlet.setServletName(servletName);
        servlet.setServletClass(servletClass);
        app.getServlets().add(servlet);
    }

    private static void addFilter(WebApp app, String filterClass) {
        Filter filter = WebFactory.eINSTANCE.createFilter();
        filter.setFilterClass(filterClass);
        app.getFilters().add(filter);
    }
}

