/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.ear.operations;

import java.util.Collections;
import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.j2ee.application.internal.operations.EARComponentImportDataModelProvider;
import org.eclipse.jst.j2ee.internal.archive.ArchiveWrapper;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.tests.OperationTestCase;
import org.eclipse.wst.common.tests.SimpleTestSuite;
import org.eclipse.wtp.j2ee.headless.tests.ear.operations.EARExportOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.JEEImportOperationTest;

public class EARImportOperationTest
extends JEEImportOperationTest {
    public EARImportOperationTest() {
        super("EARImportOperationTests");
    }

    public EARImportOperationTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new SimpleTestSuite(EARImportOperationTest.class);
    }

    public void testEARImport12_WithDependencies() throws Exception {
        this.runImportTests_All("EAR12");
    }

    public void testEARImport13_WithDependencies() throws Exception {
        this.runImportTests_All("EAR13");
    }

    public void testEARImport14_WithDependencies() throws Exception {
        this.runImportTests_All("EAR14");
    }

    public void testEARImport50_WithDependencies() throws Exception {
        this.runImportTests_All("EAR50");
    }

    public void testEARImport12_ChangedContentDir_WithDependencies() throws Exception {
        this.runImportTests_All("EAR12_ChangedContentDir");
    }

    public void testEARImport13_ChangedContentDir_WithDependencies() throws Exception {
        this.runImportTests_All("EAR13_ChangedContentDir");
    }

    public void testEARImport14_ChangedContentDir_WithDependencies() throws Exception {
        this.runImportTests_All("EAR14_ChangedContentDir");
    }

    public void testEARImport50_ChangedContentDir_WithDependencies() throws Exception {
        this.runImportTests_All("EAR50_ChangedContentDir");
    }

    public void testEARImport50_EAR5NoDD_DependincesNoDDs() throws Exception {
        String archiveName = "EAR5NoDD_DependincesNoDDs" + this.getModuleExtension();
        this.runAndVerifyImport_ExportedWithSource(archiveName);
        OperationTestCase.deleteAllProjects();
        this.runAndVerifyImport_DontExplodeAllModules(archiveName);
        OperationTestCase.deleteAllProjects();
        this.runAndVerifyImport_DontExplodeAnyModules(archiveName);
        OperationTestCase.deleteAllProjects();
    }

    public void testEARImport50_EAR5NoDD_DependincesNoDDs_WithUtil() throws Exception {
        String archiveName = "EAR5NoDD_DependincesNoDDs_WithUtil" + this.getModuleExtension();
        this.runAndVerifyImport_ExportedWithSource(archiveName);
        OperationTestCase.deleteAllProjects();
        this.runAndVerifyImport_DontExplodeAllModules(archiveName);
        OperationTestCase.deleteAllProjects();
        this.runAndVerifyImport_DontExplodeAnyModules(archiveName);
        OperationTestCase.deleteAllProjects();
    }

    public void testEARImport50_EAR5NoDD_DependincesWithDDs() throws Exception {
        String archiveName = "EAR5NoDD_DependincesWithDDs" + this.getModuleExtension();
        this.runAndVerifyImport_ExportedWithSource(archiveName);
        OperationTestCase.deleteAllProjects();
        this.runAndVerifyImport_DontExplodeAllModules(archiveName);
        OperationTestCase.deleteAllProjects();
        this.runAndVerifyImport_DontExplodeAnyModules(archiveName);
        OperationTestCase.deleteAllProjects();
    }

    public void testEARImport50_EAR5NoDD_DependincesWithDDs_WithUtil() throws Exception {
        String archiveName = "EAR5NoDD_DependincesWithDDs_WithUtil" + this.getModuleExtension();
        this.runAndVerifyImport_ExportedWithSource(archiveName);
        OperationTestCase.deleteAllProjects();
        this.runAndVerifyImport_DontExplodeAllModules(archiveName);
        OperationTestCase.deleteAllProjects();
        this.runAndVerifyImport_DontExplodeAnyModules(archiveName);
        OperationTestCase.deleteAllProjects();
    }

    public void testEARImport50_EAR5NoDD_DependincesNoDDsAndWithDDs() throws Exception {
        String archiveName = "EAR5NoDD_DependincesNoDDsAndWithDDs" + this.getModuleExtension();
        this.runAndVerifyImport_ExportedWithSource(archiveName);
        OperationTestCase.deleteAllProjects();
        this.runAndVerifyImport_DontExplodeAllModules(archiveName);
        OperationTestCase.deleteAllProjects();
        this.runAndVerifyImport_DontExplodeAnyModules(archiveName);
        OperationTestCase.deleteAllProjects();
    }

    public void testEARImport50_EAR5NoDD_DependincesNoDDsAndWithDDs_WithUtil() throws Exception {
        String archiveName = "EAR5NoDD_DependincesNoDDsAndWithDDs_WithUtil" + this.getModuleExtension();
        this.runAndVerifyImport_ExportedWithSource(archiveName);
        OperationTestCase.deleteAllProjects();
        this.runAndVerifyImport_DontExplodeAllModules(archiveName);
        OperationTestCase.deleteAllProjects();
        this.runAndVerifyImport_DontExplodeAnyModules(archiveName);
        OperationTestCase.deleteAllProjects();
    }

    public void testEARImport50_EAR5WithDD_DependincesNoDDs() throws Exception {
        String archiveName = "EAR5WithDD_DependincesNoDDs" + this.getModuleExtension();
        this.runAndVerifyImport_ExportedWithSource(archiveName);
        OperationTestCase.deleteAllProjects();
        this.runAndVerifyImport_DontExplodeAllModules(archiveName);
        OperationTestCase.deleteAllProjects();
        this.runAndVerifyImport_DontExplodeAnyModules(archiveName);
        OperationTestCase.deleteAllProjects();
    }

    public void testEARImport50_EAR5WithDD_DependincesNoDDs_WithUtil() throws Exception {
        String archiveName = "EAR5WithDD_DependincesNoDDs_WithUtil" + this.getModuleExtension();
        this.runAndVerifyImport_ExportedWithSource(archiveName);
        OperationTestCase.deleteAllProjects();
        this.runAndVerifyImport_DontExplodeAllModules(archiveName);
        OperationTestCase.deleteAllProjects();
        this.runAndVerifyImport_DontExplodeAnyModules(archiveName);
        OperationTestCase.deleteAllProjects();
    }

    public void testEARImport50_EAR5WithDD_DependincesWithDDs() throws Exception {
        String archiveName = "EAR5WithDD_DependincesWithDDs" + this.getModuleExtension();
        this.runAndVerifyImport_ExportedWithSource(archiveName);
        OperationTestCase.deleteAllProjects();
        this.runAndVerifyImport_DontExplodeAllModules(archiveName);
        OperationTestCase.deleteAllProjects();
        this.runAndVerifyImport_DontExplodeAnyModules(archiveName);
        OperationTestCase.deleteAllProjects();
    }

    public void testEARImport50_EAR5WithDD_DependincesWithDDs_WithUtil() throws Exception {
        String archiveName = "EAR5WithDD_DependincesWithDDs_WithUtil" + this.getModuleExtension();
        this.runAndVerifyImport_ExportedWithSource(archiveName);
        OperationTestCase.deleteAllProjects();
        this.runAndVerifyImport_DontExplodeAllModules(archiveName);
        OperationTestCase.deleteAllProjects();
        this.runAndVerifyImport_DontExplodeAnyModules(archiveName);
        OperationTestCase.deleteAllProjects();
    }

    public void testEARImport50_EAR5WithDD_DependincesNoDDsAndWithDDs() throws Exception {
        String archiveName = "EAR5WithDD_DependincesNoDDsAndWithDDs" + this.getModuleExtension();
        this.runAndVerifyImport_ExportedWithSource(archiveName);
        OperationTestCase.deleteAllProjects();
        this.runAndVerifyImport_DontExplodeAllModules(archiveName);
        OperationTestCase.deleteAllProjects();
        this.runAndVerifyImport_DontExplodeAnyModules(archiveName);
        OperationTestCase.deleteAllProjects();
    }

    public void testEARImport50_EAR5WithDD_DependincesNoDDsAndWithDDs_WithUtil() throws Exception {
        String archiveName = "EAR5WithDD_DependincesNoDDsAndWithDDs_WithUtil" + this.getModuleExtension();
        this.runAndVerifyImport_ExportedWithSource(archiveName);
        OperationTestCase.deleteAllProjects();
        this.runAndVerifyImport_DontExplodeAllModules(archiveName);
        OperationTestCase.deleteAllProjects();
        this.runAndVerifyImport_DontExplodeAnyModules(archiveName);
        OperationTestCase.deleteAllProjects();
    }

    public void test288180() throws Exception {
        String archiveName = "288180.ear";
        String archivePath = this.getArchivePath(archiveName);
        this.verifyImportArchiveExists(archivePath);
        IDataModel importModel = this.getImportDataModel(archivePath, "288180", null, true);
        IStatus status = importModel.validate();
        EARImportOperationTest.assertTrue((boolean)status.isOK());
        importModel.dispose();
        OperationTestCase.deleteAllProjects();
    }

    protected String getModuleExtension() {
        return ".ear";
    }

    protected IDataModel getImportDataModel(String filePath, String projectName, IDataModel creationModel, boolean closeArchiveOnDispose) {
        return EARImportOperationTest.getEARImportDataModel(filePath, projectName, creationModel, closeArchiveOnDispose);
    }

    public static IDataModel getEARImportDataModel(String filePath, String projectName, IDataModel creationModel, boolean closeArchiveOnDispose) {
        IDataModel importModel = DataModelFactory.createDataModel((IDataModelProvider)new EARComponentImportDataModelProvider());
        importModel.setProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME", (Object)filePath);
        importModel.setProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME", (Object)projectName);
        importModel.setProperty("IJ2EEArtifactImportDataModelProperties.closeArchiveOnDispose", (Object)closeArchiveOnDispose);
        if (creationModel != null) {
            importModel.setProperty("IJ2EEArtifactImportDataModelProperties.NESTED_MODEL_J2EE_COMPONENT_CREATION", (Object)creationModel);
        }
        return importModel;
    }

    public static IDataModel setExtendedEARImportDataModelProperties(IDataModel importModel, IPath nestedModuleRoot, List utilityList, List selectedModelsList, List ejbClientList, List moduleModelsList, List utilityModelsList) {
        if (nestedModuleRoot != null) {
            importModel.setProperty("IEnterpriseApplicationImportDataModelProperties.NESTED_MODULE_ROOT", (Object)nestedModuleRoot);
        }
        if (utilityList != null) {
            importModel.setProperty("IEnterpriseApplicationImportDataModelProperties.UTILITY_LIST", (Object)utilityList);
        }
        if (selectedModelsList != null) {
            importModel.setProperty("IEnterpriseApplicationImportDataModelProperties.SELECTED_MODELS_LIST", (Object)selectedModelsList);
        }
        if (ejbClientList != null) {
            importModel.setProperty("IEnterpriseApplicationImportDataModelProperties.EJB_CLIENT_LIST", (Object)ejbClientList);
        }
        if (moduleModelsList != null) {
            importModel.setProperty("IEnterpriseApplicationImportDataModelProperties.MODULE_MODELS_LIST", (Object)moduleModelsList);
        }
        if (utilityModelsList != null) {
            importModel.setProperty("IEnterpriseApplicationImportDataModelProperties.UTILITY_MODELS_LIST", (Object)utilityModelsList);
        }
        return importModel;
    }

    protected IDataModel getExportDataModel(String projectName, String destination, boolean exportSource, boolean runBuild, boolean overwriteExisting) {
        return EARExportOperationTest.getEARExportDataModel(projectName, destination, exportSource, runBuild, overwriteExisting);
    }

    protected void runImportTests_All(String testName) throws Exception {
        super.runImportTests_All(testName);
        this.runAndVerifyImport_DontExplodeAllModules(String.valueOf(testName) + "_Source" + this.getModuleExtension());
        OperationTestCase.deleteAllProjects();
        this.runAndVerifyImport_DontExplodeAnyModules(String.valueOf(testName) + "_Source" + this.getModuleExtension());
        OperationTestCase.deleteAllProjects();
    }

    private void runAndVerifyImport_DontExplodeAllModules(String archiveName) throws Exception {
        String archivePath = this.getArchivePath(archiveName);
        String projectName = "exportedWithSource";
        this.verifyImportArchiveExists(archivePath);
        IDataModel importModel = this.getImportDataModel(archivePath, projectName, null, true);
        List selectedModelsList = (List)importModel.getProperty("IEnterpriseApplicationImportDataModelProperties.SELECTED_MODELS_LIST");
        int i = 0;
        while (i < 2 & i < selectedModelsList.size()) {
            selectedModelsList.remove(i);
            ++i;
        }
        importModel = EARImportOperationTest.setExtendedEARImportDataModelProperties(importModel, null, null, selectedModelsList, null, null, null);
        EARImportOperationTest.runAndVerify((IDataModel)importModel);
        this.runAndVerifyReExportation(importModel, true, true);
    }

    private void runAndVerifyImport_DontExplodeAnyModules(String archiveName) throws Exception {
        String archivePath = this.getArchivePath(archiveName);
        String projectName = "exportedWithSource";
        this.verifyImportArchiveExists(archivePath);
        IDataModel importModel = this.getImportDataModel(archivePath, projectName, null, true);
        importModel = EARImportOperationTest.setExtendedEARImportDataModelProperties(importModel, null, null, Collections.EMPTY_LIST, null, null, null);
        EARImportOperationTest.runAndVerify((IDataModel)importModel);
        this.runAndVerifyReExportation(importModel, true, true);
    }

    protected void runAndVerifyReExportation(IDataModel importModel, boolean exportSource, boolean runBuild) throws Exception {
        this.removeNestedArchivesForExplodedProjects(importModel);
        super.runAndVerifyReExportation(importModel, exportSource, runBuild);
    }

    private void removeNestedArchivesForExplodedProjects(IDataModel importModel) throws Exception {
        List selectedModelsList = (List)importModel.getProperty("IEnterpriseApplicationImportDataModelProperties.SELECTED_MODELS_LIST");
        String earProjectName = importModel.getStringProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME");
        IVirtualComponent projectVirtComponent = ComponentUtilities.getComponent((String)earProjectName);
        IVirtualFolder virtRootFolder = projectVirtComponent.getRootFolder();
        ArchiveWrapper nestedArchiveWrapper = null;
        IPath nestedArchivePath = null;
        IVirtualFile nestedArchiveVirtFile = null;
        IFile nestedArchiveFile = null;
        for (IDataModel selectedModel : selectedModelsList) {
            nestedArchiveWrapper = (ArchiveWrapper)selectedModel.getProperty("IJ2EEComponentImportDataModelProperties.ARCHIVE_WRAPPER");
            nestedArchivePath = nestedArchiveWrapper.getPath();
            nestedArchiveVirtFile = virtRootFolder.getFile(nestedArchivePath);
            Assert.assertTrue((String)"The EAR project should contain the selected module as an archive", (boolean)nestedArchiveVirtFile.exists());
            nestedArchiveFile = nestedArchiveVirtFile.getUnderlyingFile();
            nestedArchiveFile.delete(true, null);
        }
    }
}

