/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.tests.axis.tomcat.v50.perfmsr;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.tests.axis.tomcat.v50.WSWizardTomcat50Test;
import org.eclipse.jst.ws.tests.performance.util.PerformanceJUnitUtils;
import org.eclipse.jst.ws.tests.performance.util.PerformanceJobUtil;
import org.eclipse.jst.ws.tests.util.JUnitUtils;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.wst.command.internal.env.eclipse.AccumulateStatusHandler;
import org.eclipse.wst.common.environment.IEnvironment;

public class PerfmsrClientAxisTC50
extends WSWizardTomcat50Test {
    private final String WS_RUNTIMEID_AXIS = "org.eclipse.jst.ws.axis.creation.axisWebServiceRT";
    private final String CLIENT_PROJECT_NAME = "TestWebClient";
    private IFile sourceFile_;

    protected void createProjects() throws Exception {
        IProject webProject = ProjectUtilities.getProject((String)"TestWebClient");
        if (!webProject.exists()) {
            JUnitUtils.createWebModule((String)"TestWebClient", (String)"TestWebClient", (String)this.server_.getId(), (String)"org.eclipse.jst.server.tomcat.50", (String)"14", (IEnvironment)this.env_, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected void installInputData() throws Exception {
        IProject webProject = ProjectUtilities.getProject((String)"TestWebClient");
        IFolder destFolder = (IFolder)J2EEUtils.getWebContentContainer((IProject)webProject);
        JUnitUtils.copyTestData((String)"TDJava", (IFolder)destFolder, (IEnvironment)this.env_, null);
        this.sourceFile_ = destFolder.getFile((IPath)new Path("Echo.wsdl"));
        JUnitUtils.disableValidation((IProject)webProject);
        JUnitUtils.syncBuildProject((IProject)webProject, (IEnvironment)this.env_, null);
    }

    protected void initJ2EEWSRuntimeServerDefaults() throws Exception {
        JUnitUtils.setWSRuntimeServer((String)"org.eclipse.jst.ws.axis.creation.axisWebServiceRT", (String)"org.eclipse.jst.server.tomcat.50");
        JUnitUtils.setClientScenarioDefault();
    }

    protected void initInitialSelection() throws Exception {
        this.initialSelection_ = new StructuredSelection((Object)this.sourceFile_);
    }

    public void testClientAxisTC50() throws Exception {
        IStatus[] status;
        PerformanceJobUtil.waitForStartupJobs();
        JUnitUtils.enableProxyGeneration((boolean)true);
        JUnitUtils.enableOverwrite((boolean)true);
        JUnitUtils.setRuntimePreference((String)"org.eclipse.jst.ws.axis.creation.axisWebServiceRT");
        Performance perf = Performance.getDefault();
        PerformanceMeter performanceMeter = perf.createPerformanceMeter(perf.getDefaultScenarioId((TestCase)this));
        try {
            performanceMeter.start();
            status = PerformanceJUnitUtils.launchCreationWizard("org.eclipse.jst.ws.internal.consumption.ui.wizard.client.clientwizard", "org.eclipse.core.resources.IFile", this.initialSelection_);
            performanceMeter.stop();
            performanceMeter.commit();
            perf.assertPerformance(performanceMeter);
        }
        finally {
            if (performanceMeter == null) {
                performanceMeter.dispose();
            }
        }
        this.verifyOutput(status);
    }

    private final void verifyOutput(IStatus[] status) throws Exception {
        IProject webProject = ProjectUtilities.getProject((String)"TestWebClient");
        IPath destPath = ResourceUtils.getJavaSourceLocation((IProject)webProject);
        IFolder srcFolder = (IFolder)ResourceUtils.findResource((IPath)destPath);
        IFolder folder = srcFolder.getFolder("foo");
        PerfmsrClientAxisTC50.assertTrue((boolean)folder.exists());
        PerfmsrClientAxisTC50.assertTrue((folder.members().length > 0 ? 1 : 0) != 0);
        AccumulateStatusHandler statusHandler = new AccumulateStatusHandler(status);
        IStatus[] s = statusHandler.getErrorReports();
        if (s.length > 0) {
            int i = 0;
            while (i < s.length) {
                System.out.println("Error message for report #" + i + ": " + s[i].getMessage());
                ++i;
            }
        }
        PerfmsrClientAxisTC50.assertTrue((s.length == 0 ? 1 : 0) != 0);
    }

    protected void deleteInputData() throws Exception {
        IProject webProject = ProjectUtilities.getProject((String)"TestWebClient");
        webProject.delete(true, true, null);
    }
}

