/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.tests.performance.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PerformanceJobUtil {
    private static List<Job> getRunningJobs() {
        ArrayList<Job> jobs = new ArrayList<Job>();
        jobs.addAll(Arrays.asList(Job.getJobManager().find(null)));
        return jobs;
    }

    public static void waitForStartupJobs() {
        if (System.getProperty("ws.perf.startup.nowait") != null) {
            System.out.println("ws.perf.startup.nowait property was set.  Not waiting for start up jobs");
            return;
        }
        System.out.println("waiting up jobs to complete.  Set the ws.perf.startup.nowait vm arg to skip this wait");
        try {
            PerformanceJobUtil.waitForJobs();
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private static void waitForJobs() throws InterruptedException {
        List<Job> jobs = PerformanceJobUtil.getRunningJobs();
        int counter = 0;
        while (!jobs.isEmpty()) {
            Object[] jobNames = new String[jobs.size()];
            int i = 0;
            while (i < jobs.size()) {
                jobNames[i] = jobs.get(i).getName();
                ++i;
            }
            System.out.println("Waiting for " + jobs.size() + " jobs: " + Arrays.toString(jobNames));
            Thread.sleep(2000L);
            jobs = PerformanceJobUtil.getRunningJobs();
            if (++counter != 60) continue;
            System.out.println("Giving up waiting after 2 minutes.  Still  " + jobs.size() + " jobs running: " + Arrays.toString(jobNames));
            break;
        }
    }
}

