/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.test;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.validation.test.TaskStatus;
import org.eclipse.jst.validation.test.internal.registry.TestcaseUtility;
import org.eclipse.jst.validation.test.setup.IBuffer;

public class BufferedTaskStatus
extends TaskStatus
implements IBuffer {
    public static final String NEWLINE = System.getProperty("line.separator");
    private IProgressMonitor _monitor = null;
    private StringBuffer _buffer = null;
    private String _logFileName = null;

    public BufferedTaskStatus() {
    }

    public BufferedTaskStatus(String logFileName) {
        this(logFileName, null);
    }

    public BufferedTaskStatus(String logFileName, IProgressMonitor monitor) {
        this._buffer = new StringBuffer();
        this.setProgressMonitor(monitor);
        this.setLogFileName(logFileName);
    }

    public void clear() {
        super.clear();
        this._buffer = null;
        this._buffer = new StringBuffer();
        this._monitor.done();
        this._monitor = null;
    }

    public String getLogFileName() {
        return this._logFileName;
    }

    public void setLogFileName(String name) {
        this._logFileName = name;
    }

    public StringBuffer getBuffer() {
        return this._buffer;
    }

    public IProgressMonitor getProgressMonitor() {
        if (this._monitor == null) {
            this._monitor = new NullProgressMonitor();
        }
        return this._monitor;
    }

    public void setProgressMonitor(IProgressMonitor m) {
        this._monitor = m;
    }

    public void report() {
        String taskName;
        this._buffer.append(NEWLINE);
        this._buffer.append(">>>>>>>>>>>>>>>>TEST SUITE RESULTS>>>>>>>>>>>>>>>>");
        this._buffer.append(NEWLINE);
        this._buffer.append(NEWLINE);
        if (this.getElapsedTime().size() > 0) {
            Iterator iterator = this.getElapsedTime().keySet().iterator();
            long total = 0L;
            this._buffer.append(">>>>>>>>>>>>>>>>ELAPSED TIME>>>>>>>>>>>>>>>>");
            this._buffer.append(NEWLINE);
            while (iterator.hasNext()) {
                taskName = (String)iterator.next();
                Long elapsedTime = (Long)this.getElapsedTime().get(taskName);
                total += elapsedTime.longValue();
                this._buffer.append("Total elapsed time of task ");
                this._buffer.append(taskName);
                this._buffer.append(" is ");
                this._buffer.append(elapsedTime);
                this._buffer.append(NEWLINE);
            }
            this._buffer.append("Total time of all tasks is " + total + ", which is " + total / 1000L / 60L + " minutes.");
            this._buffer.append(NEWLINE);
        }
        int totNumPass = 0;
        Map taskStatus = this.getTaskStatus();
        Iterator iterator = taskStatus.keySet().iterator();
        this._buffer.append(NEWLINE);
        this._buffer.append(">>>>>>>>>>>>>>>>PASS/FAIL SUMMARY>>>>>>>>>>>>>>>>");
        this._buffer.append(NEWLINE);
        while (iterator.hasNext()) {
            taskName = (String)iterator.next();
            TaskStatus.TestStatus ts = (TaskStatus.TestStatus)taskStatus.get(taskName);
            this._buffer.append(ts);
            this._buffer.append(NEWLINE);
            if (!ts.isSuccessful()) continue;
            ++totNumPass;
        }
        this._buffer.append(NEWLINE);
        this._buffer.append(NEWLINE);
        this._buffer.append("Total Number Of Tests: ");
        this._buffer.append(this.numTests());
        this._buffer.append(NEWLINE);
        this._buffer.append("Number Passed: ");
        this._buffer.append(totNumPass);
        this._buffer.append(NEWLINE);
        if (this.getLogFileName() != null) {
            this._buffer.append("This report is stored in the following log file: ");
            this._buffer.append(this.getLogFileName());
            TestcaseUtility.flush(this.getLogFileName(), this._buffer.toString(), true);
        }
    }

    public void delineate(String testcaseName) {
        TaskStatus.TestStatus ts = this.getTestStatus(testcaseName);
        if (ts == null) {
            return;
        }
        StringBuffer errorsBuffer = new StringBuffer();
        errorsBuffer.append(ts.numFailure());
        errorsBuffer.append(" errors were reported and ");
        errorsBuffer.append(ts.numWarnings());
        errorsBuffer.append(" warnings were reported. Read ");
        errorsBuffer.append(this.getLogFileName());
        errorsBuffer.append(" for details.");
        this.write(errorsBuffer.toString());
    }

    public void write(String message) {
        this._buffer.append(message);
        this._buffer.append(NEWLINE);
    }
}

