/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.test.setup;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.validation.test.BVTValidationPlugin;
import org.eclipse.jst.validation.test.internal.registry.MessageUtility;
import org.eclipse.jst.validation.test.setup.IBuffer;
import org.eclipse.wst.validation.internal.TaskListUtility;
import org.eclipse.wst.validation.internal.ValidatorMetaData;

public final class TestCaseGeneratorOperation
implements IWorkspaceRunnable {
    private static final String _TESTCASE_TEMPLATE_ = "\t\t\t<test \n\t\t\t\tproject=\"{0}\"\n\t\t\t\tinput=\"\"\n\t\t\t\tvalidator=\"{1}\">\n{2}\t\t\t</test>\n";
    private static final String _TESTCASE_MESSAGE_TEMPLATE_ = "\t\t\t\t<message prefix=\"{0}\" resource=\"{1}\" location=\"{2}\" text=\"{3}\"/>\n";
    private Map _vmdBuffer = null;
    private IProject[] _projects = null;
    private IBuffer _buffer = null;

    public TestCaseGeneratorOperation(IProject[] projects, IBuffer buffer) {
        this.setProjects(projects);
        this.setBuffer(buffer);
        this._vmdBuffer = new HashMap();
    }

    public IBuffer getBuffer() {
        return this._buffer;
    }

    public void setBuffer(IBuffer b) {
        this._buffer = b;
    }

    public IProject[] getProjects() {
        return this._projects;
    }

    public void setProjects(IProject[] projects) {
        this._projects = projects;
    }

    public void run(IProgressMonitor arg0) throws CoreException {
        try {
            try {
                this.generate(this.getProjects());
            }
            catch (Throwable exc) {
                BVTValidationPlugin.getPlugin().handleException(exc);
                this.getBuffer().write("A Throwable was caught; could not generate the test case. Check the LoggingUtil.log file for details.");
                this._vmdBuffer.clear();
            }
        }
        finally {
            this._vmdBuffer.clear();
        }
    }

    protected void generate(IProject[] projects) {
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            IMarker[] markers = TaskListUtility.getValidationTasks((IResource)project, (int)7);
            if (markers == null || markers.length == 0) {
                this.getBuffer().write("Cannot generate a test case for project " + project.getName() + " until \"Run Validation\" has been run. Enable only the validator whose test case is to be generated, right-click, and \"Run Validation\". Once the validation messages have been reported, a test case can be generated from those messages.");
            } else {
                ArrayList<IMarker> markerList = new ArrayList<IMarker>();
                int j = 0;
                while (j < markers.length) {
                    markerList.add(markers[j]);
                    ++j;
                }
                Collections.sort(markerList, MessageUtility.getMessageComparator(this.getBuffer(), false));
                for (IMarker marker : markerList) {
                    String location;
                    ValidatorMetaData vmd = MessageUtility.getValidator(marker);
                    if (vmd == null) continue;
                    StringBuffer messageBuffer = this.getBuffer(vmd);
                    String messageId = MessageUtility.getMessagePrefix(marker);
                    String resource = MessageUtility.getResource(marker);
                    Integer lineNumber = MessageUtility.getLineNumber(marker);
                    location = lineNumber == null ? (location = MessageUtility.getLocation(marker)) : (location = lineNumber.toString());
                    String text = MessageUtility.getMessage(marker);
                    text = text.replace('<', '[');
                    text = text.replace('>', ']');
                    text = text.replace('\"', '\'');
                    messageBuffer.append(MessageFormat.format(_TESTCASE_MESSAGE_TEMPLATE_, messageId, resource, location, text));
                }
                for (ValidatorMetaData vmd : this._vmdBuffer.keySet()) {
                    StringBuffer buffer = (StringBuffer)this._vmdBuffer.get(vmd);
                    String testcaseTemplate = MessageFormat.format(_TESTCASE_TEMPLATE_, project.getName(), vmd.getValidatorUniqueName(), buffer.toString());
                    this.getBuffer().write(testcaseTemplate);
                    buffer.delete(0, buffer.length());
                }
            }
            ++i;
        }
    }

    private StringBuffer getBuffer(ValidatorMetaData vmd) {
        StringBuffer buffer = (StringBuffer)this._vmdBuffer.get(vmd);
        if (buffer == null) {
            buffer = new StringBuffer();
            this._vmdBuffer.put(vmd, buffer);
        }
        return buffer;
    }
}

