/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.tests.unittest;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.command.common.AssociateModuleWithEARCommand;
import org.eclipse.jst.ws.tests.unittest.WSJUnitConstants;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class J2EEUtilsTests
extends TestCase
implements WSJUnitConstants {
    private IProject project1 = null;
    private IProject project2 = null;
    private IProject ejbProject = null;
    private String comp1 = "webComponent";

    protected void setUp() throws Exception {
        super.setUp();
        this.project1 = ProjectUtilities.getProject((String)"FlexProject");
        J2EEUtilsTests.assertNotNull((Object)this.project1);
        this.project2 = ProjectUtilities.getProject((String)"FlexProject2");
        J2EEUtilsTests.assertNotNull((Object)this.project2);
        this.ejbProject = ProjectUtilities.getProject((String)"FlexEJBProject");
        J2EEUtilsTests.assertNotNull((Object)this.ejbProject);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public static Test suite() {
        return new TestSuite(J2EEUtilsTests.class);
    }

    public void testComponentsExist() {
        System.out.println("< BEGIN: testComponentExists ...");
        IVirtualComponent vc1 = J2EEUtils.getVirtualComponent((IProject)this.project1);
        IVirtualComponent vc2 = J2EEUtils.getVirtualComponent((String)this.project2.getName());
        J2EEUtilsTests.assertTrue((boolean)vc1.exists());
        J2EEUtilsTests.assertTrue((boolean)J2EEUtils.exists((IProject)this.project1));
        J2EEUtilsTests.assertTrue((boolean)vc2.exists());
        J2EEUtilsTests.assertTrue((boolean)J2EEUtils.exists((String)this.project2.getName(), (String)"FlexProject2"));
        System.out.println("< END: testComponentExists ...");
    }

    public void testLocationGetterMethods() {
        System.out.println("< BEGIN: testLocationGetterMethods ...");
        IPath loc1 = J2EEUtils.getWebContentPath((IProject)this.project1);
        System.out.println("WebContentPath of project1 = " + loc1);
        IResource res = ResourceUtils.getWorkspaceRoot().findMember(loc1);
        J2EEUtilsTests.assertTrue((boolean)res.exists());
        J2EEUtilsTests.assertTrue((boolean)res.toString().endsWith("WebContent"));
        IPath loc2 = J2EEUtils.getWebContentPath((IProject)this.project2);
        System.out.println("WebContentPath of project2 = " + loc2);
        IResource res2 = ResourceUtils.getWorkspaceRoot().findMember(loc2);
        J2EEUtilsTests.assertTrue((boolean)res2.exists());
        J2EEUtilsTests.assertTrue((boolean)res2.toString().endsWith("WebContent"));
        IPath loc3 = J2EEUtils.getWebInfPath((IProject)this.project1);
        System.out.println("Web-INF path = " + loc3);
        IResource res3 = ResourceUtils.getWorkspaceRoot().findMember(loc3);
        J2EEUtilsTests.assertTrue((boolean)res3.exists());
        J2EEUtilsTests.assertTrue((boolean)res3.toString().endsWith("WEB-INF"));
        IContainer container = J2EEUtils.getWebContentContainer((IProject)this.project2);
        IResource res4 = ResourceUtils.getWorkspaceRoot().findMember(container.getFullPath());
        J2EEUtilsTests.assertEquals((Object)res2, (Object)res4);
        System.out.println("< END: testLocationGetterMethods ...");
    }

    public void testJ2EEVersionMethods() {
        System.out.println("< BEGIN: testJ2EEVersionMethods ...");
        String j3 = J2EEUtils.getJ2EEVersionAsString((IProject)this.project1);
        System.out.println("J2EEVersion p1 as String: " + j3);
        J2EEUtilsTests.assertEquals((String)"2.4", (String)j3);
        IVirtualComponent vc2 = J2EEUtils.getVirtualComponent((IProject)this.project2);
        int j2 = J2EEUtils.getJ2EEVersion((IVirtualComponent)vc2);
        System.out.println("J2EEVersions p1: " + j2);
        J2EEUtilsTests.assertEquals((int)24, (int)j2);
        System.out.println("< END: testJ2EEVersionMethods ...");
    }

    public void testComponentGetterMethods() {
        System.out.println("< BEGIN: testComponentGetterMethods ...");
        IVirtualComponent[] vcs = J2EEUtils.getAllComponents();
        this.checkVirtualComponentsExists(vcs);
        IVirtualComponent[] vcs2 = J2EEUtils.getAllEARComponents();
        this.checkVirtualComponentsExists(vcs2);
        IVirtualComponent[] vcs3 = J2EEUtils.getAllWebComponents();
        this.checkVirtualComponentsExists(vcs3);
        IVirtualComponent[] vcs4 = J2EEUtils.getWebComponents((IProject)this.project1);
        this.checkVirtualComponentsExists(vcs4);
        String[] names = J2EEUtils.getWebComponentNames((IProject)this.project2);
        this.printNameStrings(names);
        String[] names2 = J2EEUtils.toComponentNamesArray((IVirtualComponent[])J2EEUtils.getComponentsByType((IProject)this.project1, (int)3));
        this.printNameStrings(names2);
        IProject[] projects = J2EEUtils.getAllFlexibleProjects();
        int i = 0;
        while (i < projects.length) {
            System.out.println("Flex project " + i + " = " + projects[i]);
            ++i;
        }
        System.out.println("< END: testComponentGetterMethods ...");
    }

    private void checkVirtualComponentsExists(IVirtualComponent[] vcs) {
        int i = 0;
        while (i < vcs.length) {
            IVirtualComponent vc = vcs[i];
            System.out.println("VC: Project = " + vc.getProject() + " Name = " + vc.getName());
            J2EEUtilsTests.assertTrue((boolean)vc.exists());
            ++i;
        }
    }

    private void printNameStrings(String[] names) {
        int i = 0;
        while (i < names.length) {
            System.out.println("Name" + i + " = " + names[i]);
            ++i;
        }
    }

    public void dtestAssociateComponentCommand() {
        System.out.println("< BEGIN: testAssociateComponentCommand ...");
        AssociateModuleWithEARCommand amwe = new AssociateModuleWithEARCommand();
        amwe.setEar("EARComponent");
        amwe.setEARProject("FlexProject");
        amwe.setModule(this.comp1);
        amwe.setProject("FlexProject");
        amwe.execute(null, null);
        System.out.println("< END: testAssociateComponentCommand ...");
    }

    public void dtestReferencingGetterMethods() {
        System.out.println("< BEGIN: testReferencingGetterMethods ...");
        System.out.println("isComponentAssociated ..");
        J2EEUtils.isComponentAssociated((IProject)this.project1, (IProject)this.project1);
        String[] names = J2EEUtils.toComponentNamesArray((IVirtualComponent[])J2EEUtils.getReferencingEARComponents((IProject)this.project1));
        this.printNameStrings(names);
        String[] names2 = J2EEUtils.toComponentNamesArray((IVirtualComponent[])J2EEUtils.getReferencingEARComponents((IProject)this.project2));
        this.printNameStrings(names2);
        String[] names3 = J2EEUtils.toComponentNamesArray((IVirtualComponent[])J2EEUtils.getReferencingWebComponentsFromEAR((IProject)this.project1));
        this.printNameStrings(names3);
        System.out.println("< END: testReferencingGetterMethods ...");
    }

    public void dtestIsComponentMethods() {
        System.out.println("< BEGIN: testIsComponentMethods ...");
        J2EEUtilsTests.assertTrue((boolean)J2EEUtils.isEJB20Component((IProject)this.ejbProject));
        System.out.println("< END: testIsComponentMethods ...");
    }
}

