/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.tests;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public abstract class AbstractTests
extends TestCase {
    protected static final String DEFAULT_TEST_PROJECT_NAME = "testProject";
    protected static final IWorkspace ws = ResourcesPlugin.getWorkspace();
    protected final Set<IResource> resourcesToCleanup = new HashSet<IResource>();
    protected final List<Runnable> tearDownOperations = new ArrayList<Runnable>();

    protected AbstractTests(String name) {
        super(name);
    }

    protected void tearDown() throws CoreException {
        for (IResource r : this.resourcesToCleanup) {
            r.delete(true, null);
        }
        for (Runnable runnable : this.tearDownOperations) {
            runnable.run();
        }
    }

    protected final void addResourceToCleanup(IResource resource) {
        this.resourcesToCleanup.add(resource);
    }

    protected final void addTearDownOperation(Runnable runnable) {
        this.tearDownOperations.add(runnable);
    }

    protected final IFacetedProject createFacetedProject() throws CoreException {
        return this.createFacetedProject(DEFAULT_TEST_PROJECT_NAME);
    }

    protected IFacetedProject createFacetedProject(String name) throws CoreException {
        AbstractTests.assertFalse((boolean)ws.getRoot().getProject(name).exists());
        IFacetedProject fpj = ProjectFacetsManager.create((String)name, null, null);
        IProject pj = fpj.getProject();
        AbstractTests.assertTrue((boolean)pj.exists());
        this.addResourceToCleanup((IResource)pj);
        return fpj;
    }
}

