/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.tests.support;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUtils {
    public static void writeToFile(IFile file, String contents) throws CoreException {
        try {
            byte[] bytes = contents.getBytes("UTF-8");
            if (file.exists()) {
                file.setContents((InputStream)new ByteArrayInputStream(bytes), false, false, null);
            } else {
                file.create((InputStream)new ByteArrayInputStream(bytes), false, null);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readFromFile(IFile file) throws CoreException, IOException {
        TestCase.assertTrue((boolean)file.exists());
        StringBuffer buf = new StringBuffer();
        InputStreamReader r = new InputStreamReader(file.getContents());
        try {
            int count;
            char[] chars = new char[1024];
            while ((count = r.read(chars)) != -1) {
                buf.append(chars, 0, count);
            }
        }
        catch (Throwable throwable) {
            try {
                ((Reader)r).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((Reader)r).close();
        }
        catch (IOException iOException) {}
        return buf.toString();
    }

    public static void assertEquals(IFile file, String expectedContents) throws CoreException, IOException {
        TestCase.assertEquals((String)TestUtils.readFromFile(file), (String)expectedContents);
    }

    public static void assertFileContains(IFile file, String str) throws CoreException, IOException {
        TestCase.assertTrue((TestUtils.readFromFile(file).indexOf(str) != -1 ? 1 : 0) != 0);
    }

    public static void waitForCondition(ICondition condition) {
        TestUtils.waitForCondition(condition, 10);
    }

    public static void waitForCondition(ICondition condition, int seconds) {
        int i = 0;
        while (i < seconds && !condition.check()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
        TestCase.assertTrue((boolean)condition.check());
    }

    public static <T> Set<T> asSet(T ... objects) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        set.addAll(Arrays.asList(objects));
        return set;
    }

    public static interface ICondition {
        public boolean check();
    }
}

