/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.tests.model;

import java.io.IOException;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSValue;
import org.eclipse.wst.css.core.tests.model.AbstractModelTest;
import org.eclipse.wst.css.core.tests.util.FileUtil;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;

public class CSSFontFamilyTest
extends AbstractModelTest {
    private static final String FONT_FAMILY = "font-family";

    public void testFontFamilies() throws IOException {
        ICSSModel model = this.getModel();
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        structuredDocument.set(FileUtil.createString("src/org/eclipse/wst/css/core/tests/testfiles", "CSSFontFamilyTest.css"));
        CSSStyleSheet sheet = (CSSStyleSheet)model.getDocument();
        CSSRuleList rules = sheet.getCssRules();
        CSSFontFamilyTest.assertEquals((int)4, (int)rules.getLength());
        CSSRule rule = rules.item(0);
        CSSFontFamilyTest.assertEquals((short)1, (short)rule.getType());
        CSSFontFamilyTest.assertTrue((boolean)(rule instanceof CSSStyleRule));
        CSSStyleDeclaration declaration = ((CSSStyleRule)rule).getStyle();
        CSSValue value = declaration.getPropertyCSSValue(FONT_FAMILY);
        this.checkPrimitiveString(value, new AbstractModelTest.PrimitiveString(21, "Courier"));
        rule = rules.item(1);
        CSSFontFamilyTest.assertEquals((short)1, (short)rule.getType());
        CSSFontFamilyTest.assertTrue((boolean)(rule instanceof CSSStyleRule));
        declaration = ((CSSStyleRule)rule).getStyle();
        value = declaration.getPropertyCSSValue(FONT_FAMILY);
        this.checkPrimitiveString(value, new AbstractModelTest.PrimitiveString(21, "Courier New"));
        rule = rules.item(2);
        CSSFontFamilyTest.assertEquals((short)1, (short)rule.getType());
        CSSFontFamilyTest.assertTrue((boolean)(rule instanceof CSSStyleRule));
        declaration = ((CSSStyleRule)rule).getStyle();
        value = declaration.getPropertyCSSValue(FONT_FAMILY);
        this.checkPrimitiveString(value, new AbstractModelTest.PrimitiveString(19, "Courier New"));
        rule = rules.item(3);
        CSSFontFamilyTest.assertEquals((short)1, (short)rule.getType());
        CSSFontFamilyTest.assertTrue((boolean)(rule instanceof CSSStyleRule));
        declaration = ((CSSStyleRule)rule).getStyle();
        value = declaration.getPropertyCSSValue(FONT_FAMILY);
        this.checkPrimitiveString(value, new AbstractModelTest.PrimitiveString(21, "Comic Sans"));
    }

    public void testValueModification() throws IOException {
        ICSSModel model = this.getModel();
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        structuredDocument.set(FileUtil.createString("src/org/eclipse/wst/css/core/tests/testfiles", "CSSFontFamilyTest.css"));
        CSSStyleSheet sheet = (CSSStyleSheet)model.getDocument();
        CSSRuleList rules = sheet.getCssRules();
        CSSFontFamilyTest.assertEquals((int)4, (int)rules.getLength());
        CSSRule rule = rules.item(0);
        CSSFontFamilyTest.assertEquals((short)1, (short)rule.getType());
        CSSFontFamilyTest.assertTrue((boolean)(rule instanceof CSSStyleRule));
        CSSStyleDeclaration declaration = ((CSSStyleRule)rule).getStyle();
        CSSValue value = declaration.getPropertyCSSValue(FONT_FAMILY);
        this.checkPrimitiveString(value, new AbstractModelTest.PrimitiveString(21, "Courier"));
        declaration.setProperty(FONT_FAMILY, "\"Times New Roman\", Times, serif", "");
        value = declaration.getPropertyCSSValue(FONT_FAMILY);
        CSSFontFamilyTest.assertTrue((boolean)(value instanceof ICSSValue));
        CSSFontFamilyTest.assertEquals((String)"\"Times New Roman\", Times, serif", (String)((ICSSValue)value).getCSSValueText());
        declaration.setProperty(FONT_FAMILY, "\"Times New Roman\", Times", "");
        value = declaration.getPropertyCSSValue(FONT_FAMILY);
        CSSFontFamilyTest.assertTrue((boolean)(value instanceof ICSSValue));
        CSSFontFamilyTest.assertEquals((String)"\"Times New Roman\", Times", (String)((ICSSValue)value).getCSSValueText());
    }
}

