/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.tests.model;

import java.io.IOException;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.tests.model.AbstractModelTest;
import org.eclipse.wst.css.core.tests.util.FileUtil;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.w3c.dom.css.CSSPageRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public class CSSPageRuleTest
extends AbstractModelTest {
    public void testInsertText1() throws IOException {
        ICSSModel model = this.getModel();
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        structuredDocument.set(FileUtil.createString("src/org/eclipse/wst/css/core/tests/testfiles", "CSSPageRuleTest.css"));
        CSSStyleSheet sheet = (CSSStyleSheet)model.getDocument();
        CSSRuleList ruleList = sheet.getCssRules();
        CSSPageRuleTest.assertEquals((int)6, (int)ruleList.getLength());
        CSSRule rule = ruleList.item(0);
        CSSPageRuleTest.assertEquals((short)6, (short)rule.getType());
        CSSPageRuleTest.assertTrue((boolean)(rule instanceof CSSPageRule));
        CSSStyleDeclaration declaration = ((CSSPageRule)rule).getStyle();
        CSSPageRuleTest.assertEquals((int)2, (int)declaration.getLength());
        CSSValue value = declaration.getPropertyCSSValue("size");
        CSSPageRuleTest.assertTrue((boolean)(value instanceof CSSValueList));
        CSSValueList valueList = (CSSValueList)value;
        CSSPageRuleTest.assertEquals((int)2, (int)valueList.getLength());
        this.checkPrimitiveNumber(valueList.item(0), new AbstractModelTest.PrimitiveNumber(8, 8.5f));
        this.checkPrimitiveNumber(valueList.item(1), new AbstractModelTest.PrimitiveNumber(8, 11.0f));
        value = declaration.getPropertyCSSValue("margin");
        this.checkPrimitiveNumber(value, new AbstractModelTest.PrimitiveNumber(6, 2.0f));
    }

    public void testInsertText2() throws IOException {
        ICSSModel model = this.getModel();
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        structuredDocument.set(FileUtil.createString("src/org/eclipse/wst/css/core/tests/testfiles", "CSSPageRuleTest.css"));
        CSSStyleSheet sheet = (CSSStyleSheet)model.getDocument();
        CSSRuleList ruleList = sheet.getCssRules();
        CSSPageRuleTest.assertEquals((int)6, (int)ruleList.getLength());
        CSSRule rule = ruleList.item(1);
        CSSPageRuleTest.assertEquals((short)6, (short)rule.getType());
        CSSPageRuleTest.assertTrue((boolean)(rule instanceof CSSPageRule));
        CSSStyleDeclaration declaration = ((CSSPageRule)rule).getStyle();
        CSSPageRuleTest.assertEquals((int)2, (int)declaration.getLength());
        CSSValue value = declaration.getPropertyCSSValue("size");
        this.checkPrimitiveString(value, new AbstractModelTest.PrimitiveString(21, "auto"));
        value = declaration.getPropertyCSSValue("margin");
        this.checkPrimitiveNumber(value, new AbstractModelTest.PrimitiveNumber(2, 10.0f));
    }

    public void testInsertText3() throws IOException {
        ICSSModel model = this.getModel();
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        structuredDocument.set(FileUtil.createString("src/org/eclipse/wst/css/core/tests/testfiles", "CSSPageRuleTest.css"));
        CSSStyleSheet sheet = (CSSStyleSheet)model.getDocument();
        CSSRuleList ruleList = sheet.getCssRules();
        CSSPageRuleTest.assertEquals((int)6, (int)ruleList.getLength());
        CSSRule rule = ruleList.item(2);
        CSSPageRuleTest.assertEquals((short)6, (short)rule.getType());
        CSSPageRuleTest.assertTrue((boolean)(rule instanceof CSSPageRule));
        CSSPageRuleTest.assertEquals((String)":left", (String)((CSSPageRule)rule).getSelectorText());
        CSSStyleDeclaration declaration = ((CSSPageRule)rule).getStyle();
        CSSPageRuleTest.assertEquals((int)2, (int)declaration.getLength());
        CSSValue value = declaration.getPropertyCSSValue("margin-left");
        this.checkPrimitiveNumber(value, new AbstractModelTest.PrimitiveNumber(6, 4.0f));
        value = declaration.getPropertyCSSValue("margin-right");
        this.checkPrimitiveNumber(value, new AbstractModelTest.PrimitiveNumber(6, 3.0f));
    }

    public void testInsertText4() throws IOException {
        ICSSModel model = this.getModel();
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        structuredDocument.set(FileUtil.createString("src/org/eclipse/wst/css/core/tests/testfiles", "CSSPageRuleTest.css"));
        CSSStyleSheet sheet = (CSSStyleSheet)model.getDocument();
        CSSRuleList ruleList = sheet.getCssRules();
        CSSPageRuleTest.assertEquals((int)6, (int)ruleList.getLength());
        CSSRule rule = ruleList.item(3);
        CSSPageRuleTest.assertEquals((short)6, (short)rule.getType());
        CSSPageRuleTest.assertTrue((boolean)(rule instanceof CSSPageRule));
        CSSPageRuleTest.assertEquals((String)":right", (String)((CSSPageRule)rule).getSelectorText());
        CSSStyleDeclaration declaration = ((CSSPageRule)rule).getStyle();
        CSSPageRuleTest.assertEquals((int)2, (int)declaration.getLength());
        CSSValue value = declaration.getPropertyCSSValue("margin-left");
        this.checkPrimitiveNumber(value, new AbstractModelTest.PrimitiveNumber(6, 3.0f));
        value = declaration.getPropertyCSSValue("margin-right");
        this.checkPrimitiveNumber(value, new AbstractModelTest.PrimitiveNumber(6, 4.0f));
    }

    public void testInsertText5() throws IOException {
        ICSSModel model = this.getModel();
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        structuredDocument.set(FileUtil.createString("src/org/eclipse/wst/css/core/tests/testfiles", "CSSPageRuleTest.css"));
        CSSStyleSheet sheet = (CSSStyleSheet)model.getDocument();
        CSSRuleList ruleList = sheet.getCssRules();
        CSSPageRuleTest.assertEquals((int)6, (int)ruleList.getLength());
        CSSRule rule = ruleList.item(4);
        CSSPageRuleTest.assertEquals((short)6, (short)rule.getType());
        CSSPageRuleTest.assertTrue((boolean)(rule instanceof CSSPageRule));
        CSSPageRuleTest.assertEquals((String)"narrow", (String)((CSSPageRule)rule).getSelectorText());
        CSSStyleDeclaration declaration = ((CSSPageRule)rule).getStyle();
        CSSPageRuleTest.assertEquals((int)1, (int)declaration.getLength());
        CSSValue value = declaration.getPropertyCSSValue("size");
        CSSPageRuleTest.assertTrue((boolean)(value instanceof CSSValueList));
        CSSValueList valueList = (CSSValueList)value;
        CSSPageRuleTest.assertEquals((int)2, (int)valueList.getLength());
        this.checkPrimitiveNumber(valueList.item(0), new AbstractModelTest.PrimitiveNumber(6, 9.0f));
        this.checkPrimitiveNumber(valueList.item(1), new AbstractModelTest.PrimitiveNumber(6, 18.0f));
    }

    public void testInsertText6() throws IOException {
        ICSSModel model = this.getModel();
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        structuredDocument.set(FileUtil.createString("src/org/eclipse/wst/css/core/tests/testfiles", "CSSPageRuleTest.css"));
        CSSStyleSheet sheet = (CSSStyleSheet)model.getDocument();
        CSSRuleList ruleList = sheet.getCssRules();
        CSSPageRuleTest.assertEquals((int)6, (int)ruleList.getLength());
        CSSRule rule = ruleList.item(5);
        CSSPageRuleTest.assertEquals((short)6, (short)rule.getType());
        CSSPageRuleTest.assertTrue((boolean)(rule instanceof CSSPageRule));
        CSSPageRuleTest.assertEquals((String)"rotated", (String)((CSSPageRule)rule).getSelectorText());
        CSSStyleDeclaration declaration = ((CSSPageRule)rule).getStyle();
        CSSPageRuleTest.assertEquals((int)1, (int)declaration.getLength());
        CSSValue value = declaration.getPropertyCSSValue("size");
        this.checkPrimitiveString(value, new AbstractModelTest.PrimitiveString(21, "landscape"));
    }
}

