/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.core.tests.internal;

import java.net.URL;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNodeList;
import org.eclipse.wst.xsd.contentmodel.internal.CMDocumentFactoryXSD;
import org.eclipse.wst.xsd.contentmodel.internal.XSDImpl;
import org.eclipse.wst.xsd.core.tests.internal.BaseTestCase;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.osgi.framework.Bundle;

public class BugFixesTest
extends BaseTestCase {
    protected String BUGFIXES_DIR = "BugFixes/";

    public static Test suite() {
        return new TestSuite(BugFixesTest.class);
    }

    protected void setUp() {
        super.setUp();
    }

    public void testXSIType() {
        String soapSchemaURI = this.locateFileUsingCatalog("http://schemas.xmlsoap.org/wsdl/soap/");
        CMDocumentFactoryXSD factory = new CMDocumentFactoryXSD();
        BugFixesTest.assertNotNull((String)"Assert factory is not null", (Object)factory);
        CMDocument cmDocument = factory.createCMDocument(soapSchemaURI);
        BugFixesTest.assertNotNull((String)"Assert CMDocument is not null", (Object)cmDocument);
        CMNamedNodeMap elements = cmDocument.getElements();
        boolean foundDesiredElement = false;
        for (CMElementDeclaration element : elements) {
            if (!"binding".equals(element.getElementName())) continue;
            foundDesiredElement = true;
            CMNamedNodeMap attributes = element.getAttributes();
            BugFixesTest.assertNotNull((Object)attributes);
            BugFixesTest.assertTrue((attributes.getLength() == 3 ? 1 : 0) != 0);
            CMNode attrNode = null;
            attrNode = attributes.getNamedItem("required");
            BugFixesTest.assertNotNull((Object)attrNode);
            attrNode = attributes.getNamedItem("transport");
            BugFixesTest.assertNotNull((Object)attrNode);
            attrNode = attributes.getNamedItem("style");
            BugFixesTest.assertNotNull((Object)attrNode);
            attrNode = attributes.getNamedItem("type");
            BugFixesTest.assertNull((Object)attrNode);
            break;
        }
        BugFixesTest.assertTrue((boolean)foundDesiredElement);
    }

    public void testXSDTypeWhitespaceFacets() {
        String XSD_FILE_NAME = "XSDWhitespace.xsd";
        String fileURI = String.valueOf(this.FILE_PROTOCOL) + this.PLUGIN_ABSOLUTE_PATH + this.SAMPLES_DIR + XSD_FILE_NAME;
        CMDocumentFactoryXSD factory = new CMDocumentFactoryXSD();
        BugFixesTest.assertNotNull((String)"Assert factory is not null", (Object)factory);
        CMDocument cmDocument = factory.createCMDocument(fileURI);
        BugFixesTest.assertNotNull((String)"Assert CMDocument is not null", (Object)cmDocument);
        CMElementDeclaration elemDecl = (CMElementDeclaration)cmDocument.getElements().item(0);
        BugFixesTest.assertEquals((String)"test", (String)elemDecl.getNodeName());
        BugFixesTest.assertTrue((boolean)(elemDecl.getContent() instanceof XSDImpl.XSDModelGroupAdapter));
        XSDImpl.XSDModelGroupAdapter group = (XSDImpl.XSDModelGroupAdapter)elemDecl.getContent();
        CMNodeList list = group.getChildNodes();
        XSDImpl.XSDElementDeclarationAdapter adapter = null;
        String nodeName = null;
        String expected = null;
        CMDataType type = null;
        int i = 0;
        while (i < list.getLength()) {
            adapter = (XSDImpl.XSDElementDeclarationAdapter)list.item(i);
            nodeName = adapter.getNodeName();
            BugFixesTest.assertNotNull((Object)nodeName);
            BugFixesTest.assertTrue((boolean)nodeName.contains("-"));
            type = adapter.getDataType();
            BugFixesTest.assertNotNull((Object)type);
            expected = nodeName.substring(nodeName.indexOf(45) + 1);
            BugFixesTest.assertEquals((Object)expected, (Object)type.getProperty("org.eclipse.wst.xsd.cm.properties/whitespace"));
            ++i;
        }
    }

    public void testXSITypeVsTypeAttr() {
        String XSD_FILE_NAME = "XSITypeTest.xsd";
        String fileURI = String.valueOf(this.FILE_PROTOCOL) + this.PLUGIN_ABSOLUTE_PATH + this.SAMPLES_DIR + XSD_FILE_NAME;
        CMDocumentFactoryXSD factory = new CMDocumentFactoryXSD();
        BugFixesTest.assertNotNull((String)"Assert factory is not null", (Object)factory);
        CMDocument cmDocument = factory.createCMDocument(fileURI);
        BugFixesTest.assertNotNull((String)"Assert CMDocument is not null", (Object)cmDocument);
        CMNamedNodeMap elements = cmDocument.getElements();
        BugFixesTest.assertEquals((int)elements.getLength(), (int)2);
        CMElementDeclaration cmElementDeclaration = (CMElementDeclaration)elements.item(0);
        CMElementDeclaration cmElementDeclarationA = null;
        CMElementDeclaration cmElementDeclarationB = null;
        if ("elementA".equals(cmElementDeclaration.getElementName())) {
            cmElementDeclarationA = cmElementDeclaration;
            cmElementDeclarationB = (CMElementDeclaration)elements.item(1);
        } else {
            cmElementDeclarationB = cmElementDeclaration;
            cmElementDeclarationA = (CMElementDeclaration)elements.item(1);
        }
        CMNamedNodeMap attributesA = cmElementDeclarationA.getAttributes();
        BugFixesTest.assertEquals((int)attributesA.getLength(), (int)1);
        CMAttributeDeclaration cmAttributeDeclarationA = (CMAttributeDeclaration)attributesA.item(0);
        BugFixesTest.assertEquals((String)"type", (String)cmAttributeDeclarationA.getAttrName());
        CMDataType attrTypeA = cmAttributeDeclarationA.getAttrType();
        String[] enumeratedValuesA = attrTypeA.getEnumeratedValues();
        BugFixesTest.assertEquals((int)1, (int)enumeratedValuesA.length);
        BugFixesTest.assertEquals((String)"X", (String)enumeratedValuesA[0]);
        CMNamedNodeMap attributesB = cmElementDeclarationB.getAttributes();
        BugFixesTest.assertEquals((int)attributesB.getLength(), (int)1);
        CMAttributeDeclaration cmAttributeDeclarationB = (CMAttributeDeclaration)attributesB.item(0);
        BugFixesTest.assertEquals((String)"type", (String)cmAttributeDeclarationB.getAttrName());
        CMDataType attrTypeB = cmAttributeDeclarationB.getAttrType();
        BugFixesTest.assertEquals((String)"typeNames", (String)attrTypeB.getDataTypeName());
    }

    public void testEnumerationsInComplexTypesWithSimpleContent() {
        String vxmlSchemaURI = this.locateFileUsingCatalog("http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd");
        BugFixesTest.assertNotNull((String)("unable to locate file for " + vxmlSchemaURI), (Object)vxmlSchemaURI);
        BugFixesTest.assertTrue((String)("unable to locate file for " + vxmlSchemaURI), (vxmlSchemaURI.length() > 0 ? 1 : 0) != 0);
        XSDSchema xsdSchema = XSDImpl.buildXSDModel((String)vxmlSchemaURI);
        BugFixesTest.assertNotNull((String)("failed to build model for " + vxmlSchemaURI), (Object)xsdSchema);
        String typeName = "transport-guaranteeType";
        for (XSDTypeDefinition type : xsdSchema.getTypeDefinitions()) {
            XSDComplexTypeDefinition complexType;
            if (!(type instanceof XSDComplexTypeDefinition) || !typeName.equals((complexType = (XSDComplexTypeDefinition)type).getName())) continue;
            String[] enumeratedValuesForType = XSDImpl.getEnumeratedValuesForType((XSDTypeDefinition)complexType);
            BugFixesTest.assertEquals((int)3, (int)enumeratedValuesForType.length);
            return;
        }
    }

    public void testGlobalElementDocumentation() {
        XSDImpl.DocumentationImpl doc;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.wst.xsd.core.tests");
        URL url = bundle.getEntry("/testresources/samples/documentation/globalreftest.xsd");
        CMDocument document = XSDImpl.buildCMDocument((String)url.toExternalForm());
        BugFixesTest.assertNotNull((String)"Content model loaded Null", (Object)document);
        CMNamedNodeMap elements = document.getElements();
        CMElementDeclaration node = (CMElementDeclaration)elements.getNamedItem("rootTest");
        BugFixesTest.assertNotNull((String)"Missing rootElement", (Object)node);
        CMElementDeclaration testElement = (CMElementDeclaration)node.getLocalElements().getNamedItem("test");
        BugFixesTest.assertNotNull((String)"Missing test element", (Object)testElement);
        CMNodeList documentation = (CMNodeList)testElement.getProperty("documentation");
        if (documentation.getLength() == 0) {
            BugFixesTest.fail((String)"test global element missing documentation.");
        }
        int cnt = 0;
        while (cnt < documentation.getLength()) {
            doc = (XSDImpl.DocumentationImpl)documentation.item(cnt);
            BugFixesTest.assertEquals((String)"Test global element missing documentation.", (String)"This some global documentation", (String)doc.getValue());
            ++cnt;
        }
        testElement = (CMElementDeclaration)node.getLocalElements().getNamedItem("testElement");
        documentation = (CMNodeList)testElement.getProperty("documentation");
        if (documentation.getLength() == 0) {
            BugFixesTest.fail((String)"testElement local element missing documentation.");
        }
        cnt = 0;
        while (cnt < documentation.getLength()) {
            doc = (XSDImpl.DocumentationImpl)documentation.item(cnt);
            BugFixesTest.assertEquals((String)"testElement documentation wrong.", (String)"This is an override", (String)doc.getValue());
            ++cnt;
        }
    }

    public void testGlobalAtrributeDocumentation() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.wst.xsd.core.tests");
        URL url = bundle.getEntry("/testresources/samples/documentation/TestAttributeRefs.xsd");
        CMDocument document = XSDImpl.buildCMDocument((String)url.toExternalForm());
        BugFixesTest.assertNotNull((String)"Content model loaded Null", (Object)document);
        CMNamedNodeMap elements = document.getElements();
        CMElementDeclaration node = (CMElementDeclaration)elements.getNamedItem("object");
        BugFixesTest.assertNotNull((String)"Missing object element", (Object)node);
        CMNamedNodeMap attributes = node.getAttributes();
        this.testGlobalAttr1Documentation(attributes);
        this.testGlobalAttr2Documentation(attributes);
        this.testGlobalAttr3Documentation(attributes);
        this.testGlobalAttr4Documentation(attributes);
        this.testLocalAttrDocumentation(attributes);
    }

    public void testForBug176420() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.wst.xsd.core.tests");
        URL url = bundle.getEntry("/testresources/samples/testSchemaForBug176420.xsd");
        CMDocument document = XSDImpl.buildCMDocument((String)url.toExternalForm());
        BugFixesTest.assertNotNull((String)"Content model loaded Null", (Object)document);
        CMNode cmNode = document.getElements().item(0);
        String[] enumeratedValues = ((CMElementDeclaration)cmNode).getDataType().getEnumeratedValues();
        BugFixesTest.assertEquals((int)12, (int)enumeratedValues.length);
    }

    private void testLocalAttrDocumentation(CMNamedNodeMap attributes) {
        CMAttributeDeclaration attribute = (CMAttributeDeclaration)attributes.getNamedItem("localAttr");
        BugFixesTest.assertNotNull((Object)"Missing localAttr attribute.");
        CMNodeList documentation = (CMNodeList)attribute.getProperty("documentation");
        if (documentation.getLength() == 0) {
            BugFixesTest.fail((String)"Unable to find documentation for localAttr");
        }
        BugFixesTest.assertEquals((String)"Wrong number of documentation annotations.", (int)2, (int)documentation.getLength());
        BugFixesTest.assertEquals((String)"Incorrect annotation for localAttr:", (String)"PASS! Multiple documentation elements for local attribute part 1", (String)((XSDImpl.DocumentationImpl)documentation.item(0)).getValue().trim());
        BugFixesTest.assertEquals((String)"Incorrect annotation for localAttr:", (String)"PASS! Multiple documentation elements for local attribute part 2", (String)((XSDImpl.DocumentationImpl)documentation.item(1)).getValue().trim());
    }

    private void testGlobalAttr1Documentation(CMNamedNodeMap attributes) {
        CMAttributeDeclaration attribute = (CMAttributeDeclaration)attributes.getNamedItem("globalAttr1");
        BugFixesTest.assertNotNull((Object)"Missing globalAttr1 attribute.");
        CMNodeList documentation = (CMNodeList)attribute.getProperty("documentation");
        if (documentation.getLength() == 0) {
            BugFixesTest.fail((String)"Unable to find documentation for globalAttr1");
        }
        BugFixesTest.assertEquals((String)"Wrong number of documentation annotations.", (int)2, (int)documentation.getLength());
        BugFixesTest.assertEquals((String)"Incorrect first annotation for globalAttr1:", (String)"PASS! Documentation for attribute ref overrides the resolved attribute ref documentation", (String)((XSDImpl.DocumentationImpl)documentation.item(0)).getValue().trim());
        BugFixesTest.assertEquals((String)"Incorrect second annotation for globalAttr1:", (String)"PASS! Multiple documentation elements.", (String)((XSDImpl.DocumentationImpl)documentation.item(1)).getValue().trim());
    }

    private void testGlobalAttr2Documentation(CMNamedNodeMap attributes) {
        CMAttributeDeclaration attribute = (CMAttributeDeclaration)attributes.getNamedItem("globalAttr2");
        BugFixesTest.assertNotNull((Object)"Missing globalAttr1 attribute.");
        CMNodeList documentation = (CMNodeList)attribute.getProperty("documentation");
        if (documentation.getLength() == 0) {
            BugFixesTest.fail((String)"Unable to find documentation for globalAttr2");
        }
        BugFixesTest.assertEquals((String)"Wrong number of documentation annotations.", (int)1, (int)documentation.getLength());
        BugFixesTest.assertEquals((String)"Incorrect annotation for globalAttr2:", (String)"PASS! Documentation for resolved attribute ref when the attribute ref does not have documentation", (String)((XSDImpl.DocumentationImpl)documentation.item(0)).getValue().trim());
    }

    private void testGlobalAttr3Documentation(CMNamedNodeMap attributes) {
        CMAttributeDeclaration attribute = (CMAttributeDeclaration)attributes.getNamedItem("globalAttr3");
        BugFixesTest.assertNotNull((Object)"Missing globalAttr1 attribute.");
        CMNodeList documentation = (CMNodeList)attribute.getProperty("documentation");
        if (documentation.getLength() == 0) {
            BugFixesTest.fail((String)"Unable to find documentation for globalAttr3");
        }
        BugFixesTest.assertEquals((String)"Wrong number of documentation annotations.", (int)1, (int)documentation.getLength());
        BugFixesTest.assertEquals((String)"Incorrect annotation for globalAttr3:", (String)"PASS! Documentation for resolved attribute ref when the attribute ref has an annotation but does not have documentation", (String)((XSDImpl.DocumentationImpl)documentation.item(0)).getValue().trim());
    }

    private void testGlobalAttr4Documentation(CMNamedNodeMap attributes) {
        CMAttributeDeclaration attribute = (CMAttributeDeclaration)attributes.getNamedItem("globalAttr4");
        BugFixesTest.assertNotNull((Object)"Missing globalAttr1 attribute.");
        CMNodeList documentation = (CMNodeList)attribute.getProperty("documentation");
        if (documentation.getLength() == 0) {
            BugFixesTest.fail((String)"Documentation element not returned for globalAttr4");
        }
        BugFixesTest.assertNull((String)"globalAttr4 returned data when non expected.", (Object)((XSDImpl.DocumentationImpl)documentation.item(0)).getValue());
    }

    public void testBase64BinaryDefaultValue() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.wst.xsd.core.tests");
        URL url = bundle.getEntry("/testresources/samples/base64Binary/Test.xsd");
        CMDocument cmDocument = XSDImpl.buildCMDocument((String)url.toExternalForm());
        BugFixesTest.assertNotNull((Object)cmDocument);
        CMNamedNodeMap elements = cmDocument.getElements();
        CMElementDeclaration cmElementDeclaration = (CMElementDeclaration)elements.getNamedItem("Test");
        BugFixesTest.assertNotNull((Object)cmElementDeclaration);
        CMDataType dataType = cmElementDeclaration.getDataType();
        BugFixesTest.assertNotNull((Object)dataType);
        String impliedValue = dataType.generateInstanceValue();
        BugFixesTest.assertEquals((String)"MA==", (String)impliedValue);
    }
}

