/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.contentassist.tests;

import junit.framework.TestCase;
import org.eclipse.jst.jsf.core.internal.contentassist.el.ContentAssistParser;
import org.eclipse.jst.jsf.core.internal.contentassist.el.ContentAssistStrategy;

public class CompletionPrefixTest
extends TestCase {
    private static final String empty_ = " ";
    private static final String xxx = "xxx";
    private static final String xxxDot = "xxx.";
    private static final String xxxYYY = "xxx.yyy";
    private static final String xxxYYYZZZ = "xxx.yyy.zzz";
    private static final String xxxLtYYY = "xxx < yyy";
    private static final String xxxDotYYYLtZZZ = "xxx.yyy < zzz";
    private static final String xxxMapYYY = "xxx['yyy']";
    private static final String xxxMapXXXExpr = "xxx[XXX]";
    private static final String xxxMapXXXDotExpr = "xxx[XXX.]";
    private static final String xxxMapXXXDotYYYExpr = "xxx[XXX.YYY]";
    private static final String xxxMapXXXDotYYYDotExpr = "xxx[XXX.YYY.]";
    private static final String xxxMapXXXDotYYYDotZZZExpr = "xxx[XXX.YYY.ZZZ]";

    public void testPrefix_null() {
        ContentAssistStrategy prefix = ContentAssistParser.getPrefix((int)1, null);
        CompletionPrefixTest.assertNull((Object)prefix);
    }

    public void testPrefix_empty_() {
        ContentAssistStrategy prefix = ContentAssistParser.getPrefix((int)1, (String)empty_);
        CompletionPrefixTest.assertTrue((prefix.getType() == 1 && "".equals(prefix.getValue()) ? 1 : 0) != 0);
    }

    public void testPrefix_xxx() {
        ContentAssistStrategy prefix = ContentAssistParser.getPrefix((int)1, (String)xxx);
        CompletionPrefixTest.assertTrue((prefix.getType() == 1 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)2, (String)xxx);
        CompletionPrefixTest.assertTrue((prefix.getType() == 1 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)4, (String)xxx);
        CompletionPrefixTest.assertTrue((prefix.getType() == 1 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
    }

    public void testPrefix_xxxDot() {
        ContentAssistStrategy prefix = ContentAssistParser.getPrefix((int)1, (String)xxxDot);
        CompletionPrefixTest.assertTrue((prefix.getType() == 1 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)2, (String)xxxDot);
        CompletionPrefixTest.assertTrue((prefix.getType() == 1 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)4, (String)xxxDot);
        CompletionPrefixTest.assertTrue((prefix.getType() == 1 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
    }

    public void testSuffix_xxxDot() {
        ContentAssistStrategy prefix = ContentAssistParser.getPrefix((int)5, (String)xxxDot);
        CompletionPrefixTest.assertTrue((prefix.getType() == 0 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
    }

    public void testPrefix_xxxYYY() {
        ContentAssistStrategy prefix = ContentAssistParser.getPrefix((int)1, (String)xxxYYY);
        CompletionPrefixTest.assertTrue((prefix.getType() == 1 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)2, (String)xxxYYY);
        CompletionPrefixTest.assertTrue((prefix.getType() == 1 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)4, (String)xxxYYY);
        CompletionPrefixTest.assertTrue((prefix.getType() == 1 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
    }

    public void testFirstSuffix_xxxYYY() {
        ContentAssistStrategy prefix = ContentAssistParser.getPrefix((int)5, (String)xxxYYY);
        CompletionPrefixTest.assertTrue((prefix.getType() == 0 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)6, (String)xxxYYY);
        CompletionPrefixTest.assertTrue((prefix.getType() == 0 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)8, (String)xxxYYY);
        CompletionPrefixTest.assertTrue((prefix.getType() == 0 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
    }

    public void testPrefix_xxxYYYZZZ() {
        ContentAssistStrategy prefix = ContentAssistParser.getPrefix((int)1, (String)xxxYYYZZZ);
        CompletionPrefixTest.assertTrue((prefix.getType() == 1 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)2, (String)xxxYYYZZZ);
        CompletionPrefixTest.assertTrue((prefix.getType() == 1 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)4, (String)xxxYYYZZZ);
        CompletionPrefixTest.assertTrue((prefix.getType() == 1 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
    }

    public void testFirstSuffix_xxxYYYZZZ() {
        ContentAssistStrategy prefix = ContentAssistParser.getPrefix((int)5, (String)xxxYYYZZZ);
        CompletionPrefixTest.assertTrue((prefix.getType() == 0 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)6, (String)xxxYYYZZZ);
        CompletionPrefixTest.assertTrue((prefix.getType() == 0 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)8, (String)xxxYYYZZZ);
        CompletionPrefixTest.assertTrue((prefix.getType() == 0 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
    }

    public void testSecondSuffix_xxxYYYZZZ() {
        ContentAssistStrategy prefix = ContentAssistParser.getPrefix((int)9, (String)xxxYYYZZZ);
        CompletionPrefixTest.assertTrue((prefix.getType() == 0 && xxxYYY.equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)10, (String)xxxYYYZZZ);
        CompletionPrefixTest.assertTrue((prefix.getType() == 0 && xxxYYY.equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)12, (String)xxxYYYZZZ);
        CompletionPrefixTest.assertTrue((prefix.getType() == 0 && xxxYYY.equals(prefix.getValue()) ? 1 : 0) != 0);
    }

    public void testPrefix_xxxLtYYY() {
        ContentAssistStrategy prefix = ContentAssistParser.getPrefix((int)1, (String)xxxLtYYY);
        CompletionPrefixTest.assertTrue((prefix.getType() == 1 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)2, (String)xxxLtYYY);
        CompletionPrefixTest.assertTrue((prefix.getType() == 1 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)4, (String)xxxLtYYY);
        CompletionPrefixTest.assertTrue((prefix.getType() == 1 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)7, (String)xxxLtYYY);
        CompletionPrefixTest.assertTrue((prefix.getType() == 1 && "yyy".equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)8, (String)xxxLtYYY);
        CompletionPrefixTest.assertTrue((prefix.getType() == 1 && "yyy".equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)10, (String)xxxLtYYY);
        CompletionPrefixTest.assertTrue((prefix.getType() == 1 && "yyy".equals(prefix.getValue()) ? 1 : 0) != 0);
    }

    public void testPrefix_xxxDotYYYLtZZZ() {
        ContentAssistStrategy prefix = ContentAssistParser.getPrefix((int)1, (String)xxxDotYYYLtZZZ);
        CompletionPrefixTest.assertTrue((prefix.getType() == 1 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)2, (String)xxxDotYYYLtZZZ);
        CompletionPrefixTest.assertTrue((prefix.getType() == 1 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)4, (String)xxxDotYYYLtZZZ);
        CompletionPrefixTest.assertTrue((prefix.getType() == 1 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)5, (String)xxxDotYYYLtZZZ);
        CompletionPrefixTest.assertTrue((prefix.getType() == 0 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)6, (String)xxxDotYYYLtZZZ);
        CompletionPrefixTest.assertTrue((prefix.getType() == 0 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)8, (String)xxxDotYYYLtZZZ);
        CompletionPrefixTest.assertTrue((prefix.getType() == 0 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)11, (String)xxxDotYYYLtZZZ);
        CompletionPrefixTest.assertTrue((prefix.getType() == 1 && "zzz".equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)14, (String)xxxDotYYYLtZZZ);
        CompletionPrefixTest.assertTrue((prefix.getType() == 1 && "zzz".equals(prefix.getValue()) ? 1 : 0) != 0);
    }

    public void testSuffix_xxxDotYYYLtZZZ() {
        ContentAssistStrategy prefix = ContentAssistParser.getPrefix((int)15, (String)"xxx.yyy < zzz.");
        CompletionPrefixTest.assertTrue((prefix.getType() == 0 && "zzz".equals(prefix.getValue()) ? 1 : 0) != 0);
    }

    public void testPrefix_xxxMapYYY() {
        ContentAssistStrategy prefix = ContentAssistParser.getPrefix((int)1, (String)xxxMapYYY);
        CompletionPrefixTest.assertTrue((prefix.getType() == 1 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)2, (String)xxxMapYYY);
        CompletionPrefixTest.assertTrue((prefix.getType() == 1 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)4, (String)xxxMapYYY);
        CompletionPrefixTest.assertTrue((prefix.getType() == 1 && xxx.equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)12, (String)"xxx['yyy'].");
        System.out.println(prefix.getValue());
        CompletionPrefixTest.assertTrue((prefix.getType() == 0 && xxxMapYYY.equals(prefix.getValue()) ? 1 : 0) != 0);
    }

    public void testPrefix_xxxMapXXXDotExpr() {
        ContentAssistStrategy prefix = ContentAssistParser.getPrefix((int)5, (String)xxxMapXXXExpr);
        CompletionPrefixTest.assertTrue((prefix.getType() == 1 && "XXX".equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)6, (String)xxxMapXXXExpr);
        CompletionPrefixTest.assertTrue((prefix.getType() == 1 && "XXX".equals(prefix.getValue()) ? 1 : 0) != 0);
        prefix = ContentAssistParser.getPrefix((int)8, (String)xxxMapXXXExpr);
        CompletionPrefixTest.assertTrue((prefix.getType() == 1 && "XXX".equals(prefix.getValue()) ? 1 : 0) != 0);
    }

    public void testSuffix_xxxMapXXXDotExpr() {
        ContentAssistStrategy prefix = ContentAssistParser.getPrefix((int)8, (String)xxxMapXXXDotExpr);
        CompletionPrefixTest.assertEquals((int)1, (int)prefix.getType());
        CompletionPrefixTest.assertEquals((String)"XXX", (String)prefix.getValue());
        prefix = ContentAssistParser.getPrefix((int)9, (String)xxxMapXXXDotExpr);
        CompletionPrefixTest.assertEquals((int)0, (int)prefix.getType());
        CompletionPrefixTest.assertEquals((String)"XXX", (String)prefix.getValue());
    }

    public void testSuffix_xxxMapXXXDotYYYExpr() {
        ContentAssistStrategy prefix = ContentAssistParser.getPrefix((int)9, (String)xxxMapXXXDotYYYExpr);
        CompletionPrefixTest.assertEquals((int)0, (int)prefix.getType());
        CompletionPrefixTest.assertEquals((String)"XXX", (String)prefix.getValue());
        prefix = ContentAssistParser.getPrefix((int)10, (String)xxxMapXXXDotYYYExpr);
        CompletionPrefixTest.assertEquals((int)0, (int)prefix.getType());
        CompletionPrefixTest.assertEquals((String)"XXX", (String)prefix.getValue());
        prefix = ContentAssistParser.getPrefix((int)12, (String)xxxMapXXXDotYYYExpr);
        CompletionPrefixTest.assertEquals((int)0, (int)prefix.getType());
        CompletionPrefixTest.assertEquals((String)"XXX", (String)prefix.getValue());
        prefix = ContentAssistParser.getPrefix((int)12, (String)xxxMapXXXDotYYYDotExpr);
        CompletionPrefixTest.assertEquals((int)0, (int)prefix.getType());
        CompletionPrefixTest.assertEquals((String)"XXX", (String)prefix.getValue());
        prefix = ContentAssistParser.getPrefix((int)13, (String)xxxMapXXXDotYYYDotExpr);
        CompletionPrefixTest.assertEquals((int)0, (int)prefix.getType());
        CompletionPrefixTest.assertEquals((String)"XXX.YYY", (String)prefix.getValue());
    }

    public void testSuffix_xxxMapXXXDotYYYDotZZZExpr() {
        ContentAssistStrategy prefix = ContentAssistParser.getPrefix((int)13, (String)xxxMapXXXDotYYYDotZZZExpr);
        CompletionPrefixTest.assertEquals((int)0, (int)prefix.getType());
        CompletionPrefixTest.assertEquals((String)"XXX.YYY", (String)prefix.getValue());
        prefix = ContentAssistParser.getPrefix((int)14, (String)xxxMapXXXDotYYYDotZZZExpr);
        CompletionPrefixTest.assertEquals((int)0, (int)prefix.getType());
        CompletionPrefixTest.assertEquals((String)"XXX.YYY", (String)prefix.getValue());
        prefix = ContentAssistParser.getPrefix((int)16, (String)xxxMapXXXDotYYYDotZZZExpr);
        CompletionPrefixTest.assertEquals((int)0, (int)prefix.getType());
        CompletionPrefixTest.assertEquals((String)"XXX.YYY", (String)prefix.getValue());
    }
}

