/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.contentassist.tests;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.jsf.contentassist.tests.BaseTestClass;
import org.eclipse.jst.jsf.contentassist.tests.ContentAssistTestsPlugin;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.symbol.IBeanInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.IBeanMethodSymbol;
import org.eclipse.jst.jsf.context.symbol.IBeanPropertySymbol;
import org.eclipse.jst.jsf.core.internal.contentassist.el.ContentAssistParser;
import org.eclipse.jst.jsf.core.internal.contentassist.el.SymbolInfo;
import org.eclipse.jst.jsf.core.tests.util.JSFCoreUtilHelper;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;

public class TestContentAssistParser
extends BaseTestClass {
    private WebProjectTestEnvironment _testEnv;
    private IFile _jspFile;
    private IType _myBeanType;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        this._testEnv = new WebProjectTestEnvironment(String.valueOf(((Object)((Object)this)).getClass().getName()) + "_" + this.getName());
        this._testEnv.createProject(false);
        TestContentAssistParser.assertNotNull((Object)this._testEnv);
        TestContentAssistParser.assertNotNull((Object)this._testEnv.getTestProject());
        TestContentAssistParser.assertTrue((boolean)this._testEnv.getTestProject().isAccessible());
        JSFFacetedTestEnvironment jsfFacedEnv = new JSFFacetedTestEnvironment(this._testEnv);
        jsfFacedEnv.initialize("1.1");
        this._testEnv.loadResourceInWebRoot(ContentAssistTestsPlugin.getDefault().getBundle(), "/testdata/faces-config_basic.xml.data", "/WEB-INF/faces-config.xml");
        this._jspFile = (IFile)this._testEnv.loadResourceInWebRoot(ContentAssistTestsPlugin.getDefault().getBundle(), "/testdata/basicELExpressions.jsp.data", "/basicELExpressions.jsp");
        TestContentAssistParser.assertNotNull((Object)this._jspFile);
        TestContentAssistParser.assertTrue((boolean)this._jspFile.isAccessible());
        JDTTestEnvironment jdtTestEnv = new JDTTestEnvironment((ProjectTestEnvironment)this._testEnv);
        TestFileResource resource = new TestFileResource();
        resource.load(ContentAssistTestsPlugin.getDefault().getBundle(), "/testdata/MyBean.java.data");
        jdtTestEnv.addSourceFile("src", "beans", "MyBean", resource.toString());
        this._myBeanType = JavaCore.create((IProject)this._testEnv.getTestProject()).findType("beans.MyBean");
        TestContentAssistParser.assertNotNull((Object)this._myBeanType);
        TestContentAssistParser.assertTrue((boolean)this._myBeanType.exists());
    }

    public void testSanity() throws Exception {
        JSFCoreUtilHelper.assertELSanity((IFile)this._jspFile, (int)518, (String)"value", (String)"#{}");
        JSFCoreUtilHelper.assertELSanity((IFile)this._jspFile, (int)547, (String)"value", (String)"#{   }");
        JSFCoreUtilHelper.assertELSanity((IFile)this._jspFile, (int)579, (String)"value", (String)"#{myBean}");
        JSFCoreUtilHelper.assertELSanity((IFile)this._jspFile, (int)614, (String)"value", (String)"#{myBean.property}");
        JSFCoreUtilHelper.assertELSanity((IFile)this._jspFile, (int)658, (String)"value", (String)"#{paramValues.foo}");
        JSFCoreUtilHelper.assertELSanity((IFile)this._jspFile, (int)706, (String)"action", (String)"#{myBean.actionMethod}");
        JSFCoreUtilHelper.assertELVariableSanity((IFile)this._jspFile, (String)"myBean");
    }

    public void testGetPrefix() {
    }

    public void testGetSymbolInfo() throws Exception {
        TestContentAssistParser.assertNull((Object)ContentAssistParser.getSymbolInfo((IStructuredDocumentContext)JSFCoreUtilHelper.getDocumentContext((IFile)this._jspFile, (int)518).getContext(), (int)1, null));
        TestContentAssistParser.assertNull((Object)ContentAssistParser.getSymbolInfo((IStructuredDocumentContext)JSFCoreUtilHelper.getDocumentContext((IFile)this._jspFile, (int)518).getContext(), (int)1, (String)""));
        TestContentAssistParser.assertNull((Object)ContentAssistParser.getSymbolInfo((IStructuredDocumentContext)JSFCoreUtilHelper.getDocumentContext((IFile)this._jspFile, (int)547).getContext(), (int)1, (String)"   "));
        SymbolInfo symbolInfo = ContentAssistParser.getSymbolInfo((IStructuredDocumentContext)JSFCoreUtilHelper.getDocumentContext((IFile)this._jspFile, (int)579).getContext(), (int)1, (String)"myBean");
        TestContentAssistParser.assertNotNull((Object)symbolInfo);
        TestContentAssistParser.assertEquals((String)"myBean", (String)symbolInfo.getSymbol().getName());
        TestContentAssistParser.assertTrue((boolean)(symbolInfo.getSymbol() instanceof IBeanInstanceSymbol));
        TestContentAssistParser.assertNotNull((Object)symbolInfo.getRelativeRegion());
        TestContentAssistParser.assertEquals((int)6, (int)symbolInfo.getRelativeRegion().getLength());
        symbolInfo = ContentAssistParser.getSymbolInfo((IStructuredDocumentContext)JSFCoreUtilHelper.getDocumentContext((IFile)this._jspFile, (int)614).getContext(), (int)8, (String)"myBean.property");
        TestContentAssistParser.assertNotNull((Object)symbolInfo);
        TestContentAssistParser.assertEquals((String)"property", (String)symbolInfo.getSymbol().getName());
        TestContentAssistParser.assertTrue((boolean)(symbolInfo.getSymbol() instanceof IBeanPropertySymbol));
        TestContentAssistParser.assertNotNull((Object)symbolInfo.getRelativeRegion());
        symbolInfo = ContentAssistParser.getSymbolInfo((IStructuredDocumentContext)JSFCoreUtilHelper.getDocumentContext((IFile)this._jspFile, (int)706).getContext(), (int)8, (String)"myBean.actionMethod");
        TestContentAssistParser.assertNotNull((Object)symbolInfo);
        TestContentAssistParser.assertEquals((String)"actionMethod", (String)symbolInfo.getSymbol().getName());
        TestContentAssistParser.assertTrue((boolean)(symbolInfo.getSymbol() instanceof IBeanMethodSymbol));
        TestContentAssistParser.assertNotNull((Object)symbolInfo.getRelativeRegion());
    }
}

