/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.tests.viewer;

import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.css.ui.StructuredTextViewerConfigurationCSS;
import org.eclipse.wst.css.ui.internal.contentassist.CSSContentAssistProcessor;
import org.eclipse.wst.css.ui.tests.ProjectUtil;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceAlreadyExists;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceInUse;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;

public class TestCSSContentAssist
extends TestCase {
    protected String projectName = null;
    protected String fileName = null;
    protected String resourcesFolder = null;
    private StructuredTextViewer sourceViewer = null;
    protected IStructuredDocument document = null;
    private IStructuredModel model;
    protected IFile file = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.projectName = "CSSContentAssistForMedia";
        this.fileName = "mediaexample.css";
        this.resourcesFolder = "/testresources";
        String filePath = this.setupProject();
        this.file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
        if (this.file != null && !this.file.exists()) {
            Assert.fail((String)("Unable to locate " + this.file + "."));
        }
        this.loadFile();
        this.initializeSourceViewer();
    }

    private void initializeSourceViewer() {
        if (Display.getCurrent() != null) {
            Shell shell = null;
            Composite parent = null;
            shell = PlatformUI.isWorkbenchRunning() ? PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell() : new Shell(Display.getCurrent());
            parent = new Composite((Composite)shell, 0);
            this.sourceViewer = new StructuredTextViewer(parent, null, null, false, 0);
        } else {
            Assert.fail((String)"Unable to run the test as a display must be available.");
        }
        this.configureSourceViewer();
    }

    protected void configureSourceViewer() {
        this.sourceViewer.configure((SourceViewerConfiguration)new StructuredTextViewerConfigurationCSS());
        this.sourceViewer.setDocument((IDocument)this.document);
    }

    protected void loadFile() throws ResourceAlreadyExists, ResourceInUse, IOException, CoreException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        this.model = modelManager.getModelForEdit(this.file);
        this.document = this.model.getStructuredDocument();
    }

    protected String setupProject() throws Exception {
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(this.projectName);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
        try {
            project.create(description, (IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
        String filePath = project.getFullPath().addTrailingSeparator().append(this.fileName).toString();
        ProjectUtil.copyBundleEntriesIntoWorkspace(this.resourcesFolder, project.getFullPath().toString());
        return filePath;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testContentAssistInsideMedia() throws Exception {
        try {
            CSSContentAssistProcessor processor = new CSSContentAssistProcessor();
            ICompletionProposal[] proposals = processor.computeCompletionProposals((ITextViewer)this.sourceViewer, 24);
            TestCSSContentAssist.assertTrue((String)"No proposals at offset.", (proposals.length > 0 ? 1 : 0) != 0);
            ICompletionProposal proposal = proposals[0];
            TestCSSContentAssist.assertEquals((String)"Wrong proposal returned for ACRONYM.", (String)"azimuth", (String)proposal.getDisplayString());
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.model.releaseFromEdit();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.model.releaseFromEdit();
    }
}

