/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.document;

import junit.framework.TestCase;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;

public class GetDocumentRegionsTest
extends TestCase {
    private boolean fAlreadySetup = false;
    private IStructuredDocument fDoc = null;
    private String fText = null;

    protected void setUp() throws Exception {
        super.setUp();
        if (!this.fAlreadySetup) {
            IStructuredModel sModel = this.createModel(ContentTypeIdForXML.ContentTypeID_XML);
            this.fDoc = sModel.getStructuredDocument();
            this.fText = "<html><head></head><body> text </body></html>";
            this.fDoc.set(this.fText);
            this.fAlreadySetup = true;
        }
    }

    public void testGetAllRegions() {
        IStructuredDocumentRegion[] regions = this.fDoc.getStructuredDocumentRegions();
        this.checkRegions(regions, 7, "<html>", "</html>");
    }

    public void testExcludeEnds() {
        IStructuredDocumentRegion[] regions = this.fDoc.getStructuredDocumentRegions(6, this.fText.length() - 13);
        this.checkRegions(regions, 5, "<head>", "</body>");
    }

    public void testIncludeEnds() {
        IStructuredDocumentRegion[] regions = this.fDoc.getStructuredDocumentRegions(3, this.fText.length() - 6);
        GetDocumentRegionsTest.assertEquals((int)7, (int)regions.length);
    }

    public void testFirstTwo() {
        IStructuredDocumentRegion[] regions = this.fDoc.getStructuredDocumentRegions(2, 6);
        this.checkRegions(regions, 2, "<html>", "<head>");
    }

    public void testRightSeam() {
        IStructuredDocumentRegion[] regions = this.fDoc.getStructuredDocumentRegions(0, 12);
        this.checkRegions(regions, 2, "<html>", "<head>");
    }

    public void testLeftSeam() {
        IStructuredDocumentRegion[] regions = this.fDoc.getStructuredDocumentRegions(this.fText.length() - 7, 7);
        this.checkRegions(regions, 1, "</html>", "</html>");
    }

    public void testGetLast() {
        IStructuredDocumentRegion[] regions = this.fDoc.getStructuredDocumentRegions(this.fText.length(), 0);
        this.checkRegions(regions, 1, "</html>", "</html>");
    }

    public void testGetFirst() {
        IStructuredDocumentRegion[] regions = this.fDoc.getStructuredDocumentRegions(0, 0);
        this.checkRegions(regions, 1, "<html>", "<html>");
    }

    private void checkRegions(IStructuredDocumentRegion[] regions, int expectedLength, String firstText, String lastText) {
        GetDocumentRegionsTest.assertEquals((int)expectedLength, (int)regions.length);
        String text = regions[0].getText();
        GetDocumentRegionsTest.assertEquals((String)text, (String)firstText);
        text = regions[regions.length - 1].getText();
        GetDocumentRegionsTest.assertEquals((String)text, (String)lastText);
    }

    private IStructuredModel createModel(String contentTypeID) {
        IStructuredModel model = StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(contentTypeID);
        return model;
    }
}

