/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.range;

import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceAlreadyExists;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceInUse;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ranges.Range;

public class TestRangeCompare
extends TestCase {
    private static final String decl = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    public void testRangeCompare() throws ResourceAlreadyExists, ResourceInUse, IOException, CoreException {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(decl);
        IDOMDocument document = model.getDocument();
        Element root = document.createElement("parent");
        document.appendChild(root);
        Element child = document.createElement("child");
        root.appendChild(child);
        child.appendChild(document.createElement("child1-1"));
        Text textnode = document.createTextNode("Text Node");
        root.appendChild(textnode);
        NodeList children = root.getElementsByTagName("child");
        Range range = ((DocumentImpl)document).createRange();
        range.setEnd(children.item(0), 1);
        Range sourceRange = ((DocumentImpl)document).createRange();
        sourceRange.setEnd(textnode, 0);
        short result = range.compareBoundaryPoints((short)2, sourceRange);
        TestRangeCompare.assertEquals((int)-1, (int)result);
    }
}

