package oracle.adfdemo.view.faces.email;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.component.UIComponent;
import javax.faces.convert.Converter;
import javax.faces.context.FacesContext;

import oracle.adf.view.faces.context.AdfFacesContext;

public class RelativeDateConverter implements Converter
{
  public RelativeDateConverter()
  {
  }

  public String getAsString(FacesContext context, UIComponent component,
                            Object value)
  {
    if (value == null)
      return null;

    if (!(value instanceof Date))
      return value.toString();

    Date date = (Date) value;

    AdfFacesContext afContext = AdfFacesContext.getCurrentInstance();
    TimeZone tz = afContext.getTimeZone();
    if (tz == null)
      tz = TimeZone.getDefault();

    Locale locale = context.getViewRoot().getLocale();
    if (_isToday(date, tz, locale))
    {
      DateFormat format = DateFormat.getTimeInstance(DateFormat.SHORT,
                                                     locale);
      String dateString = format.format(date);
      String todayMask = MessageUtils.getString(context, "TODAY_MASK");
      return MessageFormat.format(todayMask, new Object[]{dateString});
    }
    else
    {
      DateFormat format = DateFormat.getDateTimeInstance(DateFormat.SHORT,
                                                         DateFormat.SHORT,
                                                         locale);
      return format.format(date);
    }
  }

  public Object getAsObject(FacesContext context, UIComponent component,
                            String value)
  {
    throw new UnsupportedOperationException();
  }

  static private boolean _isToday(Date date, TimeZone tz, Locale locale)
  {
    Calendar calendar = Calendar.getInstance(tz, locale);
    calendar.setTime(date);

    int year = calendar.get(Calendar.YEAR);
    int dayOfYear = calendar.get(Calendar.DAY_OF_YEAR);

    calendar.setTime(new Date());
    if ((year == calendar.get(Calendar.YEAR)) &&
        (dayOfYear == calendar.get(Calendar.DAY_OF_YEAR)))
    {
      return true;
    }
    else
    {
      return false;
    }
  }
}
