/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.tests.internal.utility.jdt;

import java.util.Arrays;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotationStringArrayExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.BooleanExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.CharacterStringExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.EnumArrayDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.IndexedConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.NestedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.NumberIntegerExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.PrimitiveTypeStringExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.StringExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.TypeStringExpressionConverter;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedExpressionConverter;

public class MemberAnnotationElementAdapterTests
extends AnnotationTestCase {
    public MemberAnnotationElementAdapterTests(String name) {
        super(name);
    }

    private void createAnnotationAndMembers(String annotationName, String annotationBody) throws Exception {
        this.javaProject.createCompilationUnit("annot", String.valueOf(annotationName) + ".java", "public @interface " + annotationName + " { " + annotationBody + " }");
    }

    private void createEnum(String enumName, String enumBody) throws Exception {
        this.createEnum("enums", enumName, enumBody);
    }

    private void createEnum(String packageName, String enumName, String enumBody) throws Exception {
        this.javaProject.createCompilationUnit(packageName, String.valueOf(enumName) + ".java", "public enum " + enumName + " { " + enumBody + " }");
    }

    public void testValue1() throws Exception {
        this.createAnnotationAndMembers("Foo", "String bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=\"xxx\")");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"xxx", (String)((String)aea.getValue()));
    }

    public void testValue2() throws Exception {
        this.createAnnotationAndMembers("Foo", "int bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=48)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", NumberIntegerExpressionConverter.instance());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((Object)48, (Object)aea.getValue());
    }

    public void testValue3() throws Exception {
        this.createAnnotationAndMembers("Foo", "char bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar='c')");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", CharacterStringExpressionConverter.instance());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"c", (String)((String)aea.getValue()));
    }

    public void testValue4() throws Exception {
        this.createAnnotationAndMembers("Foo", "boolean bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=false)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", BooleanExpressionConverter.instance());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((Object)Boolean.FALSE, (Object)aea.getValue());
    }

    public void testValue5() throws Exception {
        this.createAnnotationAndMembers("Baz", "boolean fred();");
        this.createAnnotationAndMembers("Bar", "annot.Baz jimmy();");
        this.createAnnotationAndMembers("Foo", "annot.Bar value();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(@annot.Bar(jimmy=@annot.Baz(fred=false)))");
        SimpleDeclarationAnnotationAdapter daa1 = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        NestedDeclarationAnnotationAdapter daa2 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa1, "value", "annot.Bar");
        NestedDeclarationAnnotationAdapter daa3 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa2, "jimmy", "annot.Baz");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa3, "fred", BooleanExpressionConverter.instance());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((Object)Boolean.FALSE, (Object)aea.getValue());
    }

    public void testValue6() throws Exception {
        this.createAnnotationAndMembers("Foo", "boolean value();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(false)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, BooleanExpressionConverter.instance());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((Object)Boolean.FALSE, (Object)aea.getValue());
    }

    public void testValueNull1() throws Exception {
        this.createAnnotationAndMembers("Foo", "String bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertNull((Object)aea.getValue());
    }

    public void testValueNull2() throws Exception {
        this.createAnnotationAndMembers("Foo", "String bar();");
        ICompilationUnit cu = this.createTestType();
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertNull((Object)aea.getValue());
    }

    public void testValueNull3() throws Exception {
        this.createAnnotationAndMembers("Baz", "String fred();");
        this.createAnnotationAndMembers("Bar", "annot.Baz jimmy();");
        this.createAnnotationAndMembers("Foo", "annot.Bar value();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(@annot.Bar(jimmy=@annot.Baz))");
        SimpleDeclarationAnnotationAdapter daa1 = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        NestedDeclarationAnnotationAdapter daa2 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa1, "value", "annot.Bar");
        NestedDeclarationAnnotationAdapter daa3 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa2, "jimmy", "annot.Baz");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa3, (String)"fred");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertNull((Object)aea.getValue());
    }

    public void testValueStringConcatenation() throws Exception {
        this.createAnnotationAndMembers("Foo", "String bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=\"xxx\" + \"yyy\" + \"zzz\")");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"xxxyyyzzz", (String)((String)aea.getValue()));
    }

    public void testValueStringConstant() throws Exception {
        this.createAnnotationAndMembers("Foo", "String bar();");
        ICompilationUnit cu = this.createTestType("private static final String FOO_BAR = \"xxx\"; @annot.Foo(bar=FOO_BAR + \"yyy\" + \"zzz\")");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"xxxyyyzzz", (String)((String)aea.getValue()));
    }

    public void testValueNumberArithmetic() throws Exception {
        this.createAnnotationAndMembers("Foo", "int bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=47 - 7 + 2 * 1 / 1)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forNumbers((DeclarationAnnotationAdapter)daa, (String)"bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((Object)42, (Object)aea.getValue());
    }

    public void testValueNumberShift() throws Exception {
        this.createAnnotationAndMembers("Foo", "int bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=2 << 2)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forNumbers((DeclarationAnnotationAdapter)daa, (String)"bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((Object)8, (Object)aea.getValue());
    }

    public void testValueNumberConstant() throws Exception {
        this.createAnnotationAndMembers("Foo", "int bar();");
        ICompilationUnit cu = this.createTestType("private static final int FOO_BAR = 77; @annot.Foo(bar=FOO_BAR)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forNumbers((DeclarationAnnotationAdapter)daa, (String)"bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((Object)77, (Object)aea.getValue());
    }

    public void testValueCharacterConstant() throws Exception {
        this.createAnnotationAndMembers("Foo", "char bar();");
        ICompilationUnit cu = this.createTestType("private static final char FOO_BAR = 'Q'; @annot.Foo(bar=FOO_BAR)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forCharacters((DeclarationAnnotationAdapter)daa, (String)"bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"Q", (String)((String)aea.getValue()));
    }

    public void testValueCharacterCast() throws Exception {
        this.createAnnotationAndMembers("Foo", "char bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=(char) 0x41)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forCharacters((DeclarationAnnotationAdapter)daa, (String)"bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"A", (String)((String)aea.getValue()));
    }

    public void testValueBooleanOperator1() throws Exception {
        this.createAnnotationAndMembers("Foo", "boolean bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=7 > 2)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forBooleans((DeclarationAnnotationAdapter)daa, (String)"bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((Object)Boolean.TRUE, (Object)aea.getValue());
    }

    public void testValueBooleanOperator2() throws Exception {
        this.createAnnotationAndMembers("Foo", "boolean bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=7 == 2)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forBooleans((DeclarationAnnotationAdapter)daa, (String)"bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((Object)Boolean.FALSE, (Object)aea.getValue());
    }

    public void testValueBooleanOperator3() throws Exception {
        this.createAnnotationAndMembers("Foo", "boolean bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=(7 != 2) && false)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forBooleans((DeclarationAnnotationAdapter)daa, (String)"bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((Object)Boolean.FALSE, (Object)aea.getValue());
    }

    public void testValueBooleanOperator4() throws Exception {
        this.createAnnotationAndMembers("Foo", "boolean bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=(7 != 2) ? false : true)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forBooleans((DeclarationAnnotationAdapter)daa, (String)"bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((Object)Boolean.FALSE, (Object)aea.getValue());
    }

    public void testValueInvalidValue1() throws Exception {
        this.createAnnotationAndMembers("Foo", "String bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=77)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertNull((Object)aea.getValue());
    }

    public void testValueInvalidValue2() throws Exception {
        this.createAnnotationAndMembers("Foo", "String bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=bazzzz)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertNull((Object)aea.getValue());
    }

    public void testValueInvalidValue3() throws Exception {
        this.createAnnotationAndMembers("Foo", "boolean bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=bazzzz)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forBooleans((DeclarationAnnotationAdapter)daa, (String)"bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertNull((Object)aea.getValue());
    }

    public void testValueInvalidValue4() throws Exception {
        this.createAnnotationAndMembers("Foo", "char bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=\"bazzzz\")");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forCharacters((DeclarationAnnotationAdapter)daa, (String)"bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertNull((Object)aea.getValue());
    }

    public void testValueInvalidValue5() throws Exception {
        this.createAnnotationAndMembers("Foo", "Class bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=\"java.lang.Object\")");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", SimpleTypeStringExpressionConverter.instance());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertNull((Object)aea.getValue());
    }

    public void testValueInvalidValue6() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=enums.TestEnum.class)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumDeclarationAnnotationElementAdapter daea = new EnumDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertNull((Object)aea.getValue());
    }

    public void testValueInvalidValue7() throws Exception {
        this.createAnnotationAndMembers("Baz", "boolean fred();");
        this.createAnnotationAndMembers("Bar", "annot.Baz jimmy();");
        this.createAnnotationAndMembers("Foo", "annot.Bar value();");
        String value = "\"false\"";
        String element = "fred=" + value;
        String annotation = "@annot.Foo(@annot.Bar(jimmy=@annot.Baz(" + element + ")))";
        ICompilationUnit cu = this.createTestType(annotation);
        SimpleDeclarationAnnotationAdapter daa1 = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        NestedDeclarationAnnotationAdapter daa2 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa1, "value", "annot.Bar");
        NestedDeclarationAnnotationAdapter daa3 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa2, "jimmy", "annot.Baz");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa3, "fred", BooleanExpressionConverter.instance());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertNull((Object)aea.getValue());
    }

    public void testValueInvalidValue8() throws Exception {
        this.createAnnotationAndMembers("Foo", "String[] bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar={true, false})");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", (ExpressionConverter)AnnotationStringArrayExpressionConverter.forStrings());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertTrue((boolean)Arrays.equals(new String[2], (Object[])aea.getValue()));
    }

    public void testValueInvalidValue9() throws Exception {
        this.createAnnotationAndMembers("Foo", "String[] bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=77)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", (ExpressionConverter)AnnotationStringArrayExpressionConverter.forStrings());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertTrue((boolean)Arrays.equals(new String[0], (Object[])aea.getValue()));
    }

    public void testASTNode1() throws Exception {
        this.createAnnotationAndMembers("Foo", "String bar();");
        String value = "\"xxx\"";
        String element = "bar=" + value;
        String annotation = "@annot.Foo(" + element + ")";
        ICompilationUnit cu = this.createTestType(annotation);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        TextRange textRange = ASTTools.buildTextRange((ASTNode)aea.getAstNode(this.buildASTRoot(cu)));
        MemberAnnotationElementAdapterTests.assertEquals((int)this.getSource(cu).indexOf(value), (int)textRange.getOffset());
        MemberAnnotationElementAdapterTests.assertEquals((int)value.length(), (int)textRange.getLength());
        MemberAnnotationElementAdapterTests.assertEquals((int)7, (int)textRange.getLineNumber());
    }

    public void testASTNode2() throws Exception {
        this.createAnnotationAndMembers("Baz", "boolean fred();");
        this.createAnnotationAndMembers("Bar", "annot.Baz jimmy();");
        this.createAnnotationAndMembers("Foo", "annot.Bar value();");
        String value = "false";
        String element = "fred=" + value;
        String annotation = "@annot.Foo(@annot.Bar(jimmy=@annot.Baz(" + element + ")))";
        ICompilationUnit cu = this.createTestType(annotation);
        SimpleDeclarationAnnotationAdapter daa1 = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        NestedDeclarationAnnotationAdapter daa2 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa1, "value", "annot.Bar");
        NestedDeclarationAnnotationAdapter daa3 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa2, "jimmy", "annot.Baz");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa3, "fred", BooleanExpressionConverter.instance());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((Object)Boolean.FALSE, (Object)aea.getValue());
        TextRange textRange = ASTTools.buildTextRange((ASTNode)aea.getAstNode(this.buildASTRoot(cu)));
        MemberAnnotationElementAdapterTests.assertEquals((int)value.length(), (int)textRange.getLength());
    }

    public void testASTNode3() throws Exception {
        this.createAnnotationAndMembers("Foo", "String value();");
        String element = "\"xxx\"";
        String annotation = "@annot.Foo(" + element + ")";
        ICompilationUnit cu = this.createTestType(annotation);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa);
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        TextRange textRange = ASTTools.buildTextRange((ASTNode)aea.getAstNode(this.buildASTRoot(cu)));
        MemberAnnotationElementAdapterTests.assertEquals((int)this.getSource(cu).indexOf(element), (int)textRange.getOffset());
        MemberAnnotationElementAdapterTests.assertEquals((int)element.length(), (int)textRange.getLength());
    }

    public void testASTNode4() throws Exception {
        this.createAnnotationAndMembers("Foo", "String value();");
        String annotation = "@annot.Foo";
        ICompilationUnit cu = this.createTestType(annotation);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa);
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        TextRange textRange = ASTTools.buildTextRange((ASTNode)aea.getAstNode(this.buildASTRoot(cu)));
        MemberAnnotationElementAdapterTests.assertEquals((int)this.getSource(cu).indexOf(annotation), (int)textRange.getOffset());
        MemberAnnotationElementAdapterTests.assertEquals((int)annotation.length(), (int)textRange.getLength());
    }

    public void testSetValue1() throws Exception {
        this.createAnnotationAndMembers("Foo", "String bar();");
        String annotation = "@annot.Foo(bar=\"xxx\")";
        ICompilationUnit cu = this.createTestType(annotation);
        this.assertSourceContains(annotation, cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue(null);
        this.assertSourceDoesNotContain("bar", cu);
    }

    public void testSetValue2() throws Exception {
        this.createAnnotationAndMembers("Foo", "String bar();");
        String annotation = "@annot.Foo(bar=\"xxx\")";
        ICompilationUnit cu = this.createTestType(annotation);
        this.assertSourceContains(annotation, cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue(null);
        this.assertSourceDoesNotContain(annotation, cu);
        this.assertSourceContains("@Foo", cu);
    }

    public void testSetValue3() throws Exception {
        this.createAnnotationAndMembers("Baz", "boolean fred();");
        this.createAnnotationAndMembers("Bar", "annot.Baz jimmy();");
        this.createAnnotationAndMembers("Foo", "annot.Bar value();");
        String annotation = "@annot.Foo(@annot.Bar(jimmy=@annot.Baz(fred=false)))";
        ICompilationUnit cu = this.createTestType(annotation);
        this.assertSourceContains(annotation, cu);
        SimpleDeclarationAnnotationAdapter daa1 = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        NestedDeclarationAnnotationAdapter daa2 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa1, "value", "annot.Bar");
        NestedDeclarationAnnotationAdapter daa3 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa2, "jimmy", "annot.Baz");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa3, "fred", BooleanExpressionConverter.instance());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue(null);
        this.assertSourceDoesNotContain(annotation, cu);
        this.assertSourceDoesNotContain("fred", cu);
    }

    public void testSetValue3a() throws Exception {
        this.createAnnotationAndMembers("Baz", "boolean fred();");
        this.createAnnotationAndMembers("Bar", "annot.Baz jimmy();");
        this.createAnnotationAndMembers("Foo", "annot.Bar value();");
        String annotation = "@annot.Foo(@annot.Bar(jimmy=@annot.Baz(fred=false)))";
        ICompilationUnit cu = this.createTestType(annotation);
        this.assertSourceContains(annotation, cu);
        SimpleDeclarationAnnotationAdapter daa1 = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        NestedDeclarationAnnotationAdapter daa2 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa1, "value", "annot.Bar");
        NestedDeclarationAnnotationAdapter daa3 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa2, "jimmy", "annot.Baz");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa3, "fred", BooleanExpressionConverter.instance());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue(null);
        this.assertSourceDoesNotContain(annotation, cu);
        this.assertSourceDoesNotContain("fred", cu);
        this.assertSourceContains("@annot.Foo(@annot.Bar(jimmy=@Baz))", cu);
    }

    public void testSetValue4() throws Exception {
        this.createAnnotationAndMembers("Foo", "String bar();");
        ICompilationUnit cu = this.createTestType();
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)"xxx");
        this.assertSourceContains("@Foo(bar = \"xxx\")", cu);
    }

    public void testSetValue5() throws Exception {
        this.createAnnotationAndMembers("Baz", "boolean fred();");
        this.createAnnotationAndMembers("Bar", "annot.Baz jimmy();");
        this.createAnnotationAndMembers("Foo", "annot.Bar value();");
        String annotation = "@annot.Foo(@annot.Bar(jimmy=@annot.Baz(fred=false)))";
        ICompilationUnit cu = this.createTestType(annotation);
        this.assertSourceContains(annotation, cu);
        SimpleDeclarationAnnotationAdapter daa1 = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        NestedDeclarationAnnotationAdapter daa2 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa1, "value", "annot.Bar");
        NestedDeclarationAnnotationAdapter daa3 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa2, "jimmy", "annot.Baz");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa3, "fred", BooleanExpressionConverter.instance());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)Boolean.TRUE);
        this.assertSourceDoesNotContain(annotation, cu);
        this.assertSourceContains("@annot.Foo(@annot.Bar(jimmy=@annot.Baz(fred=true)))", cu);
    }

    public void testSetValue6() throws Exception {
        this.createAnnotationAndMembers("Baz", "boolean fred();");
        this.createAnnotationAndMembers("Bar", "annot.Baz jimmy();");
        this.createAnnotationAndMembers("Foo", "annot.Bar value();");
        ICompilationUnit cu = this.createTestType();
        SimpleDeclarationAnnotationAdapter daa1 = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        NestedDeclarationAnnotationAdapter daa2 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa1, "value", "annot.Bar");
        NestedDeclarationAnnotationAdapter daa3 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa2, "jimmy", "annot.Baz");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa3, "fred", BooleanExpressionConverter.instance());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)Boolean.TRUE);
        this.assertSourceContains("@Foo(@Bar(jimmy = @Baz(fred = true)))", cu);
    }

    public void testSetValue7() throws Exception {
        this.createAnnotationAndMembers("Foo", "String bar();");
        String annotation = "@annot.Foo(bar=\"xxx\")";
        ICompilationUnit cu = this.createTestType(annotation);
        this.assertSourceContains(annotation, cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)"yyy");
        this.assertSourceDoesNotContain(annotation, cu);
        this.assertSourceContains("@annot.Foo(bar=\"yyy\")", cu);
    }

    public void testSetValue8() throws Exception {
        this.createAnnotationAndMembers("Foo", "String bar();");
        String annotation = "@annot.Foo";
        ICompilationUnit cu = this.createTestType(annotation);
        this.assertSourceContains(annotation, cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)"xxx");
        this.assertSourceContains("@Foo(bar = \"xxx\")", cu);
    }

    public void testSetValue9() throws Exception {
        this.createAnnotationAndMembers("Foo", "String value(); String bar();");
        String annotation = "@annot.Foo(\"zzz\")";
        ICompilationUnit cu = this.createTestType(annotation);
        this.assertSourceContains(annotation, cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)"xxx");
        this.assertSourceDoesNotContain(annotation, cu);
        this.assertSourceContains("@Foo(value = \"zzz\", bar = \"xxx\")", cu);
    }

    public void testSetValue10() throws Exception {
        this.createAnnotationAndMembers("Foo", "String bar(); String baz();");
        String annotation = "@annot.Foo(bar=\"xxx\")";
        ICompilationUnit cu = this.createTestType(annotation);
        this.assertSourceContains(annotation, cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"baz");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)"yyy");
        this.assertSourceDoesNotContain(annotation, cu);
        this.assertSourceContains("@annot.Foo(bar=\"xxx\", baz = \"yyy\")", cu);
    }

    public void testSetValue11() throws Exception {
        this.createAnnotationAndMembers("Baz", "int fred();");
        this.createAnnotationAndMembers("Bar", "annot.Baz[] jimmy();");
        this.createAnnotationAndMembers("Foo", "annot.Bar value();");
        String annotation = "@annot.Foo(@annot.Bar(jimmy={@annot.Baz(fred=0), @annot.Baz(fred=1), @annot.Baz(fred=2), @annot.Baz(fred=3)}))";
        ICompilationUnit cu = this.createTestType(annotation);
        this.assertSourceContains(annotation, cu);
        SimpleDeclarationAnnotationAdapter daa1 = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        NestedDeclarationAnnotationAdapter daa2 = new NestedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa1, "value", "annot.Bar");
        NestedIndexedDeclarationAnnotationAdapter daa3 = new NestedIndexedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)daa2, "jimmy", 2, "annot.Baz");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa3, "fred", NumberIntegerExpressionConverter.instance());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((Object)2, (Object)aea.getValue());
        aea.setValue((Object)48);
        this.assertSourceContains("@annot.Foo(@annot.Bar(jimmy={@annot.Baz(fred=0), @annot.Baz(fred=1), @annot.Baz(fred=48), @annot.Baz(fred=3)}))", cu);
    }

    public void testSetValue12() throws Exception {
        this.createAnnotationAndMembers("Foo", "String value();");
        String annotation = "@annot.Foo";
        ICompilationUnit cu = this.createTestType(annotation);
        this.assertSourceContains(annotation, cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"value");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)"xxx");
        this.assertSourceContains("@Foo(\"xxx\")", cu);
    }

    public void testSetValue13() throws Exception {
        this.createAnnotationAndMembers("Foo", "String value();");
        String annotation = "@annot.Foo(\"zzz\")";
        ICompilationUnit cu = this.createTestType(annotation);
        this.assertSourceContains(annotation, cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"value");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)"xxx");
        this.assertSourceDoesNotContain(annotation, cu);
        this.assertSourceContains("@annot.Foo(\"xxx\")", cu);
    }

    public void testSimpleTypeLiteral1() throws Exception {
        this.createAnnotationAndMembers("Foo", "Class bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=java.lang.Object.class)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", SimpleTypeStringExpressionConverter.instance());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"java.lang.Object", (String)((String)aea.getValue()));
    }

    public void testSimpleTypeLiteral2() throws Exception {
        this.createAnnotationAndMembers("Foo", "Class bar();");
        ICompilationUnit cu = this.createTestType();
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", SimpleTypeStringExpressionConverter.instance());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)"java.lang.Object");
        this.assertSourceContains("@Foo(bar = java.lang.Object.class)", cu);
    }

    public void testSimpleTypeLiteral3() throws Exception {
        this.createAnnotationAndMembers("Foo", "Class bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=int.class)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", SimpleTypeStringExpressionConverter.instance());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertNull((Object)aea.getValue());
    }

    public void testSimpleTypeLiteral4() throws Exception {
        this.createAnnotationAndMembers("Foo", "Class bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=java.util.Map.Entry.class)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", SimpleTypeStringExpressionConverter.instance());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"java.util.Map.Entry", (String)((String)aea.getValue()));
    }

    public void testPrimitiveTypeLiteral1() throws Exception {
        this.createAnnotationAndMembers("Foo", "Class bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=int.class)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", PrimitiveTypeStringExpressionConverter.instance());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"int", (String)((String)aea.getValue()));
    }

    public void testPrimitiveTypeLiteral2() throws Exception {
        this.createAnnotationAndMembers("Foo", "Class bar();");
        ICompilationUnit cu = this.createTestType();
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", PrimitiveTypeStringExpressionConverter.instance());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)"int");
        this.assertSourceContains("@Foo(bar = int.class)", cu);
    }

    public void testPrimitiveTypeLiteral3() throws Exception {
        this.createAnnotationAndMembers("Foo", "Class bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=java.lang.Object.class)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", PrimitiveTypeStringExpressionConverter.instance());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertNull((Object)aea.getValue());
    }

    public void testPrimitiveTypeLiteral4() throws Exception {
        this.createAnnotationAndMembers("Foo", "Class bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=void.class)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", PrimitiveTypeStringExpressionConverter.instance());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"void", (String)((String)aea.getValue()));
    }

    public void testTypeLiteral1() throws Exception {
        this.createAnnotationAndMembers("Foo", "Class bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=java.lang.Object.class)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", TypeStringExpressionConverter.instance());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"java.lang.Object", (String)((String)aea.getValue()));
    }

    public void testTypeLiteral2() throws Exception {
        this.createAnnotationAndMembers("Foo", "Class bar();");
        ICompilationUnit cu = this.createTestType();
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", TypeStringExpressionConverter.instance());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)"java.lang.Object");
        this.assertSourceContains("@Foo(bar = java.lang.Object.class)", cu);
    }

    public void testTypeLiteral3() throws Exception {
        this.createAnnotationAndMembers("Foo", "Class bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=java.util.Map.Entry.class)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", TypeStringExpressionConverter.instance());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"java.util.Map.Entry", (String)((String)aea.getValue()));
    }

    public void testTypeLiteral14() throws Exception {
        this.createAnnotationAndMembers("Foo", "Class bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=int.class)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", TypeStringExpressionConverter.instance());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"int", (String)((String)aea.getValue()));
    }

    public void testTypeLiteral5() throws Exception {
        this.createAnnotationAndMembers("Foo", "Class bar();");
        ICompilationUnit cu = this.createTestType();
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", TypeStringExpressionConverter.instance());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)"int");
        this.assertSourceContains("@Foo(bar = int.class)", cu);
    }

    public void testTypeLiteral6() throws Exception {
        this.createAnnotationAndMembers("Foo", "Class bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=void.class)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", TypeStringExpressionConverter.instance());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"void", (String)((String)aea.getValue()));
    }

    public void testValueEnum1() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=enums.TestEnum.XXX)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumDeclarationAnnotationElementAdapter daea = new EnumDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"enums.TestEnum.XXX", (String)((String)aea.getValue()));
    }

    public void testValueEnum2() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum bar();");
        ICompilationUnit cu = this.createTestType("static enums.TestEnum.XXX", "@annot.Foo(bar=XXX)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumDeclarationAnnotationElementAdapter daea = new EnumDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"enums.TestEnum.XXX", (String)((String)aea.getValue()));
    }

    public void testValueEnum3() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumDeclarationAnnotationElementAdapter daea = new EnumDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertNull((Object)aea.getValue());
    }

    public void testValueEnum4() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum bar();");
        ICompilationUnit cu = this.createTestType("enums.TestEnum", "@annot.Foo(bar=TestEnum.XXX)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumDeclarationAnnotationElementAdapter daea = new EnumDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertEquals((String)"enums.TestEnum.XXX", (String)((String)aea.getValue()));
    }

    public void testSetValueEnum1() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum bar();");
        String expected = "@annot.Foo(bar=XXX)";
        ICompilationUnit cu = this.createTestType("static enums.TestEnum.XXX", expected);
        this.assertSourceContains(expected, cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumDeclarationAnnotationElementAdapter daea = new EnumDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue(null);
        this.assertSourceDoesNotContain("bar", cu);
    }

    public void testSetValueEnum2() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum bar();");
        String expected = "@Foo(bar = XXX)";
        ICompilationUnit cu = this.createTestType();
        this.assertSourceDoesNotContain(expected, cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumDeclarationAnnotationElementAdapter daea = new EnumDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)"enums.TestEnum.XXX");
        this.assertSourceContains("import static enums.TestEnum.XXX;", cu);
        this.assertSourceContains(expected, cu);
    }

    public void testSetValueEnumImportCollision1() throws Exception {
        this.createEnum("enums1", "TestEnum", "XXX, YYY, ZZZ");
        this.createEnum("enums2", "TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums1.TestEnum bar1();  enums2.TestEnum bar2();");
        String expected = "@Foo(bar1 = XXX, bar2 = TestEnum.XXX)";
        ICompilationUnit cu = this.createTestType();
        this.assertSourceDoesNotContain(expected, cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumDeclarationAnnotationElementAdapter daea1 = new EnumDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar1");
        AnnotatedElementAnnotationElementAdapter aea1 = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea1);
        aea1.setValue((Object)"enums1.TestEnum.XXX");
        EnumDeclarationAnnotationElementAdapter daea2 = new EnumDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar2");
        AnnotatedElementAnnotationElementAdapter aea2 = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea2);
        aea2.setValue((Object)"enums2.TestEnum.XXX");
        this.assertSourceContains("import static enums1.TestEnum.XXX;", cu);
        this.assertSourceDoesNotContain("import static enums2.TestEnum.XXX;", cu);
        this.assertSourceContains("import enums2.TestEnum;", cu);
        this.assertSourceContains(expected, cu);
    }

    public void testSetValueEnumImportCollision2() throws Exception {
        this.createEnum("enums1", "TestEnum", "XXX, YYY, ZZZ");
        this.createEnum("enums2", "TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums1.TestEnum bar1();  enums2.TestEnum bar2();");
        String expected = "@annot.Foo(bar1=XXX, bar2 = TestEnum.XXX)";
        ICompilationUnit cu = this.createTestType("static enums1.TestEnum.*", "@annot.Foo(bar1=XXX)");
        this.assertSourceDoesNotContain(expected, cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumDeclarationAnnotationElementAdapter daea1 = new EnumDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar1");
        AnnotatedElementAnnotationElementAdapter aea1 = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea1);
        MemberAnnotationElementAdapterTests.assertNotNull((Object)aea1.getValue());
        EnumDeclarationAnnotationElementAdapter daea2 = new EnumDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar2");
        AnnotatedElementAnnotationElementAdapter aea2 = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea2);
        aea2.setValue((Object)"enums2.TestEnum.XXX");
        this.assertSourceContains("import static enums1.TestEnum.*;", cu);
        this.assertSourceDoesNotContain("import static enums2.TestEnum.XXX;", cu);
        this.assertSourceContains("import enums2.TestEnum;", cu);
        this.assertSourceContains(expected, cu);
    }

    public void testSetValueEnumImportCollision3() throws Exception {
        this.createEnum("TestEnum1", "XXX, YYY, ZZZ");
        this.createEnum("TestEnum2", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum1 bar1();  enums.TestEnum2 bar2();");
        String expected = "@Foo(bar1 = XXX, bar2 = TestEnum2.XXX)";
        ICompilationUnit cu = this.createTestType();
        this.assertSourceDoesNotContain(expected, cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumDeclarationAnnotationElementAdapter daea1 = new EnumDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar1");
        AnnotatedElementAnnotationElementAdapter aea1 = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea1);
        aea1.setValue((Object)"enums.TestEnum1.XXX");
        EnumDeclarationAnnotationElementAdapter daea2 = new EnumDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar2");
        AnnotatedElementAnnotationElementAdapter aea2 = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea2);
        aea2.setValue((Object)"enums.TestEnum2.XXX");
        this.assertSourceContains("import static enums.TestEnum1.XXX;", cu);
        this.assertSourceContains("import enums.TestEnum2;", cu);
        this.assertSourceContains(expected, cu);
    }

    public void testSetValueEnumImportCollision4() throws Exception {
        this.createEnum("TestEnum1", "XXX, YYY, ZZZ");
        this.createEnum("TestEnum2", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum1 bar1();  enums.TestEnum2 bar2();");
        String expected = "@annot.Foo(bar1=XXX, bar2 = TestEnum2.XXX)";
        ICompilationUnit cu = this.createTestType("static enums.TestEnum1.*", "@annot.Foo(bar1=XXX)");
        this.assertSourceDoesNotContain(expected, cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumDeclarationAnnotationElementAdapter daea1 = new EnumDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar1");
        AnnotatedElementAnnotationElementAdapter aea1 = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea1);
        MemberAnnotationElementAdapterTests.assertNotNull((Object)aea1.getValue());
        EnumDeclarationAnnotationElementAdapter daea2 = new EnumDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar2");
        AnnotatedElementAnnotationElementAdapter aea2 = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea2);
        aea2.setValue((Object)"enums.TestEnum2.XXX");
        this.assertSourceContains("import static enums.TestEnum1.*;", cu);
        this.assertSourceContains("import enums.TestEnum2;", cu);
        this.assertSourceContains(expected, cu);
    }

    public void testSetValueEnumImportCollision5() throws Exception {
        this.createEnum("TestEnum1", "XXX, YYY, ZZZ");
        this.createEnum("TestEnum2", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum1 bar1();  enums.TestEnum2 bar2();");
        String expected = "@Foo(bar1 = XXX, bar2 = TestEnum2.XXX)";
        ICompilationUnit cu = this.createTestType("enums.*", "");
        this.assertSourceDoesNotContain(expected, cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumDeclarationAnnotationElementAdapter daea1 = new EnumDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar1");
        AnnotatedElementAnnotationElementAdapter aea1 = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea1);
        aea1.setValue((Object)"enums.TestEnum1.XXX");
        EnumDeclarationAnnotationElementAdapter daea2 = new EnumDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar2");
        AnnotatedElementAnnotationElementAdapter aea2 = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea2);
        aea2.setValue((Object)"enums.TestEnum2.XXX");
        this.assertSourceContains("import enums.*;", cu);
        this.assertSourceContains("import static enums.TestEnum1.XXX;", cu);
        this.assertSourceDoesNotContain("import enums.TestEnum2;", cu);
        this.assertSourceContains(expected, cu);
    }

    public void testSetValueEnumImportCollision6() throws Exception {
        this.createEnum("enums1", "TestEnum", "XXX, YYY, ZZZ");
        this.createEnum("enums2", "TestEnum", "XXX, YYY, ZZZ");
        this.createEnum("enums3", "TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums1.TestEnum bar1();  enums2.TestEnum bar2();  enums3.TestEnum bar3();");
        String expected = "@Foo(bar1 = XXX, bar2 = TestEnum.XXX, bar3 = enums3.TestEnum.XXX)";
        ICompilationUnit cu = this.createTestType();
        this.assertSourceDoesNotContain(expected, cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumDeclarationAnnotationElementAdapter daea1 = new EnumDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar1");
        AnnotatedElementAnnotationElementAdapter aea1 = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea1);
        aea1.setValue((Object)"enums1.TestEnum.XXX");
        EnumDeclarationAnnotationElementAdapter daea2 = new EnumDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar2");
        AnnotatedElementAnnotationElementAdapter aea2 = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea2);
        aea2.setValue((Object)"enums2.TestEnum.XXX");
        EnumDeclarationAnnotationElementAdapter daea3 = new EnumDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar3");
        AnnotatedElementAnnotationElementAdapter aea3 = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea3);
        aea3.setValue((Object)"enums3.TestEnum.XXX");
        this.assertSourceContains("import static enums1.TestEnum.XXX;", cu);
        this.assertSourceDoesNotContain("import static enums2.TestEnum.XXX;", cu);
        this.assertSourceContains("import enums2.TestEnum;", cu);
        this.assertSourceDoesNotContain("import static enums3", cu);
        this.assertSourceDoesNotContain("import enums3", cu);
        this.assertSourceContains(expected, cu);
    }

    public void testValueStringArray() throws Exception {
        this.createAnnotationAndMembers("Foo", "String[] bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar={\"string0\", \"string1\"})");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", (ExpressionConverter)AnnotationStringArrayExpressionConverter.forStrings());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertTrue((boolean)Arrays.equals(new String[]{"string0", "string1"}, (Object[])aea.getValue()));
    }

    public void testValueStringArrayConcatenation() throws Exception {
        this.createAnnotationAndMembers("Foo", "String[] bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar={\"stri\" + \"ng0\", \"s\" + \"tring1\"})");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", (ExpressionConverter)AnnotationStringArrayExpressionConverter.forStrings());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertTrue((boolean)Arrays.equals(new String[]{"string0", "string1"}, (Object[])aea.getValue()));
    }

    public void testValueStringArrayEmpty() throws Exception {
        this.createAnnotationAndMembers("Foo", "String[] bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar={})");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", (ExpressionConverter)AnnotationStringArrayExpressionConverter.forStrings());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertTrue((boolean)Arrays.equals(new String[0], (Object[])aea.getValue()));
    }

    public void testValueStringArraySingleElement() throws Exception {
        this.createAnnotationAndMembers("Foo", "String[] bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=\"string0\")");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", (ExpressionConverter)AnnotationStringArrayExpressionConverter.forStrings());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertTrue((boolean)Arrays.equals(new String[]{"string0"}, (Object[])aea.getValue()));
    }

    public void testValueNullStringArray() throws Exception {
        this.createAnnotationAndMembers("Foo", "String[] bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo()");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        IndexedConversionDeclarationAnnotationElementAdapter daea = new IndexedConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", (IndexedExpressionConverter)AnnotationStringArrayExpressionConverter.forStrings());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertTrue((boolean)Arrays.equals(new String[0], (Object[])aea.getValue()));
    }

    public void testSetValueStringArray() throws Exception {
        this.createAnnotationAndMembers("Foo", "String[] bar();");
        String expected = "@Foo(bar = { \"string0\", \"string1\" })";
        ICompilationUnit cu = this.createTestType();
        this.assertSourceDoesNotContain(expected, cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        IndexedConversionDeclarationAnnotationElementAdapter daea = new IndexedConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", (IndexedExpressionConverter)AnnotationStringArrayExpressionConverter.forStrings());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)new String[]{"string0", "string1"});
        this.assertSourceContains(expected, cu);
    }

    public void testSetValueStringArrayEmptyRemove() throws Exception {
        this.createAnnotationAndMembers("Foo", "String[] bar();");
        String expected = "@Foo";
        ICompilationUnit cu = this.createTestType();
        this.assertSourceDoesNotContain(expected, cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        IndexedConversionDeclarationAnnotationElementAdapter daea = new IndexedConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", (IndexedExpressionConverter)AnnotationStringArrayExpressionConverter.forStrings());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)new String[0]);
        this.assertSourceDoesNotContain(expected, cu);
    }

    public void testSetValueStringArrayEmpty() throws Exception {
        this.createAnnotationAndMembers("Foo", "String[] bar();");
        String expected = "@Foo(bar = {})";
        ICompilationUnit cu = this.createTestType();
        this.assertSourceDoesNotContain(expected, cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        AnnotationStringArrayExpressionConverter expressionConverter = new AnnotationStringArrayExpressionConverter(StringExpressionConverter.instance(), false);
        IndexedConversionDeclarationAnnotationElementAdapter daea = new IndexedConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", (IndexedExpressionConverter)expressionConverter);
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)new String[0]);
        this.assertSourceContains(expected, cu);
    }

    public void testSetValueStringArraySingleElement() throws Exception {
        this.createAnnotationAndMembers("Foo", "String[] bar();");
        String annotation = "@Foo(bar = \"string0\")";
        ICompilationUnit cu = this.createTestType();
        this.assertSourceDoesNotContain(annotation, cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        IndexedConversionDeclarationAnnotationElementAdapter daea = new IndexedConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", (IndexedExpressionConverter)AnnotationStringArrayExpressionConverter.forStrings());
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)new String[]{"string0"});
        this.assertSourceContains(annotation, cu);
    }

    public void testValueEnumArray() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum[] bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar={enums.TestEnum.XXX, enums.TestEnum.YYY})");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumArrayDeclarationAnnotationElementAdapter daea = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertTrue((boolean)Arrays.equals(new String[]{"enums.TestEnum.XXX", "enums.TestEnum.YYY"}, (Object[])aea.getValue()));
    }

    public void testValueEnumArrayInvalidEntry() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum[] bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar={enums.TestEnum.XXX, 88})");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumArrayDeclarationAnnotationElementAdapter daea = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        Object[] objectArray = new String[2];
        objectArray[0] = "enums.TestEnum.XXX";
        MemberAnnotationElementAdapterTests.assertTrue((boolean)Arrays.equals(objectArray, (Object[])aea.getValue()));
    }

    public void testValueEnumArrayEmpty() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum[] bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar={})");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumArrayDeclarationAnnotationElementAdapter daea = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertTrue((boolean)Arrays.equals(new String[0], (Object[])aea.getValue()));
    }

    public void testValueEnumArraySingleElement() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum[] bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=enums.TestEnum.XXX)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumArrayDeclarationAnnotationElementAdapter daea = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertTrue((boolean)Arrays.equals(new String[]{"enums.TestEnum.XXX"}, (Object[])aea.getValue()));
    }

    public void testValueEnumArraySingleElementInvalid() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum[] bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo(bar=\"\")");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumArrayDeclarationAnnotationElementAdapter daea = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertTrue((boolean)Arrays.equals(new String[1], (Object[])aea.getValue()));
    }

    public void testValueNullEnumArray() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum[] bar();");
        ICompilationUnit cu = this.createTestType("@annot.Foo()");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumArrayDeclarationAnnotationElementAdapter daea = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        MemberAnnotationElementAdapterTests.assertTrue((boolean)Arrays.equals(new String[0], (Object[])aea.getValue()));
    }

    public void testSetValueEnumArray() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum[] bar();");
        String expected = "@Foo(bar = { XXX, YYY })";
        ICompilationUnit cu = this.createTestType();
        this.assertSourceDoesNotContain(expected, cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumArrayDeclarationAnnotationElementAdapter daea = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)new String[]{"enums.TestEnum.XXX", "enums.TestEnum.YYY"});
        this.assertSourceContains("import static enums.TestEnum.XXX;", cu);
        this.assertSourceContains("import static enums.TestEnum.YYY;", cu);
        this.assertSourceContains(expected, cu);
    }

    public void testSetValueEnumArrayEmptyRemove() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum[] bar();");
        String expected = "@Foo";
        ICompilationUnit cu = this.createTestType();
        this.assertSourceDoesNotContain(expected, cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumArrayDeclarationAnnotationElementAdapter daea = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)new String[0]);
        this.assertSourceDoesNotContain(expected, cu);
    }

    public void testSetValueEnumArrayEmpty() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum[] bar();");
        String expected = "@Foo(bar = {})";
        ICompilationUnit cu = this.createTestType();
        this.assertSourceDoesNotContain(expected, cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumArrayDeclarationAnnotationElementAdapter daea = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar", false);
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)new String[0]);
        this.assertSourceContains(expected, cu);
    }

    public void testSetValueEnumArraySingleElement() throws Exception {
        this.createEnum("TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum[] bar();");
        String expected = "@Foo(bar = XXX)";
        ICompilationUnit cu = this.createTestType();
        this.assertSourceDoesNotContain(expected, cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumArrayDeclarationAnnotationElementAdapter daea = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar");
        AnnotatedElementAnnotationElementAdapter aea = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea);
        aea.setValue((Object)new String[]{"enums.TestEnum.XXX"});
        this.assertSourceContains("import static enums.TestEnum.XXX;", cu);
        this.assertSourceContains(expected, cu);
    }

    public void testSetValueEnumArrayImportCollision1() throws Exception {
        this.createEnum("enums1", "TestEnum", "XXX, YYY, ZZZ");
        this.createEnum("enums2", "TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums1.TestEnum[] bar1();  enums2.TestEnum[] bar2();");
        String expected = "@Foo(bar1 = { XXX, YYY }, bar2 = { TestEnum.XXX, TestEnum.YYY })";
        ICompilationUnit cu = this.createTestType();
        this.assertSourceDoesNotContain(expected, cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumArrayDeclarationAnnotationElementAdapter daea1 = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar1");
        AnnotatedElementAnnotationElementAdapter aea1 = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea1);
        aea1.setValue((Object)new String[]{"enums1.TestEnum.XXX", "enums1.TestEnum.YYY"});
        EnumArrayDeclarationAnnotationElementAdapter daea2 = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar2");
        AnnotatedElementAnnotationElementAdapter aea2 = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea2);
        aea2.setValue((Object)new String[]{"enums2.TestEnum.XXX", "enums2.TestEnum.YYY"});
        this.assertSourceContains("import static enums1.TestEnum.XXX;", cu);
        this.assertSourceContains("import static enums1.TestEnum.YYY;", cu);
        this.assertSourceDoesNotContain("import static enums2.TestEnum.XXX;", cu);
        this.assertSourceDoesNotContain("import static enums2.TestEnum.YYY;", cu);
        this.assertSourceContains("import enums2.TestEnum;", cu);
        this.assertSourceContains(expected, cu);
    }

    public void testSetValueEnumArrayImportCollision2() throws Exception {
        this.createEnum("enums1", "TestEnum", "XXX, YYY, ZZZ");
        this.createEnum("enums2", "TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums1.TestEnum[] bar1();  enums2.TestEnum[] bar2();");
        String expected = "@annot.Foo(bar1={XXX,YYY}, bar2 = { TestEnum.XXX, TestEnum.YYY })";
        ICompilationUnit cu = this.createTestType("static enums1.TestEnum.*", "@annot.Foo(bar1={XXX,YYY})");
        this.assertSourceDoesNotContain(expected, cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumArrayDeclarationAnnotationElementAdapter daea1 = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar1");
        AnnotatedElementAnnotationElementAdapter aea1 = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea1);
        MemberAnnotationElementAdapterTests.assertNotNull((Object)aea1.getValue());
        EnumArrayDeclarationAnnotationElementAdapter daea2 = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar2");
        AnnotatedElementAnnotationElementAdapter aea2 = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea2);
        aea2.setValue((Object)new String[]{"enums2.TestEnum.XXX", "enums2.TestEnum.YYY"});
        this.assertSourceContains("import static enums1.TestEnum.*;", cu);
        this.assertSourceDoesNotContain("import static enums2.TestEnum.XXX;", cu);
        this.assertSourceDoesNotContain("import static enums2.TestEnum.YYY;", cu);
        this.assertSourceContains("import enums2.TestEnum;", cu);
        this.assertSourceContains(expected, cu);
    }

    public void testSetValueEnumArrayImportCollision3() throws Exception {
        this.createEnum("TestEnum1", "XXX, YYY, ZZZ");
        this.createEnum("TestEnum2", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum1[] bar1();  enums.TestEnum2[] bar2();");
        String expected = "@Foo(bar1 = { XXX, YYY }, bar2 = { TestEnum2.XXX, TestEnum2.YYY })";
        ICompilationUnit cu = this.createTestType();
        this.assertSourceDoesNotContain(expected, cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumArrayDeclarationAnnotationElementAdapter daea1 = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar1");
        AnnotatedElementAnnotationElementAdapter aea1 = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea1);
        aea1.setValue((Object)new String[]{"enums.TestEnum1.XXX", "enums.TestEnum1.YYY"});
        EnumArrayDeclarationAnnotationElementAdapter daea2 = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar2");
        AnnotatedElementAnnotationElementAdapter aea2 = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea2);
        aea2.setValue((Object)new String[]{"enums.TestEnum2.XXX", "enums.TestEnum2.YYY"});
        this.assertSourceContains("import static enums.TestEnum1.XXX;", cu);
        this.assertSourceContains("import static enums.TestEnum1.YYY;", cu);
        this.assertSourceDoesNotContain("import static enums.TestEnum2.XXX;", cu);
        this.assertSourceDoesNotContain("import static enums.TestEnum2.YYY;", cu);
        this.assertSourceContains("import enums.TestEnum2;", cu);
        this.assertSourceContains(expected, cu);
    }

    public void testSetValueEnumArrayImportCollision4() throws Exception {
        this.createEnum("TestEnum1", "XXX, YYY, ZZZ");
        this.createEnum("TestEnum2", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums.TestEnum1[] bar1();  enums.TestEnum2[] bar2();");
        String expected = "@annot.Foo(bar1={XXX,YYY}, bar2 = { TestEnum2.XXX, TestEnum2.YYY })";
        ICompilationUnit cu = this.createTestType("static enums.TestEnum1.*", "@annot.Foo(bar1={XXX,YYY})");
        this.assertSourceDoesNotContain(expected, cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumArrayDeclarationAnnotationElementAdapter daea1 = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar1");
        AnnotatedElementAnnotationElementAdapter aea1 = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea1);
        MemberAnnotationElementAdapterTests.assertNotNull((Object)aea1.getValue());
        EnumArrayDeclarationAnnotationElementAdapter daea2 = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar2");
        AnnotatedElementAnnotationElementAdapter aea2 = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea2);
        aea2.setValue((Object)new String[]{"enums.TestEnum2.XXX", "enums.TestEnum2.YYY"});
        this.assertSourceContains("import static enums.TestEnum1.*;", cu);
        this.assertSourceDoesNotContain("import static enums.TestEnum2.XXX;", cu);
        this.assertSourceDoesNotContain("import static enums.TestEnum2.YYY;", cu);
        this.assertSourceContains("import enums.TestEnum2;", cu);
        this.assertSourceContains(expected, cu);
    }

    public void testSetValueEnumArrayImportCollision6() throws Exception {
        this.createEnum("enums1", "TestEnum", "XXX, YYY, ZZZ");
        this.createEnum("enums2", "TestEnum", "XXX, YYY, ZZZ");
        this.createEnum("enums3", "TestEnum", "XXX, YYY, ZZZ");
        this.createAnnotationAndMembers("Foo", "enums1.TestEnum[] bar1();  enums2.TestEnum[] bar2();  enums3.TestEnum[] bar3();");
        String expected = "@Foo(bar1 = { XXX, YYY }, bar2 = { TestEnum.XXX, TestEnum.YYY }, bar3 = { enums3.TestEnum.XXX, enums3.TestEnum.YYY })";
        ICompilationUnit cu = this.createTestType();
        this.assertSourceDoesNotContain(expected, cu);
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.Foo");
        EnumArrayDeclarationAnnotationElementAdapter daea1 = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar1");
        AnnotatedElementAnnotationElementAdapter aea1 = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea1);
        aea1.setValue((Object)new String[]{"enums1.TestEnum.XXX", "enums1.TestEnum.YYY"});
        EnumArrayDeclarationAnnotationElementAdapter daea2 = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar2");
        AnnotatedElementAnnotationElementAdapter aea2 = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea2);
        aea2.setValue((Object)new String[]{"enums2.TestEnum.XXX", "enums2.TestEnum.YYY"});
        EnumArrayDeclarationAnnotationElementAdapter daea3 = new EnumArrayDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "bar3");
        AnnotatedElementAnnotationElementAdapter aea3 = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)this.idField(cu), (DeclarationAnnotationElementAdapter)daea3);
        aea3.setValue((Object)new String[]{"enums3.TestEnum.XXX", "enums3.TestEnum.YYY"});
        this.assertSourceContains("import static enums1.TestEnum.XXX;", cu);
        this.assertSourceContains("import static enums1.TestEnum.YYY;", cu);
        this.assertSourceDoesNotContain("import static enums2", cu);
        this.assertSourceContains("import enums2.TestEnum;", cu);
        this.assertSourceDoesNotContain("import static enums3", cu);
        this.assertSourceDoesNotContain("import enums3", cu);
        this.assertSourceContains(expected, cu);
    }
}

