/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.wst.jsdt.core.BindingKey;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaModelTests;

public class BindingKeyTests
extends AbstractJavaModelTests {
    static /* synthetic */ Class class$0;

    public BindingKeyTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.BindingKeyTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return BindingKeyTests.buildModelTestSuite(clazz);
    }

    protected void assertBindingKeyEquals(String expected, String key) {
        if (!expected.equals(key)) {
            System.out.println(String.valueOf(this.displayString(key, 3)) + ",");
        }
        BindingKeyTests.assertEquals((String)expected, (String)key);
    }

    protected void assertBindingKeySignatureEquals(String expected, String key) {
        BindingKey bindingKey = new BindingKey(key);
        String signature = bindingKey.toSignature();
        if (!expected.equals(signature)) {
            System.out.println(String.valueOf(this.displayString(signature, 3)) + ",");
        }
        BindingKeyTests.assertEquals((String)expected, (String)signature);
    }

    public void test001() {
        this.assertBindingKeySignatureEquals("p", "p");
    }

    public void test002() {
        this.assertBindingKeySignatureEquals("Lp.X;", "Lp/X;");
    }

    public void test003() {
        this.assertBindingKeySignatureEquals("LClazz;", "LClazz;");
    }

    public void test004() {
        this.assertBindingKeySignatureEquals("Lp.X$Member;", "Lp/X$Member;");
    }

    public void test005() {
        this.assertBindingKeySignatureEquals("Lp1.X$Member1$Member2;", "Lp1/X$Member1$Member2;");
    }

    public void test006() {
        this.assertBindingKeySignatureEquals("Lp1.X$1;", "Lp1/X$1;");
    }

    public void test007() {
        this.assertBindingKeySignatureEquals("Lp1.X$1$Y;", "Lp1/X$1$Y;");
    }

    public void test008() {
        this.assertBindingKeySignatureEquals("[Lp1.X;", "[Lp1/X;");
    }

    public void test012() {
        this.assertBindingKeySignatureEquals("Lp1.Secondary;", "Lp1/X~Secondary;");
    }

    public void test013() {
        this.assertBindingKeySignatureEquals("Lp1.Secondary$1;", "Lp1/X~Secondary$1;");
    }

    public void test014() {
        this.assertBindingKeySignatureEquals("(Ljava.lang.String;I)Z", "Lp1/X;.foo(Ljava/lang/String;I)Z");
    }

    public void test015() {
        String key = BindingKey.createTypeBindingKey((String)"java.lang.Object");
        this.assertBindingKeyEquals("Ljava/lang/Object;", key);
    }

    public void test017() {
        String key = BindingKey.createTypeBindingKey((String)"Boolean[]");
        this.assertBindingKeyEquals("[LBoolean;", key);
    }

    public void test020() {
        String key = BindingKey.createArrayTypeBindingKey((String)"Ljava/lang/Object;", (int)1);
        this.assertBindingKeyEquals("[Ljava/lang/Object;", key);
    }

    public void test021() {
        String key = BindingKey.createArrayTypeBindingKey((String)"I", (int)2);
        this.assertBindingKeyEquals("[[I", key);
    }

    public void test034() {
        this.assertBindingKeySignatureEquals("(Ljava.lang.String;I)Z", "Lp1/X;.Set(Ljava/lang/String;I)Z");
    }

    public void test037() {
        this.assertBindingKeySignatureEquals("Ljava.lang.String;", "Lp/X;.foo)Ljava/lang/String;");
    }

    public void test039() {
        this.assertBindingKeySignatureEquals("Z", "Z");
    }
}

