/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterable;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.ListListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.ReadOnlyCompositeListIterable;
import org.eclipse.jpt.common.utility.iterable.ListIterable;

public class ReadOnlyCompositeListIterableTests
extends TestCase {
    public ReadOnlyCompositeListIterableTests(String name) {
        super(name);
    }

    public void testIterator() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("0");
        c1.add("1");
        c1.add("2");
        c1.add("3");
        ListListIterable li1 = new ListListIterable(c1);
        ArrayList<String> c2 = new ArrayList<String>();
        c2.add("4");
        c2.add("5");
        c2.add("6");
        c2.add("7");
        ListListIterable li2 = new ListListIterable(c2);
        ReadOnlyCompositeListIterable composite = IterableTools.concatenateReadOnly((ListIterable[])new ListIterable[]{li1, li2});
        int i = 0;
        for (String s : composite) {
            ReadOnlyCompositeListIterableTests.assertEquals((String)String.valueOf(i++), (String)s);
        }
    }

    public void testExtraElement1() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("0");
        c1.add("1");
        c1.add("2");
        c1.add("3");
        ListListIterable li1 = new ListListIterable(c1);
        ReadOnlyCompositeListIterable composite = IterableTools.addReadOnly((ListIterable)li1, (Object)"4");
        int i = 0;
        for (String s : composite) {
            ReadOnlyCompositeListIterableTests.assertEquals((String)String.valueOf(i++), (String)s);
        }
    }

    public void testExtraElement2() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("1");
        c1.add("2");
        c1.add("3");
        ListListIterable li1 = new ListListIterable(c1);
        ReadOnlyCompositeListIterable composite = IterableTools.insertReadOnly((Object)"0", (ListIterable)li1);
        int i = 0;
        for (String s : composite) {
            ReadOnlyCompositeListIterableTests.assertEquals((String)String.valueOf(i++), (String)s);
        }
    }

    public void testCollectionOfIterables() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("0");
        c1.add("1");
        c1.add("2");
        c1.add("3");
        ListListIterable li1 = new ListListIterable(c1);
        ArrayList<String> c2 = new ArrayList<String>();
        c2.add("4");
        c2.add("5");
        c2.add("6");
        c2.add("7");
        ListListIterable li2 = new ListListIterable(c2);
        ArrayList<ListListIterable> collection = new ArrayList<ListListIterable>();
        collection.add(li1);
        collection.add(li2);
        ListListIterable li = new ListListIterable(collection);
        ReadOnlyCompositeListIterable composite = new ReadOnlyCompositeListIterable((ListIterable)li);
        int i = 0;
        for (String s : composite) {
            ReadOnlyCompositeListIterableTests.assertEquals((String)String.valueOf(i++), (String)s);
        }
    }

    public void testToString() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("0");
        c1.add("1");
        c1.add("2");
        c1.add("3");
        ListListIterable li1 = new ListListIterable(c1);
        ArrayList<String> c2 = new ArrayList<String>();
        c2.add("4");
        c2.add("5");
        c2.add("6");
        c2.add("7");
        ListListIterable li2 = new ListListIterable(c2);
        ReadOnlyCompositeListIterable composite = IterableTools.concatenateReadOnly((ListIterable[])new ListIterable[]{li1, li2});
        ReadOnlyCompositeListIterableTests.assertNotNull((Object)composite.toString());
    }
}

