/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterable;

import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleElementIterableTests
extends TestCase {
    public SingleElementIterableTests(String name) {
        super(name);
    }

    public void testIterator() {
        for (String s : this.buildSingleElementIterable()) {
            SingleElementIterableTests.assertEquals((String)this.singleElement(), (String)s);
        }
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        Iterator<String> stream = this.buildSingleElementIterable().iterator();
        String string = stream.next();
        try {
            string = stream.next();
            SingleElementIterableTests.fail((String)("bogus element: " + string));
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        SingleElementIterableTests.assertTrue((boolean)exCaught);
    }

    public void testRemove() {
        boolean exCaught = false;
        Iterator<String> stream = this.buildSingleElementIterable().iterator();
        while (stream.hasNext()) {
            if (!stream.next().equals(this.singleElement())) continue;
            try {
                stream.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        SingleElementIterableTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    protected Iterable<String> buildSingleElementIterable() {
        return new SingleElementIterable((Object)this.singleElement());
    }

    protected String singleElement() {
        return "single element";
    }
}

