/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterable;

import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementListIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleElementListIterableTests
extends TestCase {
    public SingleElementListIterableTests(String name) {
        super(name);
    }

    public void testIterator() {
        for (String s : this.buildSingleElementListIterable()) {
            SingleElementListIterableTests.assertEquals((String)this.singleElement(), (String)s);
        }
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        Iterator<String> stream = this.buildSingleElementListIterable().iterator();
        String string = stream.next();
        try {
            string = stream.next();
            SingleElementListIterableTests.fail((String)("bogus element: " + string));
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        SingleElementListIterableTests.assertTrue((boolean)exCaught);
    }

    public void testRemove() {
        boolean exCaught = false;
        Iterator<String> stream = this.buildSingleElementListIterable().iterator();
        while (stream.hasNext()) {
            if (!stream.next().equals(this.singleElement())) continue;
            try {
                stream.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        SingleElementListIterableTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    public void testToString() {
        SingleElementListIterableTests.assertNotNull((Object)this.buildSingleElementListIterable().toString());
    }

    protected Iterable<String> buildSingleElementListIterable() {
        return new SingleElementListIterable((Object)this.singleElement());
    }

    protected String singleElement() {
        return "single element";
    }
}

