/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringBufferInputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.compiler.libraries.SystemLibraryLocation;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.Requestor;
import org.eclipse.wst.jsdt.internal.compiler.Compiler;
import org.eclipse.wst.jsdt.internal.compiler.ICompilerRequestor;
import org.eclipse.wst.jsdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.wst.jsdt.internal.compiler.IProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.batch.FileSystem;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.INameEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblemFactory;

public class Util {
    private static String TARGET_PLUGIN;
    private static int DELETE_MAX_TIME;
    public static boolean DELETE_DEBUG;
    public static int DELETE_MAX_WAIT;
    private static final boolean DEBUG = false;
    private static final String OUTPUT_DIRECTORY;
    private static final String DELAY_BEFORE_CLEAN_PREVIOUS;
    static /* synthetic */ Class class$0;

    static {
        File dir;
        String container;
        TARGET_PLUGIN = "org.eclipse.wst.jsdt.core";
        DELETE_MAX_TIME = 0;
        DELETE_DEBUG = false;
        DELETE_MAX_WAIT = 10000;
        DELAY_BEFORE_CLEAN_PREVIOUS = System.getProperty("delay");
        long millisecondsPerHour = 3600000L;
        long delay = millisecondsPerHour * 2L;
        try {
            if (DELAY_BEFORE_CLEAN_PREVIOUS != null) {
                float hours = Float.parseFloat(DELAY_BEFORE_CLEAN_PREVIOUS);
                delay = (int)((float)millisecondsPerHour * hours);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        if ((container = System.getProperty("jdt.test.output_directory")) == null) {
            container = System.getProperty("user.dir");
        }
        if (container == null) {
            container = ".";
        }
        if (Character.isLowerCase(container.charAt(0)) && container.charAt(1) == ':') {
            container = String.valueOf(Character.toUpperCase(container.charAt(0))) + container.substring(1);
        }
        if ((dir = new File(new File(container), "comptest")).exists()) {
            long now = System.currentTimeMillis();
            if (now - dir.lastModified() > delay) {
                Util.flushDirectoryContent(dir);
            } else {
                File[] testDirs = dir.listFiles();
                int i = 0;
                int l = testDirs.length;
                while (i < l) {
                    if (testDirs[i].isDirectory() && now - testDirs[i].lastModified() > delay) {
                        Util.delete(testDirs[i]);
                    }
                    ++i;
                }
            }
        }
        File dateDir = new File(dir, "run." + System.currentTimeMillis());
        OUTPUT_DIRECTORY = dateDir.getPath();
    }

    public static void appendProblem(StringBuffer problems, IProblem problem, char[] source, int problemCount) {
        problems.append(String.valueOf(problemCount) + (problem.isError() ? ". ERROR" : ". WARNING"));
        problems.append(" in " + new String(problem.getOriginatingFileName()));
        if (source != null) {
            problems.append(((DefaultProblem)problem).errorReportSource(source));
        }
        problems.append("\n");
        problems.append(problem.getMessage());
        problems.append("\n");
    }

    public static CompilationUnit[] compilationUnits(String[] testFiles) {
        int length = testFiles.length / 2;
        CompilationUnit[] result = new CompilationUnit[length];
        int index = 0;
        int i = 0;
        while (i < length) {
            String fileName = testFiles[index];
            result[i] = new CompilationUnit(testFiles[index + 1].toCharArray(), fileName, null);
            char[] fileNameChars = fileName.toCharArray();
            int lastIndexOf = CharOperation.lastIndexOf((char)'/', (char[])fileNameChars);
            if (lastIndexOf >= 0) {
                char[] subarray = CharOperation.subarray((char[])fileNameChars, (int)0, (int)lastIndexOf);
                result[i].packageName = CharOperation.splitOn((char)'/', (char[])subarray);
            }
            index += 2;
            ++i;
        }
        return result;
    }

    public static void compile(String[] pathsAndContents, Map options, String outputPath) {
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
        Requestor requestor = new Requestor((IProblemFactory)problemFactory, outputPath.endsWith(File.separator) ? outputPath : String.valueOf(outputPath) + File.separator, false, null, false, false);
        FileSystem nameEnvironment = new FileSystem(Util.getJavaClassLibs(), new String[0], null);
        IErrorHandlingPolicy errorHandlingPolicy = new IErrorHandlingPolicy(){

            public boolean proceedOnErrors() {
                return true;
            }

            public boolean stopOnFirstError() {
                return false;
            }
        };
        CompilerOptions compilerOptions = new CompilerOptions(options);
        compilerOptions.performMethodsFullRecovery = false;
        compilerOptions.performStatementsRecovery = false;
        Compiler batchCompiler = new Compiler((INameEnvironment)nameEnvironment, errorHandlingPolicy, compilerOptions, (ICompilerRequestor)requestor, (IProblemFactory)problemFactory);
        batchCompiler.options.produceReferenceInfo = true;
        batchCompiler.compile((ICompilationUnit[])Util.compilationUnits(pathsAndContents));
        System.err.print(requestor.problemLog);
    }

    public static String[] concatWithClassLibs(String[] classpaths, boolean inFront) {
        String[] classLibs = Util.getJavaClassLibs();
        if (classpaths == null) {
            return classLibs;
        }
        int classLibsLength = classLibs.length;
        int classpathsLength = classpaths.length;
        String[] defaultClassPaths = new String[classLibsLength + classpathsLength];
        if (inFront) {
            System.arraycopy(classLibs, 0, defaultClassPaths, classpathsLength, classLibsLength);
            System.arraycopy(classpaths, 0, defaultClassPaths, 0, classpathsLength);
        } else {
            System.arraycopy(classLibs, 0, defaultClassPaths, 0, classLibsLength);
            System.arraycopy(classpaths, 0, defaultClassPaths, classLibsLength, classpathsLength);
        }
        int i = 0;
        while (i < classpathsLength) {
            File file = new File(classpaths[i]);
            if (!file.exists()) {
                file.mkdirs();
            }
            ++i;
        }
        return defaultClassPaths;
    }

    public static String[] concatWithClassLibs(String classpath, boolean inFront) {
        String[] classLibs = Util.getJavaClassLibs();
        int length = classLibs.length;
        File dir = new File(classpath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String[] defaultClassPaths = new String[length + 1];
        if (inFront) {
            System.arraycopy(classLibs, 0, defaultClassPaths, 1, length);
            defaultClassPaths[0] = classpath;
        } else {
            System.arraycopy(classLibs, 0, defaultClassPaths, 0, length);
            defaultClassPaths[length] = classpath;
        }
        return defaultClassPaths;
    }

    public static String convertToIndependantLineDelimiter(String source) {
        if (source.indexOf(10) == -1 && source.indexOf(13) == -1) {
            return source;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int length = source.length();
        while (i < length) {
            char car = source.charAt(i);
            if (car == '\r') {
                buffer.append('\n');
                if (i < length - 1 && source.charAt(i + 1) == '\n') {
                    ++i;
                }
            } else {
                buffer.append(car);
            }
            ++i;
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copy(String sourcePath, String destPath) {
        FileOutputStream out;
        block22: {
            sourcePath = Util.toNativePath(sourcePath);
            destPath = Util.toNativePath(destPath);
            File source = new File(sourcePath);
            if (!source.exists()) {
                return;
            }
            File dest = new File(destPath);
            if (!dest.exists()) {
                return;
            }
            if (source.isDirectory()) {
                String[] files = source.list();
                if (files == null) return;
                int i = 0;
                while (true) {
                    if (i >= files.length) {
                        return;
                    }
                    String file = files[i];
                    File sourceFile = new File(source, file);
                    if (sourceFile.isDirectory()) {
                        File destSubDir = new File(dest, file);
                        destSubDir.mkdir();
                        Util.copy(sourceFile.getPath(), destSubDir.getPath());
                    } else {
                        Util.copy(sourceFile.getPath(), dest.getPath());
                    }
                    ++i;
                }
            }
            FileInputStream in = null;
            out = null;
            try {
                try {
                    in = new FileInputStream(source);
                    File destFile = new File(dest, source.getName());
                    if (destFile.exists() && !Util.delete(destFile)) {
                        throw new IOException(destFile + " is in use");
                    }
                    out = new FileOutputStream(destFile);
                    int bufferLength = 1024;
                    byte[] buffer = new byte[bufferLength];
                    int read = 0;
                    while (read != -1) {
                        read = in.read(buffer, 0, bufferLength);
                        if (read == -1) continue;
                        out.write(buffer, 0, read);
                    }
                }
                catch (IOException e) {
                    throw new Error(e.toString());
                }
            }
            catch (Throwable throwable) {
                Object var10_17 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out == null) throw throwable;
                try {
                    out.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var10_18 = null;
                if (in == null) break block22;
            }
            try {}
            catch (IOException iOException) {}
            in.close();
        }
        if (out == null) return;
        try {}
        catch (IOException iOException) {
            return;
        }
        out.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void createFile(String path, String contents) throws IOException {
        FileOutputStream output = new FileOutputStream(path);
        try {
            output.write(contents.getBytes());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            output.close();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        output.close();
    }

    public static void createJar(String[] pathsAndContents, Map options, String jarPath) throws IOException {
        String classesPath = String.valueOf(Util.getOutputDirectory()) + File.separator + "classes";
        File classesDir = new File(classesPath);
        Util.flushDirectoryContent(classesDir);
        Util.compile(pathsAndContents, options, classesPath);
        Util.zip(classesDir, jarPath);
    }

    public static void createJar(String[] pathsAndContents, String jarPath, String compliance) throws IOException {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("org.eclipse.wst.jsdt.core.compiler.compliance", compliance);
        options.put("org.eclipse.wst.jsdt.core.compiler.source", compliance);
        options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", compliance);
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedLocal", "ignore");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedPrivateMember", "ignore");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.fieldHiding", "ignore");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.localVariableHiding", "ignore");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.typeParameterHiding", "ignore");
        options.put("org.eclipse.wst.jsdt.core.compiler.debug.localVariable", "generate");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.rawTypeReference", "ignore");
        Util.createJar(pathsAndContents, options, jarPath);
    }

    public static void createSourceZip(String[] pathsAndContents, String zipPath) throws IOException {
        String sourcesPath = String.valueOf(Util.getOutputDirectory()) + File.separator + "sources";
        File sourcesDir = new File(sourcesPath);
        Util.flushDirectoryContent(sourcesDir);
        int i = 0;
        int length = pathsAndContents.length;
        while (i < length) {
            String sourcePath = String.valueOf(sourcesPath) + File.separator + pathsAndContents[i];
            File sourceFile = new File(sourcePath);
            sourceFile.getParentFile().mkdirs();
            Util.createFile(sourcePath, pathsAndContents[i + 1]);
            i += 2;
        }
        Util.zip(sourcesDir, zipPath);
    }

    public static boolean delete(File file) {
        if (file.isDirectory()) {
            Util.flushDirectoryContent(file);
        }
        file.delete();
        if (Util.isFileDeleted(file)) {
            return true;
        }
        return Util.waitUntilFileDeleted(file);
    }

    public static boolean delete(IResource resource) {
        try {
            resource.delete(true, null);
            if (Util.isResourceDeleted(resource)) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return Util.waitUntilResourceDeleted(resource);
    }

    public static boolean delete(String path) {
        return Util.delete(new File(path));
    }

    public static String displayString(String inputString) {
        return Util.displayString(inputString, 0);
    }

    public static String displayString(String inputString, int indent) {
        return Util.displayString(inputString, indent, false);
    }

    public static String displayString(String inputString, int indent, boolean shift) {
        if (inputString == null) {
            return "null";
        }
        int length = inputString.length();
        StringBuffer buffer = new StringBuffer(length);
        StringTokenizer tokenizer = new StringTokenizer(inputString, "\n\r", true);
        int i = 0;
        while (i < indent) {
            buffer.append("\t");
            ++i;
        }
        if (shift) {
            ++indent;
        }
        buffer.append("\"");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("\r")) {
                buffer.append("\\r");
                if (!tokenizer.hasMoreTokens()) continue;
                token = tokenizer.nextToken();
                if (token.equals("\n")) {
                    buffer.append("\\n");
                    if (!tokenizer.hasMoreTokens()) continue;
                    buffer.append("\" + \n");
                    int i2 = 0;
                    while (i2 < indent) {
                        buffer.append("\t");
                        ++i2;
                    }
                    buffer.append("\"");
                    continue;
                }
                buffer.append("\" + \n");
                int i3 = 0;
                while (i3 < indent) {
                    buffer.append("\t");
                    ++i3;
                }
                buffer.append("\"");
            } else if (token.equals("\n")) {
                buffer.append("\\n");
                if (!tokenizer.hasMoreTokens()) continue;
                buffer.append("\" + \n");
                int i4 = 0;
                while (i4 < indent) {
                    buffer.append("\t");
                    ++i4;
                }
                buffer.append("\"");
                continue;
            }
            StringBuffer tokenBuffer = new StringBuffer();
            int i5 = 0;
            while (i5 < token.length()) {
                char c = token.charAt(i5);
                switch (c) {
                    case '\r': {
                        tokenBuffer.append("\\r");
                        break;
                    }
                    case '\n': {
                        tokenBuffer.append("\\n");
                        break;
                    }
                    case '\b': {
                        tokenBuffer.append("\\b");
                        break;
                    }
                    case '\t': {
                        tokenBuffer.append("\t");
                        break;
                    }
                    case '\f': {
                        tokenBuffer.append("\\f");
                        break;
                    }
                    case '\"': {
                        tokenBuffer.append("\\\"");
                        break;
                    }
                    case '\'': {
                        tokenBuffer.append("\\'");
                        break;
                    }
                    case '\\': {
                        tokenBuffer.append("\\\\");
                        break;
                    }
                    default: {
                        tokenBuffer.append(c);
                    }
                }
                ++i5;
            }
            buffer.append(tokenBuffer.toString());
        }
        buffer.append("\"");
        return buffer.toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fileContent(String sourceFilePath) {
        File sourceFile = new File(sourceFilePath);
        if (!sourceFile.exists()) {
            return null;
        }
        if (!sourceFile.isFile()) {
            return null;
        }
        StringBuffer sourceContentBuffer = new StringBuffer();
        FileInputStream input = null;
        try {
            input = new FileInputStream(sourceFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        try {
            try {
                int read;
                do {
                    if ((read = input.read()) == -1) continue;
                    sourceContentBuffer.append((char)read);
                } while (read != -1);
                input.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                Object var5_6 = null;
                try {
                    input.close();
                    return null;
                }
                catch (IOException iOException) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {}
            catch (IOException iOException) {}
            input.close();
            throw throwable;
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        try {}
        catch (IOException iOException) {
            return sourceContentBuffer.toString();
        }
        input.close();
        return sourceContentBuffer.toString();
    }

    public static String fileContentToDisplayString(String sourceFilePath, int indent, boolean independantLineDelimiter) {
        String sourceString = Util.fileContent(sourceFilePath);
        if (independantLineDelimiter) {
            sourceString = Util.convertToIndependantLineDelimiter(sourceString);
        }
        return Util.displayString(sourceString, indent);
    }

    public static void fileContentToDisplayString(String sourceFilePath, int indent, String destinationFilePath, boolean independantLineDelimiter) {
        String displayString = Util.fileContentToDisplayString(sourceFilePath, indent, independantLineDelimiter);
        if (destinationFilePath == null) {
            System.out.println(displayString);
            return;
        }
        Util.writeToFile(displayString, destinationFilePath);
    }

    public static void flushDirectoryContent(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        int max = files.length;
        while (i < max) {
            Util.delete(files[i]);
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    public static int getFreePort() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 46->49)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String[] getJavaClassLibs() {
        IPath targetRoot = new Path(System.getProperty("user.dir")).removeLastSegments(1);
        IPath pluginDir = targetRoot.append((IPath)new Path(TARGET_PLUGIN));
        IPath libDir = pluginDir.append((IPath)new Path(new String(SystemLibraryLocation.LIBRARY_PLUGIN_DIRECTORY)));
        IPath fullDir = libDir.append((IPath)new Path(new String(SystemLibraryLocation.SYSTEM_LIBARAY_NAME)));
        File libFile = new File(fullDir.toOSString());
        if (!libFile.exists()) {
            targetRoot = new Path(OUTPUT_DIRECTORY);
            libDir = targetRoot.append((IPath)new Path(new String(SystemLibraryLocation.LIBRARY_PLUGIN_DIRECTORY)));
            libFile = new File(libDir.toOSString());
            libFile.mkdirs();
            fullDir = libDir.append((IPath)new Path(new String(SystemLibraryLocation.SYSTEM_LIBARAY_NAME)));
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.compiler.libraries.SystemLibraryLocation");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            String inputName = String.valueOf(new String(SystemLibraryLocation.LIBRARY_PLUGIN_DIRECTORY)) + "/" + new String(SystemLibraryLocation.SYSTEM_LIBARAY_NAME);
            clazz2.getClassLoader().getResource(inputName);
            InputStream inputStream = clazz2.getClassLoader().getResourceAsStream(inputName);
            try {
                Util.copyFile(inputStream, new File(fullDir.toOSString()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new String[]{fullDir.toOSString()};
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyFile(InputStream src, File dst) throws IOException {
        OutputStream out;
        block12: {
            BufferedInputStream in = null;
            out = null;
            try {
                int len;
                in = new BufferedInputStream(src);
                out = new BufferedOutputStream(new FileOutputStream(dst));
                byte[] buffer = new byte[4096];
                while ((len = ((InputStream)in).read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException iOException) {}
                }
                if (out == null) throw throwable;
                try {
                    out.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var6_8 = null;
                if (in == null) break block12;
            }
            try {}
            catch (IOException iOException) {}
            ((InputStream)in).close();
        }
        if (out == null) return;
        try {}
        catch (IOException iOException) {
            return;
        }
        out.close();
    }

    public static String copyToOutput(String fileName, String contents) {
        Path targetRoot = new Path(OUTPUT_DIRECTORY);
        Path filePath = new Path(fileName);
        IPath libDir = targetRoot.append(filePath.removeLastSegments(1));
        String fullFileName = libDir.toOSString();
        File libFile = new File(fullFileName);
        libFile.mkdirs();
        IPath fullDir = libDir.append(filePath.lastSegment());
        StringBufferInputStream inputStream = new StringBufferInputStream(contents);
        try {
            Util.copyFile(inputStream, new File(fullDir.toOSString()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fullDir.toOSString();
    }

    public static String getJavaClassLibsAsString() {
        String[] classLibs = Util.getJavaClassLibs();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int max = classLibs.length;
        while (i < max) {
            buffer.append(classLibs[i]).append(File.pathSeparatorChar);
            ++i;
        }
        return buffer.toString();
    }

    public static String getJREDirectory() {
        return System.getProperty("java.home");
    }

    public static String getOutputDirectory() {
        return OUTPUT_DIRECTORY;
    }

    private static File getParentChildFile(File file) {
        int length;
        File parent = file.getParentFile();
        if (parent == null || !parent.exists()) {
            return null;
        }
        File[] files = parent.listFiles();
        int n = length = files == null ? 0 : files.length;
        if (length > 0) {
            int i = 0;
            while (i < length) {
                if (files[i] == file) {
                    return files[i];
                }
                if (files[i].equals(file)) {
                    return files[i];
                }
                if (files[i].getPath().equals(file.getPath())) {
                    return files[i];
                }
                ++i;
            }
        }
        return null;
    }

    private static IResource getParentChildResource(IResource resource) {
        IContainer parent = resource.getParent();
        if (parent == null || !parent.exists()) {
            return null;
        }
        try {
            int length;
            IResource[] members = parent.members();
            int n = length = members == null ? 0 : members.length;
            if (length > 0) {
                int i = 0;
                while (i < length) {
                    if (members[i] == resource) {
                        return members[i];
                    }
                    if (members[i].equals((Object)resource)) {
                        return members[i];
                    }
                    if (members[i].getFullPath().equals((Object)resource.getFullPath())) {
                        return members[i];
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    private static String getTestName() {
        StackTraceElement[] elements = new Exception().getStackTrace();
        int idx = 0;
        int length = elements.length;
        while (idx < length && !elements[idx++].getClassName().startsWith("org.eclipse.wst.jsdt")) {
        }
        if (idx < length) {
            StackTraceElement testElement = null;
            while (idx < length && elements[idx].getClassName().startsWith("org.eclipse.wst.jsdt")) {
                testElement = elements[idx++];
            }
            if (testElement != null) {
                return String.valueOf(testElement.getClassName()) + " - " + testElement.getMethodName();
            }
        }
        return "?";
    }

    public static String indentString(String inputString, int indent) {
        if (inputString == null) {
            return "";
        }
        int length = inputString.length();
        StringBuffer buffer = new StringBuffer(length);
        StringTokenizer tokenizer = new StringTokenizer(inputString, "\n\r", true);
        StringBuffer indentStr = new StringBuffer(indent);
        int i = 0;
        while (i < indent) {
            indentStr.append("\t");
            ++i;
        }
        buffer.append(indentStr);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            buffer.append(token);
            if (!token.equals("\r") && !token.equals("\n")) continue;
            buffer.append(indentStr);
        }
        return buffer.toString();
    }

    public static boolean isFileDeleted(File file) {
        return !file.exists() && Util.getParentChildFile(file) == null;
    }

    public static boolean isMacOS() {
        return System.getProperty("os.name").indexOf("Mac") != -1;
    }

    public static boolean isResourceDeleted(IResource resource) {
        return !resource.isAccessible() && Util.getParentChildResource(resource) == null;
    }

    private static void printFileInfo(File file, int indent, int recurse) {
        File parent;
        int length;
        String tab = "";
        int i = 0;
        while (i < indent) {
            tab = String.valueOf(tab) + "\t";
            ++i;
        }
        System.out.print(String.valueOf(tab) + "- " + file.getName() + " file info: ");
        String sep = "";
        if (file.canRead()) {
            System.out.print("read");
            sep = ", ";
        }
        if (file.canWrite()) {
            System.out.print(String.valueOf(sep) + "write");
            sep = ", ";
        }
        if (file.exists()) {
            System.out.print(String.valueOf(sep) + "exist");
            sep = ", ";
        }
        if (file.isDirectory()) {
            System.out.print(String.valueOf(sep) + "dir");
            sep = ", ";
        }
        if (file.isFile()) {
            System.out.print(String.valueOf(sep) + "file");
            sep = ", ";
        }
        if (file.isHidden()) {
            System.out.print(String.valueOf(sep) + "hidden");
            sep = ", ";
        }
        System.out.println();
        File[] files = file.listFiles();
        int n = length = files == null ? 0 : files.length;
        if (length > 0) {
            boolean children = recurse < 0;
            System.out.print(String.valueOf(tab) + "\t+ children: ");
            if (children) {
                System.out.println();
            }
            int i2 = 0;
            while (i2 < length) {
                if (children) {
                    Util.printFileInfo(files[i2], indent + 2, -1);
                } else {
                    if (i2 > 0) {
                        System.out.print(", ");
                    }
                    System.out.print(files[i2].getName());
                    if (files[i2].isDirectory()) {
                        System.out.print("[dir]");
                    } else if (files[i2].isFile()) {
                        System.out.print("[file]");
                    } else {
                        System.out.print("[?]");
                    }
                }
                ++i2;
            }
            if (!children) {
                System.out.println();
            }
        }
        if (recurse > 0 && (parent = file.getParentFile()) != null) {
            Util.printFileInfo(parent, indent + 1, recurse - 1);
        }
    }

    private static void printJdtCoreStackTrace(Exception exception, int indent) {
        String tab = "";
        int i = 0;
        while (i < indent) {
            tab = String.valueOf(tab) + "\t";
            ++i;
        }
        StackTraceElement[] elements = (exception == null ? new Exception() : exception).getStackTrace();
        int idx = 0;
        int length = elements.length;
        while (idx < length && !elements[idx++].getClassName().startsWith("org.eclipse.wst.jsdt")) {
        }
        if (idx < length) {
            System.out.print(String.valueOf(tab) + "- stack trace");
            if (exception == null) {
                System.out.println(":");
            } else {
                System.out.println(" for exception " + exception + ":");
            }
            while (idx < length && elements[idx].getClassName().startsWith("org.eclipse.wst.jsdt")) {
                StackTraceElement testElement = elements[idx++];
                System.out.println(String.valueOf(tab) + "\t-> " + testElement);
            }
        } else {
            exception.printStackTrace(System.out);
        }
    }

    public static String toNativePath(String path) {
        String nativePath = path.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        return nativePath.endsWith("/") || nativePath.endsWith("\\") ? nativePath.substring(0, nativePath.length() - 1) : nativePath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unzip(String zipPath, String destDirPath) throws IOException {
        FileInputStream zipIn = new FileInputStream(zipPath);
        byte[] buf = new byte[8192];
        File destDir = new File(destDirPath);
        ZipInputStream zis = new ZipInputStream(zipIn);
        FileOutputStream fos = null;
        try {
            block15: {
                try {
                    ZipEntry zEntry;
                    block10: while ((zEntry = zis.getNextEntry()) != null) {
                        if (zEntry.isDirectory()) {
                            new File(destDir, zEntry.getName()).mkdirs();
                            continue;
                        }
                        String filePath = zEntry.getName();
                        int lastSeparator = filePath.lastIndexOf("/");
                        String fileDir = "";
                        if (lastSeparator >= 0) {
                            fileDir = filePath.substring(0, lastSeparator);
                        }
                        new File(destDir, fileDir).mkdirs();
                        File outFile = new File(destDir, filePath);
                        fos = new FileOutputStream(outFile);
                        int n = 0;
                        while (true) {
                            if ((n = zis.read(buf)) < 0) {
                                fos.close();
                                continue block10;
                            }
                            fos.write(buf, 0, n);
                        }
                    }
                }
                catch (IOException iOException) {
                    if (fos == null) break block15;
                    try {
                        fos.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            Object var13_15 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            try {
                ((InputStream)zipIn).close();
                if (zis == null) throw throwable;
                zis.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        ((InputStream)zipIn).close();
        if (zis == null) return;
        zis.close();
    }

    private static boolean waitUntilFileDeleted(File file) {
        if (DELETE_DEBUG) {
            System.out.println();
            System.out.println("WARNING in test: " + Util.getTestName());
            System.out.println("\t- problems occured while deleting " + file);
            Util.printJdtCoreStackTrace(null, 1);
            Util.printFileInfo(file.getParentFile(), 1, -1);
            System.out.print("\t- wait for (" + DELETE_MAX_WAIT + "ms max): ");
        }
        int count = 0;
        int delay = 10;
        int maxRetry = DELETE_MAX_WAIT / delay;
        int time = 0;
        while (count < maxRetry) {
            block12: {
                block11: {
                    ++count;
                    Thread.sleep(delay);
                    if ((time += delay) > DELETE_MAX_TIME) {
                        DELETE_MAX_TIME = time;
                    }
                    if (DELETE_DEBUG) {
                        System.out.print('.');
                    }
                    if (!file.exists() || !file.delete()) break block11;
                    if (DELETE_DEBUG) {
                        System.out.println();
                        System.out.println("\t=> file really removed after " + time + "ms (max=" + DELETE_MAX_TIME + "ms)");
                        System.out.println();
                    }
                    return true;
                }
                if (!Util.isFileDeleted(file)) break block12;
                if (DELETE_DEBUG) {
                    System.out.println();
                    System.out.println("\t=> file disappeared after " + time + "ms (max=" + DELETE_MAX_TIME + "ms)");
                    System.out.println();
                }
                return true;
            }
            try {
                if (count < 10 || delay > 100) continue;
                count = 1;
                maxRetry = DELETE_MAX_WAIT / (delay *= 10);
                if (DELETE_MAX_WAIT % delay == 0) continue;
                ++maxRetry;
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        if (!DELETE_DEBUG) {
            System.out.println();
            System.out.println("WARNING in test: " + Util.getTestName());
            System.out.println("\t- problems occured while deleting " + file);
            Util.printJdtCoreStackTrace(null, 1);
            Util.printFileInfo(file.getParentFile(), 1, -1);
        }
        System.out.println();
        System.out.println("\t!!! ERROR: " + file + " was never deleted even after having waited " + DELETE_MAX_TIME + "ms!!!");
        System.out.println();
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean waitUntilResourceDeleted(IResource resource) {
        File file = resource.getLocation().toFile();
        if (DELETE_DEBUG) {
            System.out.println();
            System.out.println("WARNING in test: " + Util.getTestName());
            System.out.println("\t- problems occured while deleting resource " + resource);
            Util.printJdtCoreStackTrace(null, 1);
            Util.printFileInfo(file.getParentFile(), 1, -1);
            System.out.print("\t- wait for (" + DELETE_MAX_WAIT + "ms max): ");
        }
        int count = 0;
        int delay = 10;
        int maxRetry = DELETE_MAX_WAIT / delay;
        int time = 0;
        while (count < maxRetry) {
            try {
                ++count;
                Thread.sleep(delay);
                if ((time += delay) > DELETE_MAX_TIME) {
                    DELETE_MAX_TIME = time;
                }
                if (DELETE_DEBUG) {
                    System.out.print('.');
                }
                if (resource.isAccessible()) {
                    try {
                        resource.delete(true, null);
                        if (Util.isResourceDeleted(resource) && Util.isFileDeleted(file)) {
                            if (DELETE_DEBUG) {
                                System.out.println();
                                System.out.println("\t=> resource really removed after " + time + "ms (max=" + DELETE_MAX_TIME + "ms)");
                                System.out.println();
                            }
                            return true;
                        }
                    }
                    catch (CoreException coreException) {}
                }
                if (Util.isResourceDeleted(resource) && Util.isFileDeleted(file)) {
                    if (DELETE_DEBUG) {
                        System.out.println();
                        System.out.println("\t=> resource disappeared after " + time + "ms (max=" + DELETE_MAX_TIME + "ms)");
                        System.out.println();
                    }
                    return true;
                }
                if (count < 10 || delay > 100) continue;
                count = 1;
                maxRetry = DELETE_MAX_WAIT / (delay *= 10);
                if (DELETE_MAX_WAIT % delay == 0) continue;
                ++maxRetry;
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        if (!DELETE_DEBUG) {
            System.out.println();
            System.out.println("WARNING in test: " + Util.getTestName());
            System.out.println("\t- problems occured while deleting resource " + resource);
            Util.printJdtCoreStackTrace(null, 1);
            Util.printFileInfo(file.getParentFile(), 1, -1);
        }
        System.out.println();
        System.out.println("\t!!! ERROR: " + resource + " was never deleted even after having waited " + DELETE_MAX_TIME + "ms!!!");
        System.out.println();
        return false;
    }

    /*
     * Exception decompiling
     */
    public static void writeToFile(String contents, String destinationFilePath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 79->83)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static void zip(File rootDir, String zipPath) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 76->80)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void zip(File dir, ZipOutputStream zip, int rootPathLength) throws IOException {
        File[] files = dir.listFiles();
        if (files != null) {
            int i = 0;
            int length = files.length;
            while (i < length) {
                File file = files[i];
                if (file.isFile()) {
                    String path = file.getPath();
                    path = path.substring(rootPathLength);
                    ZipEntry entry = new ZipEntry(path.replace('\\', '/'));
                    zip.putNextEntry(entry);
                    zip.write(org.eclipse.wst.jsdt.internal.compiler.util.Util.getFileByteContent((File)file));
                    zip.closeEntry();
                } else {
                    Util.zip(file, zip, rootPathLength);
                }
                ++i;
            }
        }
    }
}

