/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.DiscriminatorType;
import org.eclipse.jpt.jpa.core.context.Embeddable;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.InheritanceType;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.MappedSuperclass;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.SpecifiedAssociationOverride;
import org.eclipse.jpt.jpa.core.context.SpecifiedAttributeOverride;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedSecondaryTable;
import org.eclipse.jpt.jpa.core.context.Table;
import org.eclipse.jpt.jpa.core.context.VirtualAssociationOverride;
import org.eclipse.jpt.jpa.core.context.VirtualAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaAssociationOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.context.java.JavaIdMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaNamedNativeQuery;
import org.eclipse.jpt.jpa.core.context.java.JavaNamedQuery;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedAssociationOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedSecondaryTable;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedTable;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualAssociationOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualAttributeOverride;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.internal.context.java.JavaNullTypeMapping;
import org.eclipse.jpt.jpa.core.resource.java.AssociationOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.DiscriminatorColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.DiscriminatorValueAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.EntityAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.IdClassAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.InheritanceAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.NamedNativeQueryAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.NamedQueryAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.SecondaryTableAnnotation;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class JavaEntityTests
extends ContextModelTestCase {
    private static final String ENTITY_NAME = "entityName";
    private static final String TABLE_NAME = "MY_TABLE";
    private static final String DISCRIMINATOR_VALUE = "MY_DISCRIMINATOR_VALUE";
    protected static final String SUB_TYPE_NAME = "AnnotationTestTypeChild";
    protected static final String FULLY_QUALIFIED_SUB_TYPE_NAME = "test.AnnotationTestTypeChild";

    public JavaEntityTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestEntityInvalidNamedQueries() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.NamedQueries", "javax.persistence.NamedQuery"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append(CR);
                sb.append("@NamedQueries(value={@NamedQuery(query=\"asdf\", name=\"foo\"), @NamedQuer})");
            }
        });
    }

    private void createTestAbstractEntity() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public abstract class ").append("AnnotationTestType").append(" ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestType.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityAnnotationOnProperty() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestMappedSuperclass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "javax.persistence.Basic", "javax.persistence.Version", "javax.persistence.Transient", "javax.persistence.Embedded", "javax.persistence.EmbeddedId", "javax.persistence.OneToOne", "javax.persistence.OneToMany", "javax.persistence.ManyToOne", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("private String foo;").append(CR);
                sb.append(CR);
                sb.append("    @Basic");
                sb.append(CR);
                sb.append("    private int basic;").append(CR);
                sb.append(CR);
                sb.append("    @Version");
                sb.append(CR);
                sb.append("    private int version;").append(CR);
                sb.append(CR);
                sb.append("    @Transient");
                sb.append(CR);
                sb.append("    private int transient;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded");
                sb.append(CR);
                sb.append("    private int embedded;").append(CR);
                sb.append(CR);
                sb.append("    @EmbeddedId");
                sb.append(CR);
                sb.append("    private int embeddedId;").append(CR);
                sb.append(CR);
                sb.append("    @OneToOne");
                sb.append(CR);
                sb.append("    private AnnotationTestTypeChild oneToOne;").append(CR);
                sb.append(CR);
                sb.append("    @OneToMany");
                sb.append(CR);
                sb.append("    private int oneToMany;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToOne");
                sb.append(CR);
                sb.append("    private int manyToOne;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToMany");
                sb.append(CR);
                sb.append("    private int manyToMany;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private ICompilationUnit createTestAbstractEntityTablePerClass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Inheritance", "javax.persistence.InheritanceType", "javax.persistence.OneToOne"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)");
                sb.append("abstract");
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("private String foo;").append(CR);
                sb.append(CR);
                sb.append("    @OneToOne");
                sb.append(CR);
                sb.append("    private int address;").append(CR);
                sb.append(CR);
                sb.append("    @OneToOne");
                sb.append(CR);
                sb.append("    private int address2;").append(CR);
                sb.append(CR);
                sb.append("    ");
            }
        });
    }

    private ICompilationUnit createTestEntityWithName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity(name=\"entityName\")");
            }
        });
    }

    private ICompilationUnit createTestEntityWithTable() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Table"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@Table(name=\"MY_TABLE\")");
            }
        });
    }

    private void createTestSubType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append(JavaEntityTests.SUB_TYPE_NAME).append(" ");
                sb.append("extends AnnotationTestType ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestTypeChild.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithInheritance() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Inheritance", "javax.persistence.InheritanceType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithDiscriminatorValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.DiscriminatorValue"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@DiscriminatorValue(value=\"MY_DISCRIMINATOR_VALUE\")");
            }
        });
    }

    private ICompilationUnit createTestEntityWithSecondaryTable() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.SecondaryTable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@SecondaryTable(name=\"foo\")");
            }
        });
    }

    private ICompilationUnit createTestEntityWithSecondaryTables() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@SecondaryTables({@SecondaryTable(name=\"foo\"), @SecondaryTable(name=\"bar\")})");
            }
        });
    }

    private ICompilationUnit createAbstractTestEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Inheritance", "javax.persistence.InheritanceType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)").append(CR);
                sb.append("abstract");
            }
        });
    }

    private void createTestIdClass() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("public class ").append("TestTypeId").append(" ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "TestTypeId.java", sourceWriter);
    }

    public void testMorphToMappedSuperclass() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = (JavaEntity)this.getJavaPersistentType().getMapping();
        entity.getTable().setSpecifiedName("FOO");
        entity.addSpecifiedSecondaryTable(0);
        entity.addSpecifiedPrimaryKeyJoinColumn(0);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        resourceType.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceType.addAnnotation(0, "javax.persistence.AssociationOverride");
        entity.setSpecifiedInheritanceStrategy(InheritanceType.JOINED);
        entity.setSpecifiedDiscriminatorValue("asdf");
        entity.getDiscriminatorColumn().setSpecifiedName("BAR");
        entity.getGeneratorContainer().addTableGenerator();
        entity.getGeneratorContainer().addSequenceGenerator();
        entity.getIdClassReference().setSpecifiedIdClassName("myIdClass");
        entity.getQueryContainer().addNamedNativeQuery(0);
        entity.getQueryContainer().addNamedQuery(0);
        this.getJavaPersistentType().setMappingKey("mappedSuperclass");
        JavaEntityTests.assertTrue((boolean)(this.getJavaPersistentType().getMapping() instanceof MappedSuperclass));
        JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.Entity"));
        JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.Table"));
        JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.SecondaryTable"));
        JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.PrimaryKeyJoinColumn"));
        JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AttributeOverride"));
        JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AssociationOverride"));
        JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.Inheritance"));
        JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.DiscriminatorValue"));
        JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.DiscriminatorColumn"));
        JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.TableGenerator"));
        JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaEntityTests.assertNotNull((Object)resourceType.getAnnotation("javax.persistence.IdClass"));
        JavaEntityTests.assertNotNull((Object)resourceType.getAnnotation(0, "javax.persistence.NamedQuery"));
        JavaEntityTests.assertNotNull((Object)resourceType.getAnnotation(0, "javax.persistence.NamedNativeQuery"));
    }

    public void testMorphToEmbeddable() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = (JavaEntity)this.getJavaPersistentType().getMapping();
        entity.getTable().setSpecifiedName("FOO");
        entity.addSpecifiedSecondaryTable(0);
        entity.addSpecifiedPrimaryKeyJoinColumn(0);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        resourceType.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceType.addAnnotation(0, "javax.persistence.AssociationOverride");
        entity.setSpecifiedInheritanceStrategy(InheritanceType.JOINED);
        entity.setSpecifiedDiscriminatorValue("asdf");
        entity.getDiscriminatorColumn().setSpecifiedName("BAR");
        entity.getGeneratorContainer().addTableGenerator();
        entity.getGeneratorContainer().addSequenceGenerator();
        entity.getIdClassReference().setSpecifiedIdClassName("myIdClass");
        entity.getQueryContainer().addNamedNativeQuery(0);
        entity.getQueryContainer().addNamedQuery(0);
        this.getJavaPersistentType().setMappingKey("embeddable");
        JavaEntityTests.assertTrue((boolean)(this.getJavaPersistentType().getMapping() instanceof Embeddable));
        JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.Entity"));
        JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.Table"));
        JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.SecondaryTable"));
        JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.PrimaryKeyJoinColumn"));
        JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AttributeOverride"));
        JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AssociationOverride"));
        JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.Inheritance"));
        JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.DiscriminatorValue"));
        JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.DiscriminatorColumn"));
        JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.TableGenerator"));
        JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.IdClass"));
        JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.NamedQuery"));
        JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.NamedNativeQuery"));
    }

    public void testMorphToNull() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = (JavaEntity)this.getJavaPersistentType().getMapping();
        entity.getTable().setSpecifiedName("FOO");
        entity.addSpecifiedSecondaryTable(0);
        entity.addSpecifiedPrimaryKeyJoinColumn(0);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        resourceType.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceType.addAnnotation(0, "javax.persistence.AssociationOverride");
        entity.setSpecifiedInheritanceStrategy(InheritanceType.JOINED);
        entity.setSpecifiedDiscriminatorValue("asdf");
        entity.getDiscriminatorColumn().setSpecifiedName("BAR");
        entity.getGeneratorContainer().addTableGenerator();
        entity.getGeneratorContainer().addSequenceGenerator();
        entity.getIdClassReference().setSpecifiedIdClassName("myIdClass");
        entity.getQueryContainer().addNamedNativeQuery(0);
        entity.getQueryContainer().addNamedQuery(0);
        this.getJavaPersistentType().setMappingKey(MappingKeys.NULL_TYPE_MAPPING_KEY);
        JavaEntityTests.assertTrue((boolean)(this.getJavaPersistentType().getMapping() instanceof JavaNullTypeMapping));
        JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.Entity"));
        JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.Table"));
        JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.SecondaryTable"));
        JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.PrimaryKeyJoinColumn"));
        JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AttributeOverride"));
        JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AssociationOverride"));
        JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.Inheritance"));
        JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.DiscriminatorValue"));
        JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.DiscriminatorColumn"));
        JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.TableGenerator"));
        JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.IdClass"));
        JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.NamedQuery"));
        JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.NamedNativeQuery"));
    }

    public void testAccessNoAnnotations() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((Object)AccessType.FIELD, (Object)this.getJavaPersistentType().getAccess());
    }

    public void testAccessAnnotationsOnSuper() throws Exception {
        this.createTestEntityAnnotationOnProperty();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        JavaPersistentType childPersistentType = this.getJavaPersistentType();
        PersistentType superPersistentType = childPersistentType.getSuperPersistentType();
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)superPersistentType.getAccess());
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)childPersistentType.getAccess());
        ((IdMapping)superPersistentType.getAttributeNamed("id").getMapping()).getColumn().setSpecifiedName("FOO");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ((JavaResourceMethod)resourceType.getMethods().iterator().next()).removeAnnotation("javax.persistence.Id");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)superPersistentType.getAccess());
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)childPersistentType.getAccess());
        ((BasicMapping)superPersistentType.getAttributeNamed("id").getMapping()).getColumn().setSpecifiedName(null);
        JavaEntityTests.assertEquals((Object)AccessType.FIELD, (Object)superPersistentType.getAccess());
        JavaEntityTests.assertEquals((Object)AccessType.FIELD, (Object)childPersistentType.getAccess());
        this.getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSpecifiedAccess(AccessType.PROPERTY);
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)superPersistentType.getAccess());
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)childPersistentType.getAccess());
        this.getEntityMappings().setSpecifiedAccess(AccessType.FIELD);
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)superPersistentType.getAccess());
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)childPersistentType.getAccess());
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.removeXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getJavaPersistentType().getAccess());
        JavaEntityTests.assertEquals((Object)AccessType.FIELD, (Object)childPersistentType.getAccess());
        OrmPersistentType childOrmPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.removeXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        JavaEntityTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getJavaPersistentType().getAccess());
        JavaEntityTests.assertEquals((Object)AccessType.FIELD, (Object)childOrmPersistentType.getJavaPersistentType().getAccess());
    }

    public void testAccessWithXmlSettings() throws Exception {
        this.createTestEntityAnnotationOnProperty();
        this.addXmlClassRef("test.AnnotationTestType");
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)this.getJavaPersistentType().getAccess());
        ((IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getColumn().setSpecifiedName("FOO");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ((JavaResourceMethod)resourceType.getMethods().iterator().next()).removeAnnotation("javax.persistence.Id");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)this.getJavaPersistentType().getAccess());
        ((BasicMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getColumn().setSpecifiedName(null);
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((Object)AccessType.FIELD, (Object)this.getJavaPersistentType().getAccess());
        this.getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSpecifiedAccess(AccessType.PROPERTY);
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)this.getJavaPersistentType().getAccess());
        this.getEntityMappings().setSpecifiedAccess(AccessType.FIELD);
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)this.getJavaPersistentType().getAccess());
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaEntityTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getJavaPersistentType().getAccess());
        ormPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        JavaEntityTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentType.getJavaPersistentType().getAccess());
    }

    public void testGetSpecifiedNameNull() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getSpecifiedName());
    }

    public void testGetSpecifiedName() throws Exception {
        this.createTestEntityWithName();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)ENTITY_NAME, (String)this.getJavaEntity().getSpecifiedName());
    }

    public void testGetDefaultNameSpecifiedNameNull() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)"AnnotationTestType", (String)this.getJavaEntity().getDefaultName());
    }

    public void testGetDefaultName() throws Exception {
        this.createTestEntityWithName();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)"AnnotationTestType", (String)this.getJavaEntity().getDefaultName());
    }

    public void testGetNameSpecifiedNameNull() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)"AnnotationTestType", (String)this.getJavaEntity().getName());
    }

    public void testGetName() throws Exception {
        this.createTestEntityWithName();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)ENTITY_NAME, (String)this.getJavaEntity().getName());
    }

    public void testSetSpecifiedName() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.getJavaEntity().setSpecifiedName("foo");
        JavaEntityTests.assertEquals((String)"foo", (String)this.getJavaEntity().getSpecifiedName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaEntityTests.assertEquals((String)"foo", (String)((EntityAnnotation)resourceType.getAnnotation("javax.persistence.Entity")).getName());
    }

    public void testSetSpecifiedNameNull() throws Exception {
        this.createTestEntityWithName();
        this.addXmlClassRef("test.AnnotationTestType");
        this.getJavaEntity().setSpecifiedName(null);
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getSpecifiedName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaEntityTests.assertNull((Object)((EntityAnnotation)resourceType.getAnnotation("javax.persistence.Entity")).getName());
    }

    public void testUpdateFromSpecifiedNameChangeInResourceModel() throws Exception {
        this.createTestEntityWithName();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        EntityAnnotation entity = (EntityAnnotation)resourceType.getAnnotation("javax.persistence.Entity");
        entity.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((String)"foo", (String)this.getJavaEntity().getSpecifiedName());
    }

    public void testGetTableName() throws Exception {
        this.addXmlClassRef("test.AnnotationTestType");
        this.createTestEntityWithName();
        JavaEntityTests.assertEquals((String)ENTITY_NAME, (String)this.getJavaEntity().getPrimaryTableName());
    }

    public void testGetTableName2() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)"AnnotationTestType", (String)this.getJavaEntity().getPrimaryTableName());
    }

    public void testGetTableName3() throws Exception {
        this.createTestEntityWithTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)TABLE_NAME, (String)this.getJavaEntity().getPrimaryTableName());
    }

    public void testSetTableNameWithNullTable() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSpecifiedTable table = this.getJavaEntity().getTable();
        JavaEntityTests.assertEquals((String)"AnnotationTestType", (String)table.getName());
        this.assertSourceDoesNotContain("@Table", cu);
        table.setSpecifiedName(TABLE_NAME);
        this.assertSourceContains("@Table(name = \"MY_TABLE\")", cu);
        JavaEntityTests.assertEquals((String)TABLE_NAME, (String)this.getJavaEntity().getPrimaryTableName());
        JavaEntityTests.assertEquals((String)TABLE_NAME, (String)table.getName());
        table.setSpecifiedCatalog(TABLE_NAME);
    }

    public void testGetInheritanceStrategy() throws Exception {
        this.createTestEntityWithInheritance();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)this.getJavaEntity().getInheritanceStrategy());
    }

    public void testGetDefaultInheritanceStrategy() throws Exception {
        this.createTestEntity();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator specifiedClassRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        Entity childEntity = (Entity)((ClassRef)specifiedClassRefs.next()).getJavaPersistentType().getMapping();
        Entity rootEntity = (Entity)((ClassRef)specifiedClassRefs.next()).getJavaPersistentType().getMapping();
        JavaEntityTests.assertNotSame((Object)childEntity, (Object)rootEntity);
        JavaEntityTests.assertEquals((Object)InheritanceType.SINGLE_TABLE, (Object)childEntity.getDefaultInheritanceStrategy());
        rootEntity.setSpecifiedInheritanceStrategy(InheritanceType.TABLE_PER_CLASS);
        JavaEntityTests.assertEquals((Object)InheritanceType.SINGLE_TABLE, (Object)rootEntity.getDefaultInheritanceStrategy());
        JavaEntityTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)childEntity.getDefaultInheritanceStrategy());
        JavaEntityTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)childEntity.getInheritanceStrategy());
        JavaEntityTests.assertNull((Object)childEntity.getSpecifiedInheritanceStrategy());
    }

    public void testGetSpecifiedInheritanceStrategy() throws Exception {
        this.createTestEntityWithInheritance();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)this.getJavaEntity().getSpecifiedInheritanceStrategy());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        InheritanceAnnotation inheritance = (InheritanceAnnotation)resourceType.getAnnotation("javax.persistence.Inheritance");
        inheritance.setStrategy(org.eclipse.jpt.jpa.core.resource.java.InheritanceType.JOINED);
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((Object)InheritanceType.JOINED, (Object)this.getJavaEntity().getSpecifiedInheritanceStrategy());
        inheritance.setStrategy(null);
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getSpecifiedInheritanceStrategy());
    }

    public void testSetSpecifiedInheritanceStrategy() throws Exception {
        this.createTestEntityWithInheritance();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)this.getJavaEntity().getSpecifiedInheritanceStrategy());
        this.getJavaEntity().setSpecifiedInheritanceStrategy(InheritanceType.JOINED);
        JavaEntityTests.assertEquals((Object)InheritanceType.JOINED, (Object)this.getJavaEntity().getSpecifiedInheritanceStrategy());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        InheritanceAnnotation inheritance = (InheritanceAnnotation)resourceType.getAnnotation("javax.persistence.Inheritance");
        JavaEntityTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.InheritanceType.JOINED, (Object)inheritance.getStrategy());
    }

    public void testGetDiscriminatorValue() throws Exception {
        this.createTestEntityWithDiscriminatorValue();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)DISCRIMINATOR_VALUE, (String)this.getJavaEntity().getDiscriminatorValue());
    }

    public void testGetDefaultDiscriminatorValue() throws Exception {
        this.createTestEntityWithDiscriminatorValue();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals(null, (String)this.getJavaEntity().getDefaultDiscriminatorValue());
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        JavaEntityTests.assertEquals((String)this.getJavaEntity().getName(), (String)this.getJavaEntity().getDefaultDiscriminatorValue());
        this.getJavaEntity().getDiscriminatorColumn().setSpecifiedDiscriminatorType(DiscriminatorType.INTEGER);
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getDefaultDiscriminatorValue());
    }

    public void testGetSpecifiedDiscriminatorValue() throws Exception {
        this.createTestEntityWithDiscriminatorValue();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)DISCRIMINATOR_VALUE, (String)this.getJavaEntity().getSpecifiedDiscriminatorValue());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        DiscriminatorValueAnnotation discriminatorValue = (DiscriminatorValueAnnotation)resourceType.getAnnotation("javax.persistence.DiscriminatorValue");
        discriminatorValue.setValue("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((String)"foo", (String)this.getJavaEntity().getSpecifiedDiscriminatorValue());
        discriminatorValue.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getSpecifiedDiscriminatorValue());
    }

    public void testSetSpecifiedDiscriminatorValue() throws Exception {
        this.createTestEntityWithDiscriminatorValue();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((String)DISCRIMINATOR_VALUE, (String)this.getJavaEntity().getSpecifiedDiscriminatorValue());
        this.getJavaEntity().setSpecifiedDiscriminatorValue("foo");
        JavaEntityTests.assertEquals((String)"foo", (String)this.getJavaEntity().getSpecifiedDiscriminatorValue());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        DiscriminatorValueAnnotation discriminatorValue = (DiscriminatorValueAnnotation)resourceType.getAnnotation("javax.persistence.DiscriminatorValue");
        JavaEntityTests.assertEquals((String)"foo", (String)discriminatorValue.getValue());
    }

    public void testSecondaryTables() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator secondaryTables = this.getJavaEntity().getSecondaryTables().iterator();
        JavaEntityTests.assertTrue((boolean)secondaryTables.hasNext());
        JavaEntityTests.assertEquals((String)"foo", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
    }

    public void testSecondaryTablesSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaEntityTests.assertEquals((int)0, (int)entity.getSecondaryTablesSize());
        ((SecondaryTableAnnotation)resourceType.addAnnotation(0, "javax.persistence.SecondaryTable")).setName("FOO");
        ((SecondaryTableAnnotation)resourceType.addAnnotation(1, "javax.persistence.SecondaryTable")).setName("BAR");
        ((SecondaryTableAnnotation)resourceType.addAnnotation(2, "javax.persistence.SecondaryTable")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((int)3, (int)entity.getSecondaryTablesSize());
    }

    public void testSpecifiedSecondaryTables() throws Exception {
        this.createTestEntityWithSecondaryTables();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator specifiedSecondaryTables = this.getJavaEntity().getSpecifiedSecondaryTables().iterator();
        JavaEntityTests.assertTrue((boolean)specifiedSecondaryTables.hasNext());
        JavaEntityTests.assertEquals((String)"foo", (String)((JavaSpecifiedSecondaryTable)specifiedSecondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"bar", (String)((JavaSpecifiedSecondaryTable)specifiedSecondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedSecondaryTables.hasNext());
    }

    public void testSpecifiedSecondaryTablesSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaEntityTests.assertEquals((int)0, (int)entity.getSpecifiedSecondaryTablesSize());
        ((SecondaryTableAnnotation)resourceType.addAnnotation(0, "javax.persistence.SecondaryTable")).setName("FOO");
        ((SecondaryTableAnnotation)resourceType.addAnnotation(1, "javax.persistence.SecondaryTable")).setName("BAR");
        ((SecondaryTableAnnotation)resourceType.addAnnotation(2, "javax.persistence.SecondaryTable")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((int)3, (int)entity.getSpecifiedSecondaryTablesSize());
    }

    public void testAddSpecifiedSecondaryTable() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.getJavaEntity().addSpecifiedSecondaryTable(0).setSpecifiedName("FOO");
        this.getJavaEntity().addSpecifiedSecondaryTable(0).setSpecifiedName("BAR");
        this.getJavaEntity().addSpecifiedSecondaryTable(0).setSpecifiedName("BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ListIterator secondaryTables = resourceType.getAnnotations("javax.persistence.SecondaryTable").iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTableAnnotation)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((SecondaryTableAnnotation)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTableAnnotation)secondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
    }

    public void testAddSpecifiedSecondaryTable2() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.getJavaEntity().addSpecifiedSecondaryTable(0).setSpecifiedName("FOO");
        this.getJavaEntity().addSpecifiedSecondaryTable(1).setSpecifiedName("BAR");
        this.getJavaEntity().addSpecifiedSecondaryTable(0).setSpecifiedName("BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ListIterator secondaryTables = resourceType.getAnnotations("javax.persistence.SecondaryTable").iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTableAnnotation)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTableAnnotation)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((SecondaryTableAnnotation)secondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
    }

    public void testAddSpecifiedSecondaryTablePreservePkJoinColumns() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSpecifiedSecondaryTable specifiedSecondaryTable = this.getJavaEntity().addSpecifiedSecondaryTable(0);
        specifiedSecondaryTable.setSpecifiedName("FOO");
        specifiedSecondaryTable.setSpecifiedCatalog("CATALOG");
        specifiedSecondaryTable.setSpecifiedSchema("SCHEMA");
        specifiedSecondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("PK_NAME");
        JavaSpecifiedSecondaryTable specifiedSecondaryTable2 = this.getJavaEntity().addSpecifiedSecondaryTable(1);
        specifiedSecondaryTable2.setSpecifiedName("BAR");
        ListIterator secondaryTables = this.getJavaEntity().getSecondaryTables().iterator();
        SpecifiedSecondaryTable secondaryTable = (SpecifiedSecondaryTable)secondaryTables.next();
        JavaEntityTests.assertEquals((Object)secondaryTable, (Object)specifiedSecondaryTable);
        JavaEntityTests.assertEquals((String)"FOO", (String)secondaryTable.getName());
        JavaEntityTests.assertEquals((String)"CATALOG", (String)secondaryTable.getCatalog());
        JavaEntityTests.assertEquals((String)"SCHEMA", (String)secondaryTable.getSchema());
        JavaEntityTests.assertEquals((int)1, (int)secondaryTable.getSpecifiedPrimaryKeyJoinColumnsSize());
        SpecifiedPrimaryKeyJoinColumn pkJoinColumn = (SpecifiedPrimaryKeyJoinColumn)secondaryTable.getSpecifiedPrimaryKeyJoinColumns().iterator().next();
        JavaEntityTests.assertEquals((String)"PK_NAME", (String)pkJoinColumn.getName());
        secondaryTable = (SpecifiedSecondaryTable)secondaryTables.next();
        JavaEntityTests.assertEquals((Object)secondaryTable, (Object)specifiedSecondaryTable2);
        JavaEntityTests.assertEquals((String)"BAR", (String)secondaryTable.getName());
        JavaEntityTests.assertEquals((int)0, (int)secondaryTable.getSpecifiedPrimaryKeyJoinColumnsSize());
    }

    public void testRemoveSpecifiedSecondaryTable() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.getJavaEntity().addSpecifiedSecondaryTable(0).setSpecifiedName("FOO");
        this.getJavaEntity().addSpecifiedSecondaryTable(1).setSpecifiedName("BAR");
        this.getJavaEntity().addSpecifiedSecondaryTable(2).setSpecifiedName("BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaEntityTests.assertEquals((int)3, (int)resourceType.getAnnotationsSize("javax.persistence.SecondaryTable"));
        this.getJavaEntity().removeSpecifiedSecondaryTable(1);
        ListIterator secondaryTableResources = resourceType.getAnnotations("javax.persistence.SecondaryTable").iterator();
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTableAnnotation)secondaryTableResources.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTableAnnotation)secondaryTableResources.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTableResources.hasNext());
        ListIterator secondaryTables = this.getJavaEntity().getSecondaryTables().iterator();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
        this.getJavaEntity().removeSpecifiedSecondaryTable(1);
        secondaryTableResources = resourceType.getAnnotations("javax.persistence.SecondaryTable").iterator();
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTableAnnotation)secondaryTableResources.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTableResources.hasNext());
        secondaryTables = this.getJavaEntity().getSecondaryTables().iterator();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
        this.getJavaEntity().removeSpecifiedSecondaryTable(0);
        secondaryTableResources = resourceType.getAnnotations("javax.persistence.SecondaryTable").iterator();
        JavaEntityTests.assertFalse((boolean)secondaryTableResources.hasNext());
        secondaryTables = this.getJavaEntity().getSecondaryTables().iterator();
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
        JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.SecondaryTable"));
    }

    public void testMoveSpecifiedSecondaryTable() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        entity.addSpecifiedSecondaryTable(0).setSpecifiedName("FOO");
        entity.addSpecifiedSecondaryTable(1).setSpecifiedName("BAR");
        entity.addSpecifiedSecondaryTable(2).setSpecifiedName("BAZ");
        ListIterator javaSecondaryTables = resourceType.getAnnotations("javax.persistence.SecondaryTable").iterator();
        JavaEntityTests.assertEquals((int)3, (int)IteratorTools.size((Iterator)javaSecondaryTables));
        entity.moveSpecifiedSecondaryTable(2, 0);
        ListIterator secondaryTables = entity.getSpecifiedSecondaryTables().iterator();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getSpecifiedName());
        javaSecondaryTables = resourceType.getAnnotations("javax.persistence.SecondaryTable").iterator();
        JavaEntityTests.assertEquals((String)"BAR", (String)((SecondaryTableAnnotation)javaSecondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTableAnnotation)javaSecondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTableAnnotation)javaSecondaryTables.next()).getName());
        entity.moveSpecifiedSecondaryTable(0, 1);
        secondaryTables = entity.getSpecifiedSecondaryTables().iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getSpecifiedName());
        javaSecondaryTables = resourceType.getAnnotations("javax.persistence.SecondaryTable").iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((SecondaryTableAnnotation)javaSecondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((SecondaryTableAnnotation)javaSecondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((SecondaryTableAnnotation)javaSecondaryTables.next()).getName());
    }

    public void testUpdateSpecifiedSecondaryTables() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ((SecondaryTableAnnotation)resourceType.addAnnotation(0, "javax.persistence.SecondaryTable")).setName("FOO");
        ((SecondaryTableAnnotation)resourceType.addAnnotation(1, "javax.persistence.SecondaryTable")).setName("BAR");
        ((SecondaryTableAnnotation)resourceType.addAnnotation(2, "javax.persistence.SecondaryTable")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator secondaryTables = entity.getSpecifiedSecondaryTables().iterator();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
        resourceType.moveAnnotation(2, 0, "javax.persistence.SecondaryTable");
        this.getJpaProject().synchronizeContextModel();
        secondaryTables = entity.getSpecifiedSecondaryTables().iterator();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
        resourceType.moveAnnotation(0, 1, "javax.persistence.SecondaryTable");
        this.getJpaProject().synchronizeContextModel();
        secondaryTables = entity.getSpecifiedSecondaryTables().iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
        resourceType.removeAnnotation(1, "javax.persistence.SecondaryTable");
        this.getJpaProject().synchronizeContextModel();
        secondaryTables = entity.getSpecifiedSecondaryTables().iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
        resourceType.removeAnnotation(1, "javax.persistence.SecondaryTable");
        this.getJpaProject().synchronizeContextModel();
        secondaryTables = entity.getSpecifiedSecondaryTables().iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getName());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
        resourceType.removeAnnotation(0, "javax.persistence.SecondaryTable");
        this.getJpaProject().synchronizeContextModel();
        secondaryTables = entity.getSpecifiedSecondaryTables().iterator();
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
    }

    public void testAssociatedTables() throws Exception {
        this.createTestEntityWithSecondaryTables();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((int)3, (int)IterableTools.size((Iterable)this.getJavaEntity().getAssociatedTables()));
        Iterator associatedTables = this.getJavaEntity().getAssociatedTables().iterator();
        Table table1 = (Table)associatedTables.next();
        SpecifiedSecondaryTable table2 = (SpecifiedSecondaryTable)associatedTables.next();
        SpecifiedSecondaryTable table3 = (SpecifiedSecondaryTable)associatedTables.next();
        JavaEntityTests.assertEquals((String)"AnnotationTestType", (String)table1.getName());
        JavaEntityTests.assertEquals((String)"foo", (String)table2.getName());
        JavaEntityTests.assertEquals((String)"bar", (String)table3.getName());
    }

    public void testAssociatedTablesIncludingInherited() throws Exception {
        this.createTestEntityWithSecondaryTables();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator specifiedClassRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        Entity childEntity = (Entity)((ClassRef)specifiedClassRefs.next()).getJavaPersistentType().getMapping();
        Entity rootEntity = (Entity)((ClassRef)specifiedClassRefs.next()).getJavaPersistentType().getMapping();
        JavaEntityTests.assertEquals((int)3, (int)IterableTools.size((Iterable)rootEntity.getAllAssociatedTables()));
        Iterator associatedTables = rootEntity.getAllAssociatedTables().iterator();
        Table table1 = (Table)associatedTables.next();
        SpecifiedSecondaryTable table2 = (SpecifiedSecondaryTable)associatedTables.next();
        SpecifiedSecondaryTable table3 = (SpecifiedSecondaryTable)associatedTables.next();
        JavaEntityTests.assertEquals((String)"AnnotationTestType", (String)table1.getName());
        JavaEntityTests.assertEquals((String)"foo", (String)table2.getName());
        JavaEntityTests.assertEquals((String)"bar", (String)table3.getName());
        JavaEntityTests.assertEquals((int)4, (int)IterableTools.size((Iterable)childEntity.getAllAssociatedTables()));
    }

    public void testAssociatedTableNamesIncludingInherited() throws Exception {
        this.createTestEntityWithSecondaryTables();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator specifiedClassRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        Entity childEntity = (Entity)((ClassRef)specifiedClassRefs.next()).getJavaPersistentType().getMapping();
        Entity rootEntity = (Entity)((ClassRef)specifiedClassRefs.next()).getJavaPersistentType().getMapping();
        JavaEntityTests.assertEquals((int)3, (int)IterableTools.size((Iterable)rootEntity.getAllAssociatedTableNames()));
        Iterator associatedTables = rootEntity.getAllAssociatedTableNames().iterator();
        String table1 = (String)associatedTables.next();
        String table2 = (String)associatedTables.next();
        String table3 = (String)associatedTables.next();
        JavaEntityTests.assertEquals((String)"AnnotationTestType", (String)table1);
        JavaEntityTests.assertEquals((String)"foo", (String)table2);
        JavaEntityTests.assertEquals((String)"bar", (String)table3);
        JavaEntityTests.assertEquals((int)4, (int)IterableTools.size((Iterable)childEntity.getAllAssociatedTableNames()));
    }

    public void testAddSecondaryTableToResourceModel() throws Exception {
        this.createTestEntityWithName();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        SecondaryTableAnnotation secondaryTable = (SecondaryTableAnnotation)resourceType.addAnnotation(0, "javax.persistence.SecondaryTable");
        secondaryTable.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((int)1, (int)this.getJavaEntity().getSecondaryTablesSize());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedSecondaryTable)this.getJavaEntity().getSecondaryTables().iterator().next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedSecondaryTable)this.getJavaEntity().getSecondaryTables().iterator().next()).getName());
        SecondaryTableAnnotation secondaryTable2 = (SecondaryTableAnnotation)resourceType.addAnnotation(1, "javax.persistence.SecondaryTable");
        secondaryTable2.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((int)2, (int)this.getJavaEntity().getSecondaryTablesSize());
        ListIterator secondaryTables = this.getJavaEntity().getSecondaryTables().iterator();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getSpecifiedName());
        SecondaryTableAnnotation secondaryTable3 = (SecondaryTableAnnotation)resourceType.addAnnotation(0, "javax.persistence.SecondaryTable");
        secondaryTable3.setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((int)3, (int)this.getJavaEntity().getSecondaryTablesSize());
        secondaryTables = this.getJavaEntity().getSecondaryTables().iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getSpecifiedName());
    }

    public void testRemoveSecondaryTableFromResourceModel() throws Exception {
        this.createTestEntityWithSecondaryTables();
        this.addXmlClassRef("test.AnnotationTestType");
        this.getJavaEntity().addSpecifiedSecondaryTable(2).setSpecifiedName("baz");
        ListIterator secondaryTables = this.getJavaEntity().getSecondaryTables().iterator();
        JavaEntityTests.assertEquals((int)3, (int)this.getJavaEntity().getSecondaryTablesSize());
        JavaEntityTests.assertEquals((String)"foo", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"bar", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"baz", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        resourceType.removeAnnotation(0, "javax.persistence.SecondaryTable");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((int)2, (int)this.getJavaEntity().getSecondaryTablesSize());
        secondaryTables = this.getJavaEntity().getSecondaryTables().iterator();
        JavaEntityTests.assertEquals((String)"bar", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"baz", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getSpecifiedName());
        resourceType.removeAnnotation(0, "javax.persistence.SecondaryTable");
        this.getJpaProject().synchronizeContextModel();
        secondaryTables = this.getJavaEntity().getSecondaryTables().iterator();
        JavaEntityTests.assertEquals((int)1, (int)this.getJavaEntity().getSecondaryTablesSize());
        JavaEntityTests.assertEquals((String)"baz", (String)((JavaSpecifiedSecondaryTable)secondaryTables.next()).getSpecifiedName());
        resourceType.removeAnnotation(0, "javax.persistence.SecondaryTable");
        this.getJpaProject().synchronizeContextModel();
        secondaryTables = this.getJavaEntity().getSecondaryTables().iterator();
        JavaEntityTests.assertEquals((int)0, (int)this.getJavaEntity().getSecondaryTablesSize());
        JavaEntityTests.assertFalse((boolean)secondaryTables.hasNext());
    }

    public void testGetSequenceGenerator() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getGeneratorContainer().getSequenceGenerator());
        JavaEntityTests.assertEquals((int)0, (int)this.getJavaEntity().getPersistenceUnit().getGeneratorsSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        resourceType.addAnnotation("javax.persistence.SequenceGenerator");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertNotNull((Object)this.getJavaEntity().getGeneratorContainer().getSequenceGenerator());
        JavaEntityTests.assertEquals((int)2, (int)resourceType.getAnnotationsSize());
        JavaEntityTests.assertEquals((int)1, (int)this.getJavaEntity().getPersistenceUnit().getGeneratorsSize());
        this.getJavaEntity().getGeneratorContainer().getSequenceGenerator().setName("foo");
        JavaEntityTests.assertEquals((int)1, (int)this.getJavaEntity().getPersistenceUnit().getGeneratorsSize());
    }

    public void testAddSequenceGenerator() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getGeneratorContainer().getSequenceGenerator());
        this.getJavaEntity().getGeneratorContainer().addSequenceGenerator();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaEntityTests.assertNotNull((Object)resourceType.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaEntityTests.assertNotNull((Object)this.getJavaEntity().getGeneratorContainer().getSequenceGenerator());
        try {
            this.getJavaEntity().getGeneratorContainer().addSequenceGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        JavaEntityTests.fail((String)"IllegalStateException not thrown");
    }

    public void testRemoveSequenceGenerator() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        resourceType.addAnnotation("javax.persistence.SequenceGenerator");
        this.getJpaProject().synchronizeContextModel();
        this.getJavaEntity().getGeneratorContainer().removeSequenceGenerator();
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getGeneratorContainer().getSequenceGenerator());
        JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.SequenceGenerator"));
        try {
            this.getJavaEntity().getGeneratorContainer().removeSequenceGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        JavaEntityTests.fail((String)"IllegalStateException not thrown");
    }

    public void testGetTableGenerator() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getGeneratorContainer().getTableGenerator());
        JavaEntityTests.assertEquals((int)0, (int)this.getJavaEntity().getPersistenceUnit().getGeneratorsSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        resourceType.addAnnotation("javax.persistence.TableGenerator");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertNotNull((Object)this.getJavaEntity().getGeneratorContainer().getTableGenerator());
        JavaEntityTests.assertEquals((int)2, (int)resourceType.getAnnotationsSize());
        JavaEntityTests.assertEquals((int)1, (int)this.getJavaEntity().getPersistenceUnit().getGeneratorsSize());
        this.getJavaEntity().getGeneratorContainer().getTableGenerator().setName("foo");
        JavaEntityTests.assertEquals((int)1, (int)this.getJavaEntity().getPersistenceUnit().getGeneratorsSize());
    }

    public void testAddTableGenerator() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getGeneratorContainer().getTableGenerator());
        this.getJavaEntity().getGeneratorContainer().addTableGenerator();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaEntityTests.assertNotNull((Object)resourceType.getAnnotation("javax.persistence.TableGenerator"));
        JavaEntityTests.assertNotNull((Object)this.getJavaEntity().getGeneratorContainer().getTableGenerator());
        try {
            this.getJavaEntity().getGeneratorContainer().addTableGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        JavaEntityTests.fail((String)"IllegalStateException not thrown");
    }

    public void testRemoveTableGenerator() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        resourceType.addAnnotation("javax.persistence.TableGenerator");
        this.getJpaProject().synchronizeContextModel();
        this.getJavaEntity().getGeneratorContainer().removeTableGenerator();
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getGeneratorContainer().getTableGenerator());
        JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.TableGenerator"));
        try {
            this.getJavaEntity().getGeneratorContainer().removeTableGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        JavaEntityTests.fail((String)"IllegalStateException not thrown");
    }

    public void testGetDiscriminatorColumn() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertNotNull((Object)this.getJavaEntity().getDiscriminatorColumn());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        DiscriminatorColumnAnnotation column = (DiscriminatorColumnAnnotation)resourceType.addAnnotation("javax.persistence.DiscriminatorColumn");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((String)"foo", (String)this.getJavaEntity().getDiscriminatorColumn().getSpecifiedName());
        column.setName(null);
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getDiscriminatorColumn().getSpecifiedName());
        resourceType.removeAnnotation("javax.persistence.DiscriminatorColumn");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertNotNull((Object)this.getJavaEntity().getDiscriminatorColumn());
    }

    public void testSpecifiedPrimaryKeyJoinColumns() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator specifiedPkJoinColumns = this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaEntityTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        PrimaryKeyJoinColumnAnnotation pkJoinColumn = (PrimaryKeyJoinColumnAnnotation)resourceType.addAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        pkJoinColumn.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedPkJoinColumns = this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        pkJoinColumn = (PrimaryKeyJoinColumnAnnotation)resourceType.addAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        pkJoinColumn.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedPkJoinColumns = this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        pkJoinColumn = (PrimaryKeyJoinColumnAnnotation)resourceType.addAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        pkJoinColumn.setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedPkJoinColumns = this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        resourceType.moveAnnotation(1, 0, "javax.persistence.PrimaryKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        specifiedPkJoinColumns = this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        resourceType.removeAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        specifiedPkJoinColumns = this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        resourceType.removeAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        specifiedPkJoinColumns = this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        resourceType.removeAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        specifiedPkJoinColumns = this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaEntityTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
    }

    public void testSpecifiedPrimaryKeyJoinColumnsSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((int)0, (int)this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumnsSize());
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAR");
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAZ");
        JavaEntityTests.assertEquals((int)3, (int)this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumnsSize());
    }

    public void testPrimaryKeyJoinColumnsSize() throws Exception {
        this.createTestEntity();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertEquals((int)1, (int)this.getJavaEntity().getPrimaryKeyJoinColumnsSize());
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAR");
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAZ");
        JavaEntityTests.assertEquals((int)3, (int)this.getJavaEntity().getPrimaryKeyJoinColumnsSize());
    }

    public void testGetDefaultPrimaryKeyJoinColumn() throws Exception {
        this.createTestEntity();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertNotNull((Object)this.getJavaEntity().getDefaultPrimaryKeyJoinColumn());
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAR");
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAZ");
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getDefaultPrimaryKeyJoinColumn());
    }

    public void testAddSpecifiedPrimaryKeyJoinColumn() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAR");
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ListIterator pkJoinColumns = resourceType.getAnnotations("javax.persistence.PrimaryKeyJoinColumn").iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)pkJoinColumns.hasNext());
    }

    public void testAddSpecifiedPrimaryKeyJoinColumn2() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(1).setSpecifiedName("BAR");
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ListIterator pkJoinColumns = resourceType.getAnnotations("javax.persistence.PrimaryKeyJoinColumn").iterator();
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)pkJoinColumns.hasNext());
    }

    public void testRemoveSpecifiedPrimaryKeyJoinColumn() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(1).setSpecifiedName("BAR");
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaEntityTests.assertEquals((int)3, (int)resourceType.getAnnotationsSize("javax.persistence.PrimaryKeyJoinColumn"));
        this.getJavaEntity().removeSpecifiedPrimaryKeyJoinColumn(1);
        ListIterator pkJoinColumnResources = resourceType.getAnnotations("javax.persistence.PrimaryKeyJoinColumn").iterator();
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumnResources.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumnResources.next()).getName());
        JavaEntityTests.assertFalse((boolean)pkJoinColumnResources.hasNext());
        ListIterator pkJoinColumns = this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedPrimaryKeyJoinColumn)pkJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedPrimaryKeyJoinColumn)pkJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)pkJoinColumns.hasNext());
        this.getJavaEntity().removeSpecifiedPrimaryKeyJoinColumn(1);
        pkJoinColumnResources = resourceType.getAnnotations("javax.persistence.PrimaryKeyJoinColumn").iterator();
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumnResources.next()).getName());
        JavaEntityTests.assertFalse((boolean)pkJoinColumnResources.hasNext());
        pkJoinColumns = this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedPrimaryKeyJoinColumn)pkJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)pkJoinColumns.hasNext());
        this.getJavaEntity().removeSpecifiedPrimaryKeyJoinColumn(0);
        pkJoinColumnResources = resourceType.getAnnotations("javax.persistence.PrimaryKeyJoinColumn").iterator();
        JavaEntityTests.assertFalse((boolean)pkJoinColumnResources.hasNext());
        pkJoinColumns = this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaEntityTests.assertFalse((boolean)pkJoinColumns.hasNext());
        JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.PrimaryKeyJoinColumn"));
    }

    public void testMoveSpecifiedPrimaryKeyJoinColumn() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        entity.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        entity.addSpecifiedPrimaryKeyJoinColumn(1).setSpecifiedName("BAR");
        entity.addSpecifiedPrimaryKeyJoinColumn(2).setSpecifiedName("BAZ");
        ListIterator javaPrimaryKeyJoinColumns = resourceType.getAnnotations("javax.persistence.PrimaryKeyJoinColumn").iterator();
        JavaEntityTests.assertEquals((int)3, (int)IteratorTools.size((Iterator)javaPrimaryKeyJoinColumns));
        entity.moveSpecifiedPrimaryKeyJoinColumn(2, 0);
        ListIterator primaryKeyJoinColumns = entity.getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        javaPrimaryKeyJoinColumns = resourceType.getAnnotations("javax.persistence.PrimaryKeyJoinColumn").iterator();
        JavaEntityTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumnAnnotation)javaPrimaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)javaPrimaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)javaPrimaryKeyJoinColumns.next()).getName());
        entity.moveSpecifiedPrimaryKeyJoinColumn(0, 1);
        primaryKeyJoinColumns = entity.getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        javaPrimaryKeyJoinColumns = resourceType.getAnnotations("javax.persistence.PrimaryKeyJoinColumn").iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)javaPrimaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumnAnnotation)javaPrimaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)javaPrimaryKeyJoinColumns.next()).getName());
    }

    public void testUpdateSpecifiedPrimaryKeyJoinColumns() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ((PrimaryKeyJoinColumnAnnotation)resourceType.addAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn")).setName("FOO");
        ((PrimaryKeyJoinColumnAnnotation)resourceType.addAnnotation(1, "javax.persistence.PrimaryKeyJoinColumn")).setName("BAR");
        ((PrimaryKeyJoinColumnAnnotation)resourceType.addAnnotation(2, "javax.persistence.PrimaryKeyJoinColumn")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator primaryKeyJoinColumns = entity.getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        resourceType.moveAnnotation(2, 0, "javax.persistence.PrimaryKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        primaryKeyJoinColumns = entity.getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        resourceType.moveAnnotation(0, 1, "javax.persistence.PrimaryKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        primaryKeyJoinColumns = entity.getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        resourceType.removeAnnotation(1, "javax.persistence.PrimaryKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        primaryKeyJoinColumns = entity.getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        resourceType.removeAnnotation(1, "javax.persistence.PrimaryKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        primaryKeyJoinColumns = entity.getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaEntityTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        resourceType.removeAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        primaryKeyJoinColumns = entity.getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaEntityTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
    }

    public void testPrimaryKeyJoinColumnIsVirtual() throws Exception {
        this.createTestEntity();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertTrue((boolean)this.getJavaEntity().getDefaultPrimaryKeyJoinColumn().isVirtual());
        this.getJavaEntity().addSpecifiedPrimaryKeyJoinColumn(0);
        SpecifiedPrimaryKeyJoinColumn specifiedPkJoinColumn = (SpecifiedPrimaryKeyJoinColumn)this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumns().iterator().next();
        JavaEntityTests.assertFalse((boolean)specifiedPkJoinColumn.isVirtual());
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getDefaultPrimaryKeyJoinColumn());
    }

    public void testTableNameIsInvalid() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertFalse((boolean)this.getJavaEntity().tableNameIsInvalid("AnnotationTestType"));
        JavaEntityTests.assertTrue((boolean)this.getJavaEntity().tableNameIsInvalid("FOO"));
        this.getJavaEntity().addSpecifiedSecondaryTable(0).setSpecifiedName("BAR");
        JavaEntityTests.assertFalse((boolean)this.getJavaEntity().tableNameIsInvalid("BAR"));
    }

    public void testAttributeMappingKeyAllowed() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = (Entity)this.getJavaPersistentType().getMapping();
        JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("basic"));
        JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("id"));
        JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("embedded"));
        JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("embeddedId"));
        JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("version"));
        JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("transient"));
        JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("oneToOne"));
        JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("manyToOne"));
        JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("oneToMany"));
        JavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("manyToMany"));
    }

    public void testOverridableAttributes() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAttributes = this.getJavaEntity().getOverridableAttributeNames().iterator();
        JavaEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
        this.getJavaEntity().setSpecifiedInheritanceStrategy(InheritanceType.TABLE_PER_CLASS);
        overridableAttributes = this.getJavaEntity().getOverridableAttributeNames().iterator();
        JavaEntityTests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
    }

    public void testOverridableAttributeNames() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAttributeNames = this.getJavaEntity().getOverridableAttributeNames().iterator();
        JavaEntityTests.assertFalse((boolean)overridableAttributeNames.hasNext());
        this.getJavaEntity().setSpecifiedInheritanceStrategy(InheritanceType.TABLE_PER_CLASS);
        overridableAttributeNames = this.getJavaEntity().getOverridableAttributeNames().iterator();
        JavaEntityTests.assertEquals((String)"id", (String)((String)overridableAttributeNames.next()));
        JavaEntityTests.assertEquals((String)"name", (String)((String)overridableAttributeNames.next()));
        JavaEntityTests.assertFalse((boolean)overridableAttributeNames.hasNext());
    }

    public void testAllOverridableAttributes() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAttributes = this.getJavaEntity().getAllOverridableAttributeNames().iterator();
        JavaEntityTests.assertEquals((String)"foo", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertEquals((String)"basic", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertEquals((String)"version", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
    }

    public void testAllOverridableAttributesTablePerClass() throws Exception {
        this.createTestAbstractEntityTablePerClass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAttributes = this.getJavaEntity().getAllOverridableAttributeNames().iterator();
        JavaEntityTests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertEquals((String)"foo", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        JavaEntity abstractEntity = (JavaEntity)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        overridableAttributes = abstractEntity.getAllOverridableAttributeNames().iterator();
        JavaEntityTests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertEquals((String)"foo", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
    }

    public void testAllOverridableAssociationsTablePerClass() throws Exception {
        this.createTestAbstractEntityTablePerClass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAssociations = this.getJavaEntity().getAllOverridableAssociationNames().iterator();
        JavaEntityTests.assertEquals((String)"address", (String)((String)overridableAssociations.next()));
        JavaEntityTests.assertEquals((String)"address2", (String)((String)overridableAssociations.next()));
        JavaEntityTests.assertFalse((boolean)overridableAssociations.hasNext());
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        JavaEntity abstractEntity = (JavaEntity)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        overridableAssociations = abstractEntity.getAllOverridableAssociationNames().iterator();
        JavaEntityTests.assertEquals((String)"address", (String)((String)overridableAssociations.next()));
        JavaEntityTests.assertEquals((String)"address2", (String)((String)overridableAssociations.next()));
        JavaEntityTests.assertFalse((boolean)overridableAssociations.hasNext());
    }

    public void testAllOverridableAttributesMappedSuperclassInOrmXml() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        Iterator overridableAttributes = this.getJavaEntity().getAllOverridableAttributeNames().iterator();
        JavaEntityTests.assertEquals((String)"foo", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertEquals((String)"basic", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertEquals((String)"version", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        JavaEntityTests.assertFalse((boolean)overridableAttributes.hasNext());
    }

    public void testAllOverridableAttributeNames() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAttributeNames = this.getJavaEntity().getAllOverridableAttributeNames().iterator();
        JavaEntityTests.assertEquals((String)"foo", (String)((String)overridableAttributeNames.next()));
        JavaEntityTests.assertEquals((String)"basic", (String)((String)overridableAttributeNames.next()));
        JavaEntityTests.assertEquals((String)"version", (String)((String)overridableAttributeNames.next()));
        JavaEntityTests.assertEquals((String)"id", (String)((String)overridableAttributeNames.next()));
        JavaEntityTests.assertEquals((String)"name", (String)((String)overridableAttributeNames.next()));
        JavaEntityTests.assertFalse((boolean)overridableAttributeNames.hasNext());
    }

    public void testSpecifiedAttributeOverrides() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        ListIterator specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceType.addAnnotation(1, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        resourceType.moveAnnotation(1, 0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        resourceType.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        resourceType.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        resourceType.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
    }

    public void testVirtualAttributeOverrideDefaults() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        JavaEntity javaEntity = (JavaEntity)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        JavaAttributeOverrideContainer overrideContainer = javaEntity.getAttributeOverrideContainer();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)resourceType.getName());
        JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AttributeOverride"));
        JavaEntityTests.assertEquals((int)5, (int)overrideContainer.getVirtualOverridesSize());
        VirtualAttributeOverride virtualAttributeOverride = (VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        JavaEntityTests.assertEquals((String)"foo", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertEquals((String)"foo", (String)virtualAttributeOverride.getColumn().getName());
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)virtualAttributeOverride.getColumn().getTableName());
        JavaEntityTests.assertEquals(null, (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        JavaEntityTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUnique());
        JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isNullable());
        JavaEntityTests.assertEquals((int)255, (int)virtualAttributeOverride.getColumn().getLength());
        JavaEntityTests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getPrecision());
        JavaEntityTests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getScale());
        MappedSuperclass mappedSuperclass = (MappedSuperclass)this.getJavaPersistentType().getMapping();
        BasicMapping fooMapping = (BasicMapping)mappedSuperclass.getPersistentType().getAttributeNamed("foo").getMapping();
        fooMapping.getColumn().setSpecifiedName("FOO");
        fooMapping.getColumn().setSpecifiedTableName("BAR");
        fooMapping.getColumn().setColumnDefinition("COLUMN_DEF");
        fooMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        fooMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        fooMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        fooMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        fooMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        fooMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        fooMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)resourceType.getName());
        JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AttributeOverride"));
        JavaEntityTests.assertEquals((int)5, (int)overrideContainer.getVirtualOverridesSize());
        virtualAttributeOverride = (VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        JavaEntityTests.assertEquals((String)"foo", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)virtualAttributeOverride.getColumn().getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)virtualAttributeOverride.getColumn().getTableName());
        JavaEntityTests.assertEquals((String)"COLUMN_DEF", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        JavaEntityTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        JavaEntityTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUnique());
        JavaEntityTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isNullable());
        JavaEntityTests.assertEquals((int)5, (int)virtualAttributeOverride.getColumn().getLength());
        JavaEntityTests.assertEquals((int)6, (int)virtualAttributeOverride.getColumn().getPrecision());
        JavaEntityTests.assertEquals((int)7, (int)virtualAttributeOverride.getColumn().getScale());
        fooMapping.getColumn().setSpecifiedName(null);
        fooMapping.getColumn().setSpecifiedTableName(null);
        fooMapping.getColumn().setColumnDefinition(null);
        fooMapping.getColumn().setSpecifiedInsertable(null);
        fooMapping.getColumn().setSpecifiedUpdatable(null);
        fooMapping.getColumn().setSpecifiedUnique(null);
        fooMapping.getColumn().setSpecifiedNullable(null);
        fooMapping.getColumn().setSpecifiedLength(null);
        fooMapping.getColumn().setSpecifiedPrecision(null);
        fooMapping.getColumn().setSpecifiedScale(null);
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)resourceType.getName());
        JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AttributeOverride"));
        virtualAttributeOverride = (VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        JavaEntityTests.assertEquals((String)"foo", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertEquals((String)"foo", (String)virtualAttributeOverride.getColumn().getName());
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)virtualAttributeOverride.getColumn().getTableName());
        JavaEntityTests.assertEquals(null, (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        JavaEntityTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUnique());
        JavaEntityTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isNullable());
        JavaEntityTests.assertEquals((int)255, (int)virtualAttributeOverride.getColumn().getLength());
        JavaEntityTests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getPrecision());
        JavaEntityTests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getScale());
        virtualAttributeOverride.convertToSpecified();
        JavaEntityTests.assertEquals((int)4, (int)overrideContainer.getVirtualOverridesSize());
    }

    public void testVirtualAttributeOverridesEntityHierachy() throws Exception {
        this.createTestAbstractEntityTablePerClass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        JavaEntity javaEntity = (JavaEntity)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        JavaAttributeOverrideContainer overrideContainer = javaEntity.getAttributeOverrideContainer();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)resourceType.getName());
        JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AttributeOverride"));
        JavaEntityTests.assertEquals((int)3, (int)overrideContainer.getVirtualOverridesSize());
        VirtualAttributeOverride virtualAttributeOverride = (VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getColumn().getName());
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)virtualAttributeOverride.getColumn().getTableName());
        JavaEntity superclass = (JavaEntity)this.getJavaPersistentType().getMapping();
        BasicMapping idMapping = (BasicMapping)superclass.getPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.getColumn().setSpecifiedTableName("BAR");
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)resourceType.getName());
        JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AttributeOverride"));
        JavaEntityTests.assertEquals((int)3, (int)overrideContainer.getVirtualOverridesSize());
        virtualAttributeOverride = (VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)virtualAttributeOverride.getColumn().getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)virtualAttributeOverride.getColumn().getTableName());
        idMapping.getColumn().setSpecifiedName(null);
        idMapping.getColumn().setSpecifiedTableName(null);
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)resourceType.getName());
        JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AttributeOverride"));
        virtualAttributeOverride = (VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getColumn().getName());
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)virtualAttributeOverride.getColumn().getTableName());
        virtualAttributeOverride.convertToSpecified();
        JavaEntityTests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
    }

    public void testSpecifiedAttributeOverridesSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        JavaEntityTests.assertEquals((int)0, (int)overrideContainer.getSpecifiedOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((int)2, (int)overrideContainer.getSpecifiedOverridesSize());
    }

    public void testVirtualAttributeOverridesSize() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        JavaEntityTests.assertEquals((int)5, (int)overrideContainer.getVirtualOverridesSize());
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaEntityTests.assertEquals((int)4, (int)overrideContainer.getVirtualOverridesSize());
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaEntityTests.assertEquals((int)3, (int)overrideContainer.getVirtualOverridesSize());
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaEntityTests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaEntityTests.assertEquals((int)1, (int)overrideContainer.getVirtualOverridesSize());
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaEntityTests.assertEquals((int)0, (int)overrideContainer.getVirtualOverridesSize());
    }

    public void testAttributeOverridesSize() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        JavaEntityTests.assertEquals((int)5, (int)overrideContainer.getOverridesSize());
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaEntityTests.assertEquals((int)5, (int)overrideContainer.getOverridesSize());
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaEntityTests.assertEquals((int)5, (int)overrideContainer.getOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.AstNodeType.TYPE);
        AttributeOverrideAnnotation annotation = (AttributeOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AttributeOverride");
        annotation.setName("bar");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((int)6, (int)overrideContainer.getOverridesSize());
    }

    public void testAttributeOverrideSetVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ListIterator attributeOverrides = resourceType.getAnnotations("javax.persistence.AttributeOverride").iterator();
        JavaEntityTests.assertEquals((String)"foo", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"basic", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testAttributeOverrideSetVirtual2() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        ListIterator virtualAttributeOverrides = overrideContainer.getVirtualOverrides().iterator();
        virtualAttributeOverrides.next();
        ((JavaVirtualAttributeOverride)virtualAttributeOverrides.next()).convertToSpecified();
        ((JavaVirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ListIterator attributeOverrides = resourceType.getAnnotations("javax.persistence.AttributeOverride").iterator();
        JavaEntityTests.assertEquals((String)"basic", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"foo", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testAttributeOverrideSetVirtualTrue() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        ((JavaVirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((JavaVirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((JavaVirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((JavaVirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaEntityTests.assertEquals((int)4, (int)IterableTools.size((Iterable)resourceType.getAnnotations("javax.persistence.AttributeOverride")));
        ((JavaSpecifiedAttributeOverride)overrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        ListIterator attributeOverrideResources = resourceType.getAnnotations("javax.persistence.AttributeOverride").iterator();
        JavaEntityTests.assertEquals((String)"basic", (String)((AttributeOverrideAnnotation)attributeOverrideResources.next()).getName());
        JavaEntityTests.assertEquals((String)"version", (String)((AttributeOverrideAnnotation)attributeOverrideResources.next()).getName());
        JavaEntityTests.assertEquals((String)"id", (String)((AttributeOverrideAnnotation)attributeOverrideResources.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrideResources.hasNext());
        ListIterator attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertEquals((String)"basic", (String)((JavaSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"version", (String)((JavaSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"id", (String)((JavaSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        ((JavaSpecifiedAttributeOverride)overrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        attributeOverrideResources = resourceType.getAnnotations("javax.persistence.AttributeOverride").iterator();
        JavaEntityTests.assertEquals((String)"version", (String)((AttributeOverrideAnnotation)attributeOverrideResources.next()).getName());
        JavaEntityTests.assertEquals((String)"id", (String)((AttributeOverrideAnnotation)attributeOverrideResources.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrideResources.hasNext());
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertEquals((String)"version", (String)((JavaSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"id", (String)((JavaSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        ((JavaSpecifiedAttributeOverride)overrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        attributeOverrideResources = resourceType.getAnnotations("javax.persistence.AttributeOverride").iterator();
        JavaEntityTests.assertEquals((String)"id", (String)((AttributeOverrideAnnotation)attributeOverrideResources.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrideResources.hasNext());
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertEquals((String)"id", (String)((JavaSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        ((JavaSpecifiedAttributeOverride)overrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        attributeOverrideResources = resourceType.getAnnotations("javax.persistence.AttributeOverride").iterator();
        JavaEntityTests.assertFalse((boolean)attributeOverrideResources.hasNext());
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AttributeOverride"));
    }

    public void testMoveSpecifiedAttributeOverride() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        ((JavaVirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((JavaVirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((JavaVirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((JavaVirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ListIterator javaAttributeOverrides = resourceType.getAnnotations("javax.persistence.AttributeOverride").iterator();
        JavaEntityTests.assertEquals((int)4, (int)IteratorTools.size((Iterator)javaAttributeOverrides));
        overrideContainer.moveSpecifiedOverride(2, 0);
        ListIterator attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertEquals((String)"basic", (String)((JavaSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"version", (String)((JavaSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"foo", (String)((JavaSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"id", (String)((JavaSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        javaAttributeOverrides = resourceType.getAnnotations("javax.persistence.AttributeOverride").iterator();
        JavaEntityTests.assertEquals((String)"basic", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"version", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"foo", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"id", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        overrideContainer.moveSpecifiedOverride(0, 1);
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertEquals((String)"version", (String)((JavaSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"basic", (String)((JavaSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"foo", (String)((JavaSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"id", (String)((JavaSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        javaAttributeOverrides = resourceType.getAnnotations("javax.persistence.AttributeOverride").iterator();
        JavaEntityTests.assertEquals((String)"version", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"basic", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"foo", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"id", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
    }

    public void testUpdateSpecifiedAttributeOverrides() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ((AttributeOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AttributeOverride")).setName("FOO");
        ((AttributeOverrideAnnotation)resourceType.addAnnotation(1, "javax.persistence.AttributeOverride")).setName("BAR");
        ((AttributeOverrideAnnotation)resourceType.addAnnotation(2, "javax.persistence.AttributeOverride")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        resourceType.moveAnnotation(2, 0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        resourceType.moveAnnotation(0, 1, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        resourceType.removeAnnotation(1, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        resourceType.removeAnnotation(1, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
        resourceType.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testAttributeOverrideIsVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        ListIterator virtualAttributeOverrides = overrideContainer.getVirtualOverrides().iterator();
        JavaVirtualAttributeOverride virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        JavaEntityTests.assertEquals((String)"foo", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        JavaEntityTests.assertEquals((String)"basic", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        JavaEntityTests.assertEquals((String)"version", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        JavaEntityTests.assertEquals((String)"name", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        JavaEntityTests.assertFalse((boolean)virtualAttributeOverrides.hasNext());
        ((JavaVirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        SpecifiedAttributeOverride specifiedAttributeOverride = (SpecifiedAttributeOverride)overrideContainer.getSpecifiedOverrides().iterator().next();
        JavaEntityTests.assertFalse((boolean)specifiedAttributeOverride.isVirtual());
        virtualAttributeOverrides = overrideContainer.getVirtualOverrides().iterator();
        virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        JavaEntityTests.assertEquals((String)"basic", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        JavaEntityTests.assertEquals((String)"version", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        JavaEntityTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        JavaEntityTests.assertEquals((String)"name", (String)virtualAttributeOverride.getName());
        JavaEntityTests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        JavaEntityTests.assertFalse((boolean)virtualAttributeOverrides.hasNext());
    }

    public void testOverridableAssociationNames() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAssociationNames = this.getJavaEntity().getOverridableAssociationNames().iterator();
        JavaEntityTests.assertFalse((boolean)overridableAssociationNames.hasNext());
    }

    public void testAllOverridableAssociationNames() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAssociationNames = this.getJavaEntity().getAllOverridableAssociationNames().iterator();
        JavaEntityTests.assertEquals((String)"oneToOne", (String)((String)overridableAssociationNames.next()));
        JavaEntityTests.assertEquals((String)"manyToOne", (String)((String)overridableAssociationNames.next()));
        JavaEntityTests.assertFalse((boolean)overridableAssociationNames.hasNext());
    }

    public void testAllOverridableAssociations() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAssociations = this.getJavaEntity().getAllOverridableAssociationNames().iterator();
        JavaEntityTests.assertEquals((String)"oneToOne", (String)((String)overridableAssociations.next()));
        JavaEntityTests.assertEquals((String)"manyToOne", (String)((String)overridableAssociations.next()));
        JavaEntityTests.assertFalse((boolean)overridableAssociations.hasNext());
    }

    public void testSpecifiedAssociationOverrides() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ListIterator specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AssociationOverride");
        associationOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        associationOverride = (AssociationOverrideAnnotation)resourceType.addAnnotation(1, "javax.persistence.AssociationOverride");
        associationOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        associationOverride = (AssociationOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AssociationOverride");
        associationOverride.setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        resourceType.moveAnnotation(1, 0, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        resourceType.removeAnnotation(0, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        resourceType.removeAnnotation(0, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        resourceType.removeAnnotation(0, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
    }

    public void testVirtualAssociationOverrideDefaults() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        JavaEntity javaEntity = (JavaEntity)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        JavaAssociationOverrideContainer overrideContainer = javaEntity.getAssociationOverrideContainer();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)resourceType.getName());
        JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AssociationOverride"));
        JavaEntityTests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
        VirtualAssociationOverride virtualAssociationOverride = (VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        JoinColumnRelationshipStrategy joiningStrategy = virtualAssociationOverride.getRelationship().getJoinColumnStrategy();
        JavaEntityTests.assertEquals((String)"oneToOne", (String)virtualAssociationOverride.getName());
        JavaEntityTests.assertEquals((int)1, (int)joiningStrategy.getJoinColumnsSize());
        JoinColumn virtualJoinColumn = (JoinColumn)joiningStrategy.getJoinColumns().iterator().next();
        JavaEntityTests.assertEquals((String)"oneToOne_id", (String)virtualJoinColumn.getName());
        JavaEntityTests.assertEquals((String)"id", (String)virtualJoinColumn.getReferencedColumnName());
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)virtualJoinColumn.getTableName());
        JavaEntityTests.assertEquals(null, (String)virtualJoinColumn.getColumnDefinition());
        JavaEntityTests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isInsertable());
        JavaEntityTests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isUpdatable());
        JavaEntityTests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isUnique());
        JavaEntityTests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isNullable());
        OneToOneMapping oneToOneMapping = (OneToOneMapping)this.getJavaPersistentType().getAttributeNamed("oneToOne").getMapping();
        SpecifiedJoinColumn joinColumn = oneToOneMapping.getRelationship().getJoinColumnStrategy().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("MY_JOIN_COLUMN");
        joinColumn.setSpecifiedReferencedColumnName("MY_REFERENCE_COLUMN");
        joinColumn.setSpecifiedTableName("BAR");
        joinColumn.setColumnDefinition("COLUMN_DEF");
        joinColumn.setSpecifiedInsertable(Boolean.FALSE);
        joinColumn.setSpecifiedUpdatable(Boolean.FALSE);
        joinColumn.setSpecifiedUnique(Boolean.TRUE);
        joinColumn.setSpecifiedNullable(Boolean.FALSE);
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)resourceType.getName());
        JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AssociationOverride"));
        JavaEntityTests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
        virtualAssociationOverride = (VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        joiningStrategy = virtualAssociationOverride.getRelationship().getJoinColumnStrategy();
        JavaEntityTests.assertEquals((String)"oneToOne", (String)virtualAssociationOverride.getName());
        JavaEntityTests.assertEquals((int)1, (int)joiningStrategy.getJoinColumnsSize());
        virtualAssociationOverride = (VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        virtualJoinColumn = (JoinColumn)joiningStrategy.getJoinColumns().iterator().next();
        JavaEntityTests.assertEquals((String)"MY_JOIN_COLUMN", (String)virtualJoinColumn.getName());
        JavaEntityTests.assertEquals((String)"MY_REFERENCE_COLUMN", (String)virtualJoinColumn.getReferencedColumnName());
        JavaEntityTests.assertEquals((String)"BAR", (String)virtualJoinColumn.getTableName());
        JavaEntityTests.assertEquals((String)"COLUMN_DEF", (String)virtualJoinColumn.getColumnDefinition());
        JavaEntityTests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isInsertable());
        JavaEntityTests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isUpdatable());
        JavaEntityTests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isUnique());
        JavaEntityTests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isNullable());
        JavaEntityTests.assertEquals((String)"MY_JOIN_COLUMN", (String)((JoinColumn)joiningStrategy.getJoinColumns().iterator().next()).getName());
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)resourceType.getName());
        JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AssociationOverride"));
        virtualAssociationOverride = (VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        JavaEntityTests.assertEquals((String)"oneToOne", (String)virtualAssociationOverride.getName());
        virtualAssociationOverride.convertToSpecified();
        JavaEntityTests.assertEquals((int)1, (int)overrideContainer.getVirtualOverridesSize());
    }

    public void testSpecifiedAssociationOverridesSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        JavaEntityTests.assertEquals((int)0, (int)overrideContainer.getSpecifiedOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AssociationOverride");
        associationOverride.setName("FOO");
        associationOverride = (AssociationOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AssociationOverride");
        associationOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((int)2, (int)overrideContainer.getSpecifiedOverridesSize());
    }

    public void testVirtualAssociationOverridesSize() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        JavaEntityTests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaEntityTests.assertEquals((int)1, (int)overrideContainer.getVirtualOverridesSize());
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaEntityTests.assertEquals((int)0, (int)overrideContainer.getVirtualOverridesSize());
    }

    public void testAssociationOverridesSize() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        JavaEntityTests.assertEquals((int)2, (int)overrideContainer.getOverridesSize());
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaEntityTests.assertEquals((int)2, (int)overrideContainer.getOverridesSize());
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaEntityTests.assertEquals((int)2, (int)overrideContainer.getOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.AstNodeType.TYPE);
        AssociationOverrideAnnotation annotation = (AssociationOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AssociationOverride");
        annotation.setName("bar");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((int)3, (int)overrideContainer.getOverridesSize());
    }

    public void testAssociationOverrideSetVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ListIterator associationOverrides = resourceType.getAnnotations("javax.persistence.AssociationOverride").iterator();
        JavaEntityTests.assertEquals((String)"oneToOne", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"manyToOne", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
    }

    public void testAssociationOverrideSetVirtual2() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ListIterator virtualAssociationOverrides = overrideContainer.getVirtualOverrides().iterator();
        virtualAssociationOverrides.next();
        ((JavaVirtualAssociationOverride)virtualAssociationOverrides.next()).convertToSpecified();
        ((JavaVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ListIterator associationOverrides = resourceType.getAnnotations("javax.persistence.AssociationOverride").iterator();
        JavaEntityTests.assertEquals((String)"manyToOne", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"oneToOne", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
    }

    public void testAssociationOverrideSetVirtualTrue() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ((JavaVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((JavaVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaEntityTests.assertEquals((int)2, (int)resourceType.getAnnotationsSize("javax.persistence.AssociationOverride"));
        ((JavaSpecifiedAssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        ListIterator associationOverrideResources = resourceType.getAnnotations("javax.persistence.AssociationOverride").iterator();
        JavaEntityTests.assertEquals((String)"manyToOne", (String)((AssociationOverrideAnnotation)associationOverrideResources.next()).getName());
        JavaEntityTests.assertFalse((boolean)associationOverrideResources.hasNext());
        ListIterator associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertEquals((String)"manyToOne", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        ((JavaSpecifiedAssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        associationOverrideResources = resourceType.getAnnotations("javax.persistence.AssociationOverride").iterator();
        JavaEntityTests.assertFalse((boolean)associationOverrideResources.hasNext());
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        JavaEntityTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.AssociationOverride"));
    }

    public void testMoveSpecifiedAssociationOverride() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ((JavaVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((JavaVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ListIterator javaAssociationOverrides = resourceType.getAnnotations("javax.persistence.AssociationOverride").iterator();
        JavaEntityTests.assertEquals((int)2, (int)IteratorTools.size((Iterator)javaAssociationOverrides));
        overrideContainer.moveSpecifiedOverride(1, 0);
        ListIterator associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertEquals((String)"manyToOne", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"oneToOne", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        javaAssociationOverrides = resourceType.getAnnotations("javax.persistence.AssociationOverride").iterator();
        JavaEntityTests.assertEquals((String)"manyToOne", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"oneToOne", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
        overrideContainer.moveSpecifiedOverride(0, 1);
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertEquals((String)"oneToOne", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"manyToOne", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        javaAssociationOverrides = resourceType.getAnnotations("javax.persistence.AssociationOverride").iterator();
        JavaEntityTests.assertEquals((String)"oneToOne", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"manyToOne", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
    }

    public void testUpdateSpecifiedAssociationOverrides() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ((AssociationOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AssociationOverride")).setName("FOO");
        ((AssociationOverrideAnnotation)resourceType.addAnnotation(1, "javax.persistence.AssociationOverride")).setName("BAR");
        ((AssociationOverrideAnnotation)resourceType.addAnnotation(2, "javax.persistence.AssociationOverride")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        resourceType.moveAnnotation(2, 0, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        resourceType.moveAnnotation(0, 1, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        resourceType.removeAnnotation(1, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        resourceType.removeAnnotation(1, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAssociationOverride)associationOverrides.next()).getName());
        JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
        resourceType.removeAnnotation(0, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        JavaEntityTests.assertFalse((boolean)associationOverrides.hasNext());
    }

    public void testAssociationOverrideIsVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ListIterator virtualAssociationOverrides = overrideContainer.getVirtualOverrides().iterator();
        JavaVirtualAssociationOverride virtualAssociationOverride = (JavaVirtualAssociationOverride)virtualAssociationOverrides.next();
        JavaEntityTests.assertEquals((String)"oneToOne", (String)virtualAssociationOverride.getName());
        JavaEntityTests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        virtualAssociationOverride = (JavaVirtualAssociationOverride)virtualAssociationOverrides.next();
        JavaEntityTests.assertEquals((String)"manyToOne", (String)virtualAssociationOverride.getName());
        JavaEntityTests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        JavaEntityTests.assertFalse((boolean)virtualAssociationOverrides.hasNext());
        ((JavaVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        SpecifiedAssociationOverride specifiedAssociationOverride = (SpecifiedAssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next();
        JavaEntityTests.assertFalse((boolean)specifiedAssociationOverride.isVirtual());
        virtualAssociationOverrides = overrideContainer.getVirtualOverrides().iterator();
        virtualAssociationOverride = (JavaVirtualAssociationOverride)virtualAssociationOverrides.next();
        JavaEntityTests.assertEquals((String)"manyToOne", (String)virtualAssociationOverride.getName());
        JavaEntityTests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        JavaEntityTests.assertFalse((boolean)virtualAssociationOverrides.hasNext());
    }

    public void testAddNamedQuery() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaNamedQuery namedQuery1 = entity.getQueryContainer().addNamedQuery(0);
        namedQuery1.setName("FOO");
        ListIterator javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedQuery").iterator();
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        JavaNamedQuery namedQuery2 = entity.getQueryContainer().addNamedQuery(0);
        namedQuery2.setName("BAR");
        javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedQuery").iterator();
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        JavaNamedQuery namedQuery3 = entity.getQueryContainer().addNamedQuery(1);
        namedQuery3.setName("BAZ");
        javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedQuery").iterator();
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        ListIterator namedQueries = entity.getQueryContainer().getNamedQueries().iterator();
        JavaEntityTests.assertEquals((Object)namedQuery2, namedQueries.next());
        JavaEntityTests.assertEquals((Object)namedQuery3, namedQueries.next());
        JavaEntityTests.assertEquals((Object)namedQuery1, namedQueries.next());
        namedQueries = entity.getQueryContainer().getNamedQueries().iterator();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaNamedQuery)namedQueries.next()).getName());
        entity.getQueryContainer().addNamedNativeQuery(0).setName("foo");
    }

    public void testInvalidNamedQueries() throws Exception {
        this.createTestEntityInvalidNamedQueries();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaEntityTests.assertEquals((int)1, (int)entity.getQueryContainer().getNamedQueriesSize());
    }

    public void testRemoveNamedQuery() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        entity.getQueryContainer().addNamedQuery(0).setName("FOO");
        entity.getQueryContainer().addNamedQuery(1).setName("BAR");
        entity.getQueryContainer().addNamedQuery(2).setName("BAZ");
        ListIterator javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedQuery").iterator();
        JavaEntityTests.assertEquals((int)3, (int)IteratorTools.size((Iterator)javaNamedQueries));
        entity.getQueryContainer().removeNamedQuery(0);
        javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedQuery").iterator();
        JavaEntityTests.assertEquals((int)2, (int)IteratorTools.size((Iterator)javaNamedQueries));
        javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedQuery").iterator();
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        entity.getQueryContainer().removeNamedQuery(0);
        javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedQuery").iterator();
        JavaEntityTests.assertEquals((int)1, (int)IteratorTools.size((Iterator)javaNamedQueries));
        javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedQuery").iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        entity.getQueryContainer().removeNamedQuery(0);
        javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedQuery").iterator();
        JavaEntityTests.assertEquals((int)0, (int)IteratorTools.size((Iterator)javaNamedQueries));
    }

    public void testAddNamedNativeQueryWithNamedQuery() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        entity.getQueryContainer().addNamedQuery(0).setName("FOO");
        NamedNativeQueryAnnotation nativeQuery = (NamedNativeQueryAnnotation)resourceType.addAnnotation(0, "javax.persistence.NamedNativeQuery");
        nativeQuery.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((int)1, (int)entity.getQueryContainer().getNamedNativeQueriesSize());
        ListIterator namedQueries = entity.getQueryContainer().getNamedNativeQueries().iterator();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
    }

    public void testAddNamedQueryWithNamedNativeQuery() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        entity.getQueryContainer().addNamedNativeQuery(0).setName("FOO");
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)resourceType.addAnnotation(0, "javax.persistence.NamedQuery");
        namedQuery.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((int)1, (int)entity.getQueryContainer().getNamedQueriesSize());
        ListIterator namedQueries = entity.getQueryContainer().getNamedQueries().iterator();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaNamedQuery)namedQueries.next()).getName());
    }

    public void testMoveNamedQuery() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        entity.getQueryContainer().addNamedQuery(0).setName("FOO");
        entity.getQueryContainer().addNamedQuery(1).setName("BAR");
        entity.getQueryContainer().addNamedQuery(2).setName("BAZ");
        ListIterator javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedQuery").iterator();
        JavaEntityTests.assertEquals((int)3, (int)IteratorTools.size((Iterator)javaNamedQueries));
        entity.getQueryContainer().moveNamedQuery(2, 0);
        ListIterator namedQueries = entity.getQueryContainer().getNamedQueries().iterator();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaNamedQuery)namedQueries.next()).getName());
        javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedQuery").iterator();
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        entity.getQueryContainer().moveNamedQuery(0, 1);
        namedQueries = entity.getQueryContainer().getNamedQueries().iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaNamedQuery)namedQueries.next()).getName());
        javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedQuery").iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedQueryAnnotation)javaNamedQueries.next()).getName());
    }

    public void testUpdateNamedQueries() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaEntityTests.assertEquals((int)0, (int)entity.getPersistenceUnit().getQueriesSize());
        ((NamedQueryAnnotation)resourceType.addAnnotation(0, "javax.persistence.NamedQuery")).setName("FOO");
        ((NamedQueryAnnotation)resourceType.addAnnotation(1, "javax.persistence.NamedQuery")).setName("BAR");
        ((NamedQueryAnnotation)resourceType.addAnnotation(2, "javax.persistence.NamedQuery")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator namedQueries = entity.getQueryContainer().getNamedQueries().iterator();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        JavaEntityTests.assertEquals((int)3, (int)entity.getPersistenceUnit().getQueriesSize());
        resourceType.moveAnnotation(2, 0, "javax.persistence.NamedQuery");
        this.getJpaProject().synchronizeContextModel();
        namedQueries = entity.getQueryContainer().getNamedQueries().iterator();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        resourceType.moveAnnotation(0, 1, "javax.persistence.NamedQuery");
        this.getJpaProject().synchronizeContextModel();
        namedQueries = entity.getQueryContainer().getNamedQueries().iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        resourceType.removeAnnotation(1, "javax.persistence.NamedQuery");
        this.getJpaProject().synchronizeContextModel();
        namedQueries = entity.getQueryContainer().getNamedQueries().iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        JavaEntityTests.assertEquals((int)2, (int)entity.getPersistenceUnit().getQueriesSize());
        resourceType.removeAnnotation(1, "javax.persistence.NamedQuery");
        this.getJpaProject().synchronizeContextModel();
        namedQueries = entity.getQueryContainer().getNamedQueries().iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedQuery)namedQueries.next()).getName());
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        JavaEntityTests.assertEquals((int)1, (int)entity.getPersistenceUnit().getQueriesSize());
        resourceType.removeAnnotation(0, "javax.persistence.NamedQuery");
        this.getJpaProject().synchronizeContextModel();
        namedQueries = entity.getQueryContainer().getNamedQueries().iterator();
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        JavaEntityTests.assertEquals((int)0, (int)entity.getPersistenceUnit().getQueriesSize());
    }

    public void testNamedQueriesSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaEntityTests.assertEquals((int)0, (int)entity.getQueryContainer().getNamedQueriesSize());
        ((NamedQueryAnnotation)resourceType.addAnnotation(0, "javax.persistence.NamedQuery")).setName("FOO");
        ((NamedQueryAnnotation)resourceType.addAnnotation(1, "javax.persistence.NamedQuery")).setName("BAR");
        ((NamedQueryAnnotation)resourceType.addAnnotation(2, "javax.persistence.NamedQuery")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((int)3, (int)entity.getQueryContainer().getNamedQueriesSize());
    }

    public void testAddNamedNativeQuery() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaNamedNativeQuery namedNativeQuery = entity.getQueryContainer().addNamedNativeQuery(0);
        namedNativeQuery.setName("FOO");
        ListIterator javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedNativeQuery").iterator();
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        JavaNamedNativeQuery namedNativeQuery2 = entity.getQueryContainer().addNamedNativeQuery(0);
        namedNativeQuery2.setName("BAR");
        javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedNativeQuery").iterator();
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        JavaNamedNativeQuery namedNativeQuery3 = entity.getQueryContainer().addNamedNativeQuery(1);
        namedNativeQuery3.setName("BAZ");
        javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedNativeQuery").iterator();
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        ListIterator namedQueries = entity.getQueryContainer().getNamedNativeQueries().iterator();
        JavaEntityTests.assertEquals((Object)namedNativeQuery2, namedQueries.next());
        JavaEntityTests.assertEquals((Object)namedNativeQuery3, namedQueries.next());
        JavaEntityTests.assertEquals((Object)namedNativeQuery, namedQueries.next());
        namedQueries = entity.getQueryContainer().getNamedNativeQueries().iterator();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
    }

    public void testRemoveNamedNativeQuery() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        entity.getQueryContainer().addNamedNativeQuery(0).setName("FOO");
        entity.getQueryContainer().addNamedNativeQuery(1).setName("BAR");
        entity.getQueryContainer().addNamedNativeQuery(2).setName("BAZ");
        ListIterator javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedNativeQuery").iterator();
        JavaEntityTests.assertEquals((int)3, (int)IteratorTools.size((Iterator)javaNamedQueries));
        entity.getQueryContainer().removeNamedNativeQuery(0);
        javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedNativeQuery").iterator();
        JavaEntityTests.assertEquals((int)2, (int)IteratorTools.size((Iterator)javaNamedQueries));
        javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedNativeQuery").iterator();
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        entity.getQueryContainer().removeNamedNativeQuery(0);
        javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedNativeQuery").iterator();
        JavaEntityTests.assertEquals((int)1, (int)IteratorTools.size((Iterator)javaNamedQueries));
        javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedNativeQuery").iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        entity.getQueryContainer().removeNamedNativeQuery(0);
        javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedNativeQuery").iterator();
        JavaEntityTests.assertEquals((int)0, (int)IteratorTools.size((Iterator)javaNamedQueries));
    }

    public void testMoveNamedNativeQuery() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        entity.getQueryContainer().addNamedNativeQuery(0).setName("FOO");
        entity.getQueryContainer().addNamedNativeQuery(1).setName("BAR");
        entity.getQueryContainer().addNamedNativeQuery(2).setName("BAZ");
        ListIterator javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedNativeQuery").iterator();
        JavaEntityTests.assertEquals((int)3, (int)IteratorTools.size((Iterator)javaNamedQueries));
        entity.getQueryContainer().moveNamedNativeQuery(2, 0);
        ListIterator namedQueries = entity.getQueryContainer().getNamedNativeQueries().iterator();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedNativeQuery").iterator();
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        entity.getQueryContainer().moveNamedNativeQuery(0, 1);
        namedQueries = entity.getQueryContainer().getNamedNativeQueries().iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedNativeQuery").iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((NamedNativeQueryAnnotation)javaNamedQueries.next()).getName());
    }

    public void testUpdateNamedNativeQueries() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaEntityTests.assertEquals((int)0, (int)entity.getPersistenceUnit().getQueriesSize());
        ((NamedNativeQueryAnnotation)resourceType.addAnnotation(0, "javax.persistence.NamedNativeQuery")).setName("FOO");
        ((NamedNativeQueryAnnotation)resourceType.addAnnotation(1, "javax.persistence.NamedNativeQuery")).setName("BAR");
        ((NamedNativeQueryAnnotation)resourceType.addAnnotation(2, "javax.persistence.NamedNativeQuery")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator namedQueries = entity.getQueryContainer().getNamedNativeQueries().iterator();
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        JavaEntityTests.assertEquals((int)3, (int)entity.getPersistenceUnit().getQueriesSize());
        resourceType.moveAnnotation(2, 0, "javax.persistence.NamedNativeQuery");
        this.getJpaProject().synchronizeContextModel();
        namedQueries = entity.getQueryContainer().getNamedNativeQueries().iterator();
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        resourceType.moveAnnotation(0, 1, "javax.persistence.NamedNativeQuery");
        this.getJpaProject().synchronizeContextModel();
        namedQueries = entity.getQueryContainer().getNamedNativeQueries().iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"BAR", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        resourceType.removeAnnotation(1, "javax.persistence.NamedNativeQuery");
        this.getJpaProject().synchronizeContextModel();
        namedQueries = entity.getQueryContainer().getNamedNativeQueries().iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertEquals((String)"FOO", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        JavaEntityTests.assertEquals((int)2, (int)entity.getPersistenceUnit().getQueriesSize());
        resourceType.removeAnnotation(1, "javax.persistence.NamedNativeQuery");
        this.getJpaProject().synchronizeContextModel();
        namedQueries = entity.getQueryContainer().getNamedNativeQueries().iterator();
        JavaEntityTests.assertEquals((String)"BAZ", (String)((JavaNamedNativeQuery)namedQueries.next()).getName());
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        JavaEntityTests.assertEquals((int)1, (int)entity.getPersistenceUnit().getQueriesSize());
        resourceType.removeAnnotation(0, "javax.persistence.NamedNativeQuery");
        this.getJpaProject().synchronizeContextModel();
        namedQueries = entity.getQueryContainer().getNamedNativeQueries().iterator();
        JavaEntityTests.assertFalse((boolean)namedQueries.hasNext());
        JavaEntityTests.assertEquals((int)0, (int)entity.getPersistenceUnit().getQueriesSize());
    }

    public void testNamedNativeQueriesSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaEntityTests.assertEquals((int)0, (int)entity.getQueryContainer().getNamedNativeQueriesSize());
        ((NamedNativeQueryAnnotation)resourceType.addAnnotation(0, "javax.persistence.NamedNativeQuery")).setName("FOO");
        ((NamedNativeQueryAnnotation)resourceType.addAnnotation(1, "javax.persistence.NamedNativeQuery")).setName("BAR");
        ((NamedNativeQueryAnnotation)resourceType.addAnnotation(2, "javax.persistence.NamedNativeQuery")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((int)3, (int)entity.getQueryContainer().getNamedNativeQueriesSize());
    }

    public void testUpdateIdClass() throws Exception {
        this.createTestEntity();
        this.createTestIdClass();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getIdClassReference().getSpecifiedIdClassName());
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getIdClassReference().getIdClass());
        JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.IdClass"));
        IdClassAnnotation idClassAnnotation = (IdClassAnnotation)resourceType.addAnnotation("javax.persistence.IdClass");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getIdClassReference().getSpecifiedIdClassName());
        JavaEntityTests.assertNotNull((Object)resourceType.getAnnotation("javax.persistence.IdClass"));
        String nonExistentIdClassName = "test.Foo";
        idClassAnnotation.setValue(nonExistentIdClassName);
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((String)nonExistentIdClassName, (String)this.getJavaEntity().getIdClassReference().getSpecifiedIdClassName());
        JavaEntityTests.assertEquals((String)nonExistentIdClassName, (String)((IdClassAnnotation)resourceType.getAnnotation("javax.persistence.IdClass")).getValue());
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getIdClassReference().getIdClass());
        String existentIdClassName = "test.TestTypeId";
        idClassAnnotation.setValue(existentIdClassName);
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertEquals((String)existentIdClassName, (String)this.getJavaEntity().getIdClassReference().getSpecifiedIdClassName());
        JavaEntityTests.assertEquals((String)existentIdClassName, (String)((IdClassAnnotation)resourceType.getAnnotation("javax.persistence.IdClass")).getValue());
        JavaEntityTests.assertNotNull((Object)this.getJavaEntity().getIdClassReference().getIdClass());
        idClassAnnotation.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getIdClassReference().getSpecifiedIdClassName());
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getIdClassReference().getIdClass());
        idClassAnnotation = (IdClassAnnotation)resourceType.addAnnotation("javax.persistence.IdClass");
        idClassAnnotation.setValue(existentIdClassName);
        resourceType.removeAnnotation("javax.persistence.IdClass");
        this.getJpaProject().synchronizeContextModel();
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getIdClassReference().getSpecifiedIdClassName());
        JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.IdClass"));
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getIdClassReference().getIdClass());
    }

    public void testModifyIdClass() throws Exception {
        this.createTestEntity();
        this.createTestIdClass();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getIdClassReference().getSpecifiedIdClassName());
        JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.IdClass"));
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getIdClassReference().getIdClass());
        String nonExistentIdClassName = "test.Foo";
        this.getJavaEntity().getIdClassReference().setSpecifiedIdClassName(nonExistentIdClassName);
        JavaEntityTests.assertEquals((String)nonExistentIdClassName, (String)((IdClassAnnotation)resourceType.getAnnotation("javax.persistence.IdClass")).getValue());
        JavaEntityTests.assertEquals((String)nonExistentIdClassName, (String)this.getJavaEntity().getIdClassReference().getSpecifiedIdClassName());
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getIdClassReference().getIdClass());
        String existentIdClassName = "test.TestTypeId";
        this.getJavaEntity().getIdClassReference().setSpecifiedIdClassName(existentIdClassName);
        JavaEntityTests.assertEquals((String)existentIdClassName, (String)((IdClassAnnotation)resourceType.getAnnotation("javax.persistence.IdClass")).getValue());
        JavaEntityTests.assertEquals((String)existentIdClassName, (String)this.getJavaEntity().getIdClassReference().getSpecifiedIdClassName());
        JavaEntityTests.assertNotNull((Object)this.getJavaEntity().getIdClassReference().getIdClass());
        this.getJavaEntity().getIdClassReference().setSpecifiedIdClassName(null);
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getIdClassReference().getSpecifiedIdClassName());
        JavaEntityTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.IdClass"));
        JavaEntityTests.assertNull((Object)this.getJavaEntity().getIdClassReference().getIdClass());
    }

    public void testGetPrimaryKeyColumnNameWithAttributeOverride() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        JavaPersistentType entityPersistentType = ((ClassRef)classRefs.next()).getJavaPersistentType();
        JavaEntity javaEntity = (JavaEntity)entityPersistentType.getMapping();
        JavaPersistentType mappedSuperclassPersistentType = ((ClassRef)classRefs.next()).getJavaPersistentType();
        JavaEntityTests.assertEquals((String)"id", (String)javaEntity.getPrimaryKeyColumnName());
        ((JavaIdMapping)mappedSuperclassPersistentType.getAttributeNamed("id").getMapping()).getColumn().setSpecifiedName("MY_ID");
        JavaEntityTests.assertEquals((String)"MY_ID", (String)javaEntity.getPrimaryKeyColumnName());
        ListIterator virtualAttributeOverrides = javaEntity.getAttributeOverrideContainer().getVirtualOverrides().iterator();
        virtualAttributeOverrides.next();
        virtualAttributeOverrides.next();
        virtualAttributeOverrides.next();
        JavaVirtualAttributeOverride virtualOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        JavaEntityTests.assertEquals((String)"id", (String)virtualOverride.getName());
        virtualOverride.convertToSpecified().getColumn().setSpecifiedName("ID");
        JavaEntityTests.assertEquals((String)"ID", (String)javaEntity.getPrimaryKeyColumnName());
    }

    public void testDiscriminatorValueIsUndefinedConcreteClass() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertTrue((boolean)this.getJavaEntity().discriminatorValueIsUndefined());
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        JavaEntityTests.assertFalse((boolean)this.getJavaEntity().discriminatorValueIsUndefined());
    }

    public void testDiscriminatorValueIsUndefinedAbstractClass() throws Exception {
        this.createTestAbstractEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntityTests.assertTrue((boolean)this.getJavaEntity().discriminatorValueIsUndefined());
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        JavaEntityTests.assertTrue((boolean)this.getJavaEntity().discriminatorValueIsUndefined());
    }

    public void testSpecifiedDiscriminatorColumnIsAllowed() throws Exception {
        this.createAbstractTestEntity();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator specifiedClassRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        Entity concreteEntity = (Entity)((ClassRef)specifiedClassRefs.next()).getJavaPersistentType().getMapping();
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)concreteEntity.getName());
        Entity abstractEntity = (Entity)((ClassRef)specifiedClassRefs.next()).getJavaPersistentType().getMapping();
        JavaEntityTests.assertEquals((String)"AnnotationTestType", (String)abstractEntity.getName());
        JavaEntityTests.assertFalse((boolean)concreteEntity.specifiedDiscriminatorColumnIsAllowed());
        JavaEntityTests.assertFalse((boolean)abstractEntity.specifiedDiscriminatorColumnIsAllowed());
        abstractEntity.setSpecifiedInheritanceStrategy(null);
        JavaEntityTests.assertFalse((boolean)concreteEntity.specifiedDiscriminatorColumnIsAllowed());
        JavaEntityTests.assertTrue((boolean)abstractEntity.specifiedDiscriminatorColumnIsAllowed());
    }

    public void testAbstractEntityGetDefaultDiscriminatorColumnNameTablePerClassInheritance() throws Exception {
        this.createAbstractTestEntity();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator specifiedClassRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        Entity concreteEntity = (Entity)((ClassRef)specifiedClassRefs.next()).getJavaPersistentType().getMapping();
        JavaEntityTests.assertEquals((String)SUB_TYPE_NAME, (String)concreteEntity.getName());
        Entity abstractEntity = (Entity)((ClassRef)specifiedClassRefs.next()).getJavaPersistentType().getMapping();
        JavaEntityTests.assertEquals((String)"AnnotationTestType", (String)abstractEntity.getName());
        JavaEntityTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)abstractEntity.getSpecifiedInheritanceStrategy());
        JavaEntityTests.assertEquals(null, (Object)concreteEntity.getSpecifiedInheritanceStrategy());
        JavaEntityTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)concreteEntity.getDefaultInheritanceStrategy());
        JavaEntityTests.assertTrue((boolean)abstractEntity.discriminatorValueIsUndefined());
        JavaEntityTests.assertFalse((boolean)concreteEntity.specifiedDiscriminatorColumnIsAllowed());
        JavaEntityTests.assertEquals(null, (String)abstractEntity.getDiscriminatorColumn().getDefaultName());
        JavaEntityTests.assertEquals(null, (String)concreteEntity.getDiscriminatorColumn().getDefaultName());
        JavaEntityTests.assertTrue((boolean)abstractEntity.discriminatorValueIsUndefined());
        JavaEntityTests.assertEquals(null, (String)abstractEntity.getDefaultDiscriminatorValue());
        JavaEntityTests.assertTrue((boolean)concreteEntity.discriminatorValueIsUndefined());
        JavaEntityTests.assertEquals(null, (String)concreteEntity.getDefaultDiscriminatorValue());
    }
}

