/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.orm;

import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.InheritanceType;
import org.eclipse.jpt.jpa.core.context.SpecifiedDiscriminatorColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmEntity;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedDiscriminatorColumn;
import org.eclipse.jpt.jpa.core.resource.orm.DiscriminatorType;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class OrmDiscriminatorColumnTests
extends ContextModelTestCase {
    public OrmDiscriminatorColumnTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private void createTestAbstractEntity() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public abstract class ").append("AnnotationTestType").append(" ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestType.java", sourceWriter);
    }

    private void createTestSubType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("AnnotationTestTypeChild").append(" ");
                sb.append("extends AnnotationTestType ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestTypeChild.java", sourceWriter);
    }

    public void testUpdateSpecifiedName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmSpecifiedDiscriminatorColumn ormColumn = ormEntity.getDiscriminatorColumn();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
        entityResource.setDiscriminatorColumn(OrmFactory.eINSTANCE.createXmlDiscriminatorColumn());
        entityResource.getDiscriminatorColumn().setName("FOO");
        OrmDiscriminatorColumnTests.assertEquals((String)"FOO", (String)ormColumn.getSpecifiedName());
        OrmDiscriminatorColumnTests.assertEquals((String)"FOO", (String)entityResource.getDiscriminatorColumn().getName());
        entityResource.getDiscriminatorColumn().setName(null);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn().getName());
        entityResource.getDiscriminatorColumn().setName("FOO");
        OrmDiscriminatorColumnTests.assertEquals((String)"FOO", (String)ormColumn.getSpecifiedName());
        OrmDiscriminatorColumnTests.assertEquals((String)"FOO", (String)entityResource.getDiscriminatorColumn().getName());
        entityResource.setDiscriminatorColumn(null);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
    }

    public void testModifySpecifiedName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmSpecifiedDiscriminatorColumn ormColumn = ormEntity.getDiscriminatorColumn();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
        ormColumn.setSpecifiedName("foo");
        OrmDiscriminatorColumnTests.assertEquals((String)"foo", (String)ormColumn.getSpecifiedName());
        OrmDiscriminatorColumnTests.assertEquals((String)"foo", (String)entityResource.getDiscriminatorColumn().getName());
        ormColumn.setSpecifiedName(null);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
    }

    public void testUpdateSpecifiedLength() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmSpecifiedDiscriminatorColumn ormColumn = ormEntity.getDiscriminatorColumn();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
        entityResource.setDiscriminatorColumn(OrmFactory.eINSTANCE.createXmlDiscriminatorColumn());
        entityResource.getDiscriminatorColumn().setLength(Integer.valueOf(8));
        OrmDiscriminatorColumnTests.assertEquals((Object)8, (Object)ormColumn.getSpecifiedLength());
        OrmDiscriminatorColumnTests.assertEquals((Object)8, (Object)entityResource.getDiscriminatorColumn().getLength());
        entityResource.getDiscriminatorColumn().setLength(null);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn().getLength());
        entityResource.getDiscriminatorColumn().setLength(Integer.valueOf(11));
        OrmDiscriminatorColumnTests.assertEquals((Object)11, (Object)ormColumn.getSpecifiedLength());
        OrmDiscriminatorColumnTests.assertEquals((Object)11, (Object)entityResource.getDiscriminatorColumn().getLength());
        entityResource.setDiscriminatorColumn(null);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
    }

    public void testModifySpecifiedLength() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmSpecifiedDiscriminatorColumn ormColumn = ormEntity.getDiscriminatorColumn();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
        ormColumn.setSpecifiedLength(Integer.valueOf(7));
        OrmDiscriminatorColumnTests.assertEquals((Object)7, (Object)ormColumn.getSpecifiedLength());
        OrmDiscriminatorColumnTests.assertEquals((Object)7, (Object)entityResource.getDiscriminatorColumn().getLength());
        ormColumn.setSpecifiedLength(null);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
    }

    public void testUpdateSpecifiedColumnDefinition() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmSpecifiedDiscriminatorColumn ormColumn = ormEntity.getDiscriminatorColumn();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
        entityResource.setDiscriminatorColumn(OrmFactory.eINSTANCE.createXmlDiscriminatorColumn());
        entityResource.getDiscriminatorColumn().setColumnDefinition("FOO");
        OrmDiscriminatorColumnTests.assertEquals((String)"FOO", (String)ormColumn.getColumnDefinition());
        OrmDiscriminatorColumnTests.assertEquals((String)"FOO", (String)entityResource.getDiscriminatorColumn().getColumnDefinition());
        entityResource.getDiscriminatorColumn().setColumnDefinition(null);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn().getColumnDefinition());
        entityResource.getDiscriminatorColumn().setColumnDefinition("FOO");
        OrmDiscriminatorColumnTests.assertEquals((String)"FOO", (String)ormColumn.getColumnDefinition());
        OrmDiscriminatorColumnTests.assertEquals((String)"FOO", (String)entityResource.getDiscriminatorColumn().getColumnDefinition());
        entityResource.setDiscriminatorColumn(null);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
    }

    public void testModifySpecifiedColumnDefinition() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmSpecifiedDiscriminatorColumn ormColumn = ormEntity.getDiscriminatorColumn();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
        ormColumn.setColumnDefinition("foo");
        OrmDiscriminatorColumnTests.assertEquals((String)"foo", (String)ormColumn.getColumnDefinition());
        OrmDiscriminatorColumnTests.assertEquals((String)"foo", (String)entityResource.getDiscriminatorColumn().getColumnDefinition());
        ormColumn.setColumnDefinition(null);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
    }

    public void testUpdateSpecifiedDiscriminatorType() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmSpecifiedDiscriminatorColumn ormColumn = ormEntity.getDiscriminatorColumn();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getSpecifiedDiscriminatorType());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
        entityResource.setDiscriminatorColumn(OrmFactory.eINSTANCE.createXmlDiscriminatorColumn());
        entityResource.getDiscriminatorColumn().setDiscriminatorType(DiscriminatorType.STRING);
        OrmDiscriminatorColumnTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.DiscriminatorType.STRING, (Object)ormColumn.getSpecifiedDiscriminatorType());
        OrmDiscriminatorColumnTests.assertEquals((Object)DiscriminatorType.STRING, (Object)entityResource.getDiscriminatorColumn().getDiscriminatorType());
        entityResource.getDiscriminatorColumn().setDiscriminatorType(null);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getSpecifiedDiscriminatorType());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn().getDiscriminatorType());
        entityResource.getDiscriminatorColumn().setDiscriminatorType(DiscriminatorType.CHAR);
        OrmDiscriminatorColumnTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.DiscriminatorType.CHAR, (Object)ormColumn.getSpecifiedDiscriminatorType());
        OrmDiscriminatorColumnTests.assertEquals((Object)DiscriminatorType.CHAR, (Object)entityResource.getDiscriminatorColumn().getDiscriminatorType());
        entityResource.setDiscriminatorColumn(null);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getSpecifiedDiscriminatorType());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
    }

    public void testModifySpecifiedDiscriminatorType() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmSpecifiedDiscriminatorColumn ormColumn = ormEntity.getDiscriminatorColumn();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getSpecifiedDiscriminatorType());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
        ormColumn.setSpecifiedDiscriminatorType(org.eclipse.jpt.jpa.core.context.DiscriminatorType.STRING);
        OrmDiscriminatorColumnTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.DiscriminatorType.STRING, (Object)ormColumn.getSpecifiedDiscriminatorType());
        OrmDiscriminatorColumnTests.assertEquals((Object)DiscriminatorType.STRING, (Object)entityResource.getDiscriminatorColumn().getDiscriminatorType());
        ormColumn.setSpecifiedDiscriminatorType(null);
        OrmDiscriminatorColumnTests.assertNull((Object)ormColumn.getSpecifiedDiscriminatorType());
        OrmDiscriminatorColumnTests.assertNull((Object)entityResource.getDiscriminatorColumn());
    }

    public void testDefaultsNoDiscriminatorColumnInJava() throws Exception {
        this.createTestAbstractEntity();
        this.createTestSubType();
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity abstractEntity = (OrmEntity)persistentType.getMapping();
        OrmPersistentType childPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestTypeChild");
        OrmEntity childEntity = (OrmEntity)childPersistentType.getMapping();
        OrmDiscriminatorColumnTests.assertEquals((Object)InheritanceType.SINGLE_TABLE, (Object)abstractEntity.getDefaultInheritanceStrategy());
        OrmDiscriminatorColumnTests.assertEquals((String)"DTYPE", (String)abstractEntity.getDiscriminatorColumn().getDefaultName());
        OrmDiscriminatorColumnTests.assertEquals((int)31, (int)abstractEntity.getDiscriminatorColumn().getDefaultLength());
        OrmDiscriminatorColumnTests.assertEquals((Object)SpecifiedDiscriminatorColumn.DEFAULT_DISCRIMINATOR_TYPE, (Object)abstractEntity.getDiscriminatorColumn().getDefaultDiscriminatorType());
        OrmDiscriminatorColumnTests.assertEquals((Object)InheritanceType.SINGLE_TABLE, (Object)childEntity.getDefaultInheritanceStrategy());
        OrmDiscriminatorColumnTests.assertEquals((String)"DTYPE", (String)childEntity.getDiscriminatorColumn().getDefaultName());
        OrmDiscriminatorColumnTests.assertEquals((int)31, (int)childEntity.getDiscriminatorColumn().getDefaultLength());
        OrmDiscriminatorColumnTests.assertEquals((Object)SpecifiedDiscriminatorColumn.DEFAULT_DISCRIMINATOR_TYPE, (Object)childEntity.getDiscriminatorColumn().getDefaultDiscriminatorType());
        abstractEntity.getDiscriminatorColumn().setSpecifiedName("DTYPE2");
        abstractEntity.getDiscriminatorColumn().setSpecifiedLength(Integer.valueOf(5));
        abstractEntity.getDiscriminatorColumn().setSpecifiedDiscriminatorType(org.eclipse.jpt.jpa.core.context.DiscriminatorType.CHAR);
        OrmDiscriminatorColumnTests.assertEquals((Object)InheritanceType.SINGLE_TABLE, (Object)abstractEntity.getDefaultInheritanceStrategy());
        OrmDiscriminatorColumnTests.assertEquals((String)"DTYPE", (String)abstractEntity.getDiscriminatorColumn().getDefaultName());
        OrmDiscriminatorColumnTests.assertEquals((int)31, (int)abstractEntity.getDiscriminatorColumn().getDefaultLength());
        OrmDiscriminatorColumnTests.assertEquals((Object)SpecifiedDiscriminatorColumn.DEFAULT_DISCRIMINATOR_TYPE, (Object)abstractEntity.getDiscriminatorColumn().getDefaultDiscriminatorType());
        OrmDiscriminatorColumnTests.assertEquals((String)"DTYPE2", (String)abstractEntity.getDiscriminatorColumn().getSpecifiedName());
        OrmDiscriminatorColumnTests.assertEquals((Object)5, (Object)abstractEntity.getDiscriminatorColumn().getSpecifiedLength());
        OrmDiscriminatorColumnTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.DiscriminatorType.CHAR, (Object)abstractEntity.getDiscriminatorColumn().getSpecifiedDiscriminatorType());
        OrmDiscriminatorColumnTests.assertEquals((Object)InheritanceType.SINGLE_TABLE, (Object)childEntity.getDefaultInheritanceStrategy());
        OrmDiscriminatorColumnTests.assertEquals((String)"DTYPE2", (String)childEntity.getDiscriminatorColumn().getDefaultName());
        OrmDiscriminatorColumnTests.assertEquals((int)5, (int)childEntity.getDiscriminatorColumn().getDefaultLength());
        OrmDiscriminatorColumnTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.DiscriminatorType.CHAR, (Object)childEntity.getDiscriminatorColumn().getDefaultDiscriminatorType());
        OrmDiscriminatorColumnTests.assertEquals(null, (String)childEntity.getDiscriminatorColumn().getSpecifiedName());
        OrmDiscriminatorColumnTests.assertEquals(null, (Object)childEntity.getDiscriminatorColumn().getSpecifiedLength());
        OrmDiscriminatorColumnTests.assertEquals(null, (Object)childEntity.getDiscriminatorColumn().getSpecifiedDiscriminatorType());
        abstractEntity.getDiscriminatorColumn().setSpecifiedName(null);
        abstractEntity.getDiscriminatorColumn().setSpecifiedLength(null);
        abstractEntity.getDiscriminatorColumn().setSpecifiedDiscriminatorType(null);
        abstractEntity.setSpecifiedInheritanceStrategy(InheritanceType.TABLE_PER_CLASS);
        OrmDiscriminatorColumnTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)abstractEntity.getInheritanceStrategy());
        OrmDiscriminatorColumnTests.assertEquals(null, (String)abstractEntity.getDiscriminatorColumn().getDefaultName());
        OrmDiscriminatorColumnTests.assertEquals((int)0, (int)abstractEntity.getDiscriminatorColumn().getDefaultLength());
        OrmDiscriminatorColumnTests.assertEquals(null, (Object)abstractEntity.getDiscriminatorColumn().getDefaultDiscriminatorType());
        OrmDiscriminatorColumnTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)childEntity.getDefaultInheritanceStrategy());
        OrmDiscriminatorColumnTests.assertEquals(null, (String)childEntity.getDiscriminatorColumn().getDefaultName());
        OrmDiscriminatorColumnTests.assertEquals((int)0, (int)childEntity.getDiscriminatorColumn().getDefaultLength());
        OrmDiscriminatorColumnTests.assertEquals(null, (Object)childEntity.getDiscriminatorColumn().getDefaultDiscriminatorType());
    }

    public void testDefaultsDiscriminatorColumnInJava() throws Exception {
        this.createTestAbstractEntity();
        this.createTestSubType();
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity abstractEntity = (OrmEntity)persistentType.getMapping();
        OrmPersistentType childPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestTypeChild");
        OrmEntity childEntity = (OrmEntity)childPersistentType.getMapping();
        ((Entity)persistentType.getJavaPersistentType().getMapping()).getDiscriminatorColumn().setSpecifiedName("FOO");
        ((Entity)persistentType.getJavaPersistentType().getMapping()).getDiscriminatorColumn().setSpecifiedLength(Integer.valueOf(5));
        ((Entity)persistentType.getJavaPersistentType().getMapping()).getDiscriminatorColumn().setSpecifiedDiscriminatorType(org.eclipse.jpt.jpa.core.context.DiscriminatorType.CHAR);
        OrmDiscriminatorColumnTests.assertEquals((Object)InheritanceType.SINGLE_TABLE, (Object)abstractEntity.getDefaultInheritanceStrategy());
        OrmDiscriminatorColumnTests.assertEquals((String)"FOO", (String)abstractEntity.getDiscriminatorColumn().getDefaultName());
        OrmDiscriminatorColumnTests.assertEquals((int)5, (int)abstractEntity.getDiscriminatorColumn().getDefaultLength());
        OrmDiscriminatorColumnTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.DiscriminatorType.CHAR, (Object)abstractEntity.getDiscriminatorColumn().getDefaultDiscriminatorType());
        OrmDiscriminatorColumnTests.assertEquals((Object)InheritanceType.SINGLE_TABLE, (Object)childEntity.getDefaultInheritanceStrategy());
        OrmDiscriminatorColumnTests.assertEquals((String)"FOO", (String)childEntity.getDiscriminatorColumn().getDefaultName());
        OrmDiscriminatorColumnTests.assertEquals((int)5, (int)childEntity.getDiscriminatorColumn().getDefaultLength());
        OrmDiscriminatorColumnTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.DiscriminatorType.CHAR, (Object)childEntity.getDiscriminatorColumn().getDefaultDiscriminatorType());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        OrmDiscriminatorColumnTests.assertEquals((Object)InheritanceType.SINGLE_TABLE, (Object)abstractEntity.getDefaultInheritanceStrategy());
        OrmDiscriminatorColumnTests.assertEquals((String)"DTYPE", (String)abstractEntity.getDiscriminatorColumn().getDefaultName());
        OrmDiscriminatorColumnTests.assertEquals((int)31, (int)abstractEntity.getDiscriminatorColumn().getDefaultLength());
        OrmDiscriminatorColumnTests.assertEquals((Object)SpecifiedDiscriminatorColumn.DEFAULT_DISCRIMINATOR_TYPE, (Object)abstractEntity.getDiscriminatorColumn().getDefaultDiscriminatorType());
        OrmDiscriminatorColumnTests.assertEquals((Object)InheritanceType.SINGLE_TABLE, (Object)childEntity.getDefaultInheritanceStrategy());
        OrmDiscriminatorColumnTests.assertEquals((String)"DTYPE", (String)childEntity.getDiscriminatorColumn().getDefaultName());
        OrmDiscriminatorColumnTests.assertEquals((int)31, (int)childEntity.getDiscriminatorColumn().getDefaultLength());
        OrmDiscriminatorColumnTests.assertEquals((Object)SpecifiedDiscriminatorColumn.DEFAULT_DISCRIMINATOR_TYPE, (Object)childEntity.getDiscriminatorColumn().getDefaultDiscriminatorType());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        abstractEntity.getDiscriminatorColumn().setSpecifiedName("BAR");
        abstractEntity.getDiscriminatorColumn().setSpecifiedLength(Integer.valueOf(6));
        abstractEntity.getDiscriminatorColumn().setSpecifiedDiscriminatorType(org.eclipse.jpt.jpa.core.context.DiscriminatorType.INTEGER);
        OrmDiscriminatorColumnTests.assertEquals((Object)InheritanceType.SINGLE_TABLE, (Object)abstractEntity.getDefaultInheritanceStrategy());
        OrmDiscriminatorColumnTests.assertEquals((String)"DTYPE", (String)abstractEntity.getDiscriminatorColumn().getDefaultName());
        OrmDiscriminatorColumnTests.assertEquals((int)31, (int)abstractEntity.getDiscriminatorColumn().getDefaultLength());
        OrmDiscriminatorColumnTests.assertEquals((Object)SpecifiedDiscriminatorColumn.DEFAULT_DISCRIMINATOR_TYPE, (Object)abstractEntity.getDiscriminatorColumn().getDefaultDiscriminatorType());
        OrmDiscriminatorColumnTests.assertEquals((Object)InheritanceType.SINGLE_TABLE, (Object)childEntity.getDefaultInheritanceStrategy());
        OrmDiscriminatorColumnTests.assertEquals((String)"BAR", (String)childEntity.getDiscriminatorColumn().getDefaultName());
        OrmDiscriminatorColumnTests.assertEquals((int)6, (int)childEntity.getDiscriminatorColumn().getDefaultLength());
        OrmDiscriminatorColumnTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.DiscriminatorType.INTEGER, (Object)childEntity.getDiscriminatorColumn().getDefaultDiscriminatorType());
    }
}

