/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.Cascade;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinTable;
import org.eclipse.jpt.jpa.core.context.SpecifiedMappedByRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmCascade;
import org.eclipse.jpt.jpa.core.context.orm.OrmManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmManyToManyRelationship;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlManyToMany;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class OrmManyToManyMappingTests
extends ContextModelTestCase {
    public OrmManyToManyMappingTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntityWithValidManyToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id", "java.util.Collection"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEntityWithManyToManyMapping() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToMany").append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmPersistentAttribute each : ormPersistentType.getAttributes()) {
            each.addToXml();
        }
    }

    private ICompilationUnit createTestEntityWithValidManyToManyMapMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private java.util.Map<String, Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidMapManyToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private java.util.Map<String, Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidNonGenericMapManyToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private java.util.Map addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEmbeddableState() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    private String abbr;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "State.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityManyToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.FetchType", "javax.persistence.CascadeType", "javax.persistence.OrderBy"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany(fetch=FetchType.EAGER, targetEntity=Address.class, cascade={CascadeType.ALL, CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.REFRESH})");
                sb.append(CR);
                sb.append("    @OrderBy(\"city\"");
                sb.append(CR);
                sb.append("    private java.util.Collection<Address> address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    public void testUpdateName() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertEquals((String)"id", (String)ormManyToManyMapping.getName());
        OrmManyToManyMappingTests.assertEquals((String)"id", (String)manyToMany.getName());
        manyToMany.setName("newName");
        OrmManyToManyMappingTests.assertEquals((String)"newName", (String)ormManyToManyMapping.getName());
        OrmManyToManyMappingTests.assertEquals((String)"newName", (String)manyToMany.getName());
        manyToMany.setName(null);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getName());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getName());
    }

    public void testModifyName() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertEquals((String)"id", (String)ormManyToManyMapping.getName());
        OrmManyToManyMappingTests.assertEquals((String)"id", (String)manyToMany.getName());
        ormManyToManyMapping.setName("newName");
        OrmManyToManyMappingTests.assertEquals((String)"newName", (String)ormManyToManyMapping.getName());
        OrmManyToManyMappingTests.assertEquals((String)"newName", (String)manyToMany.getName());
        ormManyToManyMapping.setName(null);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getName());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getName());
    }

    public void testUpdateTargetEntity() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedTargetEntity());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getTargetEntity());
        manyToMany.setTargetEntity("newTargetEntity");
        OrmManyToManyMappingTests.assertEquals((String)"newTargetEntity", (String)ormManyToManyMapping.getSpecifiedTargetEntity());
        OrmManyToManyMappingTests.assertEquals((String)"newTargetEntity", (String)manyToMany.getTargetEntity());
        manyToMany.setTargetEntity(null);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedTargetEntity());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getTargetEntity());
    }

    public void testModifyTargetEntity() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedTargetEntity());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getTargetEntity());
        ormManyToManyMapping.setSpecifiedTargetEntity("newTargetEntity");
        OrmManyToManyMappingTests.assertEquals((String)"newTargetEntity", (String)ormManyToManyMapping.getSpecifiedTargetEntity());
        OrmManyToManyMappingTests.assertEquals((String)"newTargetEntity", (String)manyToMany.getTargetEntity());
        ormManyToManyMapping.setSpecifiedTargetEntity(null);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedTargetEntity());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getTargetEntity());
    }

    public void testUpdateSpecifiedFetch() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToManyResource = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedFetch());
        OrmManyToManyMappingTests.assertNull((Object)manyToManyResource.getFetch());
        manyToManyResource.setFetch(org.eclipse.jpt.jpa.core.resource.orm.FetchType.EAGER);
        OrmManyToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormManyToManyMapping.getSpecifiedFetch());
        OrmManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.FetchType.EAGER, (Object)manyToManyResource.getFetch());
        manyToManyResource.setFetch(org.eclipse.jpt.jpa.core.resource.orm.FetchType.LAZY);
        OrmManyToManyMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormManyToManyMapping.getSpecifiedFetch());
        OrmManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.FetchType.LAZY, (Object)manyToManyResource.getFetch());
        manyToManyResource.setFetch(null);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedFetch());
        OrmManyToManyMappingTests.assertNull((Object)manyToManyResource.getFetch());
    }

    public void testModifySpecifiedFetch() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToManyResource = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedFetch());
        OrmManyToManyMappingTests.assertNull((Object)manyToManyResource.getFetch());
        ormManyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        OrmManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.FetchType.EAGER, (Object)manyToManyResource.getFetch());
        OrmManyToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormManyToManyMapping.getSpecifiedFetch());
        ormManyToManyMapping.setSpecifiedFetch(FetchType.LAZY);
        OrmManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.FetchType.LAZY, (Object)manyToManyResource.getFetch());
        OrmManyToManyMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormManyToManyMapping.getSpecifiedFetch());
        ormManyToManyMapping.setSpecifiedFetch(null);
        OrmManyToManyMappingTests.assertNull((Object)manyToManyResource.getFetch());
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedFetch());
    }

    public void testUpdateMappedBy() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        SpecifiedMappedByRelationshipStrategy strategy = ormManyToManyMapping.getRelationship().getMappedByStrategy();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)strategy.getMappedByAttribute());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMappedBy());
        manyToMany.setMappedBy("newMappedBy");
        OrmManyToManyMappingTests.assertEquals((String)"newMappedBy", (String)strategy.getMappedByAttribute());
        OrmManyToManyMappingTests.assertEquals((String)"newMappedBy", (String)manyToMany.getMappedBy());
        manyToMany.setMappedBy(null);
        OrmManyToManyMappingTests.assertNull((Object)strategy.getMappedByAttribute());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMappedBy());
    }

    public void testModifyMappedBy() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        SpecifiedMappedByRelationshipStrategy strategy = ormManyToManyMapping.getRelationship().getMappedByStrategy();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)strategy.getMappedByAttribute());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMappedBy());
        strategy.setMappedByAttribute("newMappedBy");
        OrmManyToManyMappingTests.assertEquals((String)"newMappedBy", (String)strategy.getMappedByAttribute());
        OrmManyToManyMappingTests.assertEquals((String)"newMappedBy", (String)manyToMany.getMappedBy());
        strategy.setMappedByAttribute(null);
        OrmManyToManyMappingTests.assertNull((Object)strategy.getMappedByAttribute());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMappedBy());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("id");
        OrmManyToManyMapping contextMapping = (OrmManyToManyMapping)contextAttribute.getMapping();
        OrmManyToManyRelationship rel = contextMapping.getRelationship();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlManyToMany resourceMapping = (XmlManyToMany)resourceEntity.getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        OrmManyToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        OrmManyToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        OrmManyToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToMappedBy();
        OrmManyToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        OrmManyToManyMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        OrmManyToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        OrmManyToManyMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToJoinTable();
        OrmManyToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        OrmManyToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        OrmManyToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        OrmManyToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("id");
        OrmManyToManyMapping contextMapping = (OrmManyToManyMapping)contextAttribute.getMapping();
        OrmManyToManyRelationship rel = contextMapping.getRelationship();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlManyToMany resourceMapping = (XmlManyToMany)resourceEntity.getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        OrmManyToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        OrmManyToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        OrmManyToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceMapping.setMappedBy("foo");
        this.getJpaProject().synchronizeContextModel();
        OrmManyToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        OrmManyToManyMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        OrmManyToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        OrmManyToManyMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceMapping.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        this.getJpaProject().synchronizeContextModel();
        OrmManyToManyMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        OrmManyToManyMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        OrmManyToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        OrmManyToManyMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceMapping.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        OrmManyToManyMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        OrmManyToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        OrmManyToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        OrmManyToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceMapping.setJoinTable(null);
        this.getJpaProject().synchronizeContextModel();
        OrmManyToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        OrmManyToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        OrmManyToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        OrmManyToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
    }

    public void testUpdateMapKey() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKey());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMapKey());
        manyToMany.setMapKey(OrmFactory.eINSTANCE.createMapKey());
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKey());
        OrmManyToManyMappingTests.assertNotNull((Object)manyToMany.getMapKey());
        manyToMany.getMapKey().setName("myMapKey");
        OrmManyToManyMappingTests.assertEquals((String)"myMapKey", (String)ormManyToManyMapping.getSpecifiedMapKey());
        OrmManyToManyMappingTests.assertEquals((String)"myMapKey", (String)manyToMany.getMapKey().getName());
        manyToMany.getMapKey().setName(null);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKey());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMapKey().getName());
        manyToMany.getMapKey().setName("myMapKey");
        manyToMany.setMapKey(null);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKey());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMapKey());
    }

    public void testModifyMapKey() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKey());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMapKey());
        ormManyToManyMapping.setSpecifiedMapKey("myMapKey");
        OrmManyToManyMappingTests.assertEquals((String)"myMapKey", (String)ormManyToManyMapping.getSpecifiedMapKey());
        OrmManyToManyMappingTests.assertEquals((String)"myMapKey", (String)manyToMany.getMapKey().getName());
        ormManyToManyMapping.setNoMapKey(true);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKey());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMapKey());
    }

    public void testUpdateVirtualMapKey() throws Exception {
        this.createTestEntityWithValidManyToManyMapMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ManyToManyMapping virtualManyToManyMapping = (ManyToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaManyToManyMapping javaManyToManyMapping = (JavaManyToManyMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        OrmManyToManyMappingTests.assertNull((Object)virtualManyToManyMapping.getSpecifiedMapKey());
        OrmManyToManyMappingTests.assertNull((Object)virtualManyToManyMapping.getMapKey());
        OrmManyToManyMappingTests.assertFalse((boolean)virtualManyToManyMapping.isPkMapKey());
        OrmManyToManyMappingTests.assertFalse((boolean)virtualManyToManyMapping.isCustomMapKey());
        OrmManyToManyMappingTests.assertTrue((boolean)virtualManyToManyMapping.isNoMapKey());
        javaManyToManyMapping.setPkMapKey(true);
        OrmManyToManyMappingTests.assertEquals((String)"id", (String)virtualManyToManyMapping.getMapKey());
        OrmManyToManyMappingTests.assertTrue((boolean)virtualManyToManyMapping.isPkMapKey());
        OrmManyToManyMappingTests.assertFalse((boolean)virtualManyToManyMapping.isCustomMapKey());
        OrmManyToManyMappingTests.assertFalse((boolean)virtualManyToManyMapping.isNoMapKey());
        javaManyToManyMapping.setCustomMapKey(true);
        javaManyToManyMapping.setSpecifiedMapKey("city");
        OrmManyToManyMappingTests.assertEquals((String)"city", (String)virtualManyToManyMapping.getSpecifiedMapKey());
        OrmManyToManyMappingTests.assertEquals((String)"city", (String)virtualManyToManyMapping.getMapKey());
        OrmManyToManyMappingTests.assertFalse((boolean)virtualManyToManyMapping.isPkMapKey());
        OrmManyToManyMappingTests.assertTrue((boolean)virtualManyToManyMapping.isCustomMapKey());
        OrmManyToManyMappingTests.assertFalse((boolean)virtualManyToManyMapping.isNoMapKey());
    }

    public void testUpdateOrderBy() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getOrderable().getSpecifiedOrderBy());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getOrderBy());
        manyToMany.setOrderBy("newOrderBy");
        OrmManyToManyMappingTests.assertEquals((String)"newOrderBy", (String)ormManyToManyMapping.getOrderable().getSpecifiedOrderBy());
        OrmManyToManyMappingTests.assertEquals((String)"newOrderBy", (String)manyToMany.getOrderBy());
        manyToMany.setOrderBy(null);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getOrderable().getSpecifiedOrderBy());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getOrderBy());
    }

    public void testModifyOrderBy() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getOrderable().getSpecifiedOrderBy());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getOrderBy());
        ormManyToManyMapping.getOrderable().setSpecifiedOrderBy("newOrderBy");
        OrmManyToManyMappingTests.assertEquals((String)"newOrderBy", (String)ormManyToManyMapping.getOrderable().getSpecifiedOrderBy());
        OrmManyToManyMappingTests.assertEquals((String)"newOrderBy", (String)manyToMany.getOrderBy());
        ormManyToManyMapping.getOrderable().setSpecifiedOrderBy(null);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getOrderable().getSpecifiedOrderBy());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getOrderBy());
    }

    public void testIsNoOrdering() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertTrue((boolean)ormManyToManyMapping.getOrderable().isNoOrdering());
        ormManyToManyMapping.getOrderable().setSpecifiedOrderBy("foo");
        OrmManyToManyMappingTests.assertFalse((boolean)ormManyToManyMapping.getOrderable().isNoOrdering());
        ormManyToManyMapping.getOrderable().setSpecifiedOrderBy(null);
        OrmManyToManyMappingTests.assertTrue((boolean)ormManyToManyMapping.getOrderable().isNoOrdering());
    }

    public void testSetNoOrdering() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertTrue((boolean)ormManyToManyMapping.getOrderable().isNoOrdering());
        ormManyToManyMapping.getOrderable().setSpecifiedOrderBy("foo");
        OrmManyToManyMappingTests.assertFalse((boolean)ormManyToManyMapping.getOrderable().isNoOrdering());
        ormManyToManyMapping.getOrderable().setNoOrdering(true);
        OrmManyToManyMappingTests.assertTrue((boolean)ormManyToManyMapping.getOrderable().isNoOrdering());
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getOrderable().getSpecifiedOrderBy());
    }

    public void testIsCustomOrdering() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertFalse((boolean)ormManyToManyMapping.getOrderable().isCustomOrdering());
        ormManyToManyMapping.getOrderable().setSpecifiedOrderBy("foo");
        OrmManyToManyMappingTests.assertTrue((boolean)ormManyToManyMapping.getOrderable().isCustomOrdering());
        ormManyToManyMapping.getOrderable().setSpecifiedOrderBy(null);
        OrmManyToManyMappingTests.assertFalse((boolean)ormManyToManyMapping.getOrderable().isCustomOrdering());
    }

    public void testManyToManyMorphToIdMapping() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        manyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        manyToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("customOrder");
        manyToManyMapping.setSpecifiedMapKey("mapKey");
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        ormPersistentAttribute.setMappingKey("id");
        OrmManyToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmManyToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmManyToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof IdMapping));
        OrmManyToManyMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testManyToManyMorphToVersionMapping() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        manyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        manyToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("customOrder");
        manyToManyMapping.setSpecifiedMapKey("mapKey");
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        ormPersistentAttribute.setMappingKey("version");
        OrmManyToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmManyToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmManyToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof VersionMapping));
        OrmManyToManyMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testManyToManyMorphToTransientMapping() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        manyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        manyToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("customOrder");
        manyToManyMapping.setSpecifiedMapKey("mapKey");
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        ormPersistentAttribute.setMappingKey("transient");
        OrmManyToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmManyToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmManyToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof TransientMapping));
        OrmManyToManyMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testManyToManyMorphToEmbeddedMapping() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        manyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        manyToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("customOrder");
        manyToManyMapping.setSpecifiedMapKey("mapKey");
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        ormPersistentAttribute.setMappingKey("embedded");
        OrmManyToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmManyToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmManyToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedMapping));
        OrmManyToManyMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testManyToManyMorphToEmbeddedIdMapping() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        manyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        manyToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("customOrder");
        manyToManyMapping.setSpecifiedMapKey("mapKey");
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        ormPersistentAttribute.setMappingKey("embeddedId");
        OrmManyToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmManyToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmManyToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        OrmManyToManyMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testManyToManyMorphToOneToOneMapping() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        manyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        manyToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("customOrder");
        manyToManyMapping.setSpecifiedMapKey("mapKey");
        manyToManyMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("mappedBy");
        manyToManyMapping.getCascade().setAll(true);
        manyToManyMapping.getCascade().setMerge(true);
        manyToManyMapping.getCascade().setPersist(true);
        manyToManyMapping.getCascade().setRefresh(true);
        manyToManyMapping.getCascade().setRemove(true);
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        ormPersistentAttribute.setMappingKey("oneToOne");
        OrmManyToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmManyToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmManyToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToOneMapping));
        OrmManyToManyMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
        OrmManyToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)((OneToOneMapping)ormPersistentAttribute.getMapping()).getSpecifiedFetch());
        OrmManyToManyMappingTests.assertEquals((String)"TargetEntity", (String)((OneToOneMapping)ormPersistentAttribute.getMapping()).getSpecifiedTargetEntity());
        OrmManyToManyMappingTests.assertEquals((String)"mappedBy", (String)((OneToOneMapping)ormPersistentAttribute.getMapping()).getRelationship().getMappedByStrategy().getMappedByAttribute());
        OrmManyToManyMappingTests.assertTrue((boolean)((OneToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isAll());
        OrmManyToManyMappingTests.assertTrue((boolean)((OneToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isMerge());
        OrmManyToManyMappingTests.assertTrue((boolean)((OneToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isPersist());
        OrmManyToManyMappingTests.assertTrue((boolean)((OneToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isRefresh());
        OrmManyToManyMappingTests.assertTrue((boolean)((OneToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isRemove());
    }

    public void testManyToManyMorphToOneToManyMapping() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        manyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        manyToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("customOrder");
        manyToManyMapping.setSpecifiedMapKey("mapKey");
        manyToManyMapping.getCascade().setAll(true);
        manyToManyMapping.getCascade().setMerge(true);
        manyToManyMapping.getCascade().setPersist(true);
        manyToManyMapping.getCascade().setRefresh(true);
        manyToManyMapping.getCascade().setRemove(true);
        manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        SpecifiedJoinColumn joinColumn = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        SpecifiedJoinColumn inverseJoinColumn = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().addSpecifiedInverseJoinColumn(0);
        inverseJoinColumn.setSpecifiedName("inverseName");
        inverseJoinColumn.setSpecifiedReferencedColumnName("inverseReferenceName");
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        ormPersistentAttribute.setMappingKey("oneToMany");
        OrmManyToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmManyToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmManyToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToManyMapping));
        OrmManyToManyMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
        OrmManyToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)((OneToManyMapping)ormPersistentAttribute.getMapping()).getSpecifiedFetch());
        OrmManyToManyMappingTests.assertEquals((String)"TargetEntity", (String)((OneToManyMapping)ormPersistentAttribute.getMapping()).getSpecifiedTargetEntity());
        OrmManyToManyMappingTests.assertTrue((boolean)((OneToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isAll());
        OrmManyToManyMappingTests.assertTrue((boolean)((OneToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isMerge());
        OrmManyToManyMappingTests.assertTrue((boolean)((OneToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isPersist());
        OrmManyToManyMappingTests.assertTrue((boolean)((OneToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isRefresh());
        OrmManyToManyMappingTests.assertTrue((boolean)((OneToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isRemove());
        SpecifiedJoinTable joinTable = ((OneToManyMapping)ormPersistentAttribute.getMapping()).getRelationship().getJoinTableStrategy().getJoinTable();
        OrmManyToManyMappingTests.assertEquals((String)"MY_JOIN_TABLE", (String)joinTable.getName());
        OrmManyToManyMappingTests.assertEquals((String)"name", (String)((SpecifiedJoinColumn)joinTable.getJoinColumns().iterator().next()).getSpecifiedName());
        OrmManyToManyMappingTests.assertEquals((String)"referenceName", (String)((SpecifiedJoinColumn)joinTable.getJoinColumns().iterator().next()).getSpecifiedReferencedColumnName());
        OrmManyToManyMappingTests.assertEquals((String)"inverseName", (String)((SpecifiedJoinColumn)joinTable.getInverseJoinColumns().iterator().next()).getSpecifiedName());
        OrmManyToManyMappingTests.assertEquals((String)"inverseReferenceName", (String)((SpecifiedJoinColumn)joinTable.getInverseJoinColumns().iterator().next()).getSpecifiedReferencedColumnName());
    }

    public void testManyToManyMorphToManyToOneMapping() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        manyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        manyToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("customOrder");
        manyToManyMapping.setSpecifiedMapKey("mapKey");
        manyToManyMapping.getCascade().setAll(true);
        manyToManyMapping.getCascade().setMerge(true);
        manyToManyMapping.getCascade().setPersist(true);
        manyToManyMapping.getCascade().setRefresh(true);
        manyToManyMapping.getCascade().setRemove(true);
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        ormPersistentAttribute.setMappingKey("manyToOne");
        OrmManyToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmManyToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmManyToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToOneMapping));
        OrmManyToManyMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
        OrmManyToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getSpecifiedFetch());
        OrmManyToManyMappingTests.assertEquals((String)"TargetEntity", (String)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getSpecifiedTargetEntity());
        OrmManyToManyMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isAll());
        OrmManyToManyMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isMerge());
        OrmManyToManyMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isPersist());
        OrmManyToManyMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isRefresh());
        OrmManyToManyMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isRemove());
    }

    public void testManyToManyMorphToBasicMapping() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        manyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        manyToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("customOrder");
        manyToManyMapping.setSpecifiedMapKey("mapKey");
        manyToManyMapping.getCascade().setAll(true);
        manyToManyMapping.getCascade().setMerge(true);
        manyToManyMapping.getCascade().setPersist(true);
        manyToManyMapping.getCascade().setRefresh(true);
        manyToManyMapping.getCascade().setRemove(true);
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        ormPersistentAttribute.setMappingKey("basic");
        OrmManyToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmManyToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmManyToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof BasicMapping));
        OrmManyToManyMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testCandidateMappedByAttributeNames() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("addresses"), "manyToMany");
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)ormPersistentType.getAttributes().iterator().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        Iterator attributeNames = manyToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        OrmManyToManyMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        OrmManyToManyMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        OrmManyToManyMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        OrmManyToManyMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        OrmManyToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        manyToManyMapping.setSpecifiedTargetEntity("foo");
        attributeNames = manyToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        OrmManyToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        manyToManyMapping.setSpecifiedTargetEntity(null);
        attributeNames = manyToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        OrmManyToManyMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        OrmManyToManyMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        OrmManyToManyMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        OrmManyToManyMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        OrmManyToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = manyToManyMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        OrmManyToManyMappingTests.assertNull((Object)stateFooMapping);
    }

    public void testCandidateMapKeyNames() throws Exception {
        this.createTestEntityWithValidMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ManyToManyMapping virtualManyToManyMapping = (ManyToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = virtualManyToManyMapping.getCandidateMapKeyNames().iterator();
        OrmManyToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        OrmManyToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        OrmManyToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        OrmManyToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        OrmManyToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
    }

    public void testCandidateMapKeyNames2() throws Exception {
        this.createTestEntityWithValidNonGenericMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ManyToManyMapping virtualManyToManyMapping = (ManyToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaManyToManyMapping javaManyToManyMapping = (JavaManyToManyMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = virtualManyToManyMapping.getCandidateMapKeyNames().iterator();
        OrmManyToManyMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        javaManyToManyMapping.setSpecifiedTargetEntity("test.Address");
        mapKeyNames = virtualManyToManyMapping.getCandidateMapKeyNames().iterator();
        OrmManyToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        OrmManyToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        OrmManyToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        OrmManyToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        OrmManyToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
        ormPersistentType.getAttributeNamed("addresses").addToXml();
        OrmManyToManyMapping specifiedManyToManyMapping = (OrmManyToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        mapKeyNames = specifiedManyToManyMapping.getCandidateMapKeyNames().iterator();
        OrmManyToManyMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        specifiedManyToManyMapping.setSpecifiedTargetEntity("test.Address");
        mapKeyNames = specifiedManyToManyMapping.getCandidateMapKeyNames().iterator();
        OrmManyToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        OrmManyToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        OrmManyToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        OrmManyToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        OrmManyToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
        specifiedManyToManyMapping.setSpecifiedTargetEntity("String");
        mapKeyNames = specifiedManyToManyMapping.getCandidateMapKeyNames().iterator();
        OrmManyToManyMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityManyToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmManyToManyMappingTests.assertEquals((int)3, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute virtualPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        ManyToManyMapping virtualManyToManyMapping = (ManyToManyMapping)virtualPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertEquals((String)"address", (String)virtualManyToManyMapping.getName());
        OrmManyToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)virtualManyToManyMapping.getSpecifiedFetch());
        OrmManyToManyMappingTests.assertEquals((String)"Address", (String)virtualManyToManyMapping.getSpecifiedTargetEntity());
        OrmManyToManyMappingTests.assertNull((Object)virtualManyToManyMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        Cascade cascade = virtualManyToManyMapping.getCascade();
        OrmManyToManyMappingTests.assertTrue((boolean)cascade.isAll());
        OrmManyToManyMappingTests.assertTrue((boolean)cascade.isMerge());
        OrmManyToManyMappingTests.assertTrue((boolean)cascade.isPersist());
        OrmManyToManyMappingTests.assertTrue((boolean)cascade.isRemove());
        OrmManyToManyMappingTests.assertTrue((boolean)cascade.isRefresh());
        OrmManyToManyMappingTests.assertTrue((boolean)virtualManyToManyMapping.getOrderable().isCustomOrdering());
        OrmManyToManyMappingTests.assertEquals((String)"city", (String)virtualManyToManyMapping.getOrderable().getSpecifiedOrderBy());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityManyToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmManyToManyMappingTests.assertEquals((int)3, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute virtualPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        OrmManyToManyMappingTests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)virtualPersistentAttribute.getMappingKey());
        OrmManyToManyMappingTests.assertTrue((boolean)virtualPersistentAttribute.isVirtual());
        virtualPersistentAttribute.addToXml("manyToMany");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = (OrmSpecifiedPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertEquals((String)"address", (String)ormManyToManyMapping.getName());
        OrmManyToManyMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormManyToManyMapping.getFetch());
        OrmManyToManyMappingTests.assertEquals((String)"test.Address", (String)ormManyToManyMapping.getTargetEntity());
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        OrmCascade cascade = ormManyToManyMapping.getCascade();
        OrmManyToManyMappingTests.assertFalse((boolean)cascade.isAll());
        OrmManyToManyMappingTests.assertFalse((boolean)cascade.isMerge());
        OrmManyToManyMappingTests.assertFalse((boolean)cascade.isPersist());
        OrmManyToManyMappingTests.assertFalse((boolean)cascade.isRemove());
        OrmManyToManyMappingTests.assertFalse((boolean)cascade.isRefresh());
        OrmManyToManyMappingTests.assertTrue((boolean)ormManyToManyMapping.getOrderable().isNoOrdering());
        OrmManyToManyMappingTests.assertEquals(null, (String)ormManyToManyMapping.getOrderable().getSpecifiedOrderBy());
    }
}

