/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMember;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class AttributeOverrideTests
extends JpaJavaResourceModelTestCase {
    private static final String COLUMN_NAME = "MY_COLUMN";
    private static final String ATTRIBUTE_OVERRIDE_NAME = "MY_ATTRIBUTE_OVERRIDE";

    public AttributeOverrideTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestAttributeOverrideOnField() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.AttributeOverride", "javax.persistence.Column"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@AttributeOverride(name = \"MY_ATTRIBUTE_OVERRIDE\")");
            }
        });
    }

    private ICompilationUnit createTestAttributeOverrideWithColumnOnField() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.AttributeOverride", "javax.persistence.Column"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@AttributeOverride(name = \"MY_ATTRIBUTE_OVERRIDE\", column = @Column(name = \"MY_COLUMN\"))");
            }
        });
    }

    private AttributeOverrideAnnotation getAttributeOverrideAnnotationAt(JavaResourceMember resourceMember, int index) {
        return (AttributeOverrideAnnotation)resourceMember.getAnnotation(index, "javax.persistence.AttributeOverride");
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverrideOnField();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        AttributeOverrideAnnotation attributeOverride = this.getAttributeOverrideAnnotationAt((JavaResourceMember)resourceField, 0);
        AttributeOverrideTests.assertNotNull((Object)attributeOverride);
        AttributeOverrideTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
    }

    public void testGetNullColumn() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverrideOnField();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        AttributeOverrideAnnotation attributeOverride = this.getAttributeOverrideAnnotationAt((JavaResourceMember)resourceField, 0);
        ColumnAnnotation column = attributeOverride.getColumn();
        AttributeOverrideTests.assertNotNull((Object)attributeOverride);
        AttributeOverrideTests.assertNull((Object)column);
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverrideOnField();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        AttributeOverrideAnnotation attributeOverride = this.getAttributeOverrideAnnotationAt((JavaResourceMember)resourceField, 0);
        AttributeOverrideTests.assertNotNull((Object)attributeOverride);
        AttributeOverrideTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        attributeOverride.setName("Foo");
        AttributeOverrideTests.assertEquals((String)"Foo", (String)attributeOverride.getName());
        this.assertSourceContains("@AttributeOverride(name = \"Foo\")", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverrideOnField();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        AttributeOverrideAnnotation attributeOverride = this.getAttributeOverrideAnnotationAt((JavaResourceMember)resourceField, 0);
        AttributeOverrideTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        attributeOverride.setName(null);
        AttributeOverrideTests.assertNull((Object)attributeOverride.getName());
        this.assertSourceDoesNotContain("@AttributeOverride(name=\"MY_ATTRIBUTE_OVERRIDE\")", cu);
        this.assertSourceContains("@AttributeOverride", cu);
    }

    public void testColumnGetName() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverrideWithColumnOnField();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        AttributeOverrideAnnotation attributeOverride = this.getAttributeOverrideAnnotationAt((JavaResourceMember)resourceField, 0);
        ColumnAnnotation column = attributeOverride.getColumn();
        AttributeOverrideTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
    }

    public void testColumnSetName() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverrideWithColumnOnField();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        AttributeOverrideAnnotation attributeOverride = this.getAttributeOverrideAnnotationAt((JavaResourceMember)resourceField, 0);
        ColumnAnnotation column = attributeOverride.getColumn();
        AttributeOverrideTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
        column.setName("Foo");
        this.assertSourceContains("@AttributeOverride(name = \"MY_ATTRIBUTE_OVERRIDE\", column = @Column(name = \"Foo\"))", cu);
        column.setName(null);
        AttributeOverrideTests.assertNull((Object)attributeOverride.getColumn().getName());
        attributeOverride.removeColumn();
        AttributeOverrideTests.assertNull((Object)attributeOverride.getColumn());
        this.assertSourceContains("@AttributeOverride(name = \"MY_ATTRIBUTE_OVERRIDE\")", cu);
    }

    public void testAddColumn() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverrideOnField();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        AttributeOverrideAnnotation attributeOverride = this.getAttributeOverrideAnnotationAt((JavaResourceMember)resourceField, 0);
        ColumnAnnotation column = attributeOverride.getColumn();
        AttributeOverrideTests.assertNull((Object)column);
        attributeOverride.addColumn();
        column = attributeOverride.getColumn();
        AttributeOverrideTests.assertNotNull((Object)column);
        this.assertSourceContains("@AttributeOverride(name = \"MY_ATTRIBUTE_OVERRIDE\", column = @Column)", cu);
    }

    public void testRemoveColumn() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverrideOnField();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        AttributeOverrideAnnotation attributeOverride = this.getAttributeOverrideAnnotationAt((JavaResourceMember)resourceField, 0);
        ColumnAnnotation column = attributeOverride.getColumn();
        AttributeOverrideTests.assertNull((Object)column);
    }
}

