/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.XmlAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.XmlElementMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaClass;
import org.eclipse.jpt.jaxb.core.context.java.JavaClassMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaXmlValueMapping;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericJavaXmlValueMappingTests
extends JaxbContextModelTestCase {
    public GenericJavaXmlValueMappingTests(String name) {
        super(name);
    }

    private ICompilationUnit createTypeWithXmlValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "javax.xml.bind.annotation.XmlValue"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlValue");
            }
        });
    }

    private ICompilationUnit createTypeWithCollectionXmlValue() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import java.util.List;").append(CR);
                sb.append("import javax.xml.bind.annotation.XmlValue;").append(CR);
                sb.append("import javax.xml.bind.annotation.XmlType;").append(CR);
                sb.append(CR);
                sb.append("@XmlType").append(CR);
                sb.append("public class ").append("AnnotationTestType").append(" {").append(CR);
                sb.append("    @XmlValue").append(CR);
                sb.append("    public List<String> list;").append(CR);
                sb.append("}").append(CR);
            }
        };
        return this.javaProject.createCompilationUnit("test", "AnnotationTestType.java", sourceWriter);
    }

    public void testChangeMappingType() throws Exception {
        this.createTypeWithXmlValue();
        JavaClassMapping classMapping = ((JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0)).getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlValueMapping xmlValueMapping = (JavaXmlValueMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlValueMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlValueMappingTests.assertNotNull((Object)xmlValueMapping);
        GenericJavaXmlValueMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlValue"));
        persistentAttribute.setMappingKey("xml-attribute");
        XmlAttributeMapping xmlAttributeMapping = (XmlAttributeMapping)persistentAttribute.getMapping();
        GenericJavaXmlValueMappingTests.assertNotNull((Object)xmlAttributeMapping);
        GenericJavaXmlValueMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlValue"));
        GenericJavaXmlValueMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute"));
        persistentAttribute.setMappingKey("xml-value");
        xmlValueMapping = (JavaXmlValueMapping)persistentAttribute.getMapping();
        GenericJavaXmlValueMappingTests.assertNotNull((Object)xmlValueMapping);
        GenericJavaXmlValueMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlValue"));
        GenericJavaXmlValueMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute"));
        persistentAttribute.setMappingKey("xml-element");
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        GenericJavaXmlValueMappingTests.assertNotNull((Object)xmlElementMapping);
        GenericJavaXmlValueMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlValue"));
        GenericJavaXmlValueMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement"));
        persistentAttribute.setMappingKey("xml-value");
        xmlValueMapping = (JavaXmlValueMapping)persistentAttribute.getMapping();
        GenericJavaXmlValueMappingTests.assertNotNull((Object)xmlValueMapping);
        GenericJavaXmlValueMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlValue"));
        GenericJavaXmlValueMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement"));
    }

    public void testModifyXmlJavaTypeAdapter() throws Exception {
        this.createTypeWithXmlValue();
        JavaClassMapping classMapping = ((JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0)).getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlValueMapping mapping = (JavaXmlValueMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlValueMappingTests.assertNull((Object)mapping.getXmlJavaTypeAdapter());
        GenericJavaXmlValueMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
        mapping.addXmlJavaTypeAdapter();
        GenericJavaXmlValueMappingTests.assertNotNull((Object)mapping.getXmlJavaTypeAdapter());
        GenericJavaXmlValueMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
        mapping.removeXmlJavaTypeAdapter();
        GenericJavaXmlValueMappingTests.assertNull((Object)mapping.getXmlJavaTypeAdapter());
        GenericJavaXmlValueMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
    }

    public void testUpdateXmlJavaTypeAdapter() throws Exception {
        this.createTypeWithXmlValue();
        JavaClassMapping classMapping = ((JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0)).getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlValueMapping xmlValueMapping = (JavaXmlValueMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlValueMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlValueMappingTests.assertNull((Object)xmlValueMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlValueMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlValueMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
            }
        });
        GenericJavaXmlValueMappingTests.assertNotNull((Object)xmlValueMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlValueMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlValueMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
            }
        });
        GenericJavaXmlValueMappingTests.assertNull((Object)xmlValueMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlValueMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
    }

    public void testModifyXmlList1() throws Exception {
        this.createTypeWithXmlValue();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlValueMapping xmlMapping = (JavaXmlValueMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlValueMappingTests.assertFalse((boolean)xmlMapping.isXmlList());
        GenericJavaXmlValueMappingTests.assertFalse((boolean)xmlMapping.isDefaultXmlList());
        GenericJavaXmlValueMappingTests.assertFalse((boolean)xmlMapping.isSpecifiedXmlList());
        GenericJavaXmlValueMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
        xmlMapping.setSpecifiedXmlList(true);
        GenericJavaXmlValueMappingTests.assertTrue((boolean)xmlMapping.isXmlList());
        GenericJavaXmlValueMappingTests.assertFalse((boolean)xmlMapping.isDefaultXmlList());
        GenericJavaXmlValueMappingTests.assertTrue((boolean)xmlMapping.isSpecifiedXmlList());
        GenericJavaXmlValueMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
        xmlMapping.setSpecifiedXmlList(false);
        GenericJavaXmlValueMappingTests.assertFalse((boolean)xmlMapping.isXmlList());
        GenericJavaXmlValueMappingTests.assertFalse((boolean)xmlMapping.isDefaultXmlList());
        GenericJavaXmlValueMappingTests.assertFalse((boolean)xmlMapping.isSpecifiedXmlList());
        GenericJavaXmlValueMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
    }

    public void testModifyXmlList2() throws Exception {
        this.createTypeWithCollectionXmlValue();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlValueMapping xmlMapping = (JavaXmlValueMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlValueMappingTests.assertTrue((boolean)xmlMapping.isXmlList());
        GenericJavaXmlValueMappingTests.assertTrue((boolean)xmlMapping.isDefaultXmlList());
        GenericJavaXmlValueMappingTests.assertFalse((boolean)xmlMapping.isSpecifiedXmlList());
        GenericJavaXmlValueMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
        xmlMapping.setSpecifiedXmlList(true);
        GenericJavaXmlValueMappingTests.assertTrue((boolean)xmlMapping.isXmlList());
        GenericJavaXmlValueMappingTests.assertTrue((boolean)xmlMapping.isDefaultXmlList());
        GenericJavaXmlValueMappingTests.assertTrue((boolean)xmlMapping.isSpecifiedXmlList());
        GenericJavaXmlValueMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
        xmlMapping.setSpecifiedXmlList(false);
        GenericJavaXmlValueMappingTests.assertTrue((boolean)xmlMapping.isXmlList());
        GenericJavaXmlValueMappingTests.assertTrue((boolean)xmlMapping.isDefaultXmlList());
        GenericJavaXmlValueMappingTests.assertFalse((boolean)xmlMapping.isSpecifiedXmlList());
        GenericJavaXmlValueMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
    }

    public void testUpdateXmlList1() throws Exception {
        this.createTypeWithXmlValue();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlValueMapping xmlMapping = (JavaXmlValueMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlValueMappingTests.assertFalse((boolean)xmlMapping.isXmlList());
        GenericJavaXmlValueMappingTests.assertFalse((boolean)xmlMapping.isDefaultXmlList());
        GenericJavaXmlValueMappingTests.assertFalse((boolean)xmlMapping.isSpecifiedXmlList());
        GenericJavaXmlValueMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlValueMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlList");
            }
        });
        GenericJavaXmlValueMappingTests.assertTrue((boolean)xmlMapping.isXmlList());
        GenericJavaXmlValueMappingTests.assertFalse((boolean)xmlMapping.isDefaultXmlList());
        GenericJavaXmlValueMappingTests.assertTrue((boolean)xmlMapping.isSpecifiedXmlList());
        GenericJavaXmlValueMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlValueMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlList");
            }
        });
        GenericJavaXmlValueMappingTests.assertFalse((boolean)xmlMapping.isXmlList());
        GenericJavaXmlValueMappingTests.assertFalse((boolean)xmlMapping.isDefaultXmlList());
        GenericJavaXmlValueMappingTests.assertFalse((boolean)xmlMapping.isSpecifiedXmlList());
        GenericJavaXmlValueMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
    }

    public void testUpdateXmlList2() throws Exception {
        this.createTypeWithCollectionXmlValue();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlValueMapping xmlMapping = (JavaXmlValueMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlValueMappingTests.assertTrue((boolean)xmlMapping.isXmlList());
        GenericJavaXmlValueMappingTests.assertTrue((boolean)xmlMapping.isDefaultXmlList());
        GenericJavaXmlValueMappingTests.assertFalse((boolean)xmlMapping.isSpecifiedXmlList());
        GenericJavaXmlValueMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlValueMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlList");
            }
        });
        GenericJavaXmlValueMappingTests.assertTrue((boolean)xmlMapping.isXmlList());
        GenericJavaXmlValueMappingTests.assertTrue((boolean)xmlMapping.isDefaultXmlList());
        GenericJavaXmlValueMappingTests.assertTrue((boolean)xmlMapping.isSpecifiedXmlList());
        GenericJavaXmlValueMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlValueMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlList");
            }
        });
        GenericJavaXmlValueMappingTests.assertTrue((boolean)xmlMapping.isXmlList());
        GenericJavaXmlValueMappingTests.assertTrue((boolean)xmlMapping.isDefaultXmlList());
        GenericJavaXmlValueMappingTests.assertFalse((boolean)xmlMapping.isSpecifiedXmlList());
        GenericJavaXmlValueMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
    }
}

