/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.swt.bindings;

import java.util.ArrayList;
import org.eclipse.jpt.common.ui.internal.swt.events.DisposeAdapter;
import org.eclipse.jpt.common.ui.internal.swt.listeners.SWTListenerTools;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.listener.ListChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ListWidgetModelBinding<E> {
    private final ListValueModel<E> listModel;
    private final ListChangeListener listListener;
    final ArrayList<E> list = new ArrayList();
    private final Transformer<E, String> transformer;
    private final ListWidget<E> listWidget;
    private final DisposeListener listWidgetDisposeListener;
    private final SelectionBinding selectionBinding;

    ListWidgetModelBinding(ListValueModel<E> listModel, Object selectionModel, ListWidget<E> listWidget, Transformer<E, String> transformer) {
        if (listModel == null || selectionModel == null || listWidget == null || transformer == null) {
            throw new NullPointerException();
        }
        this.listModel = listModel;
        this.listWidget = listWidget;
        this.transformer = transformer;
        this.selectionBinding = listWidget.buildSelectionBinding(this.list, selectionModel);
        this.listListener = this.buildListListener();
        this.listModel.addListChangeListener("list values", this.listListener);
        this.listWidgetDisposeListener = this.buildListWidgetDisposeListener();
        this.listWidget.addDisposeListener(this.listWidgetDisposeListener);
        this.list.ensureCapacity(this.listModel.size());
        CollectionTools.addAll(this.list, this.listModel);
        this.synchronizeListWidget();
    }

    private ListChangeListener buildListListener() {
        return SWTListenerTools.wrap((ListChangeListener)new ListListener(), this.listWidget.getDisplay());
    }

    private DisposeListener buildListWidgetDisposeListener() {
        return new ListWidgetDisposeListener();
    }

    private void synchronizeListWidget() {
        String[] items = new String[this.list.size()];
        int i = 0;
        for (E item : this.list) {
            items[i++] = (String)this.transformer.transform(item);
        }
        this.listWidget.setItems(items);
        this.selectionBinding.listChanged();
    }

    void listItemsAdded(ListAddEvent event) {
        if (!this.listWidget.isDisposed()) {
            this.listItemsAdded_(event);
        }
    }

    private void listItemsAdded_(ListAddEvent event) {
        int i = event.getIndex();
        this.list.ensureCapacity(this.list.size() + event.getItemsSize());
        Iterable items = event.getItems();
        for (Object item : items) {
            this.list.add(i, item);
            this.listWidget.add((String)this.transformer.transform(item), i);
            ++i;
        }
        this.selectionBinding.listChanged();
    }

    void listItemsRemoved(ListRemoveEvent event) {
        if (!this.listWidget.isDisposed()) {
            this.listItemsRemoved_(event);
        }
    }

    private void listItemsRemoved_(ListRemoveEvent event) {
        int start = event.getIndex();
        int end = start + event.getItemsSize();
        this.list.subList(start, end).clear();
        this.listWidget.remove(start, end - 1);
        this.selectionBinding.listChanged();
    }

    void listItemsMoved(ListMoveEvent event) {
        if (!this.listWidget.isDisposed()) {
            this.listItemsMoved_(event);
        }
    }

    private void listItemsMoved_(ListMoveEvent event) {
        int target = event.getTargetIndex();
        int source = event.getSourceIndex();
        int len = event.getLength();
        int loStart = Math.min(target, source);
        int hiStart = Math.max(target, source);
        int hiEnd = hiStart + len;
        ArrayList subList = new ArrayList(this.list.subList(loStart, hiEnd));
        Object[] subArray = (String[])ArrayTools.subArray((Object[])this.listWidget.getItems(), (int)loStart, (int)hiEnd);
        int subTarget = target - loStart;
        int subSource = source - loStart;
        subList = (ArrayList)ListTools.move(subList, (int)subTarget, (int)subSource, (int)len);
        subArray = (String[])ArrayTools.move((Object[])subArray, (int)subTarget, (int)subSource, (int)len);
        int subIndex = 0;
        int i = loStart;
        while (i < hiEnd) {
            this.list.set(i, subList.get(subIndex));
            this.listWidget.setItem(i, (String)subArray[subIndex]);
            ++subIndex;
            ++i;
        }
        this.selectionBinding.listChanged();
    }

    void listItemsReplaced(ListReplaceEvent event) {
        if (!this.listWidget.isDisposed()) {
            this.listItemsReplaced_(event);
        }
    }

    private void listItemsReplaced_(ListReplaceEvent event) {
        int i = event.getIndex();
        Iterable newItems = event.getNewItems();
        for (Object item : newItems) {
            this.list.set(i, item);
            this.listWidget.setItem(i, (String)this.transformer.transform(item));
            ++i;
        }
        this.selectionBinding.listChanged();
    }

    void listCleared() {
        if (!this.listWidget.isDisposed()) {
            this.listCleared_();
        }
    }

    private void listCleared_() {
        this.list.clear();
        this.listWidget.removeAll();
    }

    void listChanged(ListChangeEvent event) {
        if (!this.listWidget.isDisposed()) {
            this.listChanged_(event);
        }
    }

    private void listChanged_(ListChangeEvent event) {
        this.list.clear();
        this.list.ensureCapacity(event.getListSize());
        Iterable eventList = event.getList();
        CollectionTools.addAll(this.list, (Iterable)eventList);
        this.synchronizeListWidget();
    }

    void listWidgetDisposed() {
        this.listWidget.removeDisposeListener(this.listWidgetDisposeListener);
        this.listModel.removeListChangeListener("list values", this.listListener);
        this.selectionBinding.dispose();
        this.list.clear();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.list);
    }

    class ListListener
    extends ListChangeAdapter {
        ListListener() {
        }

        public void itemsAdded(ListAddEvent event) {
            ListWidgetModelBinding.this.listItemsAdded(event);
        }

        public void itemsRemoved(ListRemoveEvent event) {
            ListWidgetModelBinding.this.listItemsRemoved(event);
        }

        public void itemsMoved(ListMoveEvent event) {
            ListWidgetModelBinding.this.listItemsMoved(event);
        }

        public void itemsReplaced(ListReplaceEvent event) {
            ListWidgetModelBinding.this.listItemsReplaced(event);
        }

        public void listCleared(ListClearEvent event) {
            ListWidgetModelBinding.this.listCleared();
        }

        public void listChanged(ListChangeEvent event) {
            ListWidgetModelBinding.this.listChanged(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ListWidget<E> {
        public SelectionBinding buildSelectionBinding(ArrayList<E> var1, Object var2);

        public Display getDisplay();

        public boolean isDisposed();

        public void addDisposeListener(DisposeListener var1);

        public void removeDisposeListener(DisposeListener var1);

        public String[] getItems();

        public void setItem(int var1, String var2);

        public void setItems(String[] var1);

        public void add(String var1, int var2);

        public void remove(int var1, int var2);

        public void removeAll();
    }

    class ListWidgetDisposeListener
    extends DisposeAdapter {
        ListWidgetDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent event) {
            ListWidgetModelBinding.this.listWidgetDisposed();
        }
    }

    static interface SelectionBinding {
        public void listChanged();

        public void dispose();
    }
}

