/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRepeatingElementIterator<E>
implements Iterator<E> {
    private final int size;
    int cursor;

    protected AbstractRepeatingElementIterator(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size: " + size);
        }
        this.size = size;
        this.cursor = 0;
    }

    @Override
    public boolean hasNext() {
        return this.cursor != this.size;
    }

    @Override
    public E next() {
        if (this.hasNext()) {
            ++this.cursor;
            return this.getElement();
        }
        throw new NoSuchElementException();
    }

    protected abstract E getElement();

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.size);
    }
}

