/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.db.internal;

import java.util.Arrays;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.ForeignKey;
import org.eclipse.jpt.jpa.db.internal.DTPColumnWrapper;
import org.eclipse.jpt.jpa.db.internal.DTPDatabaseObjectWrapper;
import org.eclipse.jpt.jpa.db.internal.DTPTableWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DTPForeignKeyWrapper
extends DTPDatabaseObjectWrapper<DTPTableWrapper, org.eclipse.datatools.modelbase.sql.constraints.ForeignKey>
implements ForeignKey {
    private DTPTableWrapper referencedTable;
    private LocalColumnPair[] columnPairs;
    private String defaultAttributeName;
    private boolean defaultAttributeNameCalculated = false;
    private static final Predicate<Column> IS_NOT_PART_OF_PRIMARY_KEY = PredicateTools.not(Column.IS_PART_OF_PRIMARY_KEY);

    DTPForeignKeyWrapper(DTPTableWrapper baseTable, org.eclipse.datatools.modelbase.sql.constraints.ForeignKey dtpForeignKey) {
        super(baseTable, dtpForeignKey);
    }

    @Override
    synchronized void catalogObjectChanged() {
        super.catalogObjectChanged();
        this.getConnectionProfile().foreignKeyChanged(this);
    }

    @Override
    public String toString() {
        return ObjectTools.toString((Object)this, (CharSequence)(String.valueOf(this.getName()) + ": " + Arrays.asList(this.getColumnPairArray())));
    }

    @Override
    public DTPTableWrapper getBaseTable() {
        return (DTPTableWrapper)this.parent;
    }

    @Override
    public synchronized DTPTableWrapper getReferencedTable() {
        if (this.referencedTable == null) {
            this.referencedTable = this.getBaseTable().getTable((Table)((org.eclipse.datatools.modelbase.sql.constraints.ForeignKey)this.dtpObject).getUniqueConstraint().getBaseTable());
        }
        return this.referencedTable;
    }

    @Override
    public boolean referencesSingleColumnPrimaryKey() {
        if (this.getColumnPairsSize() != 1) {
            return false;
        }
        if (this.getReferencedTable().getPrimaryKeyColumnsSize() != 1) {
            return false;
        }
        return this.getColumnPair().getReferencedColumn() == this.getReferencedTable().getPrimaryKeyColumn();
    }

    @Override
    public Iterable<ForeignKey.ColumnPair> getColumnPairs() {
        return IterableTools.iterable((Object[])this.getColumnPairArray());
    }

    @Override
    public LocalColumnPair getColumnPair() {
        LocalColumnPair[] pairs = this.getColumnPairArray();
        if (pairs.length != 1) {
            throw new IllegalStateException("multiple column pairs: " + pairs.length);
        }
        return pairs[0];
    }

    private Iterable<LocalColumnPair> getLocalColumnPairs() {
        return IterableTools.iterable((Object[])this.getColumnPairArray());
    }

    private synchronized LocalColumnPair[] getColumnPairArray() {
        if (this.columnPairs == null) {
            this.columnPairs = this.buildColumnPairArray();
        }
        return this.columnPairs;
    }

    private LocalColumnPair[] buildColumnPairArray() {
        List<org.eclipse.datatools.modelbase.sql.tables.Column> baseColumns = this.getDTPBaseColumns();
        int size = baseColumns.size();
        List<org.eclipse.datatools.modelbase.sql.tables.Column> refColumns = this.getDTPReferenceColumns();
        if (refColumns.size() != size) {
            throw new IllegalStateException(String.valueOf(this.getBaseTable().getName()) + '.' + this.getName() + " - mismatched sizes: " + size + " vs. " + refColumns.size());
        }
        Object[] result = new LocalColumnPair[baseColumns.size()];
        int i = baseColumns.size();
        while (i-- > 0) {
            result[i] = new LocalColumnPair(this.getBaseTable().getColumn(baseColumns.get(i)), this.getBaseTable().getColumn(refColumns.get(i)));
        }
        return (LocalColumnPair[])ArrayTools.sort((Object[])result, ForeignKey.ColumnPair.BASE_COLUMN_COMPARATOR);
    }

    private List<org.eclipse.datatools.modelbase.sql.tables.Column> getDTPBaseColumns() {
        return ((org.eclipse.datatools.modelbase.sql.constraints.ForeignKey)this.dtpObject).getMembers();
    }

    private List<org.eclipse.datatools.modelbase.sql.tables.Column> getDTPReferenceColumns() {
        return ((org.eclipse.datatools.modelbase.sql.constraints.ForeignKey)this.dtpObject).getUniqueConstraint().getMembers();
    }

    @Override
    public int getColumnPairsSize() {
        return this.getColumnPairArray().length;
    }

    @Override
    public Iterable<Column> getBaseColumns() {
        return IterableTools.transform(this.getLocalColumnPairs(), LocalColumnPair.BASE_COLUMN_TRANSFORMER);
    }

    boolean baseColumnsContains(Column column) {
        return IterableTools.contains(this.getBaseColumns(), (Object)column);
    }

    @Override
    public Iterable<Column> getNonPrimaryKeyBaseColumns() {
        return IterableTools.filter(this.getBaseColumns(), IS_NOT_PART_OF_PRIMARY_KEY);
    }

    @Override
    public Iterable<Column> getReferencedColumns() {
        return IterableTools.transform(this.getLocalColumnPairs(), LocalColumnPair.REFERENCED_COLUMN_TRANSFORMER);
    }

    @Override
    public String getAttributeName() {
        String defaultName = this.getDefaultAttributeName();
        return defaultName != null ? defaultName : this.getNonDefaultAttributeName();
    }

    @Override
    public synchronized String getDefaultAttributeName() {
        if (!this.defaultAttributeNameCalculated) {
            this.defaultAttributeNameCalculated = true;
            this.defaultAttributeName = this.buildDefaultAttributeName();
        }
        return this.defaultAttributeName;
    }

    private String buildDefaultAttributeName() {
        if (!this.referencesSingleColumnPrimaryKey()) {
            return null;
        }
        LocalColumnPair columnPair = this.getColumnPair();
        String baseColName = columnPair.getBaseColumn().getName();
        String refColName = columnPair.getReferencedColumn().getName();
        if (baseColName.length() <= refColName.length() + 1) {
            return null;
        }
        if (!baseColName.endsWith(refColName)) {
            return null;
        }
        int _index = baseColName.length() - refColName.length() - 1;
        if (baseColName.charAt(_index) != '_') {
            return null;
        }
        return baseColName.substring(0, _index);
    }

    private String getNonDefaultAttributeName() {
        return this.getColumnPairsSize() == 1 ? this.getNonDefaultAttributeNameFromBaseColumn() : this.getReferencedTable().getName();
    }

    private String getNonDefaultAttributeNameFromBaseColumn() {
        int refLen;
        LocalColumnPair columnPair = this.getColumnPair();
        String baseColName = columnPair.getBaseColumn().getName();
        String refColName = columnPair.getReferencedColumn().getName();
        int len = baseColName.length();
        if (len > (refLen = refColName.length()) && baseColName.endsWith(refColName) && (len -= refLen) > 1 && baseColName.charAt(len - 1) == '_') {
            --len;
        }
        return baseColName.substring(0, len);
    }

    @Override
    public String getJoinColumnAnnotationIdentifier(String attributeName) {
        String baseColumnName = this.getColumnPair().getBaseColumn().getName();
        String defaultBaseColumnName = String.valueOf(attributeName) + '_' + this.getReferencedTable().getPrimaryKeyColumn().getName();
        return this.getDTPDriverAdapter().convertNameToIdentifier(baseColumnName, defaultBaseColumnName);
    }

    boolean wraps(org.eclipse.datatools.modelbase.sql.constraints.ForeignKey foreignKey) {
        return this.dtpObject == foreignKey;
    }

    @Override
    synchronized void clear() {
        this.defaultAttributeNameCalculated = false;
        this.defaultAttributeName = null;
        this.columnPairs = null;
        this.referencedTable = null;
    }

    static class LocalColumnPair
    implements ForeignKey.ColumnPair {
        private final DTPColumnWrapper baseColumn;
        private final DTPColumnWrapper referencedColumn;
        public static final Transformer<LocalColumnPair, Column> BASE_COLUMN_TRANSFORMER = new BaseColumnTransformer();
        public static final Transformer<LocalColumnPair, Column> REFERENCED_COLUMN_TRANSFORMER = new ReferencedColumnTransformer();

        LocalColumnPair(DTPColumnWrapper baseColumn, DTPColumnWrapper referencedColumn) {
            if (baseColumn == null || referencedColumn == null) {
                throw new NullPointerException();
            }
            this.baseColumn = baseColumn;
            this.referencedColumn = referencedColumn;
        }

        public DTPColumnWrapper getBaseColumn() {
            return this.baseColumn;
        }

        public DTPColumnWrapper getReferencedColumn() {
            return this.referencedColumn;
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (CharSequence)(String.valueOf(this.baseColumn.getName()) + "=>" + this.referencedColumn.getName()));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class BaseColumnTransformer
        extends TransformerAdapter<LocalColumnPair, Column> {
            public Column transform(LocalColumnPair pair) {
                return pair.getBaseColumn();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class ReferencedColumnTransformer
        extends TransformerAdapter<LocalColumnPair, Column> {
            public Column transform(LocalColumnPair pair) {
                return pair.getReferencedColumn();
            }
        }
    }
}

