/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.features.clientinitiated.paging;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBElement;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.LinkV2;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.features.FeatureResponseBuilderImpl;
import org.eclipse.persistence.jpa.rs.util.IdHelper;
import org.eclipse.persistence.jpa.rs.util.list.PageableCollection;
import org.eclipse.persistence.jpa.rs.util.list.ReadAllQueryResultCollection;
import org.eclipse.persistence.jpa.rs.util.list.ReportQueryResultCollection;
import org.eclipse.persistence.jpa.rs.util.list.ReportQueryResultListItem;

public class PagingResponseBuilder
extends FeatureResponseBuilderImpl {
    private static String NO_PREVIOUS_CHUNK = "-1";

    @Override
    public Object buildReadAllQueryResponse(PersistenceContext context, Map<String, Object> queryParams, List<Object> items, UriInfo uriInfo) {
        ReadAllQueryResultCollection response = new ReadAllQueryResultCollection();
        for (Object item : items) {
            response.addItem(this.populatePagedReadAllQueryItemLinks(context, item));
        }
        response.setCount(items.size());
        return this.populatePagedCollectionLinks(queryParams, uriInfo, response);
    }

    @Override
    public Object buildReportQueryResponse(PersistenceContext context, Map<String, Object> queryParams, List<Object[]> results, List<ReportItem> items, UriInfo uriInfo) {
        return this.populatePagedReportQueryCollectionLinks(queryParams, results, items, uriInfo);
    }

    @Override
    public Object buildAttributeResponse(PersistenceContext context, Map<String, Object> queryParams, String attribute, Object results, UriInfo uriInfo) {
        List<Object> items;
        ReadAllQueryResultCollection collection;
        if (results instanceof Collection && this.containsDomainObjects(results) && (collection = (ReadAllQueryResultCollection)results) != null && (items = collection.getItems()) != null && !items.isEmpty()) {
            ReadAllQueryResultCollection response = new ReadAllQueryResultCollection();
            response.setItems(items);
            response.setCount(collection.getItems().size());
            return this.populatePagedCollectionLinks(queryParams, uriInfo, response);
        }
        return results;
    }

    private boolean containsDomainObjects(Object object) {
        Collection collection = (Collection)object;
        for (Object collectionItem : collection) {
            if (!PersistenceWeavedRest.class.isAssignableFrom(collectionItem.getClass())) continue;
            return true;
        }
        return false;
    }

    private Object populatePagedReadAllQueryItemLinks(PersistenceContext context, Object result) {
        ClassDescriptor descriptor = context.getJAXBDescriptorForClass(result.getClass());
        if (result instanceof PersistenceWeavedRest && descriptor != null && context != null) {
            ItemLinks itemLinks = new ItemLinks();
            PersistenceWeavedRest entity = (PersistenceWeavedRest)result;
            String entityId = IdHelper.stringifyId(result, descriptor.getAlias(), context);
            String href = context.getBaseURI() + context.getVersion() + "/" + context.getName() + "/entity/" + descriptor.getAlias() + "/" + entityId;
            itemLinks.addItem(new LinkV2("self", href));
            entity._persistence_setLinks(itemLinks);
            return entity;
        }
        return result;
    }

    private PageableCollection populatePagedCollectionLinks(Map<String, Object> queryParams, UriInfo uriInfo, PageableCollection resultCollection) {
        UriBuilder uriBuilder;
        ArrayList<LinkV2> links = new ArrayList<LinkV2>();
        int limit = Integer.parseInt((String)queryParams.get("limit"));
        int offset = Integer.parseInt((String)queryParams.get("offset"));
        String nextOffset = null;
        String prevOffset = null;
        if (limit > offset) {
            nextOffset = String.valueOf(limit);
            prevOffset = NO_PREVIOUS_CHUNK;
        } else {
            if (limit == offset) {
                prevOffset = "0";
            }
            nextOffset = String.valueOf(limit + offset);
            prevOffset = String.valueOf(offset - limit);
        }
        if (resultCollection.getCount() != null) {
            int actualCount = resultCollection.getCount();
            if (actualCount >= limit) {
                uriBuilder = UriBuilder.fromUri((URI)uriInfo.getRequestUri());
                uriBuilder.replaceQueryParam("offset", new Object[]{nextOffset});
                links.add(new LinkV2("next", uriBuilder.build(new Object[0]).toString()));
                resultCollection.setHasMore(true);
            } else {
                resultCollection.setHasMore(false);
            }
        }
        if (!NO_PREVIOUS_CHUNK.equals(prevOffset)) {
            uriBuilder = UriBuilder.fromUri((URI)uriInfo.getRequestUri());
            uriBuilder.replaceQueryParam("offset", new Object[]{prevOffset});
            links.add(new LinkV2("prev", uriBuilder.build(new Object[0]).toString()));
        }
        links.add(new LinkV2("self", uriInfo.getRequestUri().toString()));
        resultCollection.setLinks(links);
        resultCollection.setOffset(offset);
        resultCollection.setLimit(limit);
        return resultCollection;
    }

    private PageableCollection populatePagedReportQueryCollectionLinks(Map<String, Object> queryParams, List<Object[]> results, List<ReportItem> reportItems, UriInfo uriInfo) {
        ReportQueryResultCollection response = new ReportQueryResultCollection();
        for (Object[] result : results) {
            ReportQueryResultListItem queryResultListItem = new ReportQueryResultListItem();
            List<JAXBElement> jaxbFields = this.createShellJAXBElementList(reportItems, result);
            if (jaxbFields == null) {
                return null;
            }
            queryResultListItem.setFields(jaxbFields);
            response.addItem(queryResultListItem);
        }
        response.setCount(results.size());
        return this.populatePagedCollectionLinks(queryParams, uriInfo, response);
    }
}

