/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.resources.common;

import java.util.List;
import javax.persistence.Query;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBElement;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.exceptions.JPARSException;
import org.eclipse.persistence.jpa.rs.features.FeatureResponseBuilder;
import org.eclipse.persistence.jpa.rs.features.FeatureResponseBuilderImpl;
import org.eclipse.persistence.jpa.rs.features.FeatureSet;
import org.eclipse.persistence.jpa.rs.resources.common.AbstractResource;
import org.eclipse.persistence.jpa.rs.util.JPARSLogger;
import org.eclipse.persistence.jpa.rs.util.StreamingOutputMarshaller;
import org.eclipse.persistence.jpa.rs.util.list.SingleResultQueryList;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;

public abstract class AbstractSingleResultQueryResource
extends AbstractResource {
    private static final String CLASS_NAME = AbstractSingleResultQueryResource.class.getName();

    protected Response namedQuerySingleResultInternal(String version, String persistenceUnit, String queryName, HttpHeaders headers, UriInfo uriInfo) {
        JPARSLogger.entering(CLASS_NAME, "namedQuerySingleResultInternal", new Object[]{"GET", version, persistenceUnit, queryName, uriInfo.getRequestUri().toASCIIString()});
        try {
            PersistenceContext context = this.getPersistenceContext(persistenceUnit, null, uriInfo.getBaseUri(), version, null);
            Query query = context.buildQuery(AbstractSingleResultQueryResource.getMatrixParameters(uriInfo, persistenceUnit), queryName, AbstractSingleResultQueryResource.getMatrixParameters(uriInfo, queryName), AbstractSingleResultQueryResource.getQueryParameters(uriInfo));
            DatabaseQuery dbQuery = ((EJBQueryImpl)query).getDatabaseQuery();
            if (dbQuery instanceof ReportQuery) {
                List reportItems = ((ReportQuery)dbQuery).getItems();
                Object queryResults = query.getSingleResult();
                SingleResultQueryList list = this.populateReportQueryResponse(queryResults, reportItems);
                if (list != null) {
                    List acceptableMediaTypes;
                    JAXBElement element;
                    Object elementValue;
                    List<JAXBElement> item = list.getFields();
                    if (item != null && item.size() == 1 && (elementValue = (element = item.get(0)).getValue()) instanceof byte[] && (acceptableMediaTypes = headers.getAcceptableMediaTypes()).contains(MediaType.APPLICATION_OCTET_STREAM_TYPE)) {
                        return Response.ok((Object)new StreamingOutputMarshaller(context, elementValue, headers.getAcceptableMediaTypes())).build();
                    }
                    return Response.ok((Object)new StreamingOutputMarshaller(context, (Object)list, headers.getAcceptableMediaTypes())).build();
                }
                throw JPARSException.responseCouldNotBeBuiltForNamedQueryRequest(queryName, context.getName());
            }
            Object queryResult = query.getSingleResult();
            FeatureSet featureSet = context.getSupportedFeatureSet();
            FeatureResponseBuilder responseBuilder = featureSet.getResponseBuilder(FeatureSet.Feature.NO_PAGING);
            return Response.ok((Object)new StreamingOutputMarshaller(context, responseBuilder.buildSingleEntityResponse(context, AbstractSingleResultQueryResource.getQueryParameters(uriInfo), queryResult, uriInfo), headers.getAcceptableMediaTypes())).build();
        }
        catch (Exception ex) {
            throw JPARSException.exceptionOccurred(ex);
        }
    }

    private SingleResultQueryList populateReportQueryResponse(Object result, List<ReportItem> reportItems) {
        SingleResultQueryList response = new SingleResultQueryList();
        List<JAXBElement> fields = new FeatureResponseBuilderImpl().createShellJAXBElementList(reportItems, result);
        if (fields == null) {
            return null;
        }
        response.setFields(fields);
        return response;
    }
}

