/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value.swing;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.closure.Closure;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.internal.iterator.TransformationIterator;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SortedListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.swing.TableModelAdapter;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableModelAdapterTests
extends TestCase {
    private Crowd crowd;
    TableModelEvent event;

    public TableModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.crowd = this.buildCrowd();
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testGetRowCount() throws Exception {
        TableModelAdapter<Person> tableModelAdapter = this.buildTableModelAdapter();
        TableModelAdapterTests.assertEquals((int)0, (int)tableModelAdapter.getRowCount());
        tableModelAdapter.addTableModelListener(this.buildTableModelListener());
        TableModelAdapterTests.assertEquals((int)this.crowd.peopleSize(), (int)tableModelAdapter.getRowCount());
    }

    public void testGetColumnCount() throws Exception {
        TableModelAdapter<Person> tableModelAdapter = this.buildTableModelAdapter();
        TableModelAdapterTests.assertEquals((int)7, (int)tableModelAdapter.getColumnCount());
    }

    public void testGetValueAt() throws Exception {
        TableModelAdapter<Person> tableModelAdapter = this.buildTableModelAdapter();
        tableModelAdapter.addTableModelListener(this.buildTableModelListener());
        List<String> sortedNames = this.sortedNames();
        int i = 0;
        while (i < this.crowd.peopleSize()) {
            TableModelAdapterTests.assertEquals((Object)sortedNames.get(i), (Object)tableModelAdapter.getValueAt(i, 0));
            ++i;
        }
    }

    public void testSetValueAt() throws Exception {
        TableModelAdapter<Person> tableModelAdapter = this.buildTableModelAdapter();
        this.event = null;
        tableModelAdapter.addTableModelListener((TableModelListener)new TestTableModelListener(){

            public void tableChanged(TableModelEvent e) {
                TableModelAdapterTests.this.event = e;
            }
        });
        Person person = this.crowd.personNamed("Gollum");
        TableModelAdapterTests.assertEquals((String)"blue", (String)person.getEyeColor());
        TableModelAdapterTests.assertFalse((boolean)person.isEvil());
        TableModelAdapterTests.assertEquals((int)0, (int)person.getRank());
        int i = 0;
        while (i < tableModelAdapter.getRowCount()) {
            if (tableModelAdapter.getValueAt(i, 0).equals("Gollum")) {
                tableModelAdapter.setValueAt((Object)"hazel", i, 3);
                tableModelAdapter.setValueAt((Object)Boolean.TRUE, i, 4);
                tableModelAdapter.setValueAt((Object)new Integer(-1), i, 5);
                break;
            }
            ++i;
        }
        TableModelAdapterTests.assertNotNull((Object)this.event);
        TableModelAdapterTests.assertEquals((String)"hazel", (String)person.getEyeColor());
        TableModelAdapterTests.assertTrue((boolean)person.isEvil());
        TableModelAdapterTests.assertEquals((int)-1, (int)person.getRank());
    }

    public void testAddRow() throws Exception {
        TableModelAdapter<Person> tableModelAdapter = this.buildTableModelAdapter();
        this.event = null;
        tableModelAdapter.addTableModelListener(this.buildSingleEventListener());
        this.crowd.addPerson("Zzzzz");
        TableModelAdapterTests.assertNotNull((Object)this.event);
        TableModelAdapterTests.assertEquals((int)1, (int)this.event.getType());
        TableModelAdapterTests.assertEquals((int)-1, (int)this.event.getColumn());
    }

    public void testRemoveRow() throws Exception {
        TableModelAdapter<Person> tableModelAdapter = this.buildTableModelAdapter();
        this.event = null;
        tableModelAdapter.addTableModelListener(this.buildSingleEventListener());
        this.crowd.removePerson(this.crowd.personNamed("Gollum"));
        TableModelAdapterTests.assertNotNull((Object)this.event);
        TableModelAdapterTests.assertEquals((int)-1, (int)this.event.getType());
        TableModelAdapterTests.assertEquals((int)-1, (int)this.event.getColumn());
    }

    public void testChangeCell() throws Exception {
        TableModelAdapter<Person> tableModelAdapter = this.buildTableModelAdapter();
        this.event = null;
        tableModelAdapter.addTableModelListener(this.buildSingleEventListener());
        Person person = this.crowd.personNamed("Gollum");
        person.setEvil(true);
        TableModelAdapterTests.assertNotNull((Object)this.event);
        TableModelAdapterTests.assertEquals((int)0, (int)this.event.getType());
        TableModelAdapterTests.assertEquals((int)4, (int)this.event.getColumn());
    }

    public void testLazyListListener() throws Exception {
        TableModelAdapter<Person> tableModelAdapter = this.buildTableModelAdapter();
        TableModelListener listener = this.buildTableModelListener();
        TableModelAdapterTests.assertTrue((boolean)this.crowd.hasNoCollectionChangeListeners("people"));
        tableModelAdapter.addTableModelListener(listener);
        TableModelAdapterTests.assertTrue((boolean)this.crowd.hasAnyCollectionChangeListeners("people"));
        tableModelAdapter.removeTableModelListener(listener);
        TableModelAdapterTests.assertTrue((boolean)this.crowd.hasNoCollectionChangeListeners("people"));
    }

    public void testLazyCellListener() throws Exception {
        TableModelAdapter<Person> tableModelAdapter = this.buildTableModelAdapter();
        TableModelListener listener = this.buildTableModelListener();
        Person person = this.crowd.personNamed("Gollum");
        TableModelAdapterTests.assertTrue((boolean)person.hasNoPropertyChangeListeners("name"));
        TableModelAdapterTests.assertTrue((boolean)person.hasNoPropertyChangeListeners("birthDate"));
        TableModelAdapterTests.assertTrue((boolean)person.hasNoPropertyChangeListeners("eyeColor"));
        TableModelAdapterTests.assertTrue((boolean)person.hasNoPropertyChangeListeners("evil"));
        TableModelAdapterTests.assertTrue((boolean)person.hasNoPropertyChangeListeners("rank"));
        tableModelAdapter.addTableModelListener(listener);
        TableModelAdapterTests.assertTrue((boolean)person.hasAnyPropertyChangeListeners("name"));
        TableModelAdapterTests.assertTrue((boolean)person.hasAnyPropertyChangeListeners("birthDate"));
        TableModelAdapterTests.assertTrue((boolean)person.hasAnyPropertyChangeListeners("eyeColor"));
        TableModelAdapterTests.assertTrue((boolean)person.hasAnyPropertyChangeListeners("evil"));
        TableModelAdapterTests.assertTrue((boolean)person.hasAnyPropertyChangeListeners("rank"));
        tableModelAdapter.removeTableModelListener(listener);
        TableModelAdapterTests.assertTrue((boolean)person.hasNoPropertyChangeListeners("name"));
        TableModelAdapterTests.assertTrue((boolean)person.hasNoPropertyChangeListeners("birthDate"));
        TableModelAdapterTests.assertTrue((boolean)person.hasNoPropertyChangeListeners("eyeColor"));
        TableModelAdapterTests.assertTrue((boolean)person.hasNoPropertyChangeListeners("evil"));
        TableModelAdapterTests.assertTrue((boolean)person.hasNoPropertyChangeListeners("rank"));
    }

    private TableModelAdapter<Person> buildTableModelAdapter() {
        return new TableModelAdapter<Person>(this.buildSortedPeopleAdapter(), this.buildColumnAdapter()){

            protected PropertyChangeListener buildCellListener() {
                return this.buildCellListener_();
            }

            protected ListChangeListener buildListChangeListener() {
                return this.buildListChangeListener_();
            }
        };
    }

    private ListValueModel<Person> buildSortedPeopleAdapter() {
        return new SortedListValueModelAdapter(this.buildPeopleAdapter());
    }

    private CollectionValueModel<Person> buildPeopleAdapter() {
        return new CollectionAspectAdapter<Crowd, Person>("people", this.crowd){

            protected Iterator<Person> iterator_() {
                return ((Crowd)((Object)this.subject)).people();
            }

            protected int size_() {
                return ((Crowd)((Object)this.subject)).peopleSize();
            }
        };
    }

    private Crowd buildCrowd() {
        Crowd result = new Crowd();
        result.addPerson("Bilbo");
        result.addPerson("Gollum");
        result.addPerson("Frodo");
        result.addPerson("Samwise");
        return result;
    }

    private TableModelAdapter.ColumnAdapter buildColumnAdapter() {
        return new PersonColumnAdapter();
    }

    private TableModelListener buildTableModelListener() {
        return new TestTableModelListener();
    }

    private List<String> sortedNames() {
        return new ArrayList<String>(CollectionTools.sortedSet(this.crowd.peopleNames()));
    }

    private TableModelListener buildSingleEventListener() {
        return new TestTableModelListener(){

            public void tableChanged(TableModelEvent e) {
                if (TableModelAdapterTests.this.event == null) {
                    TableModelAdapterTests.this.event = e;
                } else {
                    TableModelAdapterTests.fail((String)"unexpected event");
                }
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Crowd
    extends AbstractModel {
        private final Collection<Person> people = new ArrayList<Person>();
        public static final String PEOPLE_COLLECTION = "people";

        public Iterator<Person> people() {
            return IteratorTools.clone(this.people, (Closure)new Closure<Person>(){

                public void execute(Person person) {
                    Crowd.this.removePerson(person);
                }
            });
        }

        public int peopleSize() {
            return this.people.size();
        }

        public Person addPerson(String name) {
            this.checkPersonName(name);
            return this.addPerson(new Person(this, name));
        }

        private Person addPerson(Person person) {
            this.addItemToCollection(person, this.people, PEOPLE_COLLECTION);
            return person;
        }

        public void removePerson(Person person) {
            this.removeItemFromCollection(person, this.people, PEOPLE_COLLECTION);
        }

        public void removePeople(Collection<Person> persons) {
            this.removeItemsFromCollection(persons, this.people, PEOPLE_COLLECTION);
        }

        public void removePeople(Iterator<Person> persons) {
            this.removeItemsFromCollection(persons, this.people, PEOPLE_COLLECTION);
        }

        void checkPersonName(String personName) {
            if (personName == null) {
                throw new NullPointerException();
            }
            if (IteratorTools.contains(this.peopleNames(), (Object)personName)) {
                throw new IllegalArgumentException(personName);
            }
        }

        public Iterator<String> peopleNames() {
            return new TransformationIterator(this.people.iterator(), Person.NAME_TRANSFORMER);
        }

        public Person personNamed(String name) {
            for (Person person : this.people) {
                if (!person.getName().equals(name)) continue;
                return person;
            }
            return null;
        }

        public String toString() {
            return ObjectTools.toString((Object)((Object)this), (CharSequence)(String.valueOf(String.valueOf(this.people.size())) + " people"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Person
    extends AbstractModel
    implements Comparable<Person> {
        private Crowd crowd;
        private String name;
        public static final String NAME_PROPERTY = "name";
        private Date birthDate;
        public static final String BIRTH_DATE_PROPERTY = "birthDate";
        private Date goneWestDate;
        public static final String GONE_WEST_DATE_PROPERTY = "goneWestDate";
        private String eyeColor;
        public static final String EYE_COLOR_PROPERTY = "eyeColor";
        public static final String EYE_COLOR_BLUE = "blue";
        public static final String EYE_COLOR_GREEN = "green";
        public static final String EYE_COLOR_BROWN = "brown";
        public static final String EYE_COLOR_HAZEL = "hazel";
        public static final String EYE_COLOR_PINK = "pink";
        private static Collection<String> validEyeColors;
        public static final String DEFAULT_EYE_COLOR = "blue";
        private boolean evil;
        public static final String EVIL_PROPERTY = "evil";
        private int rank;
        public static final String RANK_PROPERTY = "rank";
        private int adventureCount;
        public static final String ADVENTURE_COUNT_PROPERTY = "adventureCount";
        public static final Transformer<Person, String> NAME_TRANSFORMER;

        static {
            NAME_TRANSFORMER = new NameTransformer();
        }

        Person(Crowd crowd, String name) {
            this.crowd = crowd;
            this.name = name;
            this.birthDate = new Date();
            Calendar c = Calendar.getInstance();
            c.add(1, 250);
            this.goneWestDate = new Date(c.getTimeInMillis());
            this.eyeColor = "blue";
            this.evil = false;
            this.rank = 0;
            this.adventureCount = 0;
        }

        public static Collection<String> getValidEyeColors() {
            if (validEyeColors == null) {
                validEyeColors = Person.buildValidEyeColors();
            }
            return validEyeColors;
        }

        private static Collection<String> buildValidEyeColors() {
            ArrayList<String> result = new ArrayList<String>();
            result.add("blue");
            result.add(EYE_COLOR_GREEN);
            result.add(EYE_COLOR_BROWN);
            result.add(EYE_COLOR_HAZEL);
            result.add(EYE_COLOR_PINK);
            return result;
        }

        public Crowd getCrowd() {
            return this.crowd;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.crowd.checkPersonName(name);
            String old = this.name;
            this.name = name;
            this.firePropertyChanged(NAME_PROPERTY, old, name);
        }

        public Date getBirthDate() {
            return this.birthDate;
        }

        public void setBirthDate(Date birthDate) {
            Date old = this.birthDate;
            this.birthDate = birthDate;
            this.firePropertyChanged(BIRTH_DATE_PROPERTY, old, birthDate);
        }

        public Date getGoneWestDate() {
            return this.goneWestDate;
        }

        public void setGoneWestDate(Date goneWestDate) {
            Date old = this.goneWestDate;
            this.goneWestDate = goneWestDate;
            this.firePropertyChanged(GONE_WEST_DATE_PROPERTY, old, goneWestDate);
        }

        public String getEyeColor() {
            return this.eyeColor;
        }

        public void setEyeColor(String eyeColor) {
            if (!Person.getValidEyeColors().contains(eyeColor)) {
                throw new IllegalArgumentException(eyeColor);
            }
            String old = this.eyeColor;
            this.eyeColor = eyeColor;
            this.firePropertyChanged(EYE_COLOR_PROPERTY, old, eyeColor);
        }

        public boolean isEvil() {
            return this.evil;
        }

        public void setEvil(boolean evil) {
            boolean old = this.evil;
            this.evil = evil;
            this.firePropertyChanged(EVIL_PROPERTY, old, evil);
        }

        public int getRank() {
            return this.rank;
        }

        public void setRank(int rank) {
            int old = this.rank;
            this.rank = rank;
            this.firePropertyChanged(RANK_PROPERTY, old, rank);
        }

        public int getAdventureCount() {
            return this.adventureCount;
        }

        public void setAdventureCount(int adventureCount) {
            int old = this.adventureCount;
            this.adventureCount = adventureCount;
            this.firePropertyChanged(ADVENTURE_COUNT_PROPERTY, old, adventureCount);
        }

        @Override
        public int compareTo(Person p) {
            return this.name.compareToIgnoreCase(p.name);
        }

        public String toString() {
            return String.valueOf(this.name) + "\tborn: " + DateFormat.getDateInstance().format(this.birthDate) + "\tgone west: " + DateFormat.getDateInstance().format(this.goneWestDate) + "\teyes: " + this.eyeColor + "\tevil: " + this.evil + "\trank: " + this.rank + "\tadventures: " + this.adventureCount;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class NameTransformer
        extends TransformerAdapter<Person, String> {
            public String transform(Person person) {
                return person.getName();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PersonColumnAdapter
    implements TableModelAdapter.ColumnAdapter {
        public static final int COLUMN_COUNT = 7;
        public static final int NAME_COLUMN = 0;
        public static final int BIRTH_DATE_COLUMN = 1;
        public static final int GONE_WEST_DATE_COLUMN = 2;
        public static final int EYE_COLOR_COLUMN = 3;
        public static final int EVIL_COLUMN = 4;
        public static final int RANK_COLUMN = 5;
        public static final int ADVENTURE_COUNT_COLUMN = 6;
        private static final String[] COLUMN_NAMES = new String[]{"Name", "Birth", "Gone West", "Eyes", "Evil", "Rank", "Adventures"};

        public int columnCount() {
            return 7;
        }

        public String columnName(int index) {
            return COLUMN_NAMES[index];
        }

        public Class<?> columnClass(int index) {
            switch (index) {
                case 0: {
                    return Object.class;
                }
                case 1: {
                    return Date.class;
                }
                case 2: {
                    return Date.class;
                }
                case 3: {
                    return Object.class;
                }
                case 4: {
                    return Boolean.class;
                }
                case 5: {
                    return Integer.class;
                }
                case 6: {
                    return Integer.class;
                }
            }
            return Object.class;
        }

        public boolean columnIsEditable(int index) {
            return index != 0;
        }

        public ModifiablePropertyValueModel<Object>[] cellModels(Object subject) {
            Person person = (Person)subject;
            ModifiablePropertyValueModel[] result = new ModifiablePropertyValueModel[]{this.buildNameAdapter(person), this.buildBirthDateAdapter(person), this.buildGoneWestDateAdapter(person), this.buildEyeColorAdapter(person), this.buildEvilAdapter(person), this.buildRankAdapter(person), this.buildAdventureCountAdapter(person)};
            return result;
        }

        private ModifiablePropertyValueModel<Object> buildNameAdapter(Person person) {
            return new PropertyAspectAdapter<Person, Object>("name", person){

                protected String buildValue_() {
                    return ((Person)this.subject).getName();
                }

                protected void setValue_(Object value) {
                    ((Person)this.subject).setName((String)value);
                }
            };
        }

        private ModifiablePropertyValueModel<Object> buildBirthDateAdapter(Person person) {
            return new PropertyAspectAdapter<Person, Object>("birthDate", person){

                protected Date buildValue_() {
                    return ((Person)this.subject).getBirthDate();
                }

                protected void setValue_(Object value) {
                    ((Person)this.subject).setBirthDate((Date)value);
                }
            };
        }

        private ModifiablePropertyValueModel<Object> buildGoneWestDateAdapter(Person person) {
            return new PropertyAspectAdapter<Person, Object>("goneWestDate", person){

                protected Date buildValue_() {
                    return ((Person)this.subject).getGoneWestDate();
                }

                protected void setValue_(Object value) {
                    ((Person)this.subject).setGoneWestDate((Date)value);
                }
            };
        }

        private ModifiablePropertyValueModel<Object> buildEyeColorAdapter(Person person) {
            return new PropertyAspectAdapter<Person, Object>("eyeColor", person){

                protected String buildValue_() {
                    return ((Person)this.subject).getEyeColor();
                }

                protected void setValue_(Object value) {
                    ((Person)this.subject).setEyeColor((String)value);
                }
            };
        }

        private ModifiablePropertyValueModel<Object> buildEvilAdapter(Person person) {
            return new PropertyAspectAdapter<Person, Object>("evil", person){

                protected Boolean buildValue_() {
                    return ((Person)this.subject).isEvil();
                }

                protected void setValue_(Object value) {
                    ((Person)this.subject).setEvil((Boolean)value);
                }
            };
        }

        private ModifiablePropertyValueModel<Object> buildRankAdapter(Person person) {
            return new PropertyAspectAdapter<Person, Object>("rank", person){

                protected Integer buildValue_() {
                    return new Integer(((Person)this.subject).getRank());
                }

                protected void setValue_(Object value) {
                    ((Person)this.subject).setRank((Integer)value);
                }
            };
        }

        private ModifiablePropertyValueModel<Object> buildAdventureCountAdapter(Person person) {
            return new PropertyAspectAdapter<Person, Object>("adventureCount", person){

                protected Integer buildValue_() {
                    return new Integer(((Person)this.subject).getAdventureCount());
                }

                protected void setValue_(Object value) {
                    ((Person)this.subject).setAdventureCount((Integer)value);
                }
            };
        }
    }

    private class TestTableModelListener
    implements TableModelListener {
        TestTableModelListener() {
        }

        public void tableChanged(TableModelEvent e) {
            TableModelAdapterTests.fail((String)"unexpected event");
        }
    }
}

