/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.hyperlink;

import java.util.ArrayList;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslation;
import org.eclipse.jst.jsp.ui.internal.Logger;
import org.eclipse.jst.jsp.ui.internal.hyperlink.JSPJavaHyperlink;
import org.eclipse.jst.jsp.ui.internal.hyperlink.WorkspaceFileHyperlink;

public class JSPJavaHyperlinkDetector
extends AbstractHyperlinkDetector {
    static /* synthetic */ Class class$0;

    private IHyperlink createHyperlink(IJavaElement element, IRegion region, IDocument document) {
        Object link = null;
        if (region != null) {
            boolean isInTranslationCU = false;
            if (element instanceof ISourceReference) {
                IFile file = null;
                int jspOffset = 0;
                ITextFileBuffer textFileBuffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(document);
                if (textFileBuffer != null && textFileBuffer.getLocation() != null) {
                    file = this.getFile(textFileBuffer.getLocation().toString());
                }
                try {
                    ISourceRange range = null;
                    JSPTranslation jspTranslation = this.getJSPTranslation(document);
                    if (jspTranslation != null) {
                        ICompilationUnit cu;
                        if (element instanceof ILocalVariable) {
                            range = ((ILocalVariable)element).getNameRange();
                            IJavaElement cu2 = ((ILocalVariable)element).getAncestor(5);
                            if (cu2 != null && cu2.equals(jspTranslation.getCompilationUnit())) {
                                isInTranslationCU = true;
                            }
                        } else if (element.getElementType() == 8) {
                            ICompilationUnit cu3 = ((IField)element).getCompilationUnit();
                            if (cu3 != null && cu3.equals(jspTranslation.getCompilationUnit())) {
                                range = ((ISourceReference)element).getSourceRange();
                                isInTranslationCU = true;
                            }
                        } else if (element.getElementType() == 9 && (cu = ((IMethod)element).getCompilationUnit()) != null && cu.equals(jspTranslation.getCompilationUnit())) {
                            range = ((ISourceReference)element).getSourceRange();
                            isInTranslationCU = true;
                        }
                    }
                    if (jspTranslation != null && range != null && file != null && (jspOffset = jspTranslation.getJspOffset(range.getOffset())) >= 0) {
                        link = new WorkspaceFileHyperlink(region, file, (IRegion)new Region(jspOffset, range.getLength()));
                    }
                }
                catch (JavaModelException jme) {
                    Logger.log(202, jme.getMessage(), jme);
                }
            }
            if (link == null && !isInTranslationCU) {
                link = new JSPJavaHyperlink(region, element);
            }
        }
        return link;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IJavaElement[] elements;
        int javaOffset;
        IDocument document;
        JSPTranslation jspTranslation;
        ArrayList<IHyperlink> hyperlinks = new ArrayList<IHyperlink>(0);
        if (region != null && textViewer != null && (jspTranslation = this.getJSPTranslation(document = textViewer.getDocument())) != null && (javaOffset = jspTranslation.getJavaOffset(region.getOffset())) > -1 && !jspTranslation.isIndirect(javaOffset) && (elements = jspTranslation.getElementsFromJspRange(region.getOffset(), region.getOffset() + region.getLength())) != null && elements.length > 0) {
            int i = 0;
            while (i < elements.length) {
                IJavaElement element = elements[i];
                IRegion hyperlinkRegion = this.selectWord(document, region.getOffset());
                IHyperlink link = this.createHyperlink(element, hyperlinkRegion, document);
                if (link != null) {
                    hyperlinks.add(link);
                }
                ++i;
            }
        }
        if (hyperlinks.isEmpty()) {
            return null;
        }
        return hyperlinks.toArray(new IHyperlink[0]);
    }

    private IFile getFile(String fileString) {
        IFile file = null;
        if (fileString != null) {
            Path filePath = new Path(fileString);
            if (filePath.segmentCount() > 1 && ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)filePath).exists()) {
                return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)filePath);
            }
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)filePath);
            int i = 0;
            while (i < files.length && file == null) {
                if (files[i].exists()) {
                    file = files[i];
                }
                ++i;
            }
        }
        return file;
    }

    /*
     * Exception decompiling
     */
    private JSPTranslation getJSPTranslation(IDocument document) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 110->113)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IRegion selectWord(IDocument document, int anchor) {
        try {
            char c;
            int offset = anchor;
            while (offset >= 0) {
                c = document.getChar(offset);
                if (!Character.isJavaIdentifierPart(c)) break;
                --offset;
            }
            int start = offset;
            offset = anchor;
            int length = document.getLength();
            while (offset < length) {
                c = document.getChar(offset);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++offset;
            }
            int end = offset;
            if (start == end) {
                return new Region(start, 0);
            }
            return new Region(start + 1, end - start - 1);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }
}

