/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IExtendedModifier;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.SourceReferenceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ConstructorReferenceFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ReferenceFinderUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.TypeVariableMaplet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsModel;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsSolver;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints.SuperTypeRefactoringProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextEditBasedChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;

public abstract class HierarchyProcessor
extends SuperTypeRefactoringProcessor {
    protected IType fCachedDeclaringType;
    protected final Map fCachedMembersReferences = new HashMap(2);
    protected IType[] fCachedReferencedTypes;
    protected TextEditBasedChangeManager fChangeManager;
    protected final boolean fLayer;
    protected IMember[] fMembersToMove;

    protected static boolean areAllFragmentsDeleted(FieldDeclaration declaration, List declarationNodes) {
        Iterator iterator = declaration.fragments().iterator();
        while (iterator.hasNext()) {
            if (declarationNodes.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    protected static RefactoringStatus checkProjectCompliance(CompilationUnitRewrite sourceRewriter, IType destination, IMember[] members) {
        RefactoringStatus status = new RefactoringStatus();
        if (!JavaModelUtil.is50OrHigher(destination.getJavaScriptProject())) {
            int index = 0;
            while (index < members.length) {
                if (members[index] instanceof IFunction) {
                    IFunction method = (IFunction)members[index];
                    try {
                        if (Flags.isVarargs((int)method.getFlags())) {
                            status.merge(RefactoringStatus.createErrorStatus((String)Messages.format(RefactoringCoreMessages.PullUpRefactoring_incompatible_language_constructs1, new String[]{JavaScriptElementLabels.getTextLabel(members[index], JavaScriptElementLabels.ALL_FULLY_QUALIFIED), JavaScriptElementLabels.getTextLabel(destination, JavaScriptElementLabels.ALL_DEFAULT)}), (RefactoringStatusContext)JavaStatusContext.create(members[index])));
                        }
                    }
                    catch (JavaScriptModelException exception) {
                        JavaScriptPlugin.log(exception);
                    }
                }
                ++index;
            }
        }
        return status;
    }

    protected static void copyAnnotations(FieldDeclaration oldField, FieldDeclaration newField) {
        newField.getAST();
        int index = 0;
        int n = oldField.modifiers().size();
        while (index < n) {
            IExtendedModifier cfr_ignored_0 = (IExtendedModifier)oldField.modifiers().get(index);
            newField.modifiers();
            ++index;
        }
    }

    protected static void copyAnnotations(FunctionDeclaration oldMethod, FunctionDeclaration newMethod) {
        newMethod.getAST();
        int index = 0;
        int n = oldMethod.modifiers().size();
        while (index < n) {
            IExtendedModifier cfr_ignored_0 = (IExtendedModifier)oldMethod.modifiers().get(index);
            newMethod.modifiers();
            ++index;
        }
    }

    protected static void copyJavadocNode(ASTRewrite rewrite, IMember member, BodyDeclaration oldDeclaration, BodyDeclaration newDeclaration) throws JavaScriptModelException {
        JSdoc predecessor = oldDeclaration.getJavadoc();
        if (predecessor != null) {
            Document buffer = new Document(member.getJavaScriptUnit().getBuffer().getContents());
            try {
                String[] lines = Strings.convertIntoLines(buffer.get(predecessor.getStartPosition(), predecessor.getLength()));
                Strings.trimIndentation(lines, member.getJavaScriptProject(), false);
                JSdoc successor = (JSdoc)rewrite.createStringPlaceholder(Strings.concatenate(lines, TextUtilities.getDefaultLineDelimiter((IDocument)buffer)), 29);
                newDeclaration.setJavadoc(successor);
            }
            catch (BadLocationException exception) {
                JavaScriptPlugin.log(exception);
            }
        }
    }

    protected static void copyThrownExceptions(FunctionDeclaration oldMethod, FunctionDeclaration newMethod) {
        AST ast = newMethod.getAST();
        int index = 0;
        int n = oldMethod.thrownExceptions().size();
        while (index < n) {
            newMethod.thrownExceptions().add(index, ASTNode.copySubtree((AST)ast, (ASTNode)((Name)oldMethod.thrownExceptions().get(index))));
            ++index;
        }
    }

    protected static String createLabel(IMember member) {
        if (member instanceof IType) {
            return JavaScriptElementLabels.getTextLabel(member, JavaScriptElementLabels.ALL_FULLY_QUALIFIED);
        }
        if (member instanceof IFunction) {
            return JavaScriptElementLabels.getTextLabel(member, JavaScriptElementLabels.ALL_FULLY_QUALIFIED);
        }
        if (member instanceof IField) {
            return JavaScriptElementLabels.getTextLabel(member, JavaScriptElementLabels.ALL_FULLY_QUALIFIED);
        }
        if (member instanceof IInitializer) {
            return RefactoringCoreMessages.HierarchyRefactoring_initializer;
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    protected static FieldDeclaration createNewFieldDeclarationNode(ASTRewrite rewrite, JavaScriptUnit unit, IField field, VariableDeclarationFragment oldFieldFragment, TypeVariableMaplet[] mapping, IProgressMonitor monitor, RefactoringStatus status, int modifiers) throws JavaScriptModelException {
        VariableDeclarationFragment newFragment = rewrite.getAST().newVariableDeclarationFragment();
        newFragment.setExtraDimensions(oldFieldFragment.getExtraDimensions());
        if (oldFieldFragment.getInitializer() != null) {
            Expression newInitializer = null;
            newInitializer = mapping.length > 0 ? HierarchyProcessor.createPlaceholderForExpression(oldFieldFragment.getInitializer(), field.getJavaScriptUnit(), mapping, rewrite) : HierarchyProcessor.createPlaceholderForExpression(oldFieldFragment.getInitializer(), field.getJavaScriptUnit(), rewrite);
            newFragment.setInitializer(newInitializer);
        }
        newFragment.setName((SimpleName)ASTNode.copySubtree((AST)rewrite.getAST(), (ASTNode)oldFieldFragment.getName()));
        FieldDeclaration newField = rewrite.getAST().newFieldDeclaration(newFragment);
        FieldDeclaration oldField = ASTNodeSearchUtil.getFieldDeclarationNode(field, unit);
        HierarchyProcessor.copyJavadocNode(rewrite, (IMember)field, (BodyDeclaration)oldField, (BodyDeclaration)newField);
        HierarchyProcessor.copyAnnotations(oldField, newField);
        newField.modifiers().addAll(ASTNodeFactory.newModifiers(rewrite.getAST(), modifiers));
        Type oldType = oldField.getType();
        Type newType = null;
        newType = mapping.length > 0 ? HierarchyProcessor.createPlaceholderForType(oldType, field.getJavaScriptUnit(), mapping, rewrite) : HierarchyProcessor.createPlaceholderForType(oldType, field.getJavaScriptUnit(), rewrite);
        newField.setType(newType);
        return newField;
    }

    protected static Expression createPlaceholderForExpression(Expression expression, IJavaScriptUnit declaringCu, ASTRewrite rewrite) throws JavaScriptModelException {
        return (Expression)rewrite.createStringPlaceholder(declaringCu.getBuffer().getText(expression.getStartPosition(), expression.getLength()), 32);
    }

    protected static Expression createPlaceholderForExpression(Expression expression, IJavaScriptUnit declaringCu, TypeVariableMaplet[] mapping, ASTRewrite rewrite) throws JavaScriptModelException {
        Expression result = null;
        try {
            Document document = new Document(declaringCu.getBuffer().getContents());
            ASTRewrite rewriter = ASTRewrite.create((AST)expression.getAST());
            ITrackedNodePosition position = rewriter.track((ASTNode)expression);
            expression.accept((ASTVisitor)new TypeVariableMapper(rewriter, mapping));
            rewriter.rewriteAST((IDocument)document, declaringCu.getJavaScriptProject().getOptions(true)).apply((IDocument)document, 0);
            result = (Expression)rewrite.createStringPlaceholder(document.get(position.getStartPosition(), position.getLength()), 32);
        }
        catch (MalformedTreeException exception) {
            JavaScriptPlugin.log(exception);
        }
        catch (BadLocationException exception) {
            JavaScriptPlugin.log(exception);
        }
        return result;
    }

    protected static BodyDeclaration createPlaceholderForProtectedTypeDeclaration(BodyDeclaration bodyDeclaration, JavaScriptUnit declaringCuNode, IJavaScriptUnit declaringCu, ASTRewrite rewrite, boolean removeIndentation) throws JavaScriptModelException {
        String text = null;
        try {
            ASTRewrite rewriter = ASTRewrite.create((AST)bodyDeclaration.getAST());
            ModifierRewrite.create(rewriter, (ASTNode)bodyDeclaration).setVisibility(4, null);
            ITrackedNodePosition position = rewriter.track((ASTNode)bodyDeclaration);
            Document document = new Document(declaringCu.getBuffer().getText(declaringCuNode.getStartPosition(), declaringCuNode.getLength()));
            rewriter.rewriteAST((IDocument)document, declaringCu.getJavaScriptProject().getOptions(true)).apply((IDocument)document, 2);
            text = document.get(position.getStartPosition(), position.getLength());
        }
        catch (BadLocationException badLocationException) {
            text = HierarchyProcessor.getNewText((ASTNode)bodyDeclaration, declaringCu, removeIndentation);
        }
        return (BodyDeclaration)rewrite.createStringPlaceholder(text, 55);
    }

    protected static BodyDeclaration createPlaceholderForProtectedTypeDeclaration(final BodyDeclaration bodyDeclaration, JavaScriptUnit declaringCuNode, IJavaScriptUnit declaringCu, TypeVariableMaplet[] mapping, ASTRewrite rewrite, boolean removeIndentation) throws JavaScriptModelException {
        BodyDeclaration result = null;
        try {
            Document document = new Document(declaringCu.getBuffer().getContents());
            ASTRewrite rewriter = ASTRewrite.create((AST)bodyDeclaration.getAST());
            ITrackedNodePosition position = rewriter.track((ASTNode)bodyDeclaration);
            bodyDeclaration.accept((ASTVisitor)new TypeVariableMapper(rewriter, mapping){

                public final boolean visit(TypeDeclaration node) {
                    ModifierRewrite.create(this.fRewrite, (ASTNode)bodyDeclaration).setVisibility(4, null);
                    return true;
                }
            });
            rewriter.rewriteAST((IDocument)document, declaringCu.getJavaScriptProject().getOptions(true)).apply((IDocument)document, 0);
            result = (BodyDeclaration)rewrite.createStringPlaceholder(document.get(position.getStartPosition(), position.getLength()), 55);
        }
        catch (MalformedTreeException exception) {
            JavaScriptPlugin.log(exception);
        }
        catch (BadLocationException exception) {
            JavaScriptPlugin.log(exception);
        }
        return result;
    }

    protected static SingleVariableDeclaration createPlaceholderForSingleVariableDeclaration(SingleVariableDeclaration declaration, IJavaScriptUnit declaringCu, ASTRewrite rewrite) throws JavaScriptModelException {
        return (SingleVariableDeclaration)rewrite.createStringPlaceholder(declaringCu.getBuffer().getText(declaration.getStartPosition(), declaration.getLength()), 44);
    }

    protected static SingleVariableDeclaration createPlaceholderForSingleVariableDeclaration(SingleVariableDeclaration declaration, IJavaScriptUnit declaringCu, TypeVariableMaplet[] mapping, ASTRewrite rewrite) throws JavaScriptModelException {
        SingleVariableDeclaration result = null;
        try {
            Document document = new Document(declaringCu.getBuffer().getContents());
            ASTRewrite rewriter = ASTRewrite.create((AST)declaration.getAST());
            ITrackedNodePosition position = rewriter.track((ASTNode)declaration);
            declaration.accept((ASTVisitor)new TypeVariableMapper(rewriter, mapping));
            rewriter.rewriteAST((IDocument)document, declaringCu.getJavaScriptProject().getOptions(true)).apply((IDocument)document, 0);
            result = (SingleVariableDeclaration)rewrite.createStringPlaceholder(document.get(position.getStartPosition(), position.getLength()), 44);
        }
        catch (MalformedTreeException exception) {
            JavaScriptPlugin.log(exception);
        }
        catch (BadLocationException exception) {
            JavaScriptPlugin.log(exception);
        }
        return result;
    }

    protected static Type createPlaceholderForType(Type type, IJavaScriptUnit declaringCu, ASTRewrite rewrite) throws JavaScriptModelException {
        return (Type)rewrite.createStringPlaceholder(declaringCu.getBuffer().getText(type.getStartPosition(), type.getLength()), 43);
    }

    protected static Type createPlaceholderForType(Type type, IJavaScriptUnit declaringCu, TypeVariableMaplet[] mapping, ASTRewrite rewrite) throws JavaScriptModelException {
        Type result = null;
        try {
            Document document = new Document(declaringCu.getBuffer().getContents());
            ASTRewrite rewriter = ASTRewrite.create((AST)type.getAST());
            ITrackedNodePosition position = rewriter.track((ASTNode)type);
            type.accept((ASTVisitor)new TypeVariableMapper(rewriter, mapping));
            rewriter.rewriteAST((IDocument)document, declaringCu.getJavaScriptProject().getOptions(true)).apply((IDocument)document, 0);
            result = (Type)rewrite.createStringPlaceholder(document.get(position.getStartPosition(), position.getLength()), 43);
        }
        catch (MalformedTreeException exception) {
            JavaScriptPlugin.log(exception);
        }
        catch (BadLocationException exception) {
            JavaScriptPlugin.log(exception);
        }
        return result;
    }

    protected static BodyDeclaration createPlaceholderForTypeDeclaration(BodyDeclaration bodyDeclaration, IJavaScriptUnit declaringCu, ASTRewrite rewrite, boolean removeIndentation) throws JavaScriptModelException {
        return (BodyDeclaration)rewrite.createStringPlaceholder(HierarchyProcessor.getNewText((ASTNode)bodyDeclaration, declaringCu, removeIndentation), 55);
    }

    protected static BodyDeclaration createPlaceholderForTypeDeclaration(BodyDeclaration bodyDeclaration, IJavaScriptUnit declaringCu, TypeVariableMaplet[] mapping, ASTRewrite rewrite, boolean removeIndentation) throws JavaScriptModelException {
        BodyDeclaration result = null;
        try {
            Document document = new Document(declaringCu.getBuffer().getContents());
            ASTRewrite rewriter = ASTRewrite.create((AST)bodyDeclaration.getAST());
            ITrackedNodePosition position = rewriter.track((ASTNode)bodyDeclaration);
            bodyDeclaration.accept((ASTVisitor)new TypeVariableMapper(rewriter, mapping));
            rewriter.rewriteAST((IDocument)document, declaringCu.getJavaScriptProject().getOptions(true)).apply((IDocument)document, 0);
            result = (BodyDeclaration)rewrite.createStringPlaceholder(document.get(position.getStartPosition(), position.getLength()), 55);
        }
        catch (MalformedTreeException exception) {
            JavaScriptPlugin.log(exception);
        }
        catch (BadLocationException exception) {
            JavaScriptPlugin.log(exception);
        }
        return result;
    }

    protected static void deleteDeclarationNodes(CompilationUnitRewrite sourceRewriter, boolean sameCu, CompilationUnitRewrite unitRewriter, List members, GroupCategorySet set) throws JavaScriptModelException {
        List declarationNodes = HierarchyProcessor.getDeclarationNodes(unitRewriter.getRoot(), members);
        for (ASTNode node : declarationNodes) {
            ASTRewrite rewriter = unitRewriter.getASTRewrite();
            ImportRemover remover = unitRewriter.getImportRemover();
            if (node instanceof VariableDeclarationFragment) {
                if (!(node.getParent() instanceof FieldDeclaration)) continue;
                FieldDeclaration declaration = (FieldDeclaration)node.getParent();
                if (HierarchyProcessor.areAllFragmentsDeleted(declaration, declarationNodes)) {
                    rewriter.remove((ASTNode)declaration, (TextEditGroup)unitRewriter.createCategorizedGroupDescription(RefactoringCoreMessages.HierarchyRefactoring_remove_member, set));
                    if (sameCu) continue;
                    remover.registerRemovedNode((ASTNode)declaration);
                    continue;
                }
                rewriter.remove(node, (TextEditGroup)unitRewriter.createCategorizedGroupDescription(RefactoringCoreMessages.HierarchyRefactoring_remove_member, set));
                if (sameCu) continue;
                remover.registerRemovedNode(node);
                continue;
            }
            rewriter.remove(node, (TextEditGroup)unitRewriter.createCategorizedGroupDescription(RefactoringCoreMessages.HierarchyRefactoring_remove_member, set));
            if (sameCu) continue;
            remover.registerRemovedNode(node);
        }
    }

    protected static List getDeclarationNodes(JavaScriptUnit cuNode, List members) throws JavaScriptModelException {
        ArrayList<VariableDeclarationFragment> result = new ArrayList<VariableDeclarationFragment>(members.size());
        for (IMember member : members) {
            VariableDeclarationFragment node = null;
            if (member instanceof IField) {
                node = ASTNodeSearchUtil.getFieldDeclarationFragmentNode((IField)member, cuNode);
            } else if (member instanceof IType) {
                node = ASTNodeSearchUtil.getAbstractTypeDeclarationNode((IType)member, cuNode);
            } else if (member instanceof IFunction) {
                node = ASTNodeSearchUtil.getMethodDeclarationNode((IFunction)member, cuNode);
            }
            if (node == null) continue;
            result.add(node);
        }
        return result;
    }

    protected static String getNewText(ASTNode node, IJavaScriptUnit declaringCu, boolean removeIndentation) throws JavaScriptModelException {
        String result = declaringCu.getBuffer().getText(node.getStartPosition(), node.getLength());
        if (removeIndentation) {
            return HierarchyProcessor.getUnindentedText(result, declaringCu);
        }
        return result;
    }

    protected static String getUnindentedText(String text, IJavaScriptUnit declaringCu) throws JavaScriptModelException {
        String[] lines = Strings.convertIntoLines(text);
        Strings.trimIndentation(lines, declaringCu.getJavaScriptProject(), false);
        return Strings.concatenate(lines, StubUtility.getLineDelimiterUsed((IJavaScriptElement)declaringCu));
    }

    protected HierarchyProcessor(IMember[] members, CodeGenerationSettings settings, boolean layer) {
        super(settings);
        this.fLayer = layer;
        if (members != null) {
            IJavaScriptUnit original;
            this.fMembersToMove = (IMember[])SourceReferenceUtil.sortByOffset((ISourceReference[])members);
            if (layer && this.fMembersToMove.length > 0 && (original = this.fMembersToMove[0].getJavaScriptUnit()) != null) {
                try {
                    IJavaScriptUnit copy = this.getSharedWorkingCopy(original.getPrimary(), (IProgressMonitor)new NullProgressMonitor());
                    if (copy != null) {
                        int index = 0;
                        while (index < this.fMembersToMove.length) {
                            IJavaScriptElement[] elements = copy.findElements((IJavaScriptElement)this.fMembersToMove[index]);
                            if (elements != null && elements.length > 0 && elements[0] instanceof IMember) {
                                this.fMembersToMove[index] = (IMember)elements[0];
                            }
                            ++index;
                        }
                    }
                }
                catch (JavaScriptModelException exception) {
                    JavaScriptPlugin.log(exception);
                }
            }
        }
    }

    protected boolean canBeAccessedFrom(IMember member, IType target, ITypeHierarchy hierarchy) throws JavaScriptModelException {
        Assert.isTrue((!(member instanceof IInitializer) ? 1 : 0) != 0);
        return member.exists();
    }

    protected RefactoringStatus checkConstructorCalls(IType type, IProgressMonitor monitor) throws JavaScriptModelException {
        try {
            monitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, 2);
            RefactoringStatus result = new RefactoringStatus();
            SearchResultGroup[] groups = ConstructorReferenceFinder.getConstructorReferences(type, this.fOwner, (IProgressMonitor)new SubProgressMonitor(monitor, 1), result);
            String message = Messages.format(RefactoringCoreMessages.HierarchyRefactoring_gets_instantiated, new Object[]{JavaScriptElementLabels.getTextLabel(type, JavaScriptElementLabels.ALL_FULLY_QUALIFIED)});
            IJavaScriptUnit unit = null;
            int index = 0;
            while (index < groups.length) {
                unit = groups[index].getCompilationUnit();
                if (unit != null) {
                    JavaScriptUnit cuNode = RefactoringASTParser.parseWithASTProvider((ITypeRoot)unit, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    ASTNode[] references = ASTNodeSearchUtil.getAstNodes(groups[index].getSearchResults(), cuNode);
                    ASTNode node = null;
                    int offset = 0;
                    while (offset < references.length) {
                        node = references[offset];
                        if (node instanceof ClassInstanceCreation || ConstructorReferenceFinder.isImplicitConstructorReferenceNodeInClassCreations(node)) {
                            RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)unit, node);
                            result.addError(message, context);
                        }
                        ++offset;
                    }
                }
                ++index;
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            monitor.done();
        }
    }

    protected RefactoringStatus checkDeclaringType(IProgressMonitor monitor) throws JavaScriptModelException {
        IType type = this.getDeclaringType();
        if (type.isBinary()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.HierarchyRefactoring_members_of_binary);
        }
        if (type.isReadOnly()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.HierarchyRefactoring_members_of_read_only);
        }
        return new RefactoringStatus();
    }

    protected RefactoringStatus checkIfMembersExist() {
        RefactoringStatus result = new RefactoringStatus();
        IMember member = null;
        int index = 0;
        while (index < this.fMembersToMove.length) {
            member = this.fMembersToMove[index];
            if (member == null || !member.exists()) {
                result.addFatalError(RefactoringCoreMessages.HierarchyRefactoring_does_not_exist);
            }
            ++index;
        }
        return result;
    }

    protected void clearCaches() {
        this.fCachedReferencedTypes = null;
    }

    protected void copyParameters(ASTRewrite rewrite, IJavaScriptUnit unit, FunctionDeclaration oldMethod, FunctionDeclaration newMethod, TypeVariableMaplet[] mapping) throws JavaScriptModelException {
        SingleVariableDeclaration newDeclaration = null;
        int index = 0;
        int size = oldMethod.parameters().size();
        while (index < size) {
            SingleVariableDeclaration oldDeclaration = (SingleVariableDeclaration)oldMethod.parameters().get(index);
            newDeclaration = mapping.length > 0 ? HierarchyProcessor.createPlaceholderForSingleVariableDeclaration(oldDeclaration, unit, mapping, rewrite) : HierarchyProcessor.createPlaceholderForSingleVariableDeclaration(oldDeclaration, unit, rewrite);
            newMethod.parameters().add(index, newDeclaration);
            ++index;
        }
    }

    protected void copyReturnType(ASTRewrite rewrite, IJavaScriptUnit unit, FunctionDeclaration oldMethod, FunctionDeclaration newMethod, TypeVariableMaplet[] mapping) throws JavaScriptModelException {
        Type newReturnType = null;
        newReturnType = mapping.length > 0 ? HierarchyProcessor.createPlaceholderForType(oldMethod.getReturnType2(), unit, mapping, rewrite) : HierarchyProcessor.createPlaceholderForType(oldMethod.getReturnType2(), unit, rewrite);
        newMethod.setReturnType2(newReturnType);
    }

    @Override
    protected SuperTypeConstraintsSolver createContraintSolver(SuperTypeConstraintsModel model) {
        return new SuperTypeConstraintsSolver(model);
    }

    public IType getDeclaringType() {
        if (this.fCachedDeclaringType != null) {
            return this.fCachedDeclaringType;
        }
        this.fCachedDeclaringType = RefactoringAvailabilityTester.getTopLevelType(this.fMembersToMove);
        if (this.fCachedDeclaringType == null) {
            this.fCachedDeclaringType = this.fMembersToMove[0].getDeclaringType();
        }
        return this.fCachedDeclaringType;
    }

    public IMember[] getMembersToMove() {
        return this.fMembersToMove;
    }

    protected IType[] getTypesReferencedInMovedMembers(IProgressMonitor monitor) throws JavaScriptModelException {
        if (this.fCachedReferencedTypes == null) {
            IType[] types = ReferenceFinderUtil.getTypesReferencedIn((IJavaScriptElement[])this.fMembersToMove, this.fOwner, monitor);
            ArrayList<IType> result = new ArrayList<IType>(types.length);
            List<IMember> members = Arrays.asList(this.fMembersToMove);
            int index = 0;
            while (index < types.length) {
                if (!members.contains(types[index]) && !types[index].equals(this.getDeclaringType())) {
                    result.add(types[index]);
                }
                ++index;
            }
            this.fCachedReferencedTypes = new IType[result.size()];
            result.toArray(this.fCachedReferencedTypes);
        }
        return this.fCachedReferencedTypes;
    }

    protected boolean hasNonMovedReferences(IMember member, IProgressMonitor monitor, RefactoringStatus status) throws JavaScriptModelException {
        SearchResultGroup[] groups;
        if (!this.fCachedMembersReferences.containsKey(member)) {
            RefactoringSearchEngine2 engine = new RefactoringSearchEngine2(SearchPattern.createPattern((IJavaScriptElement)member, (int)2, (int)24));
            engine.setFiltering(true, true);
            engine.setStatus(status);
            engine.setOwner(this.fOwner);
            engine.setScope(RefactoringScopeFactory.create((IJavaScriptElement)member));
            engine.searchPattern((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.fCachedMembersReferences.put(member, engine.getResults());
        }
        if ((groups = (SearchResultGroup[])this.fCachedMembersReferences.get(member)).length == 0) {
            return false;
        }
        if (groups.length > 1) {
            return true;
        }
        IJavaScriptUnit unit = groups[0].getCompilationUnit();
        if (!this.getDeclaringType().getJavaScriptUnit().equals(unit)) {
            return true;
        }
        SearchMatch[] matches = groups[0].getSearchResults();
        int index = 0;
        while (index < matches.length) {
            if (!this.isMovedReference(matches[index])) {
                return true;
            }
            ++index;
        }
        return false;
    }

    protected boolean isMovedReference(SearchMatch match) throws JavaScriptModelException {
        ISourceRange range = null;
        int index = 0;
        while (index < this.fMembersToMove.length) {
            range = this.fMembersToMove[index].getSourceRange();
            if (range.getOffset() <= match.getOffset() && range.getOffset() + range.getLength() >= match.getOffset()) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return new RefactoringParticipant[0];
    }

    protected boolean needsVisibilityAdjustment(IMember member, boolean references, IProgressMonitor monitor, RefactoringStatus status) throws JavaScriptModelException {
        if (JdtFlags.isPublic(member)) {
            return false;
        }
        if (!references) {
            return true;
        }
        return this.hasNonMovedReferences(member, monitor, status);
    }

    public static class TypeVariableMapper
    extends ASTVisitor {
        protected final TypeVariableMaplet[] fMapping;
        protected final ASTRewrite fRewrite;

        public TypeVariableMapper(ASTRewrite rewrite, TypeVariableMaplet[] mapping) {
            Assert.isNotNull((Object)rewrite);
            Assert.isNotNull((Object)mapping);
            this.fRewrite = rewrite;
            this.fMapping = mapping;
        }

        public final boolean visit(SimpleName node) {
            node.resolveTypeBinding();
            return true;
        }
    }
}

