/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.ui.dialogs;

import java.io.File;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.ws.internal.cxf.ui.CXFUIMessages;
import org.eclipse.jst.ws.internal.cxf.ui.CXFUIPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ResourceSelectionDialog
extends SelectionStatusDialog {
    private IStatus OK_FILE_STATUS = new Status(0, "org.eclipse.jst.ws.cxf.ui", "");
    private IStatus ERROR_FILE_STATUS = new Status(4, "org.eclipse.jst.ws.cxf.ui", CXFUIMessages.RESOURCE_SELECTIN_DIALOG_BROWSE_FILE_NOT_FOUND_ERROR);
    private IStatus VALIDATE_SELECTION_STATUS = new Status(4, "org.eclipse.jst.ws.cxf.ui", "");
    private Text resourceText;
    private String filterExtension;
    private String filterName;

    public ResourceSelectionDialog(Shell parent, String filterExtension, String filterName, String dialogTitle) {
        super(parent);
        this.filterExtension = filterExtension;
        this.filterName = filterName;
        this.setTitle(dialogTitle);
        this.setStatusLineAboveButtons(true);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x400 | 0x10);
        this.updateStatus(this.VALIDATE_SELECTION_STATUS);
    }

    protected Control createDialogArea(Composite parent) {
        final Composite composite = (Composite)super.createDialogArea(parent);
        Composite buttonComposite = new Composite(composite, 0);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = 500;
        buttonComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(3, false);
        buttonComposite.setLayout((Layout)gridLayout);
        Label messageLabel = this.createMessageArea(buttonComposite);
        gridData = new GridData(1, 0x1000000, true, false);
        messageLabel.setLayoutData((Object)gridData);
        Button browseWorkspace = new Button(buttonComposite, 8);
        browseWorkspace.setText(CXFUIMessages.RESOURCE_SELECTIN_DIALOG_BROWSE_WORKSPACE_BUTTON);
        browseWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectionDialog dialog = ResourceSelectionDialog.this.createWorkspaceResourceDialog(composite.getShell());
                if (dialog.open() == 0) {
                    Object[] result = dialog.getResult();
                    IResource resource = (IResource)result[0];
                    ResourceSelectionDialog.this.resourceText.setText(resource.getLocation().toOSString());
                }
            }
        });
        gridData = new GridData(0x1000008, 4, false, false);
        browseWorkspace.setLayoutData((Object)gridData);
        Button browseFileSystem = new Button(buttonComposite, 8);
        browseFileSystem.setText(CXFUIMessages.RESOURCE_SELECTIN_DIALOG_BROWSE_FILE_SYSTEM_BUTTON);
        browseFileSystem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = ResourceSelectionDialog.this.createFileSystemResourceDialog(composite.getShell());
                String result = dialog.open();
                if (result == null) {
                    return;
                }
                Path filterPath = new Path(dialog.getFilterPath());
                String buildFileName = dialog.getFileName();
                IPath path = filterPath.append(buildFileName).makeAbsolute();
                ResourceSelectionDialog.this.resourceText.setText(path.toOSString());
            }
        });
        gridData = new GridData(0x1000008, 4, false, false);
        browseFileSystem.setLayoutData((Object)gridData);
        this.resourceText = new Text(buttonComposite, 2048);
        gridData = new GridData(4, 4, true, false);
        this.resourceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String resource = ResourceSelectionDialog.this.resourceText.getText();
                File file = new File(resource);
                if (file.exists()) {
                    ResourceSelectionDialog.this.setResult(Arrays.asList(resource));
                    ResourceSelectionDialog.this.updateStatus(ResourceSelectionDialog.this.OK_FILE_STATUS);
                } else {
                    ResourceSelectionDialog.this.updateStatus(ResourceSelectionDialog.this.ERROR_FILE_STATUS);
                }
            }
        });
        gridData.horizontalSpan = 3;
        this.resourceText.setLayoutData((Object)gridData);
        return composite;
    }

    private SelectionDialog createWorkspaceResourceDialog(Shell shell) {
        ElementTreeSelectionDialog workspaceResourceDialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        workspaceResourceDialog.setTitle(this.getMessage());
        workspaceResourceDialog.setMessage(this.filterName);
        workspaceResourceDialog.setAllowMultiple(false);
        workspaceResourceDialog.addFilter(new ViewerFilter(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    IFile file = (IFile)element;
                    if (!file.isAccessible()) return false;
                    if (!file.getFileExtension().equals(ResourceSelectionDialog.this.filterExtension)) return false;
                    return true;
                }
                if (element instanceof IProject && !((IProject)element).isOpen()) {
                    IProject project = (IProject)element;
                    return project.isAccessible();
                }
                if (!(element instanceof IContainer)) return false;
                try {
                    IResource[] resources;
                    IContainer container = (IContainer)element;
                    IResource[] iResourceArray = resources = container.members();
                    int n = resources.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            return false;
                        }
                        IResource resource = iResourceArray[n2];
                        if (this.select(viewer, parentElement, resource)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                catch (CoreException ce) {
                    CXFUIPlugin.log(ce.getStatus());
                }
                return false;
            }
        });
        workspaceResourceDialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                IFile file;
                Object selected;
                if (selection.length > 0 && (selected = selection[0]) instanceof IFile && (file = (IFile)selected).getFileExtension().equals(ResourceSelectionDialog.this.filterExtension)) {
                    return ResourceSelectionDialog.this.OK_FILE_STATUS;
                }
                return ResourceSelectionDialog.this.VALIDATE_SELECTION_STATUS;
            }
        });
        workspaceResourceDialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        return workspaceResourceDialog;
    }

    private FileDialog createFileSystemResourceDialog(Shell shell) {
        FileDialog dialog = new FileDialog(shell, 4096);
        dialog.setFilterExtensions(new String[]{"*" + this.filterExtension});
        dialog.setFilterNames(new String[]{this.filterName});
        return dialog;
    }

    protected void computeResult() {
    }
}

