/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.java.JavaClass;
import org.eclipse.jpt.jaxb.core.context.java.JavaClassMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.java.ELJavaXmlElementMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.java.XmlPathAnnotation;
import org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.ELJaxbContextModelTestCase;

public class ELJavaXmlElementMappingTests
extends ELJaxbContextModelTestCase {
    public ELJavaXmlElementMappingTests(String name) {
        super(name);
    }

    @Override
    protected String getPlatformID() {
        return "eclipselink_2_2";
    }

    private ICompilationUnit createTypeWithXmlElement() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "javax.xml.bind.annotation.XmlElement"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElement");
            }
        });
    }

    private ICompilationUnit createTypeWithXmlPath() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "org.eclipse.persistence.oxm.annotations.XmlPath"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlPath");
            }
        });
    }

    public void testModifyXmlPath() throws Exception {
        this.createTypeWithXmlElement();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        ELJavaXmlElementMapping mapping = (ELJavaXmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        ELJavaXmlElementMappingTests.assertEquals((int)0, (int)IterableTools.size((Iterable)resourceAttribute.getAnnotations("org.eclipse.persistence.oxm.annotations.XmlPath")));
        ELJavaXmlElementMappingTests.assertNull((Object)mapping.getXmlPath());
        mapping.addXmlPath();
        ELJavaXmlElementMappingTests.assertEquals((int)1, (int)IterableTools.size((Iterable)resourceAttribute.getAnnotations("org.eclipse.persistence.oxm.annotations.XmlPath")));
        ELJavaXmlElementMappingTests.assertNotNull((Object)mapping.getXmlPath());
        mapping.removeXmlPath();
        ELJavaXmlElementMappingTests.assertEquals((int)0, (int)IterableTools.size((Iterable)resourceAttribute.getAnnotations("org.eclipse.persistence.oxm.annotations.XmlPath")));
        ELJavaXmlElementMappingTests.assertNull((Object)mapping.getXmlPath());
    }

    public void testUpdateXmlPath() throws Exception {
        this.createTypeWithXmlElement();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        ELJavaXmlElementMapping mapping = (ELJavaXmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        ELJavaXmlElementMappingTests.assertEquals((int)0, (int)IterableTools.size((Iterable)resourceAttribute.getAnnotations("org.eclipse.persistence.oxm.annotations.XmlPath")));
        ELJavaXmlElementMappingTests.assertNull((Object)mapping.getXmlPath());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlElementMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "org.eclipse.persistence.oxm.annotations.XmlPath");
            }
        });
        ELJavaXmlElementMappingTests.assertEquals((int)1, (int)IterableTools.size((Iterable)resourceAttribute.getAnnotations("org.eclipse.persistence.oxm.annotations.XmlPath")));
        ELJavaXmlElementMappingTests.assertNotNull((Object)mapping.getXmlPath());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlElementMappingTests.this.removeAnnotation(declaration, "org.eclipse.persistence.oxm.annotations.XmlPath");
            }
        });
        ELJavaXmlElementMappingTests.assertEquals((int)0, (int)IterableTools.size((Iterable)resourceAttribute.getAnnotations("org.eclipse.persistence.oxm.annotations.XmlPath")));
        ELJavaXmlElementMappingTests.assertNull((Object)mapping.getXmlPath());
    }

    public void testDefault() throws Exception {
        this.createTypeWithXmlPath();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaResourceAttribute resourceAttribute = persistentAttribute.getJavaResourceAttribute();
        XmlPathAnnotation xmlPathAnnotation = (XmlPathAnnotation)resourceAttribute.getAnnotation(0, "org.eclipse.persistence.oxm.annotations.XmlPath");
        ELJavaXmlElementMappingTests.assertNotNull((Object)xmlPathAnnotation);
        ELJavaXmlElementMappingTests.assertTrue((persistentAttribute.getMapping().getKey() == "xml-element" ? 1 : 0) != 0);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlElementMappingTests.this.setMemberValuePair(declaration, "org.eclipse.persistence.oxm.annotations.XmlPath", "element/@attribute");
            }
        });
        ELJavaXmlElementMappingTests.assertNotNull((Object)xmlPathAnnotation.getValue());
        ELJavaXmlElementMappingTests.assertFalse((persistentAttribute.getMapping().getKey() == "xml-element" ? 1 : 0) != 0);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlElementMappingTests.this.setMemberValuePair(declaration, "org.eclipse.persistence.oxm.annotations.XmlPath", "./element[@name=\"foo\"]/element[1]/text()");
            }
        });
        ELJavaXmlElementMappingTests.assertNotNull((Object)xmlPathAnnotation.getValue());
        ELJavaXmlElementMappingTests.assertTrue((persistentAttribute.getMapping().getKey() == "xml-element" ? 1 : 0) != 0);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlElementMappingTests.this.removeMemberValuePair(declaration, "org.eclipse.persistence.oxm.annotations.XmlPath");
            }
        });
        ELJavaXmlElementMappingTests.assertNull((Object)xmlPathAnnotation.getValue());
        ELJavaXmlElementMappingTests.assertTrue((persistentAttribute.getMapping().getKey() == "xml-element" ? 1 : 0) != 0);
    }

    public void testModifyXmlKey() throws Exception {
        this.createTypeWithXmlElement();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        ELJavaXmlElementMapping mapping = (ELJavaXmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        ELJavaXmlElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlKey"));
        ELJavaXmlElementMappingTests.assertNull((Object)mapping.getXmlKey());
        mapping.addXmlKey();
        ELJavaXmlElementMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlKey"));
        ELJavaXmlElementMappingTests.assertNotNull((Object)mapping.getXmlKey());
        mapping.removeXmlKey();
        ELJavaXmlElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlKey"));
        ELJavaXmlElementMappingTests.assertNull((Object)mapping.getXmlKey());
    }

    public void testUpdateXmlKey() throws Exception {
        this.createTypeWithXmlElement();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        ELJavaXmlElementMapping mapping = (ELJavaXmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        ELJavaXmlElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlKey"));
        ELJavaXmlElementMappingTests.assertNull((Object)mapping.getXmlKey());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlElementMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "org.eclipse.persistence.oxm.annotations.XmlKey");
            }
        });
        ELJavaXmlElementMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlKey"));
        ELJavaXmlElementMappingTests.assertNotNull((Object)mapping.getXmlKey());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlElementMappingTests.this.removeAnnotation(declaration, "org.eclipse.persistence.oxm.annotations.XmlKey");
            }
        });
        ELJavaXmlElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlKey"));
        ELJavaXmlElementMappingTests.assertNull((Object)mapping.getXmlKey());
    }

    public void testModifyXmlCDATA() throws Exception {
        this.createTypeWithXmlElement();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        ELJavaXmlElementMapping mapping = (ELJavaXmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        ELJavaXmlElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlCDATA"));
        ELJavaXmlElementMappingTests.assertNull((Object)mapping.getXmlCDATA());
        mapping.addXmlCDATA();
        ELJavaXmlElementMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlCDATA"));
        ELJavaXmlElementMappingTests.assertNotNull((Object)mapping.getXmlCDATA());
        mapping.removeXmlCDATA();
        ELJavaXmlElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlCDATA"));
        ELJavaXmlElementMappingTests.assertNull((Object)mapping.getXmlCDATA());
    }

    public void testUpdateXmlCDATA() throws Exception {
        this.createTypeWithXmlElement();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        ELJavaXmlElementMapping mapping = (ELJavaXmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        ELJavaXmlElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlCDATA"));
        ELJavaXmlElementMappingTests.assertNull((Object)mapping.getXmlCDATA());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlElementMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "org.eclipse.persistence.oxm.annotations.XmlCDATA");
            }
        });
        ELJavaXmlElementMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlCDATA"));
        ELJavaXmlElementMappingTests.assertNotNull((Object)mapping.getXmlCDATA());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlElementMappingTests.this.removeAnnotation(declaration, "org.eclipse.persistence.oxm.annotations.XmlCDATA");
            }
        });
        ELJavaXmlElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlCDATA"));
        ELJavaXmlElementMappingTests.assertNull((Object)mapping.getXmlCDATA());
    }
}

