/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.orm;

import org.eclipse.jpt.jpa.core.context.orm.OrmEntity;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class OrmPrimaryKeyJoinColumnTests
extends ContextModelTestCase {
    public OrmPrimaryKeyJoinColumnTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    public void testUpdateSpecifiedName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmSpecifiedPrimaryKeyJoinColumn ormPrimaryKeyJoinColumn = ormEntity.addSpecifiedPrimaryKeyJoinColumn(0);
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlPrimaryKeyJoinColumn primaryKeyJoinColumnResource = (XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(0);
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)ormPrimaryKeyJoinColumn.getSpecifiedName());
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)primaryKeyJoinColumnResource.getName());
        primaryKeyJoinColumnResource.setName("FOO");
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"FOO", (String)ormPrimaryKeyJoinColumn.getSpecifiedName());
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"FOO", (String)primaryKeyJoinColumnResource.getName());
        primaryKeyJoinColumnResource.setName(null);
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)ormPrimaryKeyJoinColumn.getSpecifiedName());
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)primaryKeyJoinColumnResource.getName());
        primaryKeyJoinColumnResource.setName("FOO");
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"FOO", (String)ormPrimaryKeyJoinColumn.getSpecifiedName());
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"FOO", (String)primaryKeyJoinColumnResource.getName());
        entityResource.getPrimaryKeyJoinColumns().remove(0);
        OrmPrimaryKeyJoinColumnTests.assertFalse((boolean)ormEntity.getSpecifiedPrimaryKeyJoinColumns().iterator().hasNext());
        OrmPrimaryKeyJoinColumnTests.assertTrue((boolean)entityResource.getPrimaryKeyJoinColumns().isEmpty());
    }

    public void testModifySpecifiedName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmSpecifiedPrimaryKeyJoinColumn ormPrimaryKeyJoinColumn = ormEntity.addSpecifiedPrimaryKeyJoinColumn(0);
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlPrimaryKeyJoinColumn primaryKeyJoinColumnResource = (XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(0);
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)ormPrimaryKeyJoinColumn.getSpecifiedName());
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)primaryKeyJoinColumnResource.getName());
        ormPrimaryKeyJoinColumn.setSpecifiedName("foo");
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"foo", (String)ormPrimaryKeyJoinColumn.getSpecifiedName());
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"foo", (String)primaryKeyJoinColumnResource.getName());
        ormPrimaryKeyJoinColumn.setSpecifiedName(null);
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)ormPrimaryKeyJoinColumn.getSpecifiedName());
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)((XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(0)).getName());
    }

    public void testUpdateSpecifiedReferencedColumnName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmSpecifiedPrimaryKeyJoinColumn ormPrimaryKeyJoinColumn = ormEntity.addSpecifiedPrimaryKeyJoinColumn(0);
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlPrimaryKeyJoinColumn primaryKeyJoinColumnResource = (XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(0);
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)ormPrimaryKeyJoinColumn.getSpecifiedReferencedColumnName());
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)primaryKeyJoinColumnResource.getReferencedColumnName());
        primaryKeyJoinColumnResource.setReferencedColumnName("FOO");
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"FOO", (String)ormPrimaryKeyJoinColumn.getSpecifiedReferencedColumnName());
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"FOO", (String)primaryKeyJoinColumnResource.getReferencedColumnName());
        primaryKeyJoinColumnResource.setReferencedColumnName(null);
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)ormPrimaryKeyJoinColumn.getSpecifiedReferencedColumnName());
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)primaryKeyJoinColumnResource.getReferencedColumnName());
        primaryKeyJoinColumnResource.setReferencedColumnName("FOO");
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"FOO", (String)ormPrimaryKeyJoinColumn.getSpecifiedReferencedColumnName());
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"FOO", (String)primaryKeyJoinColumnResource.getReferencedColumnName());
        entityResource.getPrimaryKeyJoinColumns().remove(0);
        OrmPrimaryKeyJoinColumnTests.assertFalse((boolean)ormEntity.getSpecifiedPrimaryKeyJoinColumns().iterator().hasNext());
        OrmPrimaryKeyJoinColumnTests.assertTrue((boolean)entityResource.getPrimaryKeyJoinColumns().isEmpty());
    }

    public void testModifySpecifiedReferencedColumnName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmSpecifiedPrimaryKeyJoinColumn ormPrimaryKeyJoinColumn = ormEntity.addSpecifiedPrimaryKeyJoinColumn(0);
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlPrimaryKeyJoinColumn primaryKeyJoinColumnResource = (XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(0);
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)ormPrimaryKeyJoinColumn.getSpecifiedReferencedColumnName());
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)primaryKeyJoinColumnResource.getReferencedColumnName());
        ormPrimaryKeyJoinColumn.setSpecifiedReferencedColumnName("foo");
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"foo", (String)ormPrimaryKeyJoinColumn.getSpecifiedReferencedColumnName());
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"foo", (String)primaryKeyJoinColumnResource.getReferencedColumnName());
        ormPrimaryKeyJoinColumn.setSpecifiedReferencedColumnName(null);
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)ormPrimaryKeyJoinColumn.getSpecifiedReferencedColumnName());
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)((XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(0)).getReferencedColumnName());
    }

    public void testUpdateSpecifiedColumnDefinition() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmSpecifiedPrimaryKeyJoinColumn ormPrimaryKeyJoinColumn = ormEntity.addSpecifiedPrimaryKeyJoinColumn(0);
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlPrimaryKeyJoinColumn primaryKeyJoinColumnResource = (XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(0);
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)ormPrimaryKeyJoinColumn.getColumnDefinition());
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)primaryKeyJoinColumnResource.getColumnDefinition());
        primaryKeyJoinColumnResource.setColumnDefinition("FOO");
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"FOO", (String)ormPrimaryKeyJoinColumn.getColumnDefinition());
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"FOO", (String)primaryKeyJoinColumnResource.getColumnDefinition());
        primaryKeyJoinColumnResource.setColumnDefinition(null);
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)ormPrimaryKeyJoinColumn.getColumnDefinition());
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)primaryKeyJoinColumnResource.getColumnDefinition());
        primaryKeyJoinColumnResource.setColumnDefinition("FOO");
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"FOO", (String)ormPrimaryKeyJoinColumn.getColumnDefinition());
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"FOO", (String)primaryKeyJoinColumnResource.getColumnDefinition());
        entityResource.getPrimaryKeyJoinColumns().remove(0);
        OrmPrimaryKeyJoinColumnTests.assertFalse((boolean)ormEntity.getSpecifiedPrimaryKeyJoinColumns().iterator().hasNext());
        OrmPrimaryKeyJoinColumnTests.assertTrue((boolean)entityResource.getPrimaryKeyJoinColumns().isEmpty());
    }

    public void testModifySpecifiedColumnDefinition() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmSpecifiedPrimaryKeyJoinColumn ormPrimaryKeyJoinColumn = ormEntity.addSpecifiedPrimaryKeyJoinColumn(0);
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlPrimaryKeyJoinColumn primaryKeyJoinColumnResource = (XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(0);
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)ormPrimaryKeyJoinColumn.getColumnDefinition());
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)primaryKeyJoinColumnResource.getColumnDefinition());
        ormPrimaryKeyJoinColumn.setColumnDefinition("foo");
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"foo", (String)ormPrimaryKeyJoinColumn.getColumnDefinition());
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"foo", (String)primaryKeyJoinColumnResource.getColumnDefinition());
        ormPrimaryKeyJoinColumn.setColumnDefinition(null);
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)ormPrimaryKeyJoinColumn.getColumnDefinition());
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)((XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(0)).getColumnDefinition());
    }
}

