/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.crossfire.request;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.core.jsdi.Location;
import org.eclipse.wst.jsdt.debug.core.jsdi.ThreadReference;
import org.eclipse.wst.jsdt.debug.core.jsdi.VirtualMachine;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.BreakpointRequest;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.BreakpointTracker;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFScriptReference;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFVirtualMachine;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.RemoteBreakpoint;
import org.eclipse.wst.jsdt.debug.internal.crossfire.request.CFThreadEventRequest;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.CFRequestPacket;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.CFResponsePacket;

public class CFBreakpointRequest
extends CFThreadEventRequest
implements BreakpointRequest {
    private String condition = null;
    private int hitcount = 0;
    private Location location = null;
    private Long bpHandle = null;

    public CFBreakpointRequest(VirtualMachine vm, Location location) {
        super(vm);
        this.location = location;
    }

    public Location location() {
        return this.location;
    }

    public void addThreadFilter(ThreadReference thread) {
        this.setThread(thread);
    }

    public void addConditionFilter(String condition) {
        this.condition = condition;
    }

    public String getConditionFilter() {
        return this.condition;
    }

    public void addHitCountFilter(int hitcount) {
        this.hitcount = hitcount;
    }

    public int getHitCount() {
        return this.hitcount;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            List list;
            CFScriptReference script = (CFScriptReference)this.location.scriptReference();
            CFRequestPacket request = new CFRequestPacket("setBreakpoints", null);
            Map bp = new HashMap<String, Object>();
            bp.put("type", "line");
            HashMap<String, Object> loc = new HashMap<String, Object>();
            loc.put("line", new Integer(this.location.lineNumber()));
            loc.put("url", script.url());
            bp.put("location", loc);
            HashMap<String, Object> attribs = new HashMap<String, Object>();
            if (this.condition != null) {
                attribs.put("condition", this.condition);
            }
            if (this.hitcount > 0) {
                attribs.put("hitCount", new Long(this.hitcount));
            }
            attribs.put("enabled", Boolean.TRUE);
            bp.put("attributes", attribs);
            request.setArgument("breakpoints", Arrays.asList(bp));
            CFResponsePacket response = ((CFVirtualMachine)this.virtualMachine()).sendRequest(request);
            if (response.isSuccess() && (list = (List)response.getBody().get("breakpoints")) != null && list.size() > 0 && (bp = (Map)list.get(0)) != null) {
                Number handle = (Number)bp.get("handle");
                this.bpHandle = new Long(handle.longValue());
                RemoteBreakpoint rb = BreakpointTracker.addBreakpoint((CFVirtualMachine)this.virtualMachine(), bp);
                if (rb != null) {
                    BreakpointTracker.findLocalBreakpoint(rb);
                }
            }
        } else if (this.bpHandle != null) {
            CFRequestPacket request = new CFRequestPacket("deleteBreakpoints", null);
            request.getArguments().put("handles", Arrays.asList(this.bpHandle));
            CFResponsePacket response = ((CFVirtualMachine)this.virtualMachine()).sendRequest(request);
            if (response.isSuccess()) {
                BreakpointTracker.removeBreakpoint((CFVirtualMachine)this.virtualMachine(), this.bpHandle);
                this.bpHandle = null;
            }
        }
    }
}

