/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.io.IOException;
import junit.framework.Test;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElementDelta;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.compiler.ReconcileContext;
import org.eclipse.wst.jsdt.core.compiler.ValidationParticipant;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaModelTests;
import org.eclipse.wst.jsdt.core.tests.model.CancelCounter;
import org.eclipse.wst.jsdt.core.tests.model.Canceler;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.wst.jsdt.core.tests.model.TestvalidationParticipant;
import org.eclipse.wst.jsdt.core.tests.util.Util;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexManager;

public class ReconcilerTests
extends ModifyingResourceTests {
    protected IJavaScriptUnit workingCopy;
    protected AbstractJavaModelTests.ProblemRequestor problemRequestor;

    public ReconcilerTests(String name) {
        super(name);
    }

    public static Test suite() {
        return ReconcilerTests.buildModelTestSuite(ReconcilerTests.class);
    }

    protected void assertProblems(String message, String expected) {
        this.assertProblems(message, expected, this.problemRequestor);
    }

    protected void assertNoProblem(char[] source, IJavaScriptUnit unit) throws InterruptedException, JavaScriptModelException {
        IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
        if (this.problemRequestor.problemCount > 0) {
            while (indexManager.awaitingJobsCount() > 0) {
                Thread.sleep(100L);
            }
            this.problemRequestor.initialize(source);
            unit.getBuffer().setContents(source);
            unit.reconcile(3, true, null, null);
            if (this.problemRequestor.problemCount > 0) {
                ReconcilerTests.assertEquals((String)"Working copy should NOT have any problem!", (String)"", (String)this.problemRequestor.problems.toString());
            }
        }
    }

    protected void addClasspathEntries(IIncludePathEntry[] entries, boolean enableForbiddenReferences) throws JavaScriptModelException {
        IJavaScriptProject project = this.getJavaProject("Reconciler");
        IIncludePathEntry[] oldClasspath = project.getRawIncludepath();
        int oldLength = oldClasspath.length;
        int length = entries.length;
        IIncludePathEntry[] newClasspath = new IIncludePathEntry[oldLength + length];
        System.arraycopy(oldClasspath, 0, newClasspath, 0, oldLength);
        System.arraycopy(entries, 0, newClasspath, oldLength, length);
        project.setRawIncludepath(newClasspath, null);
        if (enableForbiddenReferences) {
            project.setOption("org.eclipse.wst.jsdt.core.compiler.problem.forbiddenReference", "error");
        }
    }

    protected void removeClasspathEntries(IIncludePathEntry[] entries) throws JavaScriptModelException {
        IJavaScriptProject project = this.getJavaProject("Reconciler");
        IIncludePathEntry[] oldClasspath = project.getRawIncludepath();
        int oldLength = oldClasspath.length;
        int length = entries.length;
        IIncludePathEntry[] newClasspath = new IIncludePathEntry[oldLength - length];
        System.arraycopy(oldClasspath, 0, newClasspath, 0, oldLength - length);
        project.setRawIncludepath(newClasspath, null);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.problemRequestor = new AbstractJavaModelTests.ProblemRequestor();
        this.workingCopy = this.getCompilationUnit("Reconciler/src/p1/X.js").getWorkingCopy(new WorkingCopyOwner(){}, null);
        this.problemRequestor.initialize(this.workingCopy.getSource().toCharArray());
        this.startDeltas();
    }

    @Override
    public void setUpSuite() throws Exception {
        super.setUpSuite();
        IJavaScriptProject project14 = this.createJavaProject("Reconciler", new String[]{"src"}, new String[]{"JCL_LIB"});
        this.createFolder("/Reconciler/src/p1");
        this.createFolder("/Reconciler/src/p2");
        this.createFile("/Reconciler/src/p1/X.js", "  function foo() {\n  }\n");
        project14.setOption("org.eclipse.wst.jsdt.core.compiler.source", "1.4");
        project14.setOption("org.eclipse.wst.jsdt.core.compiler.problem.unusedLocal", "ignore");
        project14.setOption("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadoc", "warning");
        this.createJavaProject("Reconciler15", new String[]{"src"}, new String[]{"JCL15_LIB"}, "bin", "1.5");
    }

    private void setUp15WorkingCopy() throws JavaScriptModelException {
        this.setUp15WorkingCopy("Reconciler15/src/p1/X.js", new WorkingCopyOwner(){});
    }

    private void setUp15WorkingCopy(String path, WorkingCopyOwner owner) throws JavaScriptModelException {
        String contents = this.workingCopy.getSource();
        this.setUpWorkingCopy(path, contents, owner);
    }

    private void setUpWorkingCopy(String path, String contents) throws JavaScriptModelException {
        this.setUpWorkingCopy(path, contents, new WorkingCopyOwner(){});
    }

    private void setUpWorkingCopy(String path, String contents, WorkingCopyOwner owner) throws JavaScriptModelException {
        this.workingCopy.discardWorkingCopy();
        this.workingCopy = this.getCompilationUnit(path).getWorkingCopy(owner, null);
        this.setWorkingCopyContents(contents);
        this.workingCopy.makeConsistent(null);
    }

    void setWorkingCopyContents(String contents) throws JavaScriptModelException {
        this.workingCopy.getBuffer().setContents(contents);
        this.problemRequestor.initialize(contents.toCharArray());
    }

    @Override
    public void tearDown() throws Exception {
        TestvalidationParticipant.PARTICIPANT = null;
        if (this.workingCopy != null) {
            this.workingCopy.discardWorkingCopy();
        }
        this.stopDeltas();
        super.tearDown();
    }

    @Override
    public void tearDownSuite() throws Exception {
        this.deleteProject("Reconciler");
        this.deleteProject("Reconciler15");
        super.tearDownSuite();
    }

    public void test00() throws Exception {
    }

    public void test00a() throws JavaScriptModelException {
        this.setWorkingCopyContents("function foo(){\n alert();\n}");
        this.workingCopy.reconcile(0, false, null, null);
        this.assertProblems("Unexpected problems", "----------\n----------\n");
    }

    public void testAccessRestriction() throws CoreException {
        try {
            this.createJavaProject("P1", new String[]{"src"}, new String[]{"JCL_LIB"}, null, null, new String[0], null, null, new boolean[0], new String[][]{{"**/X.js"}}, null, "1.4");
            this.createFile("/P1/src/X.js", "function foo() {}");
            this.createJavaProject("P2", new String[]{"src"}, new String[]{"JCL_LIB"}, new String[]{"/P1"});
            this.setUpWorkingCopy("/P2/src/Y.js", "foo();");
            this.assertProblems("Unexpected problems", "----------\n----------\n");
        }
        finally {
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testAddDuplicateMember() throws JavaScriptModelException {
        this.setWorkingCopyContents("  function foo() {\n  }\n  function foo() {\n  }\n ");
        this.workingCopy.reconcile(0, false, null, null);
        this.assertDeltas("Unexpected delta", "foo()#2[+]: {}");
    }

    public void testAddFieldAndConstructor() throws JavaScriptModelException {
        this.setWorkingCopyContents("  var i;\n  function X(p) {\n  }\n  function foo() {\n  }\n ");
        this.workingCopy.reconcile(0, false, null, null);
        this.assertDeltas("Unexpected delta", "X(p0)[+]: {}\ni[+]: {}");
    }

    public void testAddMethod1() throws JavaScriptModelException {
        this.setWorkingCopyContents("  function foo() {\n  }\n  function bar() {\n  }\n ");
        this.workingCopy.reconcile(0, false, null, null);
        this.assertDeltas("Unexpected delta", "bar()[+]: {}");
    }

    public void testAddPartialMethod1() throws JavaScriptModelException {
        this.setWorkingCopyContents("  function some()\n  function foo() {\n  }\n ");
        this.workingCopy.reconcile(0, false, null, null);
        this.assertDeltas("Unexpected delta", "some()[+]: {}");
    }

    public void testAddPartialMethod1and2() throws JavaScriptModelException {
        this.setWorkingCopyContents("  function some()\n  function foo() {\n  }\n");
        this.workingCopy.reconcile(0, false, null, null);
        this.clearDeltas();
        this.setWorkingCopyContents("  function some() {\n  function foo() {\n  }\n");
        this.workingCopy.reconcile(0, false, null, null);
        this.assertDeltas("Unexpected delta", "[Working copy] X.js[*]: {CONTENT | FINE GRAINED}");
    }

    public void testBroadcastAST1() throws JavaScriptModelException {
        this.setWorkingCopyContents("var i;\n");
        this.workingCopy.reconcile(3, false, null, null);
        this.assertASTNodeEquals("Unexpected ast", "var i;\n", (ASTNode)this.deltaListener.getCompilationUnitAST(this.workingCopy));
    }

    public void testBroadcastAST2() throws JavaScriptModelException {
        this.workingCopy.reconcile(3, true, null, null);
        this.assertASTNodeEquals("Unexpected ast", "function foo(){\n}\n", (ASTNode)this.deltaListener.getCompilationUnitAST(this.workingCopy));
    }

    public void testBroadcastAST3() throws JavaScriptModelException {
        this.workingCopy.reconcile(3, false, null, null);
        this.assertASTNodeEquals("Unexpected ast", "function foo(){\n}\n", (ASTNode)this.deltaListener.getCompilationUnitAST(this.workingCopy));
    }

    public void testBroadcastAST4() throws CoreException {
        JavaScriptCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ReconcilerTests.this.workingCopy.reconcile(3, true, null, monitor);
                ReconcilerTests.this.setWorkingCopyContents("var i;");
                ReconcilerTests.this.workingCopy.reconcile(3, false, null, monitor);
            }
        }, null);
        this.assertASTNodeEquals("Unexpected ast", "var i;\n", (ASTNode)this.deltaListener.getCompilationUnitAST(this.workingCopy));
    }

    public void testBufferOpenAfterReconcile() throws CoreException {
        try {
            this.createFile("/Reconciler/src/p1/Super.js", "package p1;\npublic class Super {\n}");
            this.setWorkingCopyContents("  function foo() {\n  }\n");
            IBuffer buffer = this.workingCopy.getBuffer();
            this.workingCopy.reconcile(0, true, null, null);
            ReconcilerTests.assertTrue((String)"Buffer should still be open", (!buffer.isClosed() ? 1 : 0) != 0);
        }
        finally {
            this.deleteFile("/Reconciler/src/p1/Super.js");
        }
    }

    public void testCancel() throws JavaScriptModelException {
        this.setWorkingCopyContents("  function foo( s) {\n  }\n");
        this.workingCopy.makeConsistent(null);
        CancelCounter counter = new CancelCounter();
        this.workingCopy.reconcile(2, true, null, (IProgressMonitor)counter);
        int i = 0;
        while (i < counter.count) {
            boolean gotException = false;
            try {
                this.workingCopy.reconcile(2, true, null, (IProgressMonitor)new Canceler(i));
            }
            catch (OperationCanceledException operationCanceledException) {
                gotException = true;
            }
            ReconcilerTests.assertTrue((String)("Should get an OperationCanceledException (" + i + ")"), (boolean)gotException);
            ++i;
        }
        this.workingCopy.reconcile(2, true, null, (IProgressMonitor)new Canceler(counter.count));
    }

    public void testCategories1() throws JavaScriptModelException {
        this.setWorkingCopyContents("  /**\n   * @category cat1\n   */\n  function foo() {\n  }\n");
        this.workingCopy.reconcile(0, false, null, null);
        this.assertDeltas("Unexpected delta", "foo()[*]: {CATEGORIES}");
    }

    public void testCategories2() throws JavaScriptModelException {
        this.setWorkingCopyContents("  /**\n   * @category cat1\n   */\n  function foo() {\n  }\n");
        this.workingCopy.makeConsistent(null);
        this.setWorkingCopyContents("  function foo() {\n  }\n");
        this.workingCopy.reconcile(0, false, null, null);
        this.assertDeltas("Unexpected delta", "X[*]: {CHILDREN | FINE GRAINED}\n\tfoo()[*]: {CATEGORIES}");
    }

    public void testCategories3() throws JavaScriptModelException {
        this.setWorkingCopyContents("  /**\n   * @category cat1\n   */\n  function foo() {\n  }\n ");
        this.workingCopy.makeConsistent(null);
        this.setWorkingCopyContents("  /**\n   * @category cat2\n   */\n  function foo() {\n  }\n");
        this.workingCopy.reconcile(0, false, null, null);
        this.assertDeltas("Unexpected delta", "X[*]: {CHILDREN | FINE GRAINED}\n\tfoo()[*]: {CATEGORIES}");
    }

    public void testCategories4() throws JavaScriptModelException {
        this.setWorkingCopyContents("  /**\n   * @category cat1\n   */\n  int f1;\n  int f2;\n");
        this.workingCopy.makeConsistent(null);
        this.setWorkingCopyContents("  /**\n   * @category cat1\n   */\n  int f1;\n  /**\n   * @category cat2\n   */\n  int f2;\n");
        this.workingCopy.reconcile(0, false, null, null);
        this.assertDeltas("Unexpected delta", "X[*]: {CHILDREN | FINE GRAINED}\n\tf2[*]: {CATEGORIES}");
    }

    public void testCloseWorkingCopy() throws JavaScriptModelException {
        IBuffer buffer = this.workingCopy.getBuffer();
        this.workingCopy.close();
        buffer.setContents("  function foo() {\n  }\n  function bar() {\n  }\n");
        this.workingCopy.reconcile(0, false, null, null);
        this.assertDeltas("Unexpected delta", "bar()[+]: {}");
    }

    public void testDeleteMethod1() throws JavaScriptModelException {
        this.setWorkingCopyContents("  ");
        this.workingCopy.reconcile(0, false, null, null);
        this.assertDeltas("Unexpected delta", "foo()[-]: {}");
    }

    public void testDeleteTwoMethods() throws JavaScriptModelException {
        this.setWorkingCopyContents("  function foo() {\n  }\n  function bar() {\n  }\n");
        this.workingCopy.reconcile(0, false, null, null);
        this.clearDeltas();
        this.setWorkingCopyContents("  ");
        this.workingCopy.reconcile(0, false, null, null);
        this.assertDeltas("Unexpected delta", "bar()[-]: {}\nfoo()[-]: {}");
    }

    public void testExcludePartOfAnotherProject1() throws CoreException {
        IIncludePathEntry[] newEntries = this.createClasspath("Reconciler", new String[]{"/P", "-**/internal/"});
        try {
            this.addClasspathEntries(newEntries, true);
            this.createJavaProject("P");
            this.createFolder("/P/p/internal");
            this.createFile("/P/p/internal/Y.js", "package p.internal;\npublic class Y {\n}");
            this.setWorkingCopyContents("package p1;\npublic class X extends p.internal.Y {\n}");
            this.workingCopy.reconcile(0, false, null, null);
            this.assertProblems("Unexpected problems", "----------\n1. ERROR in /Reconciler/src/p1/X.java (at line 2)\n\tpublic class X extends p.internal.Y {\n\t                       ^^^^^^^^^^^^\nAccess restriction: The type Y is not accessible due to restriction on required project P\n----------\n");
        }
        finally {
            this.removeClasspathEntries(newEntries);
            this.deleteProject("P");
        }
    }

    public void testExcludePartOfAnotherProject2() throws CoreException {
        IIncludePathEntry[] newEntries = this.createClasspath("Reconciler", new String[]{"/P", "-**/internal/"});
        try {
            this.addClasspathEntries(newEntries, true);
            this.createJavaProject("P");
            this.createFolder("/P/p/api");
            this.createFile("/P/p/api/Y.js", "package p.api;\npublic class Y {\n}");
            this.setWorkingCopyContents("package p1;\npublic class X extends p.api.Y {\n}");
            this.workingCopy.reconcile(0, false, null, null);
            this.assertProblems("Unexpected problems", "----------\n----------\n");
        }
        finally {
            this.removeClasspathEntries(newEntries);
            this.deleteProject("P");
        }
    }

    public void testIncludePartOfAnotherProject1() throws CoreException {
        IIncludePathEntry[] newEntries = this.createClasspath("Reconciler", new String[]{"/P", "+**/api/"});
        try {
            this.addClasspathEntries(newEntries, true);
            this.createJavaProject("P");
            this.createFolder("/P/p/api");
            this.createFile("/P/p/api/Y.js", "package p.api;\npublic class Y {\n}");
            this.setWorkingCopyContents("package p1;\npublic class X extends p.api.Y {\n}");
            this.workingCopy.reconcile(0, false, null, null);
            this.assertProblems("Unexpected problems", "----------\n----------\n");
        }
        finally {
            this.removeClasspathEntries(newEntries);
            this.deleteProject("P");
        }
    }

    public void testIncludePartOfAnotherProject2() throws CoreException {
        IIncludePathEntry[] newEntries = this.createClasspath("Reconciler", new String[]{"/P", "+**/api/|-**"});
        try {
            this.addClasspathEntries(newEntries, true);
            this.createJavaProject("P");
            this.createFolder("/P/p/internal");
            this.createFile("/P/p/internal/Y.js", "package p.internal;\npublic class Y {\n}");
            this.setWorkingCopyContents("package p1;\npublic class X extends p.internal.Y {\n}");
            this.workingCopy.reconcile(0, false, null, null);
            this.assertProblems("Unexpected problems", "----------\n1. ERROR in /Reconciler/src/p1/X.java (at line 2)\n\tpublic class X extends p.internal.Y {\n\t                       ^^^^^^^^^^^^\nAccess restriction: The type Y is not accessible due to restriction on required project P\n----------\n");
        }
        finally {
            this.removeClasspathEntries(newEntries);
            this.deleteProject("P");
        }
    }

    public void testGrowImports() throws JavaScriptModelException {
        this.setWorkingCopyContents("package p1;\npublic class X {\n}");
        this.workingCopy.reconcile(0, false, null, null);
        this.clearDeltas();
        this.setWorkingCopyContents("package p1;\nimport p\npublic class X {\n}");
        this.workingCopy.reconcile(0, false, null, null);
        this.assertDeltas("Unexpected delta", "<import container>[+]: {}");
        this.clearDeltas();
        this.setWorkingCopyContents("package p1;\nimport p2\npublic class X {\n}");
        this.workingCopy.reconcile(0, false, null, null);
        this.assertDeltas("Unexpected delta", "<import container>[*]: {CHILDREN | FINE GRAINED}\n\timport p[-]: {}\n\timport p2[+]: {}");
    }

    public void testIgnoreIfBetterNonAccessibleRule1() throws CoreException {
        IIncludePathEntry[] newEntries = this.createClasspath("Reconciler", new String[]{"/P1", "?**/internal/", "/P2", "+**/internal/Y"});
        try {
            this.addClasspathEntries(newEntries, true);
            this.createJavaProject("P1");
            this.createFolder("/P1/p/internal");
            this.createFile("/P1/p/internal/Y.js", "package p.internal;\npublic class Y {\n}");
            this.createJavaProject("P2");
            this.createFolder("/P2/p/internal");
            this.createFile("/P2/p/internal/Y.js", "package p.internal;\npublic class Y {\n}");
            this.setWorkingCopyContents("package p1;\npublic class X extends p.internal.Y {\n}");
            this.workingCopy.reconcile(0, false, null, null);
            this.assertProblems("Unexpected problems", "----------\n----------\n");
        }
        catch (Throwable throwable) {
            this.removeClasspathEntries(newEntries);
            this.deleteProjects(new String[]{"P1", "P2"});
            throw throwable;
        }
        this.removeClasspathEntries(newEntries);
        this.deleteProjects(new String[]{"P1", "P2"});
    }

    public void testIgnoreIfBetterNonAccessibleRule2() throws CoreException {
        IIncludePathEntry[] newEntries = this.createClasspath("Reconciler", new String[]{"/P1", "?**/internal/", "/P2", "~**/internal/Y"});
        try {
            this.addClasspathEntries(newEntries, true);
            this.createJavaProject("P1");
            this.createFolder("/P1/p/internal");
            this.createFile("/P1/p/internal/Y.js", "package p.internal;\npublic class Y {\n}");
            this.createJavaProject("P2");
            this.createFolder("/P2/p/internal");
            this.createFile("/P2/p/internal/Y.js", "package p.internal;\npublic class Y {\n}");
            this.setWorkingCopyContents("package p1;\npublic class X extends p.internal.Y {\n}");
            this.workingCopy.reconcile(0, false, null, null);
            this.assertProblems("Unexpected problems", "----------\n1. WARNING in /Reconciler/src/p1/X.java (at line 2)\n\tpublic class X extends p.internal.Y {\n\t                       ^^^^^^^^^^^^\nDiscouraged access: The type Y is not accessible due to restriction on required project P2\n----------\n");
        }
        catch (Throwable throwable) {
            this.removeClasspathEntries(newEntries);
            this.deleteProjects(new String[]{"P1", "P2"});
            throw throwable;
        }
        this.removeClasspathEntries(newEntries);
        this.deleteProjects(new String[]{"P1", "P2"});
    }

    public void testIgnoreIfBetterNonAccessibleRule3() throws CoreException {
        IIncludePathEntry[] newEntries = this.createClasspath("Reconciler", new String[]{"/P1", "?**/internal/", "/P2", "-**/internal/Y"});
        try {
            this.addClasspathEntries(newEntries, true);
            this.createJavaProject("P1");
            this.createFolder("/P1/p/internal");
            this.createFile("/P1/p/internal/Y.js", "package p.internal;\npublic class Y {\n}");
            this.createJavaProject("P2");
            this.createFolder("/P2/p/internal");
            this.createFile("/P2/p/internal/Y.js", "package p.internal;\npublic class Y {\n}");
            this.setWorkingCopyContents("package p1;\npublic class X extends p.internal.Y {\n}");
            this.workingCopy.reconcile(0, false, null, null);
            this.assertProblems("Unexpected problems", "----------\n1. ERROR in /Reconciler/src/p1/X.java (at line 2)\n\tpublic class X extends p.internal.Y {\n\t                       ^^^^^^^^^^^^\nAccess restriction: The type Y is not accessible due to restriction on required project P1\n----------\n");
        }
        catch (Throwable throwable) {
            this.removeClasspathEntries(newEntries);
            this.deleteProjects(new String[]{"P1", "P2"});
            throw throwable;
        }
        this.removeClasspathEntries(newEntries);
        this.deleteProjects(new String[]{"P1", "P2"});
    }

    public void testIgnoreIfBetterNonAccessibleRule4() throws CoreException {
        IIncludePathEntry[] newEntries = this.createClasspath("Reconciler", new String[]{"/P1", "?**/internal/"});
        try {
            this.addClasspathEntries(newEntries, true);
            this.createJavaProject("P1");
            this.createFolder("/P1/p/internal");
            this.createFile("/P1/p/internal/Y.js", "package p.internal;\npublic class Y {\n}");
            this.setWorkingCopyContents("package p1;\npublic class X extends p.internal.Y {\n}");
            this.workingCopy.reconcile(0, false, null, null);
            this.assertProblems("Unexpected problems", "----------\n1. ERROR in /Reconciler/src/p1/X.java (at line 2)\n\tpublic class X extends p.internal.Y {\n\t                       ^^^^^^^^^^^^\nAccess restriction: The type Y is not accessible due to restriction on required project P1\n----------\n");
        }
        catch (Throwable throwable) {
            this.removeClasspathEntries(newEntries);
            this.deleteProjects(new String[]{"P1"});
            throw throwable;
        }
        this.removeClasspathEntries(newEntries);
        this.deleteProjects(new String[]{"P1"});
    }

    public void testMethodWithError01() throws CoreException {
        this.setWorkingCopyContents("package p1;\nimport p2.*;\npublic class X {\n  public.void foo() {\n  }\n}");
        this.workingCopy.reconcile(0, false, null, null);
        this.assertDeltas("Unexpected delta after syntax error", "X[*]: {CHILDREN | FINE GRAINED}\n\tfoo()[*]: {MODIFIERS CHANGED}");
        this.assertProblems("Unexpected problems", "----------\n1. ERROR in /Reconciler/src/p1/X.java (at line 4)\n\tpublic.void foo() {\n\t      ^\nSyntax error on token \".\", delete this token\n----------\n");
        this.clearDeltas();
        String contents = "package p1;\nimport p2.*;\npublic class X {\n  public void foo() {\n  }\n}";
        this.setWorkingCopyContents(contents);
        this.workingCopy.reconcile(0, false, null, null);
        this.assertDeltas("Unexpected delta after fixing syntax error", "X[*]: {CHILDREN | FINE GRAINED}\n\tfoo()[*]: {MODIFIERS CHANGED}");
        this.assertProblems("Unexpected problems", "----------\n1. WARNING in /Reconciler/src/p1/X.java (at line 2)\n\timport p2.*;\n\t       ^^\nThe import p2 is never used\n----------\n");
    }

    public void testMethodWithError02() throws CoreException {
        String contents = "package p1;\nimport p2.*;\npublic class X {\n  public.void foo() {\n  }\n}";
        this.setWorkingCopyContents(contents);
        this.workingCopy.reconcile(0, false, null, null);
        this.problemRequestor.initialize(contents.toCharArray());
        this.workingCopy.reconcile(0, true, null, null);
        this.assertProblems("Unexpected problems", "----------\n1. ERROR in /Reconciler/src/p1/X.java (at line 4)\n\tpublic.void foo() {\n\t      ^\nSyntax error on token \".\", delete this token\n----------\n");
    }

    public void testMethodWithError03() throws CoreException {
        String contents = "package p1;\nimport p2.*;\npublic class X {\n  public.void foo() {\n  }\n}";
        this.setWorkingCopyContents(contents);
        this.workingCopy.reconcile(0, false, null, null);
        this.problemRequestor.initialize(contents.toCharArray());
        this.workingCopy.reconcile(0, false, null, null);
        this.assertProblems("Unexpected problems", "");
    }

    public void testMethodWithError04() throws CoreException {
        CancelingProblemRequestor myPbRequestor = new CancelingProblemRequestor();
        this.workingCopy.discardWorkingCopy();
        IJavaScriptUnit x = this.getCompilationUnit("Reconciler", "src", "p1", "X.js");
        this.problemRequestor = myPbRequestor;
        this.workingCopy = x.getWorkingCopy(new WorkingCopyOwner(){}, null);
        String contents = "package p1;\npublic class X {\n\tZork f;\t\n\tvoid foo(Zork z){\n\t}\n}\t\n";
        this.setWorkingCopyContents(contents);
        this.workingCopy.reconcile(0, false, null, null);
        myPbRequestor.isCanceling = true;
        myPbRequestor.initialize(contents.toCharArray());
        this.workingCopy.reconcile(0, true, null, myPbRequestor.progressMonitor);
        this.assertProblems("Unexpected problems", "----------\n1. ERROR in /Reconciler/src/p1/X.java (at line 3)\n\tZork f;\t\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void testMethodWithError05() throws CoreException {
        try {
            this.createFolder("/Reconciler/src/tests");
            String contents = "package tests;\t\nabstract class AbstractSearchableSource extends AbstractSource implements SearchableSource {\t\n\tabstract int indexOfImpl(long value);\t\n\tpublic final int indexOf(long value) {\t\n\t\treturn indexOfImpl(value);\t\n\t}\t\n}\t\n";
            this.createFile("/Reconciler/src/tests/AbstractSearchableSource.js", contents);
            this.createFile("/Reconciler/src/tests/Source.js", "package tests;\t\ninterface Source {\t\n\tlong getValue(int index);\t\n\tint size();\t\n}\t\n");
            this.createFile("/Reconciler/src/tests/AbstractSource.js", "package tests;\t\nabstract class AbstractSource implements Source {\t\n\tAbstractSource() {\t\n\t}\t\n\tvoid invalidate() {\t\n\t}\t\n\tabstract long getValueImpl(int index);\t\n\tabstract int sizeImpl();\t\n\tpublic final long getValue(int index) {\t\n\t\treturn 0;\t\n\t}\t\n\tpublic final int size() {\t\n\t\treturn 0;\t\n\t}\t\n}\t\n");
            this.createFile("/Reconciler/src/tests/SearchableSource.js", "package tests;\t\ninterface SearchableSource extends Source {\t\n\tint indexOf(long value);\t\n}\t\n");
            IJavaScriptUnit compilationUnit = this.getCompilationUnit("Reconciler", "src", "tests", "AbstractSearchableSource.js");
            AbstractJavaModelTests.ProblemRequestor pbReq = new AbstractJavaModelTests.ProblemRequestor();
            IJavaScriptUnit wc = compilationUnit.getWorkingCopy(new WorkingCopyOwner(){}, null);
            pbReq.initialize(contents.toCharArray());
            this.startDeltas();
            wc.reconcile(0, true, null, null);
            String actual = pbReq.problems.toString();
            String expected = "----------\n----------\n";
            if (!expected.equals(actual)) {
                System.out.println(Util.displayString((String)actual, (int)2));
            }
            ReconcilerTests.assertEquals((String)"unexpected errors", (String)expected, (String)actual);
        }
        finally {
            this.deleteFile("/Reconciler/src/tests/AbstractSearchableSource.js");
            this.deleteFile("/Reconciler/src/tests/SearchableSource.js");
            this.deleteFile("/Reconciler/src/tests/Source.js");
            this.deleteFile("/Reconciler/src/tests/AbstractSource.js");
            this.deleteFolder("/Reconciler/src/tests");
        }
    }

    public void testMethodWithError06() throws CoreException {
        this.workingCopy.discardWorkingCopy();
        this.workingCopy = null;
        try {
            String contents = "package p1;\npublic class Y {\n  public.void foo() {\n  }\n}";
            this.createFile("/Reconciler/src/p1/Y.js", contents);
            this.problemRequestor = new AbstractJavaModelTests.ProblemRequestor();
            this.problemRequestor.initialize(contents.toCharArray());
            this.workingCopy = this.getCompilationUnit("Reconciler/src/p1/Y.js").getWorkingCopy(new WorkingCopyOwner(){}, null);
            this.assertProblems("Unexpected problems", "----------\n1. ERROR in /Reconciler/src/p1/Y.java (at line 3)\n\tpublic.void foo() {\n\t      ^\nSyntax error on token \".\", delete this token\n----------\n");
        }
        finally {
            this.deleteFile("/Reconciler/src/p1/Y.js");
        }
    }

    public void testMethodWithError07() throws CoreException {
        this.workingCopy.discardWorkingCopy();
        this.workingCopy = null;
        try {
            String contents = "package p1;\npublic class Y {\n  public.void foo() {\n  }\n}";
            this.createFile("/Reconciler/src/p1/Y.js", contents);
            this.problemRequestor = new AbstractJavaModelTests.ProblemRequestor();
            this.problemRequestor.initialize(contents.toCharArray());
            this.workingCopy = this.getCompilationUnit("Reconciler/src/p1/Y.js").getWorkingCopy(new WorkingCopyOwner(){}, null);
            JavaModelManager.getJavaModelManager().removeInfoAndChildren((JavaElement)((CompilationUnit)this.workingCopy));
            this.problemRequestor.initialize(contents.toCharArray());
            this.workingCopy.open(null);
            this.assertProblems("Unexpected problems", "----------\n1. ERROR in /Reconciler/src/p1/Y.java (at line 3)\n\tpublic.void foo() {\n\t      ^\nSyntax error on token \".\", delete this token\n----------\n");
        }
        finally {
            this.deleteFile("/Reconciler/src/p1/Y.js");
        }
    }

    public void testMethodWithError08() throws CoreException {
        this.workingCopy.discardWorkingCopy();
        this.workingCopy = null;
        try {
            this.createFile("/Reconciler/src/p1/X01.js", "package p1;\npublic abstract class X01 {\n\tpublic abstract void bar();\t\n  public abstract void foo(Zork z); \n}");
            String contents = "package p2;\npublic class X01 extends p1.X01 {\n\tpublic void bar(){}\t\n}";
            this.createFile("/Reconciler/src/p2/X01.js", contents);
            this.problemRequestor = new AbstractJavaModelTests.ProblemRequestor();
            this.problemRequestor.initialize(contents.toCharArray());
            this.workingCopy = this.getCompilationUnit("Reconciler/src/p2/X01.js").getWorkingCopy(new WorkingCopyOwner(){}, null);
            JavaModelManager.getJavaModelManager().removeInfoAndChildren((JavaElement)((CompilationUnit)this.workingCopy));
            this.problemRequestor.initialize(contents.toCharArray());
            this.workingCopy.open(null);
            this.assertProblems("Unexpected problems", "----------\n----------\n");
        }
        finally {
            this.deleteFile("/Reconciler/src/p1/X01.js");
            this.deleteFile("/Reconciler/src/p2/X01.js");
        }
    }

    public void testMethodWithError09() throws CoreException {
        this.workingCopy.discardWorkingCopy();
        this.workingCopy = null;
        WorkingCopyOwner owner = new WorkingCopyOwner(){};
        IJavaScriptUnit workingCopy1 = null;
        try {
            workingCopy1 = this.getCompilationUnit("/Reconciler/src/p1/X1.js").getWorkingCopy(owner, null);
            workingCopy1.getBuffer().setContents("package p1;\npublic abstract class X1 {\n\tpublic abstract void bar();\t\n}");
            workingCopy1.makeConsistent(null);
            this.problemRequestor = new AbstractJavaModelTests.ProblemRequestor();
            this.workingCopy = this.getCompilationUnit("Reconciler/src/p/X.js").getWorkingCopy(owner, null);
            this.setWorkingCopyContents("package p;\npublic class X extends p1.X1 {\n\tpublic void bar(){}\t\n}");
            this.workingCopy.reconcile(0, false, owner, null);
            this.assertProblems("Unexpected problems", "----------\n----------\n");
        }
        finally {
            if (workingCopy1 != null) {
                workingCopy1.discardWorkingCopy();
            }
        }
    }

    public void testMethodWithError10() throws CoreException {
        this.workingCopy.discardWorkingCopy();
        this.workingCopy = null;
        WorkingCopyOwner owner = new WorkingCopyOwner(){};
        IJavaScriptUnit workingCopy1 = null;
        try {
            this.createFolder("/Reconciler15/src/test/cheetah");
            workingCopy1 = this.getCompilationUnit("/Reconciler15/src/test/cheetah/NestedGenerics.js").getWorkingCopy(owner, null);
            workingCopy1.getBuffer().setContents("package test.cheetah;\nimport java.util.List;\nimport java.util.Stack;\npublic class NestedGenerics {\n    Stack< List<Object>> stack = new Stack< List<Object> >();\n}\n");
            workingCopy1.makeConsistent(null);
            this.problemRequestor = new AbstractJavaModelTests.ProblemRequestor();
            this.workingCopy = this.getCompilationUnit("Reconciler15/src/test/cheetah/NestedGenericsTest.js").getWorkingCopy(owner, null);
            this.setWorkingCopyContents("package test.cheetah;\nimport java.util.Stack;\npublic class NestedGenericsTest {\n    void test() {  \n        Stack s = new NestedGenerics().stack;  \n    }\n}\n");
            this.workingCopy.reconcile(0, false, owner, null);
            this.assertProblems("Unexpected problems", "----------\n----------\n");
        }
        finally {
            if (workingCopy1 != null) {
                workingCopy1.discardWorkingCopy();
            }
            this.deleteFolder("/Reconciler15/src/test");
        }
    }

    public void testMethodWithError11() throws CoreException {
        this.workingCopy.discardWorkingCopy();
        this.workingCopy = null;
        WorkingCopyOwner owner = new WorkingCopyOwner(){};
        IJavaScriptUnit workingCopy1 = null;
        try {
            this.createFolder("/Reconciler15/src/test/cheetah");
            workingCopy1 = this.getCompilationUnit("/Reconciler15/src/test/cheetah/NestedGenerics.js").getWorkingCopy(owner, null);
            workingCopy1.getBuffer().setContents("package test.cheetah;\nimport java.util.*;\npublic class NestedGenerics {\n    Map<List<Object>,String> map = null;\n    Stack<List<Object>> stack2 = null;\n    Map<List<Object>,List<Object>> map3 = null;\n}\n");
            workingCopy1.makeConsistent(null);
            this.problemRequestor = new AbstractJavaModelTests.ProblemRequestor();
            this.workingCopy = this.getCompilationUnit("Reconciler15/src/test/cheetah/NestedGenericsTest.js").getWorkingCopy(owner, null);
            this.setWorkingCopyContents("package test.cheetah;\nimport java.util.*;\npublic class NestedGenericsTest {\n    void test() {  \n        Map m = new NestedGenerics().map;  \n\t\t Stack s2 = new NestedGenerics().stack2;    \n        Map m3 = new NestedGenerics().map3;    \n    }\n}\n");
            this.workingCopy.reconcile(0, false, owner, null);
            this.assertProblems("Unexpected problems", "----------\n----------\n");
        }
        finally {
            if (workingCopy1 != null) {
                workingCopy1.discardWorkingCopy();
            }
            this.deleteFolder("/Reconciler15/src/test");
        }
    }

    public void testMethodWithError12() throws CoreException {
        this.workingCopy.discardWorkingCopy();
        this.workingCopy = null;
        WorkingCopyOwner owner = new WorkingCopyOwner(){};
        IJavaScriptUnit workingCopy1 = null;
        try {
            this.createFolder("/Reconciler15/src/test/cheetah");
            workingCopy1 = this.getCompilationUnit("/Reconciler15/src/test/cheetah/NestedGenerics.js").getWorkingCopy(owner, null);
            workingCopy1.getBuffer().setContents("package test.cheetah;\nimport java.util.*;\npublic class NestedGenerics {\n    Map<List<?>,? super String> map = null;\n    Stack<List<? extends Object>> stack2 = null;\n    Map<List<Object[]>,List<Object>[]> map3 = null;\n}\n");
            workingCopy1.makeConsistent(null);
            this.problemRequestor = new AbstractJavaModelTests.ProblemRequestor();
            this.workingCopy = this.getCompilationUnit("Reconciler15/src/test/cheetah/NestedGenericsTest.js").getWorkingCopy(owner, null);
            this.setWorkingCopyContents("package test.cheetah;\nimport java.util.*;\npublic class NestedGenericsTest {\n    void test() {  \n        Map m = new NestedGenerics().map;  \n\t\t Stack s2 = new NestedGenerics().stack2;    \n        Map m3 = new NestedGenerics().map3;    \n    }\n}\n");
            this.workingCopy.reconcile(0, false, owner, null);
            this.assertProblems("Unexpected problems", "----------\n----------\n");
        }
        finally {
            if (workingCopy1 != null) {
                workingCopy1.discardWorkingCopy();
            }
            this.deleteFolder("/Reconciler15/src/test");
        }
    }

    public void testMethodWithError13() throws CoreException {
        this.workingCopy.discardWorkingCopy();
        this.workingCopy = null;
        WorkingCopyOwner owner = new WorkingCopyOwner(){};
        IJavaScriptUnit workingCopy1 = null;
        try {
            workingCopy1 = this.getCompilationUnit("/Reconciler15/src/test/X.js").getWorkingCopy(owner, null);
            this.createFolder("/Reconciler15/src/test");
            workingCopy1.getBuffer().setContents("package test;\npublic class X <T extends String, U> {\n\t<Y1> void bar(Y1[] y) {}\n\tvoid bar2(Y<E3[]>[] ye[]) {}\n    void foo(java.util.Map<Object[],String>.MapEntry<p.K<T>[],? super q.r.V8> m){}\n    Class<? extends Object> getClass0() {}\n    <E extends String> void pair (X<? extends E, U> e, T t){}\n}\n");
            workingCopy1.makeConsistent(null);
            this.problemRequestor = new AbstractJavaModelTests.ProblemRequestor();
            this.workingCopy = this.getCompilationUnit("Reconciler15/src/test/Y.js").getWorkingCopy(owner, null);
            this.setWorkingCopyContents("package test;\npublic class Y {\n\tvoid foo(){\n\t\tX someX = new X();\n\t\tsomeX.bar(null);\n\t}\n}\n");
            this.workingCopy.reconcile(0, false, owner, null);
            this.assertProblems("Unexpected problems", "----------\n1. WARNING in /Reconciler15/src/test/Y.java (at line 5)\n\tsomeX.bar(null);\n\t^^^^^^^^^^^^^^^\nType safety: The method bar(Object[]) belongs to the raw type X. References to generic type X<T,U> should be parameterized\n----------\n");
        }
        finally {
            if (workingCopy1 != null) {
                workingCopy1.discardWorkingCopy();
            }
            this.deleteFolder("/Reconciler15/src/test");
        }
    }

    public void testMethodWithError14() throws CoreException {
        this.workingCopy.discardWorkingCopy();
        this.workingCopy = null;
        WorkingCopyOwner owner = new WorkingCopyOwner(){};
        IJavaScriptUnit workingCopy1 = null;
        try {
            workingCopy1 = this.getCompilationUnit("/Reconciler15/src/test/X.js").getWorkingCopy(owner, null);
            this.createFolder("/Reconciler15/src/test");
            workingCopy1.getBuffer().setContents("package test;\npublic class X <T> {\n\t<U> void bar(U u) {}\n}\n");
            workingCopy1.makeConsistent(null);
            this.problemRequestor = new AbstractJavaModelTests.ProblemRequestor();
            this.workingCopy = this.getCompilationUnit("Reconciler15/src/test/Y.js").getWorkingCopy(owner, null);
            this.setWorkingCopyContents("package test;\npublic class Y {\n\tvoid foo(){\n\t\tX someX = new X();\n\t\tsomeX.bar();\n\t}\n}\n");
            this.workingCopy.reconcile(0, false, owner, null);
            this.assertProblems("Unexpected problems", "----------\n1. ERROR in /Reconciler15/src/test/Y.java (at line 5)\n\tsomeX.bar();\n\t      ^^^\nThe method bar(Object) in the type X is not applicable for the arguments ()\n----------\n");
        }
        finally {
            if (workingCopy1 != null) {
                workingCopy1.discardWorkingCopy();
            }
            this.deleteFolder("/Reconciler15/src/test");
        }
    }

    public void testMoveMember() throws JavaScriptModelException {
        this.setWorkingCopyContents("package p1;\nimport p2.*;\npublic class X {\n  public void foo() {\n  }\n  public void bar() {\n  }\n}");
        this.workingCopy.reconcile(0, false, null, null);
        this.clearDeltas();
        this.setWorkingCopyContents("package p1;\nimport p2.*;\npublic class X {\n  public void bar() {\n  }\n  public void foo() {\n  }\n}");
        this.workingCopy.reconcile(0, false, null, null);
        this.assertDeltas("Unexpected delta", "X[*]: {CHILDREN | FINE GRAINED}\n\tbar()[*]: {REORDERED}\n\tfoo()[*]: {REORDERED}");
    }

    public void testNoChanges1() throws JavaScriptModelException {
        this.setWorkingCopyContents(this.workingCopy.getSource());
        this.workingCopy.reconcile(0, false, null, null);
        this.assertDeltas("Unexpected delta", "[Working copy] X.java[*]: {CONTENT | FINE GRAINED}");
    }

    public void testNoChanges2() throws JavaScriptModelException {
        this.setWorkingCopyContents("package p1;\nimport p2.*;\npublic class X {\n  public void foo() {\n    System.out.println()\n  }\n}");
        this.workingCopy.reconcile(0, false, null, null);
        this.assertDeltas("Unexpected delta", "[Working copy] X.java[*]: {CONTENT | FINE GRAINED}");
    }

    public void testRawUsage() throws CoreException {
        IJavaScriptUnit otherCopy = null;
        try {
            WorkingCopyOwner owner = new WorkingCopyOwner(){};
            otherCopy = this.getWorkingCopy("Reconciler15/src/Generic105756.js", "public class Generic105756<T> {\n  void foo() {}\n}", owner, false);
            this.setUp15WorkingCopy("/Reconciler15/src/X.js", owner);
            this.setWorkingCopyContents("public class X {\n  void bar(Generic105756 g) {\n    g.foo();\n  }\n}");
            this.workingCopy.reconcile(0, false, owner, null);
            this.assertProblems("Unexpected problems", "----------\n----------\n");
        }
        finally {
            if (otherCopy != null) {
                otherCopy.discardWorkingCopy();
            }
        }
    }

    public void testReconcileParticipant01() throws CoreException {
        ReconcileParticipant participant = new ReconcileParticipant();
        this.setWorkingCopyContents("package p1;\nimport p2.*;\npublic class X {\n  public void bar() {\n    System.out.println()\n  }\n}");
        this.workingCopy.reconcile(0, false, null, null);
        this.assertDeltas("Unexpected participant delta", "[Working copy] X.java[*]: {CHILDREN | FINE GRAINED}\n\tX[*]: {CHILDREN | FINE GRAINED}\n\t\tbar()[+]: {}\n\t\tfoo()[-]: {}", participant.delta);
    }

    public void testReconcileParticipant02() throws CoreException {
        ReconcileParticipant participant = new ReconcileParticipant(){

            @Override
            public boolean isActive(IJavaScriptProject project) {
                return false;
            }
        };
        this.setWorkingCopyContents("package p1;\nimport p2.*;\npublic class X {\n  public void bar() {\n    System.out.println()\n  }\n}");
        this.workingCopy.reconcile(0, false, null, null);
        this.assertDeltas("Unexpected participant delta", "<null>", participant.delta);
    }

    public void testReconcileParticipant03() throws CoreException {
        ReconcileParticipant participant = new ReconcileParticipant();
        this.setWorkingCopyContents("package p1;\nimport p2.*;\npublic class X {\n  public void bar() {\n    System.out.println()\n  }\n}");
        this.workingCopy.reconcile(0, false, null, null);
        this.assertASTNodeEquals("Unexpected participant delta", "package p1;\nimport p2.*;\npublic class X {\n  public void bar(){\n  }\n}\n", (ASTNode)participant.ast);
    }

    public void testReconcileParticipant04() throws CoreException {
        ReconcileParticipant participant = new ReconcileParticipant();
        this.setWorkingCopyContents("package p1;\nimport p2.*;\npublic class X {\n  public void bar() {\n    System.out.println()\n  }\n}");
        JavaScriptUnit ast = this.workingCopy.reconcile(3, false, null, null);
        ReconcilerTests.assertSame((String)"Unexpected participant delta", (Object)participant.ast, (Object)ast);
    }

    public void testReconcileParticipant05() throws CoreException {
        new ReconcileParticipant(){

            @Override
            public void reconcile(ReconcileContext context) {
                try {
                    ReconcilerTests.this.setWorkingCopyContents("package p1;\npublic class X {\n  public void bar() {\n  }\n}");
                    context.resetAST();
                }
                catch (JavaScriptModelException e) {
                    e.printStackTrace();
                }
            }
        };
        this.setWorkingCopyContents("package p1;\npublic class X {\n  public void bar() {\n    toString()\n  }\n}");
        this.workingCopy.reconcile(0, false, null, null);
        this.assertProblems("Unexpected problems", "----------\n----------\n");
    }

    public void testReconcileParticipant06() throws CoreException {
        new ReconcileParticipant(){

            @Override
            public void reconcile(ReconcileContext context) {
                try {
                    ReconcilerTests.this.setWorkingCopyContents("package p1;\npublic class X {\n  public void bar() {\n    toString()\n  }\n}");
                    context.resetAST();
                }
                catch (JavaScriptModelException e) {
                    e.printStackTrace();
                }
            }
        };
        this.setWorkingCopyContents("package p1;\npublic class X {\n  public void bar() {\n  }\n}");
        this.workingCopy.reconcile(0, false, null, null);
        this.assertProblems("Unexpected problems", "----------\n1. ERROR in /Reconciler/src/p1/X.java (at line 4)\n\ttoString()\n\t         ^\nSyntax error, insert \";\" to complete BlockStatements\n----------\n");
    }

    public void testReconcileParticipant07() throws CoreException {
        IJavaScriptProject project = this.workingCopy.getJavaScriptProject();
        String originalSourceLevel = project.getOption("org.eclipse.wst.jsdt.core.compiler.source", true);
        try {
            project.setOption("org.eclipse.wst.jsdt.core.compiler.source", "1.1");
            ReconcileParticipant participant = new ReconcileParticipant();
            this.setWorkingCopyContents("package p1;\nimport p2.*;\npublic class X {\n  public void bar() {\n    System.out.println()\n  }\n}");
            this.workingCopy.reconcile(0, false, null, null);
            this.assertDeltas("Unexpected participant delta", "<null>", participant.delta);
        }
        finally {
            project.setOption("org.eclipse.wst.jsdt.core.compiler.source", originalSourceLevel);
        }
    }

    public void testReconcileParticipant08() throws CoreException {
        String contents = "package p1;\npublic class X {\n  public void bar() {\n  }\n}";
        this.setWorkingCopyContents(contents);
        this.workingCopy.makeConsistent(null);
        this.problemRequestor.initialize(contents.toCharArray());
        new ReconcileParticipant(){

            @Override
            public void reconcile(ReconcileContext context) {
                context.putProblems("test.marker", new CategorizedProblem[0]);
            }
        };
        this.workingCopy.reconcile(0, false, null, null);
        this.assertProblems("Unexpected problems", "");
    }

    public void testRenameMethod1() throws JavaScriptModelException {
        this.setWorkingCopyContents("package p1;\nimport p2.*;\npublic class X {\n  public void bar() {\n  }\n}");
        this.workingCopy.reconcile(0, false, null, null);
        this.assertDeltas("Unexpected delta", "X[*]: {CHILDREN | FINE GRAINED}\n\tbar()[+]: {}\n\tfoo()[-]: {}");
    }

    public void testRenameWithSyntaxError() throws JavaScriptModelException {
        this.setWorkingCopyContents("package p1;\nimport p2.*;\npublic class X {\n  public void bar( {\n  }\n}");
        this.workingCopy.reconcile(0, false, null, null);
        this.assertDeltas("Unexpected delta", "X[*]: {CHILDREN | FINE GRAINED}\n\tbar()[+]: {}\n\tfoo()[-]: {}");
        this.assertProblems("Unexpected problems", "----------\n1. ERROR in /Reconciler/src/p1/X.java (at line 4)\n\tpublic void bar( {\n\t               ^\nSyntax error, insert \")\" to complete FunctionDeclaration\n----------\n");
    }

    public void testSuppressWarnings1() throws JavaScriptModelException {
        IJavaScriptUnit otherCopy = null;
        try {
            WorkingCopyOwner owner = new WorkingCopyOwner(){};
            otherCopy = this.getWorkingCopy("/Reconciler15/src/X.js", "@Deprecated\npublic class X {\n   void foo(){}\n}\n", owner, false);
            this.setUp15WorkingCopy("/Reconciler15/src/Y.js", owner);
            this.setWorkingCopyContents("public class Y extends X {\n  @SuppressWarnings(\"all\")\n   void foo(){ super.foo(); }\n   Zork z;\n}\n");
            this.workingCopy.reconcile(0, false, owner, null);
            this.assertProblems("Unexpected problems", "----------\n1. WARNING in /Reconciler15/src/Y.java (at line 1)\n\tpublic class Y extends X {\n\t                       ^\nThe type X is deprecated\n----------\n2. ERROR in /Reconciler15/src/Y.java (at line 4)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
        }
        finally {
            if (otherCopy != null) {
                otherCopy.discardWorkingCopy();
            }
        }
    }

    public void testSuppressWarnings2() throws JavaScriptModelException {
        IJavaScriptUnit otherCopy = null;
        try {
            WorkingCopyOwner owner = new WorkingCopyOwner(){};
            otherCopy = this.getWorkingCopy("/Reconciler15/src/java/util/List.js", "package java.util;\npublic interface List<E> {\n}\n", owner, false);
            this.setUp15WorkingCopy("/Reconciler15/src/X.js", owner);
            this.setWorkingCopyContents("import java.util.List;\n\npublic class X {\n    void foo(List list) {\n        List<String> ls1 = list;\n    }\n    @SuppressWarnings(\"unchecked\")\n    void bar(List list) {\n        List<String> ls2 = list;\n    }\n   Zork z;\n}\n");
            this.workingCopy.reconcile(0, false, null, null);
            this.assertProblems("Unexpected problems", "----------\n1. WARNING in /Reconciler15/src/X.java (at line 5)\n\tList<String> ls1 = list;\n\t                   ^^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<String>\n----------\n2. ERROR in /Reconciler15/src/X.java (at line 11)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
        }
        finally {
            if (otherCopy != null) {
                otherCopy.discardWorkingCopy();
            }
        }
    }

    public void testSuppressWarnings3() throws JavaScriptModelException {
        IJavaScriptUnit otherCopy = null;
        try {
            WorkingCopyOwner owner = new WorkingCopyOwner(){};
            otherCopy = this.getWorkingCopy("/Reconciler15/src/java/util/HashMap.js", "package java.util;\npublic class HashMap implements Map {\n}\n", owner, false);
            this.setUp15WorkingCopy("/Reconciler15/src/X.js", owner);
            this.setWorkingCopyContents("import java.util.*;\n@SuppressWarnings(\"unchecked\")\npublic class X {\n\tvoid foo() {\n\t\tMap<String, String>[] map = new HashMap[10];\n\t}\n   Zork z;\n}\n");
            this.workingCopy.reconcile(0, false, owner, null);
            this.assertProblems("Unexpected problems", "----------\n1. ERROR in /Reconciler15/src/X.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
        }
        finally {
            if (otherCopy != null) {
                otherCopy.discardWorkingCopy();
            }
        }
    }

    public void testSuppressWarnings4() throws JavaScriptModelException {
        IJavaScriptUnit otherCopy = null;
        try {
            WorkingCopyOwner owner = new WorkingCopyOwner(){};
            otherCopy = this.getWorkingCopy("/Reconciler15/src/X.js", "/** @deprecated */\npublic class X {\n   void foo(){}\n}\n", owner, false);
            this.setUp15WorkingCopy("/Reconciler15/src/Y.js", owner);
            this.setWorkingCopyContents("public class Y extends X {\n  @SuppressWarnings(\"all\")\n   void foo(){ super.foo(); }\n   Zork z;\n}\n");
            this.workingCopy.reconcile(0, false, owner, null);
            this.assertProblems("Unexpected problems", "----------\n1. WARNING in /Reconciler15/src/Y.java (at line 1)\n\tpublic class Y extends X {\n\t                       ^\nThe type X is deprecated\n----------\n2. ERROR in /Reconciler15/src/Y.java (at line 4)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
        }
        finally {
            if (otherCopy != null) {
                otherCopy.discardWorkingCopy();
            }
        }
    }

    public void testUnhandledException() throws JavaScriptModelException {
        this.setWorkingCopyContents("package p1;\npublic class X {\n  public void foo() {\n    throw new Exception();\n  }\n}");
        this.workingCopy.reconcile(0, false, null, null);
        this.assertProblems("Unexpected problems", "----------\n1. ERROR in /Reconciler/src/p1/X.java (at line 4)\n\tthrow new Exception();\n\t^^^^^^^^^^^^^^^^^^^^^^\nUnhandled exception type Exception\n----------\n");
    }

    public void testMakeConsistentFoolingReconciler() throws JavaScriptModelException {
        this.setWorkingCopyContents("");
        this.workingCopy.makeConsistent(null);
        this.workingCopy.reconcile(0, false, null, null);
        this.assertDeltas("Should have got NO delta", "");
    }

    public void testBug60689() throws JavaScriptModelException {
        this.setWorkingCopyContents("public class X {\n\t/**\n\t * Returns the length of the string representing the number of \n\t * indents in the given string <code>line</code>. Returns \n\t * <code>-1<code> if the line isn't prefixed with an indent of\n\t * the given number of indents. \n\t */\n\tpublic static int computeIndentLength(String line, int numberOfIndents, int tabWidth) {\n\t\treturn 0;\n}");
        JavaScriptUnit testCU = this.workingCopy.reconcile(2, true, null, null);
        ReconcilerTests.assertNotNull((String)"We should have a comment!", (Object)testCU.getCommentList());
        ReconcilerTests.assertEquals((String)"We should have 1 comment!", (int)1, (int)testCU.getCommentList().size());
        testCU = this.workingCopy.reconcile(2, true, null, null);
        ReconcilerTests.assertNotNull((String)"We should have a comment!", (Object)testCU.getCommentList());
        ReconcilerTests.assertEquals((String)"We should have one comment!", (int)1, (int)testCU.getCommentList().size());
    }

    public void testTwoProjectsWithDifferentCompliances() throws CoreException {
        this.workingCopy.discardWorkingCopy();
        try {
            this.createJavaProject("P1", new String[]{""}, new String[]{"JCL15_LIB"}, "", "1.5");
            this.createFolder("/P1/p");
            this.createFile("/P1/p/X.js", "package p;\npublic class X {\n  void foo(Class<String> c) {\n  }\n}");
            this.createJavaProject("P2", new String[]{""}, new String[]{"JCL_LIB"}, new String[]{"/P1"}, "", "1.4");
            this.createFolder("/P2/p");
            WorkingCopyOwner owner = new WorkingCopyOwner(){};
            this.workingCopy = this.getWorkingCopy("/P2/p/Y.js", "", owner, this.problemRequestor);
            this.setWorkingCopyContents("package p;\npublic class Y {\n  void bar(Class c) {\n    new X().foo(c);\n  }\n}");
            this.workingCopy.reconcile(0, true, owner, null);
            this.assertProblems("Unexpected problems", "----------\n----------\n");
        }
        catch (Throwable throwable) {
            this.deleteProjects(new String[]{"P1", "P2"});
            throw throwable;
        }
        this.deleteProjects(new String[]{"P1", "P2"});
    }

    public void testTypeParameterWithBound() throws CoreException {
        this.workingCopy.discardWorkingCopy();
        this.workingCopy = null;
        WorkingCopyOwner owner = new WorkingCopyOwner(){};
        IJavaScriptUnit workingCopy1 = null;
        try {
            workingCopy1 = this.getWorkingCopy("/Reconciler15/src/test/I.js", "package test;\npublic interface I {\n\t<T extends I> void foo(T t);\n}\n", owner, null);
            this.problemRequestor = new AbstractJavaModelTests.ProblemRequestor();
            this.workingCopy = this.getWorkingCopy("Reconciler15/src/test/X.js", "", owner, this.problemRequestor);
            this.setWorkingCopyContents("package test;\npublic class X implements I {\n\tpublic <T extends I> void foo(T t) {\n\t}\n}\n");
            this.workingCopy.reconcile(0, false, owner, null);
            this.assertProblems("Unexpected problems", "----------\n----------\n");
        }
        finally {
            if (workingCopy1 != null) {
                workingCopy1.discardWorkingCopy();
            }
        }
    }

    public void testTypeParameterStartingWithDollar() throws CoreException {
        this.workingCopy.discardWorkingCopy();
        this.workingCopy = null;
        WorkingCopyOwner owner = new WorkingCopyOwner(){};
        IJavaScriptUnit workingCopy1 = null;
        try {
            workingCopy1 = this.getWorkingCopy("/Reconciler15/src/test/Y.js", "package test;\npublic class Y<$T> {\n\tvoid foo($T t);\n}\n", owner, null);
            this.problemRequestor = new AbstractJavaModelTests.ProblemRequestor();
            this.workingCopy = this.getWorkingCopy("Reconciler15/src/test/X.js", "", owner, this.problemRequestor);
            this.setWorkingCopyContents("package test;\npublic class X {\n\tpublic void bar() {\n    new Y<String>().foo(\"\");\n\t}\n}\n");
            this.workingCopy.reconcile(0, false, owner, null);
            this.assertProblems("Unexpected problems", "----------\n----------\n");
        }
        finally {
            if (workingCopy1 != null) {
                workingCopy1.discardWorkingCopy();
            }
        }
    }

    public void testTypeWithDollarName() throws CoreException {
        this.workingCopy.discardWorkingCopy();
        this.workingCopy = null;
        try {
            String contents = "package p1;\npublic class Y$Z {\n}";
            this.createFile("/Reconciler/src/p1/Y$Z.js", contents);
            this.problemRequestor = new AbstractJavaModelTests.ProblemRequestor();
            this.workingCopy = this.getCompilationUnit("Reconciler/src/p1/Y$Z.js").getWorkingCopy(new WorkingCopyOwner(){}, null);
            this.problemRequestor.initialize(contents.toCharArray());
            this.workingCopy.reconcile(0, true, null, null);
            this.assertProblems("Unexpected problems", "----------\n----------\n");
        }
        finally {
            this.deleteFile("/Reconciler/src/p1/Y$Z.js");
        }
    }

    public void testTypeWithDollarName2() throws CoreException {
        IJavaScriptUnit workingCopy2 = null;
        try {
            WorkingCopyOwner owner = this.workingCopy.getOwner();
            workingCopy2 = this.getWorkingCopy("/Reconciler/src/p1/Y$Z.js", "package p1;\npublic class Y$Z {\n}", owner, false);
            this.setWorkingCopyContents("package p1;\npublic class X {\n  Y$Z field;\n}");
            this.workingCopy.reconcile(0, false, owner, null);
            this.assertProblems("Unexpected problems", "----------\n----------\n");
        }
        finally {
            if (workingCopy2 != null) {
                workingCopy2.discardWorkingCopy();
            }
        }
    }

    public void testVarargs() throws CoreException {
        this.workingCopy.discardWorkingCopy();
        this.workingCopy = null;
        WorkingCopyOwner owner = new WorkingCopyOwner(){};
        IJavaScriptUnit workingCopy1 = null;
        try {
            workingCopy1 = this.getWorkingCopy("/Reconciler15/src/test/X.js", "package test;\npublic class X {\n\tvoid bar(String ... args) {}\n}\n", owner, null);
            this.problemRequestor = new AbstractJavaModelTests.ProblemRequestor();
            this.workingCopy = this.getWorkingCopy("Reconciler15/src/test/Y.js", "", owner, this.problemRequestor);
            this.setWorkingCopyContents("package test;\npublic class Y {\n\tvoid foo(){\n\t\tX someX = new X();\n\t\tsomeX.bar(\"a\", \"b\");\n\t}\n}\n");
            this.workingCopy.reconcile(0, false, owner, null);
            this.assertProblems("Unexpected problems", "----------\n----------\n");
        }
        finally {
            if (workingCopy1 != null) {
                workingCopy1.discardWorkingCopy();
            }
        }
    }

    public void testBug114338() throws CoreException {
        this.setWorkingCopyContents("package p1;\npublic class X {\n\t/**\n\t * @return a\n\t */\n\tboolean get() {\n\t\treturn false;\n\t}\n}");
        this.workingCopy.reconcile(3, true, this.wcOwner, null);
        this.assertProblems("Unexpected problems", "----------\n----------\n");
        String contents = "package p1;\npublic class X {\n\t/**\n\t * @return boolean\n\t */\n\tboolean get() {\n\t\treturn false;\n\t}\n}";
        this.setWorkingCopyContents(contents);
        this.workingCopy.reconcile(3, true, this.wcOwner, null);
        this.assertProblems("Unexpected problems", "----------\n----------\n");
    }

    public void testBug36032a() throws CoreException, InterruptedException {
        try {
            this.createJavaProject("P", new String[]{""}, new String[]{"JCL_LIB"});
            String source = "public class Test {\n\tpublic static void main(String[] args) {\n\t\tnew SFoo().foo();\n\t}\n}\n";
            this.createFile("/P/Foo.js", "class SFoo { void foo() {} }\n");
            this.createFile("/P/Test.js", source);
            char[] sourceChars = source.toCharArray();
            this.problemRequestor.initialize(sourceChars);
            this.workingCopy = this.getCompilationUnit("/P/Test.js").getWorkingCopy(new WorkingCopyOwner(){}, null);
            this.workingCopy.getBuffer().setContents(source);
            this.workingCopy.reconcile(3, true, null, null);
            this.assertNoProblem(sourceChars, this.workingCopy);
            this.createFile("/P/Bar.js", "class SBar{ void bar() {} }\n");
            source = "public class Test {\n\tpublic static void main(String[] args) {\n\t\tnew SFoo().foo();\n\t\tnew SBar().bar();\n\t}\n}\n";
            sourceChars = source.toCharArray();
            this.problemRequestor.initialize(sourceChars);
            this.workingCopy.getBuffer().setContents(source);
            this.workingCopy.reconcile(3, true, null, null);
            this.assertNoProblem(sourceChars, this.workingCopy);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testBug36032b() throws CoreException, InterruptedException {
        try {
            this.createJavaProject("P", new String[]{""}, new String[]{"JCL_LIB"});
            String source = "public class Test {\n\tpublic static void main(String[] args) {\n\t\tnew SFoo().foo();\n\t\tnew SBar().bar();\n\t}\n}\n";
            this.createFile("/P/Foo.js", "class SFoo { void foo() {} }\n");
            this.createFile("/P/Test.js", source);
            this.createFile("/P/Bar.js", "class SBar{ void bar() {} }\n");
            char[] sourceChars = source.toCharArray();
            this.problemRequestor.initialize(sourceChars);
            this.workingCopy = this.getCompilationUnit("/P/Test.js").getWorkingCopy(new WorkingCopyOwner(){}, null);
            this.workingCopy.getBuffer().setContents(source);
            this.workingCopy.reconcile(3, true, null, null);
            this.assertNoProblem(sourceChars, this.workingCopy);
            ReconcilerTests.waitUntilIndexesReady();
            this.deleteFile("/P/Bar.js");
            this.problemRequestor.initialize(source.toCharArray());
            this.workingCopy.reconcile(3, true, null, null);
            ReconcilerTests.assertEquals((String)"Working copy should not find secondary type 'Bar'!", (int)1, (int)this.problemRequestor.problemCount);
            this.assertProblems("Working copy should have problem!", "----------\n1. ERROR in /P/Test.java (at line 4)\n\tnew SBar().bar();\n\t    ^^^^\nSBar cannot be resolved to a type\n----------\n");
            source = "public class Test {\n\tpublic static void main(String[] args) {\n\t\tnew SFoo().foo();\n\t}\n}\n";
            sourceChars = source.toCharArray();
            this.problemRequestor.initialize(sourceChars);
            this.workingCopy.getBuffer().setContents(source);
            this.workingCopy.reconcile(3, true, null, null);
            this.assertNoProblem(sourceChars, this.workingCopy);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testBug36032c() throws CoreException, InterruptedException {
        try {
            this.createJavaProject("P1", new String[]{""}, new String[]{"JCL_LIB"});
            this.createFolder("/P1/test");
            this.createFile("/P1/test/Foo.js", "package test;\nclass Secondary{ void foo() {} }\n");
            this.createFile("/P1/test/Test1.js", "package test;\npublic class Test1 {\n\tpublic static void main(String[] args) {\n\t\tnew Secondary().foo();\n\t}\n}\n");
            this.createJavaProject("P2", new String[]{""}, new String[]{"JCL_LIB"}, new String[]{"/P1"});
            String source = "package test;\npublic class Test2 {\n\tpublic static void main(String[] args) {\n\t\tnew Secondary().foo();\n\t}\n}\n";
            this.createFolder("/P2/test");
            this.createFile("/P2/test/Test2.js", source);
            char[] sourceChars = source.toCharArray();
            this.problemRequestor.initialize(sourceChars);
            this.workingCopy = this.getCompilationUnit("/P2/test/Test2.js").getWorkingCopy(new WorkingCopyOwner(){}, null);
            this.workingCopy.getBuffer().setContents(source);
            this.workingCopy.reconcile(3, true, null, null);
            this.assertNoProblem(sourceChars, this.workingCopy);
        }
        finally {
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testBug118823() throws CoreException, InterruptedException, IOException {
        try {
            this.createJavaProject("P1", new String[]{""}, new String[]{"JCL_LIB"});
            String source = "class Test {}\n";
            this.createFile("/P1/Test.js", source);
            this.createJavaProject("P2", new String[]{""}, new String[]{"JCL_LIB"}, new String[]{"/P1"});
            String source2 = "class A {\n\tSecondary s;\n}\n";
            this.createFile("/P2/A.js", source2);
            ReconcilerTests.waitUntilIndexesReady();
            this.workingCopies = new IJavaScriptUnit[2];
            this.wcOwner = new WorkingCopyOwner(){};
            char[] sourceChars = source.toCharArray();
            this.problemRequestor.initialize(sourceChars);
            this.workingCopies[0] = this.getCompilationUnit("/P1/Test.js").getWorkingCopy(new WorkingCopyOwner(){}, null);
            this.assertNoProblem(sourceChars, this.workingCopies[0]);
            this.problemRequestor.initialize(source2.toCharArray());
            this.workingCopies[1] = this.getCompilationUnit("/P2/A.js").getWorkingCopy(new WorkingCopyOwner(){}, null);
            ReconcilerTests.assertEquals((String)"Working copy should not find secondary type 'Secondary'!", (int)1, (int)this.problemRequestor.problemCount);
            this.assertProblems("Working copy should have problem!", "----------\n1. ERROR in /P2/A.java (at line 2)\n\tSecondary s;\n\t^^^^^^^^^\nSecondary cannot be resolved to a type\n----------\n");
            this.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    ReconcilerTests.this.deleteFile("/P1/Test.js");
                    ReconcilerTests.this.createFile("/P1/Test.js", "public class Test {}\nclass Secondary{}\n");
                }
            }, null);
            sourceChars = "public class Test {}\nclass Secondary{}\n".toCharArray();
            this.problemRequestor.initialize(sourceChars);
            this.workingCopies[0].getBuffer().setContents("public class Test {}\nclass Secondary{}\n");
            this.workingCopies[0].reconcile(3, true, null, null);
            this.assertNoProblem(sourceChars, this.workingCopies[0]);
            sourceChars = source2.toCharArray();
            this.problemRequestor.initialize(sourceChars);
            this.workingCopies[1].getBuffer().setContents(source2);
            this.workingCopies[1].reconcile(3, true, null, null);
            this.assertNoProblem(sourceChars, this.workingCopies[1]);
        }
        finally {
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testBug118823b() throws CoreException, InterruptedException {
        try {
            this.createJavaProject("P1", new String[]{""}, new String[]{"JCL_LIB"});
            String source1 = "class Test {}\n";
            this.createFile("/P1/Test.js", source1);
            this.createJavaProject("P2", new String[]{""}, new String[]{"JCL_LIB"}, new String[]{"/P1"});
            String source2 = "class A {\n\tSecondary s;\n}\n";
            this.createFile("/P2/A.js", source2);
            ReconcilerTests.waitUntilIndexesReady();
            this.workingCopies = new IJavaScriptUnit[2];
            char[] sourceChars = source1.toCharArray();
            this.problemRequestor.initialize(sourceChars);
            this.workingCopies[0] = this.getCompilationUnit("/P1/Test.js").getWorkingCopy(new WorkingCopyOwner(){}, null);
            this.assertNoProblem(sourceChars, this.workingCopies[0]);
            this.problemRequestor.initialize(source2.toCharArray());
            this.workingCopies[1] = this.getCompilationUnit("/P2/A.js").getWorkingCopy(new WorkingCopyOwner(){}, null);
            ReconcilerTests.assertEquals((String)"Working copy should not find secondary type 'Secondary'!", (int)1, (int)this.problemRequestor.problemCount);
            this.assertProblems("Working copy should have problem!", "----------\n1. ERROR in /P2/A.java (at line 2)\n\tSecondary s;\n\t^^^^^^^^^\nSecondary cannot be resolved to a type\n----------\n");
            source1 = "public class Test {}\nclass Secondary{}\n";
            sourceChars = source1.toCharArray();
            this.problemRequestor.initialize(sourceChars);
            this.workingCopies[0].getBuffer().setContents(source1);
            this.workingCopies[0].reconcile(3, true, null, null);
            this.workingCopies[0].commitWorkingCopy(true, null);
            this.assertNoProblem(sourceChars, this.workingCopies[0]);
            sourceChars = source2.toCharArray();
            this.problemRequestor.initialize(sourceChars);
            this.workingCopies[1].getBuffer().setContents(source2);
            this.workingCopies[1].reconcile(3, true, null, null);
            this.assertNoProblem(sourceChars, this.workingCopies[1]);
        }
        finally {
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testBug118823c() throws CoreException, InterruptedException {
        try {
            this.createJavaProject("P1", new String[]{""}, new String[]{"JCL_LIB"});
            String source1 = "class Test {}\n";
            this.createFile("/P1/Test.js", source1);
            this.createJavaProject("P2", new String[]{""}, new String[]{"JCL_LIB"}, new String[]{"/P1"});
            String source2 = "class A {\n\tSecondary s;\n}\n";
            this.createFile("/P2/A.js", source2);
            ReconcilerTests.waitUntilIndexesReady();
            this.workingCopies = new IJavaScriptUnit[2];
            this.wcOwner = new WorkingCopyOwner(){};
            char[] sourceChars = source1.toCharArray();
            this.problemRequestor.initialize(sourceChars);
            this.workingCopies[0] = this.getCompilationUnit("/P1/Test.js").getWorkingCopy(new WorkingCopyOwner(){}, null);
            this.assertNoProblem(sourceChars, this.workingCopies[0]);
            this.problemRequestor.initialize(source2.toCharArray());
            this.workingCopies[1] = this.getCompilationUnit("/P2/A.js").getWorkingCopy(new WorkingCopyOwner(){}, null);
            ReconcilerTests.assertEquals((String)"Working copy should not find secondary type 'Secondary'!", (int)1, (int)this.problemRequestor.problemCount);
            this.assertProblems("Working copy should have problem!", "----------\n1. ERROR in /P2/A.java (at line 2)\n\tSecondary s;\n\t^^^^^^^^^\nSecondary cannot be resolved to a type\n----------\n");
            this.deleteFile("/P1/Test.js");
            source1 = "public class Test {}\nclass Secondary{}\n";
            this.createFile("/P1/Test.js", source1);
            sourceChars = source1.toCharArray();
            this.problemRequestor.initialize(sourceChars);
            this.workingCopies[0].getBuffer().setContents(source1);
            this.workingCopies[0].reconcile(3, true, null, null);
            this.workingCopies[0].commitWorkingCopy(true, null);
            this.assertNoProblem(sourceChars, this.workingCopies[0]);
            sourceChars = source2.toCharArray();
            this.problemRequestor.initialize(sourceChars);
            this.workingCopies[1].getBuffer().setContents(source2);
            this.workingCopies[1].reconcile(3, true, null, null);
            this.assertNoProblem(sourceChars, this.workingCopies[1]);
        }
        finally {
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void test1001() throws CoreException, InterruptedException, IOException {
        try {
            String[] sources = new String[3];
            char[][] sourcesAsCharArrays = new char[3][];
            this.createJavaProject("P1", new String[]{""}, new String[]{"JCL_LIB"});
            sources[0] = "class X {}\n";
            this.createFile("/P1/X.js", sources[0]);
            this.createJavaProject("P2", new String[]{""}, new String[]{"JCL_LIB"}, new String[]{"/P1"});
            sources[1] = "interface I {\n  void foo();\n  void bar(X p);\n}\n";
            this.createFile("/P2/I.js", sources[1]);
            this.createJavaProject("P3", new String[]{""}, new String[]{"JCL_LIB"}, new String[]{"/P2"});
            sources[2] = "class Y implements I {\n  // public void foo() { }\n  // public void bar(X p) { }\n}\n";
            this.createFile("/P3/Y.js", sources[2]);
            int i = 0;
            while (i < sources.length) {
                sourcesAsCharArrays[i] = sources[i].toCharArray();
                ++i;
            }
            ReconcilerTests.waitUntilIndexesReady();
            this.workingCopies = new IJavaScriptUnit[3];
            this.wcOwner = new WorkingCopyOwner(){};
            this.problemRequestor.initialize(sourcesAsCharArrays[0]);
            this.workingCopies[0] = this.getCompilationUnit("/P1/X.js").getWorkingCopy(new WorkingCopyOwner(){}, null);
            this.assertNoProblem(sourcesAsCharArrays[0], this.workingCopies[0]);
            this.problemRequestor.initialize(sourcesAsCharArrays[1]);
            this.workingCopies[1] = this.getCompilationUnit("/P2/I.js").getWorkingCopy(new WorkingCopyOwner(){}, null);
            this.assertNoProblem(sourcesAsCharArrays[1], this.workingCopies[1]);
            this.problemRequestor.initialize(sourcesAsCharArrays[2]);
            this.workingCopies[2] = this.getCompilationUnit("/P3/Y.js").getWorkingCopy(new WorkingCopyOwner(){}, null);
            this.assertProblems("Working copy should have problems:", "----------\n1. ERROR in /P3/Y.java (at line 1)\n\tclass Y implements I {\n\t      ^\nThe type Y must implement the inherited abstract method I.foo()\n----------\n");
        }
        finally {
            this.deleteProject("P1");
            this.deleteProject("P2");
            this.deleteProject("P3");
        }
    }

    public void test1002() throws CoreException, InterruptedException, IOException {
        try {
            String[] sources = new String[3];
            char[][] sourcesAsCharArrays = new char[3][];
            this.createJavaProject("P1", new String[]{""}, new String[]{"JCL_LIB"});
            sources[0] = "class X {}\n";
            this.createFile("/P1/X.js", sources[0]);
            this.createJavaProject("P2", new String[]{""}, new String[]{"JCL_LIB"}, new String[]{"/P1"});
            sources[1] = "interface I {\n  void foo();\n  void bar(X p);\n}\n";
            this.createFile("/P2/I.js", sources[1]);
            this.createJavaProject("P3", new String[]{""}, new String[]{"JCL_LIB"}, new String[]{"/P1", "/P2"});
            sources[2] = "class Y implements I {\n  // public void foo() { }\n  // public void bar(X p) { }\n}\n";
            this.createFile("/P3/Y.js", sources[2]);
            int i = 0;
            while (i < sources.length) {
                sourcesAsCharArrays[i] = sources[i].toCharArray();
                ++i;
            }
            ReconcilerTests.waitUntilIndexesReady();
            this.workingCopies = new IJavaScriptUnit[3];
            this.wcOwner = new WorkingCopyOwner(){};
            this.problemRequestor.initialize(sourcesAsCharArrays[0]);
            this.workingCopies[0] = this.getCompilationUnit("/P1/X.js").getWorkingCopy(new WorkingCopyOwner(){}, null);
            this.assertNoProblem(sourcesAsCharArrays[0], this.workingCopies[0]);
            this.problemRequestor.initialize(sourcesAsCharArrays[1]);
            this.workingCopies[1] = this.getCompilationUnit("/P2/I.js").getWorkingCopy(new WorkingCopyOwner(){}, null);
            this.assertNoProblem(sourcesAsCharArrays[1], this.workingCopies[1]);
            this.problemRequestor.initialize(sourcesAsCharArrays[2]);
            this.workingCopies[2] = this.getCompilationUnit("/P3/Y.js").getWorkingCopy(new WorkingCopyOwner(){}, null);
            this.assertProblems("Working copy should have problems:", "----------\n1. ERROR in /P3/Y.java (at line 1)\n\tclass Y implements I {\n\t      ^\nThe type Y must implement the inherited abstract method I.bar(X)\n----------\n2. ERROR in /P3/Y.java (at line 1)\n\tclass Y implements I {\n\t      ^\nThe type Y must implement the inherited abstract method I.foo()\n----------\n");
        }
        finally {
            this.deleteProject("P1");
            this.deleteProject("P2");
            this.deleteProject("P3");
        }
    }

    class CancelingProblemRequestor
    extends AbstractJavaModelTests.ProblemRequestor {
        IProgressMonitor progressMonitor = new IProgressMonitor(){
            boolean isCanceled = false;

            public void beginTask(String name, int totalWork) {
            }

            public void done() {
            }

            public void internalWorked(double work) {
            }

            public boolean isCanceled() {
                return this.isCanceled;
            }

            public void setCanceled(boolean value) {
                this.isCanceled = value;
            }

            public void setTaskName(String name) {
            }

            public void subTask(String name) {
            }

            public void worked(int work) {
            }
        };
        boolean isCanceling = false;

        CancelingProblemRequestor() {
        }

        @Override
        public void acceptProblem(IProblem problem) {
            if (this.isCanceling) {
                this.progressMonitor.setCanceled(true);
            }
            super.acceptProblem(problem);
        }
    }

    class ReconcileParticipant
    extends ValidationParticipant {
        IJavaScriptElementDelta delta;
        JavaScriptUnit ast;

        ReconcileParticipant() {
            TestvalidationParticipant.PARTICIPANT = this;
        }

        public boolean isActive(IJavaScriptProject project) {
            return true;
        }

        public void reconcile(ReconcileContext context) {
            this.delta = context.getDelta();
            try {
                this.ast = context.getAST3();
            }
            catch (JavaScriptModelException e) {
                ReconcilerTests.assertNull((String)"Unexpected exception", (Object)((Object)e));
            }
        }
    }
}

