/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.swt.bindings;

import java.util.HashSet;
import org.eclipse.jpt.common.ui.internal.swt.bindings.BooleanControlStateModelBinding;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CompositeBooleanControlStateModelBinding<C extends Control>
extends BooleanControlStateModelBinding<C> {
    private final HashSet<C> controls = new HashSet();

    CompositeBooleanControlStateModelBinding(PropertyValueModel<Boolean> booleanModel, Iterable<C> controls, boolean defaultValue, BooleanControlStateModelBinding.Adapter<C> adapter) {
        super(booleanModel, defaultValue, adapter);
        if (controls == null) {
            throw new NullPointerException();
        }
        for (Control control : controls) {
            if (control == null) {
                throw new NullPointerException();
            }
            if (this.controls.add(control)) continue;
            throw new IllegalArgumentException("duplicate control: " + control);
        }
        if (this.controls.isEmpty()) {
            throw new IllegalArgumentException("no controls");
        }
        this.engageBooleanModel();
        for (Control control : this.controls) {
            this.engageControl(control);
        }
        this.setControlState();
    }

    @Override
    void setControlState() {
        for (Control control : this.controls) {
            this.setControlState(control);
        }
    }

    @Override
    void controlDisposed(C control) {
        super.controlDisposed(control);
        this.controls.remove(control);
        if (this.controls.isEmpty()) {
            this.disengageBooleanModel();
        }
    }

    @Override
    boolean controlIsDisposed() {
        for (Control control : this.controls) {
            if (!control.isDisposed()) continue;
            return true;
        }
        return false;
    }
}

