/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.swt.bindings;

import org.eclipse.jpt.common.ui.internal.swt.events.DisposeAdapter;
import org.eclipse.jpt.common.ui.internal.swt.listeners.SWTListenerTools;
import org.eclipse.jpt.common.ui.internal.swt.widgets.ControlTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.PageBook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PageBookModelBinding<T> {
    private final PropertyValueModel<T> valueModel;
    private final PropertyChangeListener valueListener;
    private final Transformer<? super T, Control> transformer;
    private final PageBook pageBook;
    private final DisposeListener pageBookDisposeListener;
    private final Control defaultPage;

    PageBookModelBinding(PropertyValueModel<T> valueModel, Transformer<? super T, Control> transformer, PageBook pageBook, Control defaultPage) {
        if (valueModel == null || transformer == null || pageBook == null) {
            throw new NullPointerException();
        }
        this.valueModel = valueModel;
        this.transformer = transformer;
        this.pageBook = pageBook;
        Control control = this.defaultPage = defaultPage != null ? defaultPage : this.buildDefaultDefaultPage();
        if (this.defaultPage.getParent() != this.pageBook) {
            throw new IllegalArgumentException("The null page's parent must be the page book: " + defaultPage);
        }
        this.valueListener = this.buildValueListener();
        this.valueModel.addPropertyChangeListener("value", this.valueListener);
        this.pageBookDisposeListener = this.buildPageBookDisposeListener();
        this.pageBook.addDisposeListener(this.pageBookDisposeListener);
        this.showPage(this.valueModel.getValue());
    }

    private Control buildDefaultDefaultPage() {
        return new Label((Composite)this.pageBook, 290);
    }

    private PropertyChangeListener buildValueListener() {
        return SWTListenerTools.wrap((PropertyChangeListener)new ValueListener(), (Widget)this.pageBook);
    }

    private DisposeListener buildPageBookDisposeListener() {
        return new PageBookDisposeListener();
    }

    void valueChanged(PropertyChangeEvent event) {
        if (!this.pageBook.isDisposed()) {
            Object value = event.getNewValue();
            this.showPage(value);
        }
    }

    private void showPage(T value) {
        Control page = (Control)this.transformer.transform(value);
        this.pageBook.showPage(page != null ? page : this.defaultPage);
        ControlTools.reflow((Composite)this.pageBook);
    }

    void pageBookDisposed() {
        this.pageBook.removeDisposeListener(this.pageBookDisposeListener);
        this.valueModel.removePropertyChangeListener("value", this.valueListener);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.valueModel);
    }

    class PageBookDisposeListener
    extends DisposeAdapter {
        PageBookDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent event) {
            PageBookModelBinding.this.pageBookDisposed();
        }
    }

    class ValueListener
    extends PropertyChangeAdapter {
        ValueListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            PageBookModelBinding.this.valueChanged(event);
        }
    }
}

