/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterable;

import java.util.Iterator;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.CompositeIterator;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeIterable<E>
implements Iterable<E> {
    private final Iterable<? extends Iterable<? extends E>> iterables;

    public CompositeIterable(Iterable<? extends Iterable<? extends E>> iterables) {
        if (iterables == null) {
            throw new NullPointerException();
        }
        this.iterables = iterables;
    }

    @Override
    public Iterator<E> iterator() {
        return new CompositeIterator<E>(this.iterators());
    }

    protected Iterator<? extends Iterator<? extends E>> iterators() {
        Transformer transformer = IterableTools.iteratorTransformer();
        return IteratorTools.transform(this.iterables(), transformer);
    }

    protected Iterator<? extends Iterable<? extends E>> iterables() {
        return this.iterables.iterator();
    }

    public String toString() {
        return ListTools.list(this).toString();
    }
}

